<?php
// This file was auto-generated from sdk-root/src/data/athena/2017-05-18/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2017-05-18', 'endpointPrefix' => 'athena', 'jsonVersion' => '1.1', 'protocol' => 'json', 'protocols' => [ 'json', ], 'serviceFullName' => 'Amazon Athena', 'serviceId' => 'Athena', 'signatureVersion' => 'v4', 'targetPrefix' => 'AmazonAthena', 'uid' => 'athena-2017-05-18', 'auth' => [ 'aws.auth#sigv4', ], ], 'operations' => [ 'BatchGetNamedQuery' => [ 'name' => 'BatchGetNamedQuery', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'BatchGetNamedQueryInput', ], 'output' => [ 'shape' => 'BatchGetNamedQueryOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'BatchGetPreparedStatement' => [ 'name' => 'BatchGetPreparedStatement', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'BatchGetPreparedStatementInput', ], 'output' => [ 'shape' => 'BatchGetPreparedStatementOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'BatchGetQueryExecution' => [ 'name' => 'BatchGetQueryExecution', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'BatchGetQueryExecutionInput', ], 'output' => [ 'shape' => 'BatchGetQueryExecutionOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'CancelCapacityReservation' => [ 'name' => 'CancelCapacityReservation', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CancelCapacityReservationInput', ], 'output' => [ 'shape' => 'CancelCapacityReservationOutput', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'CreateCapacityReservation' => [ 'name' => 'CreateCapacityReservation', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateCapacityReservationInput', ], 'output' => [ 'shape' => 'CreateCapacityReservationOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], ], 'idempotent' => true, ], 'CreateDataCatalog' => [ 'name' => 'CreateDataCatalog', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateDataCatalogInput', ], 'output' => [ 'shape' => 'CreateDataCatalogOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'CreateNamedQuery' => [ 'name' => 'CreateNamedQuery', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateNamedQueryInput', ], 'output' => [ 'shape' => 'CreateNamedQueryOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], ], 'idempotent' => true, ], 'CreateNotebook' => [ 'name' => 'CreateNotebook', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateNotebookInput', ], 'output' => [ 'shape' => 'CreateNotebookOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'CreatePreparedStatement' => [ 'name' => 'CreatePreparedStatement', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreatePreparedStatementInput', ], 'output' => [ 'shape' => 'CreatePreparedStatementOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'CreatePresignedNotebookUrl' => [ 'name' => 'CreatePresignedNotebookUrl', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreatePresignedNotebookUrlRequest', ], 'output' => [ 'shape' => 'CreatePresignedNotebookUrlResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'CreateWorkGroup' => [ 'name' => 'CreateWorkGroup', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateWorkGroupInput', ], 'output' => [ 'shape' => 'CreateWorkGroupOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'DeleteCapacityReservation' => [ 'name' => 'DeleteCapacityReservation', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteCapacityReservationInput', ], 'output' => [ 'shape' => 'DeleteCapacityReservationOutput', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'DeleteDataCatalog' => [ 'name' => 'DeleteDataCatalog', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteDataCatalogInput', ], 'output' => [ 'shape' => 'DeleteDataCatalogOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'DeleteNamedQuery' => [ 'name' => 'DeleteNamedQuery', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteNamedQueryInput', ], 'output' => [ 'shape' => 'DeleteNamedQueryOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], ], 'idempotent' => true, ], 'DeleteNotebook' => [ 'name' => 'DeleteNotebook', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteNotebookInput', ], 'output' => [ 'shape' => 'DeleteNotebookOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'DeletePreparedStatement' => [ 'name' => 'DeletePreparedStatement', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeletePreparedStatementInput', ], 'output' => [ 'shape' => 'DeletePreparedStatementOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'DeleteWorkGroup' => [ 'name' => 'DeleteWorkGroup', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteWorkGroupInput', ], 'output' => [ 'shape' => 'DeleteWorkGroupOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], ], 'idempotent' => true, ], 'ExportNotebook' => [ 'name' => 'ExportNotebook', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ExportNotebookInput', ], 'output' => [ 'shape' => 'ExportNotebookOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'GetCalculationExecution' => [ 'name' => 'GetCalculationExecution', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetCalculationExecutionRequest', ], 'output' => [ 'shape' => 'GetCalculationExecutionResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetCalculationExecutionCode' => [ 'name' => 'GetCalculationExecutionCode', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetCalculationExecutionCodeRequest', ], 'output' => [ 'shape' => 'GetCalculationExecutionCodeResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetCalculationExecutionStatus' => [ 'name' => 'GetCalculationExecutionStatus', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetCalculationExecutionStatusRequest', ], 'output' => [ 'shape' => 'GetCalculationExecutionStatusResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetCapacityAssignmentConfiguration' => [ 'name' => 'GetCapacityAssignmentConfiguration', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetCapacityAssignmentConfigurationInput', ], 'output' => [ 'shape' => 'GetCapacityAssignmentConfigurationOutput', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetCapacityReservation' => [ 'name' => 'GetCapacityReservation', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetCapacityReservationInput', ], 'output' => [ 'shape' => 'GetCapacityReservationOutput', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetDataCatalog' => [ 'name' => 'GetDataCatalog', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetDataCatalogInput', ], 'output' => [ 'shape' => 'GetDataCatalogOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'GetDatabase' => [ 'name' => 'GetDatabase', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetDatabaseInput', ], 'output' => [ 'shape' => 'GetDatabaseOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'MetadataException', ], ], ], 'GetNamedQuery' => [ 'name' => 'GetNamedQuery', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetNamedQueryInput', ], 'output' => [ 'shape' => 'GetNamedQueryOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'GetNotebookMetadata' => [ 'name' => 'GetNotebookMetadata', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetNotebookMetadataInput', ], 'output' => [ 'shape' => 'GetNotebookMetadataOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'GetPreparedStatement' => [ 'name' => 'GetPreparedStatement', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetPreparedStatementInput', ], 'output' => [ 'shape' => 'GetPreparedStatementOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetQueryExecution' => [ 'name' => 'GetQueryExecution', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetQueryExecutionInput', ], 'output' => [ 'shape' => 'GetQueryExecutionOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'GetQueryResults' => [ 'name' => 'GetQueryResults', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetQueryResultsInput', ], 'output' => [ 'shape' => 'GetQueryResultsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'GetQueryRuntimeStatistics' => [ 'name' => 'GetQueryRuntimeStatistics', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetQueryRuntimeStatisticsInput', ], 'output' => [ 'shape' => 'GetQueryRuntimeStatisticsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'GetSession' => [ 'name' => 'GetSession', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetSessionRequest', ], 'output' => [ 'shape' => 'GetSessionResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetSessionStatus' => [ 'name' => 'GetSessionStatus', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetSessionStatusRequest', ], 'output' => [ 'shape' => 'GetSessionStatusResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetTableMetadata' => [ 'name' => 'GetTableMetadata', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetTableMetadataInput', ], 'output' => [ 'shape' => 'GetTableMetadataOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'MetadataException', ], ], ], 'GetWorkGroup' => [ 'name' => 'GetWorkGroup', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetWorkGroupInput', ], 'output' => [ 'shape' => 'GetWorkGroupOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'ImportNotebook' => [ 'name' => 'ImportNotebook', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ImportNotebookInput', ], 'output' => [ 'shape' => 'ImportNotebookOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'ListApplicationDPUSizes' => [ 'name' => 'ListApplicationDPUSizes', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListApplicationDPUSizesInput', ], 'output' => [ 'shape' => 'ListApplicationDPUSizesOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'ListCalculationExecutions' => [ 'name' => 'ListCalculationExecutions', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListCalculationExecutionsRequest', ], 'output' => [ 'shape' => 'ListCalculationExecutionsResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListCapacityReservations' => [ 'name' => 'ListCapacityReservations', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListCapacityReservationsInput', ], 'output' => [ 'shape' => 'ListCapacityReservationsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'ListDataCatalogs' => [ 'name' => 'ListDataCatalogs', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListDataCatalogsInput', ], 'output' => [ 'shape' => 'ListDataCatalogsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'ListDatabases' => [ 'name' => 'ListDatabases', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListDatabasesInput', ], 'output' => [ 'shape' => 'ListDatabasesOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'MetadataException', ], ], ], 'ListEngineVersions' => [ 'name' => 'ListEngineVersions', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListEngineVersionsInput', ], 'output' => [ 'shape' => 'ListEngineVersionsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'ListExecutors' => [ 'name' => 'ListExecutors', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListExecutorsRequest', ], 'output' => [ 'shape' => 'ListExecutorsResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListNamedQueries' => [ 'name' => 'ListNamedQueries', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListNamedQueriesInput', ], 'output' => [ 'shape' => 'ListNamedQueriesOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'ListNotebookMetadata' => [ 'name' => 'ListNotebookMetadata', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListNotebookMetadataInput', ], 'output' => [ 'shape' => 'ListNotebookMetadataOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'ListNotebookSessions' => [ 'name' => 'ListNotebookSessions', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListNotebookSessionsRequest', ], 'output' => [ 'shape' => 'ListNotebookSessionsResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListPreparedStatements' => [ 'name' => 'ListPreparedStatements', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListPreparedStatementsInput', ], 'output' => [ 'shape' => 'ListPreparedStatementsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'ListQueryExecutions' => [ 'name' => 'ListQueryExecutions', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListQueryExecutionsInput', ], 'output' => [ 'shape' => 'ListQueryExecutionsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'ListSessions' => [ 'name' => 'ListSessions', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListSessionsRequest', ], 'output' => [ 'shape' => 'ListSessionsResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListTableMetadata' => [ 'name' => 'ListTableMetadata', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListTableMetadataInput', ], 'output' => [ 'shape' => 'ListTableMetadataOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'MetadataException', ], ], ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListTagsForResourceInput', ], 'output' => [ 'shape' => 'ListTagsForResourceOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListWorkGroups' => [ 'name' => 'ListWorkGroups', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListWorkGroupsInput', ], 'output' => [ 'shape' => 'ListWorkGroupsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'PutCapacityAssignmentConfiguration' => [ 'name' => 'PutCapacityAssignmentConfiguration', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'PutCapacityAssignmentConfigurationInput', ], 'output' => [ 'shape' => 'PutCapacityAssignmentConfigurationOutput', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'StartCalculationExecution' => [ 'name' => 'StartCalculationExecution', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'StartCalculationExecutionRequest', ], 'output' => [ 'shape' => 'StartCalculationExecutionResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'StartQueryExecution' => [ 'name' => 'StartQueryExecution', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'StartQueryExecutionInput', ], 'output' => [ 'shape' => 'StartQueryExecutionOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'TooManyRequestsException', ], ], 'idempotent' => true, ], 'StartSession' => [ 'name' => 'StartSession', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'StartSessionRequest', ], 'output' => [ 'shape' => 'StartSessionResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'SessionAlreadyExistsException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'StopCalculationExecution' => [ 'name' => 'StopCalculationExecution', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'StopCalculationExecutionRequest', ], 'output' => [ 'shape' => 'StopCalculationExecutionResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'StopQueryExecution' => [ 'name' => 'StopQueryExecution', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'StopQueryExecutionInput', ], 'output' => [ 'shape' => 'StopQueryExecutionOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], ], 'idempotent' => true, ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'TagResourceInput', ], 'output' => [ 'shape' => 'TagResourceOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'TerminateSession' => [ 'name' => 'TerminateSession', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'TerminateSessionRequest', ], 'output' => [ 'shape' => 'TerminateSessionResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UntagResourceInput', ], 'output' => [ 'shape' => 'UntagResourceOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'UpdateCapacityReservation' => [ 'name' => 'UpdateCapacityReservation', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateCapacityReservationInput', ], 'output' => [ 'shape' => 'UpdateCapacityReservationOutput', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UpdateDataCatalog' => [ 'name' => 'UpdateDataCatalog', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateDataCatalogInput', ], 'output' => [ 'shape' => 'UpdateDataCatalogOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'UpdateNamedQuery' => [ 'name' => 'UpdateNamedQuery', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateNamedQueryInput', ], 'output' => [ 'shape' => 'UpdateNamedQueryOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], ], 'idempotent' => true, ], 'UpdateNotebook' => [ 'name' => 'UpdateNotebook', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateNotebookInput', ], 'output' => [ 'shape' => 'UpdateNotebookOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'UpdateNotebookMetadata' => [ 'name' => 'UpdateNotebookMetadata', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateNotebookMetadataInput', ], 'output' => [ 'shape' => 'UpdateNotebookMetadataOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'UpdatePreparedStatement' => [ 'name' => 'UpdatePreparedStatement', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdatePreparedStatementInput', ], 'output' => [ 'shape' => 'UpdatePreparedStatementOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'UpdateWorkGroup' => [ 'name' => 'UpdateWorkGroup', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateWorkGroupInput', ], 'output' => [ 'shape' => 'UpdateWorkGroupOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidRequestException', ], ], ], ], 'shapes' => [ 'AclConfiguration' => [ 'type' => 'structure', 'required' => [ 'S3AclOption', ], 'members' => [ 'S3AclOption' => [ 'shape' => 'S3AclOption', ], ], ], 'Age' => [ 'type' => 'integer', 'max' => 10080, 'min' => 0, ], 'AllocatedDpusInteger' => [ 'type' => 'integer', 'box' => true, 'min' => 0, ], 'AmazonResourceName' => [ 'type' => 'string', 'max' => 1011, 'min' => 1, ], 'ApplicationDPUSizes' => [ 'type' => 'structure', 'members' => [ 'ApplicationRuntimeId' => [ 'shape' => 'NameString', ], 'SupportedDPUSizes' => [ 'shape' => 'SupportedDPUSizeList', ], ], ], 'ApplicationDPUSizesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ApplicationDPUSizes', ], ], 'AthenaError' => [ 'type' => 'structure', 'members' => [ 'ErrorCategory' => [ 'shape' => 'ErrorCategory', ], 'ErrorType' => [ 'shape' => 'ErrorType', ], 'Retryable' => [ 'shape' => 'Boolean', ], 'ErrorMessage' => [ 'shape' => 'String', ], ], ], 'AuthToken' => [ 'type' => 'string', 'max' => 2048, ], 'AuthenticationType' => [ 'type' => 'string', 'enum' => [ 'DIRECTORY_IDENTITY', ], ], 'AwsAccountId' => [ 'type' => 'string', 'max' => 12, 'min' => 12, 'pattern' => '^[0-9]+$', ], 'BatchGetNamedQueryInput' => [ 'type' => 'structure', 'required' => [ 'NamedQueryIds', ], 'members' => [ 'NamedQueryIds' => [ 'shape' => 'NamedQueryIdList', ], ], ], 'BatchGetNamedQueryOutput' => [ 'type' => 'structure', 'members' => [ 'NamedQueries' => [ 'shape' => 'NamedQueryList', ], 'UnprocessedNamedQueryIds' => [ 'shape' => 'UnprocessedNamedQueryIdList', ], ], ], 'BatchGetPreparedStatementInput' => [ 'type' => 'structure', 'required' => [ 'PreparedStatementNames', 'WorkGroup', ], 'members' => [ 'PreparedStatementNames' => [ 'shape' => 'PreparedStatementNameList', ], 'WorkGroup' => [ 'shape' => 'WorkGroupName', ], ], ], 'BatchGetPreparedStatementOutput' => [ 'type' => 'structure', 'members' => [ 'PreparedStatements' => [ 'shape' => 'PreparedStatementDetailsList', ], 'UnprocessedPreparedStatementNames' => [ 'shape' => 'UnprocessedPreparedStatementNameList', ], ], ], 'BatchGetQueryExecutionInput' => [ 'type' => 'structure', 'required' => [ 'QueryExecutionIds', ], 'members' => [ 'QueryExecutionIds' => [ 'shape' => 'QueryExecutionIdList', ], ], ], 'BatchGetQueryExecutionOutput' => [ 'type' => 'structure', 'members' => [ 'QueryExecutions' => [ 'shape' => 'QueryExecutionList', ], 'UnprocessedQueryExecutionIds' => [ 'shape' => 'UnprocessedQueryExecutionIdList', ], ], ], 'Boolean' => [ 'type' => 'boolean', ], 'BoxedBoolean' => [ 'type' => 'boolean', ], 'BytesScannedCutoffValue' => [ 'type' => 'long', 'min' => 10000000, ], 'CalculationConfiguration' => [ 'type' => 'structure', 'members' => [ 'CodeBlock' => [ 'shape' => 'CodeBlock', ], ], ], 'CalculationExecutionId' => [ 'type' => 'string', 'max' => 36, 'min' => 1, ], 'CalculationExecutionState' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'CREATED', 'QUEUED', 'RUNNING', 'CANCELING', 'CANCELED', 'COMPLETED', 'FAILED', ], ], 'CalculationResult' => [ 'type' => 'structure', 'members' => [ 'StdOutS3Uri' => [ 'shape' => 'S3Uri', ], 'StdErrorS3Uri' => [ 'shape' => 'S3Uri', ], 'ResultS3Uri' => [ 'shape' => 'S3Uri', ], 'ResultType' => [ 'shape' => 'CalculationResultType', ], ], ], 'CalculationResultType' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '\\w+\\/[-+.\\w]+', ], 'CalculationStatistics' => [ 'type' => 'structure', 'members' => [ 'DpuExecutionInMillis' => [ 'shape' => 'Long', ], 'Progress' => [ 'shape' => 'DescriptionString', ], ], ], 'CalculationStatus' => [ 'type' => 'structure', 'members' => [ 'SubmissionDateTime' => [ 'shape' => 'Date', ], 'CompletionDateTime' => [ 'shape' => 'Date', ], 'State' => [ 'shape' => 'CalculationExecutionState', ], 'StateChangeReason' => [ 'shape' => 'DescriptionString', ], ], ], 'CalculationSummary' => [ 'type' => 'structure', 'members' => [ 'CalculationExecutionId' => [ 'shape' => 'CalculationExecutionId', ], 'Description' => [ 'shape' => 'DescriptionString', ], 'Status' => [ 'shape' => 'CalculationStatus', ], ], ], 'CalculationsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CalculationSummary', ], 'max' => 100, 'min' => 0, ], 'CancelCapacityReservationInput' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'CapacityReservationName', ], ], ], 'CancelCapacityReservationOutput' => [ 'type' => 'structure', 'members' => [], ], 'CapacityAllocation' => [ 'type' => 'structure', 'required' => [ 'Status', 'RequestTime', ], 'members' => [ 'Status' => [ 'shape' => 'CapacityAllocationStatus', ], 'StatusMessage' => [ 'shape' => 'String', ], 'RequestTime' => [ 'shape' => 'Timestamp', ], 'RequestCompletionTime' => [ 'shape' => 'Timestamp', ], ], ], 'CapacityAllocationStatus' => [ 'type' => 'string', 'enum' => [ 'PENDING', 'SUCCEEDED', 'FAILED', ], ], 'CapacityAssignment' => [ 'type' => 'structure', 'members' => [ 'WorkGroupNames' => [ 'shape' => 'WorkGroupNamesList', ], ], ], 'CapacityAssignmentConfiguration' => [ 'type' => 'structure', 'members' => [ 'CapacityReservationName' => [ 'shape' => 'CapacityReservationName', ], 'CapacityAssignments' => [ 'shape' => 'CapacityAssignmentsList', ], ], ], 'CapacityAssignmentsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CapacityAssignment', ], ], 'CapacityReservation' => [ 'type' => 'structure', 'required' => [ 'Name', 'Status', 'TargetDpus', 'AllocatedDpus', 'CreationTime', ], 'members' => [ 'Name' => [ 'shape' => 'CapacityReservationName', ], 'Status' => [ 'shape' => 'CapacityReservationStatus', ], 'TargetDpus' => [ 'shape' => 'TargetDpusInteger', ], 'AllocatedDpus' => [ 'shape' => 'AllocatedDpusInteger', ], 'LastAllocation' => [ 'shape' => 'CapacityAllocation', ], 'LastSuccessfulAllocationTime' => [ 'shape' => 'Timestamp', ], 'CreationTime' => [ 'shape' => 'Timestamp', ], ], ], 'CapacityReservationName' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[a-zA-Z0-9._-]+', ], 'CapacityReservationStatus' => [ 'type' => 'string', 'enum' => [ 'PENDING', 'ACTIVE', 'CANCELLING', 'CANCELLED', 'FAILED', 'UPDATE_PENDING', ], ], 'CapacityReservationsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CapacityReservation', ], ], 'CatalogNameString' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '[\\u0020-\\uD7FF\\uE000-\\uFFFD\\uD800\\uDC00-\\uDBFF\\uDFFF\\t]*', ], 'ClientRequestToken' => [ 'type' => 'string', 'max' => 36, 'min' => 1, 'pattern' => '[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}', ], 'CodeBlock' => [ 'type' => 'string', 'max' => 68000, ], 'Column' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'NameString', ], 'Type' => [ 'shape' => 'TypeString', ], 'Comment' => [ 'shape' => 'CommentString', ], ], ], 'ColumnInfo' => [ 'type' => 'structure', 'required' => [ 'Name', 'Type', ], 'members' => [ 'CatalogName' => [ 'shape' => 'String', ], 'SchemaName' => [ 'shape' => 'String', ], 'TableName' => [ 'shape' => 'String', ], 'Name' => [ 'shape' => 'String', ], 'Label' => [ 'shape' => 'String', ], 'Type' => [ 'shape' => 'String', ], 'Precision' => [ 'shape' => 'Integer', ], 'Scale' => [ 'shape' => 'Integer', ], 'Nullable' => [ 'shape' => 'ColumnNullable', ], 'CaseSensitive' => [ 'shape' => 'Boolean', ], ], ], 'ColumnInfoList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ColumnInfo', ], ], 'ColumnList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Column', ], ], 'ColumnNullable' => [ 'type' => 'string', 'enum' => [ 'NOT_NULL', 'NULLABLE', 'UNKNOWN', ], ], 'CommentString' => [ 'type' => 'string', 'max' => 255, 'min' => 0, 'pattern' => '[\\u0020-\\uD7FF\\uE000-\\uFFFD\\uD800\\uDC00-\\uDBFF\\uDFFF\\t]*', ], 'CoordinatorDpuSize' => [ 'type' => 'integer', 'box' => true, 'max' => 1, 'min' => 1, ], 'CreateCapacityReservationInput' => [ 'type' => 'structure', 'required' => [ 'TargetDpus', 'Name', ], 'members' => [ 'TargetDpus' => [ 'shape' => 'TargetDpusInteger', ], 'Name' => [ 'shape' => 'CapacityReservationName', ], 'Tags' => [ 'shape' => 'TagList', ], ], ], 'CreateCapacityReservationOutput' => [ 'type' => 'structure', 'members' => [], ], 'CreateDataCatalogInput' => [ 'type' => 'structure', 'required' => [ 'Name', 'Type', ], 'members' => [ 'Name' => [ 'shape' => 'CatalogNameString', ], 'Type' => [ 'shape' => 'DataCatalogType', ], 'Description' => [ 'shape' => 'DescriptionString', ], 'Parameters' => [ 'shape' => 'ParametersMap', ], 'Tags' => [ 'shape' => 'TagList', ], ], ], 'CreateDataCatalogOutput' => [ 'type' => 'structure', 'members' => [], ], 'CreateNamedQueryInput' => [ 'type' => 'structure', 'required' => [ 'Name', 'Database', 'QueryString', ], 'members' => [ 'Name' => [ 'shape' => 'NameString', ], 'Description' => [ 'shape' => 'DescriptionString', ], 'Database' => [ 'shape' => 'DatabaseString', ], 'QueryString' => [ 'shape' => 'QueryString', ], 'ClientRequestToken' => [ 'shape' => 'IdempotencyToken', 'idempotencyToken' => true, ], 'WorkGroup' => [ 'shape' => 'WorkGroupName', ], ], ], 'CreateNamedQueryOutput' => [ 'type' => 'structure', 'members' => [ 'NamedQueryId' => [ 'shape' => 'NamedQueryId', ], ], ], 'CreateNotebookInput' => [ 'type' => 'structure', 'required' => [ 'WorkGroup', 'Name', ], 'members' => [ 'WorkGroup' => [ 'shape' => 'WorkGroupName', ], 'Name' => [ 'shape' => 'NotebookName', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', ], ], ], 'CreateNotebookOutput' => [ 'type' => 'structure', 'members' => [ 'NotebookId' => [ 'shape' => 'NotebookId', ], ], ], 'CreatePreparedStatementInput' => [ 'type' => 'structure', 'required' => [ 'StatementName', 'WorkGroup', 'QueryStatement', ], 'members' => [ 'StatementName' => [ 'shape' => 'StatementName', ], 'WorkGroup' => [ 'shape' => 'WorkGroupName', ], 'QueryStatement' => [ 'shape' => 'QueryString', ], 'Description' => [ 'shape' => 'DescriptionString', ], ], ], 'CreatePreparedStatementOutput' => [ 'type' => 'structure', 'members' => [], ], 'CreatePresignedNotebookUrlRequest' => [ 'type' => 'structure', 'required' => [ 'SessionId', ], 'members' => [ 'SessionId' => [ 'shape' => 'SessionId', ], ], ], 'CreatePresignedNotebookUrlResponse' => [ 'type' => 'structure', 'required' => [ 'NotebookUrl', 'AuthToken', 'AuthTokenExpirationTime', ], 'members' => [ 'NotebookUrl' => [ 'shape' => 'String', ], 'AuthToken' => [ 'shape' => 'AuthToken', ], 'AuthTokenExpirationTime' => [ 'shape' => 'Long', ], ], ], 'CreateWorkGroupInput' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'WorkGroupName', ], 'Configuration' => [ 'shape' => 'WorkGroupConfiguration', ], 'Description' => [ 'shape' => 'WorkGroupDescriptionString', ], 'Tags' => [ 'shape' => 'TagList', ], ], ], 'CreateWorkGroupOutput' => [ 'type' => 'structure', 'members' => [], ], 'CustomerContentEncryptionConfiguration' => [ 'type' => 'structure', 'required' => [ 'KmsKey', ], 'members' => [ 'KmsKey' => [ 'shape' => 'KmsKey', ], ], ], 'DataCatalog' => [ 'type' => 'structure', 'required' => [ 'Name', 'Type', ], 'members' => [ 'Name' => [ 'shape' => 'CatalogNameString', ], 'Description' => [ 'shape' => 'DescriptionString', ], 'Type' => [ 'shape' => 'DataCatalogType', ], 'Parameters' => [ 'shape' => 'ParametersMap', ], ], ], 'DataCatalogSummary' => [ 'type' => 'structure', 'members' => [ 'CatalogName' => [ 'shape' => 'CatalogNameString', ], 'Type' => [ 'shape' => 'DataCatalogType', ], ], ], 'DataCatalogSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DataCatalogSummary', ], ], 'DataCatalogType' => [ 'type' => 'string', 'enum' => [ 'LAMBDA', 'GLUE', 'HIVE', ], ], 'Database' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'NameString', ], 'Description' => [ 'shape' => 'DescriptionString', ], 'Parameters' => [ 'shape' => 'ParametersMap', ], ], ], 'DatabaseList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Database', ], ], 'DatabaseString' => [ 'type' => 'string', 'max' => 255, 'min' => 1, ], 'Date' => [ 'type' => 'timestamp', ], 'Datum' => [ 'type' => 'structure', 'members' => [ 'VarCharValue' => [ 'shape' => 'datumString', ], ], ], 'DefaultExecutorDpuSize' => [ 'type' => 'integer', 'box' => true, 'max' => 1, 'min' => 1, ], 'DeleteCapacityReservationInput' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'CapacityReservationName', ], ], ], 'DeleteCapacityReservationOutput' => [ 'type' => 'structure', 'members' => [], ], 'DeleteDataCatalogInput' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'CatalogNameString', ], ], ], 'DeleteDataCatalogOutput' => [ 'type' => 'structure', 'members' => [], ], 'DeleteNamedQueryInput' => [ 'type' => 'structure', 'required' => [ 'NamedQueryId', ], 'members' => [ 'NamedQueryId' => [ 'shape' => 'NamedQueryId', 'idempotencyToken' => true, ], ], ], 'DeleteNamedQueryOutput' => [ 'type' => 'structure', 'members' => [], ], 'DeleteNotebookInput' => [ 'type' => 'structure', 'required' => [ 'NotebookId', ], 'members' => [ 'NotebookId' => [ 'shape' => 'NotebookId', ], ], ], 'DeleteNotebookOutput' => [ 'type' => 'structure', 'members' => [], ], 'DeletePreparedStatementInput' => [ 'type' => 'structure', 'required' => [ 'StatementName', 'WorkGroup', ], 'members' => [ 'StatementName' => [ 'shape' => 'StatementName', ], 'WorkGroup' => [ 'shape' => 'WorkGroupName', ], ], ], 'DeletePreparedStatementOutput' => [ 'type' => 'structure', 'members' => [], ], 'DeleteWorkGroupInput' => [ 'type' => 'structure', 'required' => [ 'WorkGroup', ], 'members' => [ 'WorkGroup' => [ 'shape' => 'WorkGroupName', ], 'RecursiveDeleteOption' => [ 'shape' => 'BoxedBoolean', ], ], ], 'DeleteWorkGroupOutput' => [ 'type' => 'structure', 'members' => [], ], 'DescriptionString' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, ], 'EncryptionConfiguration' => [ 'type' => 'structure', 'required' => [ 'EncryptionOption', ], 'members' => [ 'EncryptionOption' => [ 'shape' => 'EncryptionOption', ], 'KmsKey' => [ 'shape' => 'String', ], ], ], 'EncryptionOption' => [ 'type' => 'string', 'enum' => [ 'SSE_S3', 'SSE_KMS', 'CSE_KMS', ], ], 'EngineConfiguration' => [ 'type' => 'structure', 'required' => [ 'MaxConcurrentDpus', ], 'members' => [ 'CoordinatorDpuSize' => [ 'shape' => 'CoordinatorDpuSize', ], 'MaxConcurrentDpus' => [ 'shape' => 'MaxConcurrentDpus', ], 'DefaultExecutorDpuSize' => [ 'shape' => 'DefaultExecutorDpuSize', ], 'AdditionalConfigs' => [ 'shape' => 'ParametersMap', ], 'SparkProperties' => [ 'shape' => 'ParametersMap', ], ], ], 'EngineVersion' => [ 'type' => 'structure', 'members' => [ 'SelectedEngineVersion' => [ 'shape' => 'NameString', ], 'EffectiveEngineVersion' => [ 'shape' => 'NameString', ], ], ], 'EngineVersionsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'EngineVersion', ], 'max' => 10, 'min' => 0, ], 'ErrorCategory' => [ 'type' => 'integer', 'box' => true, 'max' => 3, 'min' => 1, ], 'ErrorCode' => [ 'type' => 'string', 'max' => 256, 'min' => 1, ], 'ErrorMessage' => [ 'type' => 'string', ], 'ErrorType' => [ 'type' => 'integer', 'box' => true, 'max' => 9999, 'min' => 0, ], 'ExecutionParameter' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, ], 'ExecutionParameters' => [ 'type' => 'list', 'member' => [ 'shape' => 'ExecutionParameter', ], 'min' => 1, ], 'ExecutorId' => [ 'type' => 'string', 'max' => 100000, 'pattern' => '.*', ], 'ExecutorState' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'CREATED', 'REGISTERED', 'TERMINATING', 'TERMINATED', 'FAILED', ], ], 'ExecutorType' => [ 'type' => 'string', 'enum' => [ 'COORDINATOR', 'GATEWAY', 'WORKER', ], ], 'ExecutorsSummary' => [ 'type' => 'structure', 'required' => [ 'ExecutorId', ], 'members' => [ 'ExecutorId' => [ 'shape' => 'ExecutorId', ], 'ExecutorType' => [ 'shape' => 'ExecutorType', ], 'StartDateTime' => [ 'shape' => 'Long', ], 'TerminationDateTime' => [ 'shape' => 'Long', ], 'ExecutorState' => [ 'shape' => 'ExecutorState', ], 'ExecutorSize' 