<?php
// This file was auto-generated from sdk-root/src/data/dataexchange/2017-07-25/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2017-07-25', 'endpointPrefix' => 'dataexchange', 'jsonVersion' => '1.1', 'protocol' => 'rest-json', 'serviceFullName' => 'AWS Data Exchange', 'serviceId' => 'DataExchange', 'signatureVersion' => 'v4', 'signingName' => 'dataexchange', 'uid' => 'dataexchange-2017-07-25', ], 'operations' => [ 'CancelJob' => [ 'name' => 'CancelJob', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v1/jobs/{JobId}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'CancelJobRequest', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateDataSet' => [ 'name' => 'CreateDataSet', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/data-sets', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateDataSetRequest', ], 'output' => [ 'shape' => 'CreateDataSetResponse', ], 'errors' => [ [ 'shape' => 'ServiceLimitExceededException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateEventAction' => [ 'name' => 'CreateEventAction', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/event-actions', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateEventActionRequest', ], 'output' => [ 'shape' => 'CreateEventActionResponse', ], 'errors' => [ [ 'shape' => 'ServiceLimitExceededException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateJob' => [ 'name' => 'CreateJob', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/jobs', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateJobRequest', ], 'output' => [ 'shape' => 'CreateJobResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateRevision' => [ 'name' => 'CreateRevision', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/data-sets/{DataSetId}/revisions', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateRevisionRequest', ], 'output' => [ 'shape' => 'CreateRevisionResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteAsset' => [ 'name' => 'DeleteAsset', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v1/data-sets/{DataSetId}/revisions/{RevisionId}/assets/{AssetId}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteAssetRequest', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteDataSet' => [ 'name' => 'DeleteDataSet', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v1/data-sets/{DataSetId}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteDataSetRequest', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteEventAction' => [ 'name' => 'DeleteEventAction', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v1/event-actions/{EventActionId}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteEventActionRequest', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteRevision' => [ 'name' => 'DeleteRevision', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v1/data-sets/{DataSetId}/revisions/{RevisionId}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteRevisionRequest', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetAsset' => [ 'name' => 'GetAsset', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/data-sets/{DataSetId}/revisions/{RevisionId}/assets/{AssetId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetAssetRequest', ], 'output' => [ 'shape' => 'GetAssetResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetDataSet' => [ 'name' => 'GetDataSet', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/data-sets/{DataSetId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetDataSetRequest', ], 'output' => [ 'shape' => 'GetDataSetResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetEventAction' => [ 'name' => 'GetEventAction', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/event-actions/{EventActionId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetEventActionRequest', ], 'output' => [ 'shape' => 'GetEventActionResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetJob' => [ 'name' => 'GetJob', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/jobs/{JobId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetJobRequest', ], 'output' => [ 'shape' => 'GetJobResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetRevision' => [ 'name' => 'GetRevision', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/data-sets/{DataSetId}/revisions/{RevisionId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetRevisionRequest', ], 'output' => [ 'shape' => 'GetRevisionResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListDataSetRevisions' => [ 'name' => 'ListDataSetRevisions', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/data-sets/{DataSetId}/revisions', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListDataSetRevisionsRequest', ], 'output' => [ 'shape' => 'ListDataSetRevisionsResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListDataSets' => [ 'name' => 'ListDataSets', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/data-sets', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListDataSetsRequest', ], 'output' => [ 'shape' => 'ListDataSetsResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListEventActions' => [ 'name' => 'ListEventActions', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/event-actions', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListEventActionsRequest', ], 'output' => [ 'shape' => 'ListEventActionsResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListJobs' => [ 'name' => 'ListJobs', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/jobs', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListJobsRequest', ], 'output' => [ 'shape' => 'ListJobsResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListRevisionAssets' => [ 'name' => 'ListRevisionAssets', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/data-sets/{DataSetId}/revisions/{RevisionId}/assets', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListRevisionAssetsRequest', ], 'output' => [ 'shape' => 'ListRevisionAssetsResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/tags/{ResourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], ], 'RevokeRevision' => [ 'name' => 'RevokeRevision', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/data-sets/{DataSetId}/revisions/{RevisionId}/revoke', 'responseCode' => 200, ], 'input' => [ 'shape' => 'RevokeRevisionRequest', ], 'output' => [ 'shape' => 'RevokeRevisionResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'SendApiAsset' => [ 'name' => 'SendApiAsset', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1', 'responseCode' => 200, ], 'input' => [ 'shape' => 'SendApiAssetRequest', ], 'output' => [ 'shape' => 'SendApiAssetResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], 'endpoint' => [ 'hostPrefix' => 'api-fulfill.', ], ], 'SendDataSetNotification' => [ 'name' => 'SendDataSetNotification', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/data-sets/{DataSetId}/notification', 'responseCode' => 202, ], 'input' => [ 'shape' => 'SendDataSetNotificationRequest', ], 'output' => [ 'shape' => 'SendDataSetNotificationResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'StartJob' => [ 'name' => 'StartJob', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/v1/jobs/{JobId}', 'responseCode' => 202, ], 'input' => [ 'shape' => 'StartJobRequest', ], 'output' => [ 'shape' => 'StartJobResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tags/{ResourceArn}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'TagResourceRequest', ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tags/{ResourceArn}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'idempotent' => true, ], 'UpdateAsset' => [ 'name' => 'UpdateAsset', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/v1/data-sets/{DataSetId}/revisions/{RevisionId}/assets/{AssetId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateAssetRequest', ], 'output' => [ 'shape' => 'UpdateAssetResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UpdateDataSet' => [ 'name' => 'UpdateDataSet', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/v1/data-sets/{DataSetId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateDataSetRequest', ], 'output' => [ 'shape' => 'UpdateDataSetResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UpdateEventAction' => [ 'name' => 'UpdateEventAction', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/v1/event-actions/{EventActionId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateEventActionRequest', ], 'output' => [ 'shape' => 'UpdateEventActionResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UpdateRevision' => [ 'name' => 'UpdateRevision', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/v1/data-sets/{DataSetId}/revisions/{RevisionId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateRevisionRequest', ], 'output' => [ 'shape' => 'UpdateRevisionResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], ], 'shapes' => [ 'AccessDeniedException' => [ 'type' => 'structure', 'required' => [ 'Message', ], 'members' => [ 'Message' => [ 'shape' => '__string', ], ], 'error' => [ 'httpStatusCode' => 403, 'senderFault' => true, ], 'exception' => true, ], 'Action' => [ 'type' => 'structure', 'members' => [ 'ExportRevisionToS3' => [ 'shape' => 'AutoExportRevisionToS3RequestDetails', ], ], ], 'ApiDescription' => [ 'type' => 'string', ], 'ApiGatewayApiAsset' => [ 'type' => 'structure', 'members' => [ 'ApiDescription' => [ 'shape' => 'ApiDescription', ], 'ApiEndpoint' => [ 'shape' => '__string', ], 'ApiId' => [ 'shape' => '__string', ], 'ApiKey' => [ 'shape' => '__string', ], 'ApiName' => [ 'shape' => '__string', ], 'ApiSpecificationDownloadUrl' => [ 'shape' => '__string', ], 'ApiSpecificationDownloadUrlExpiresAt' => [ 'shape' => 'Timestamp', ], 'ProtocolType' => [ 'shape' => 'ProtocolType', ], 'Stage' => [ 'shape' => '__string', ], ], ], 'Arn' => [ 'type' => 'string', ], 'AssetDestinationEntry' => [ 'type' => 'structure', 'required' => [ 'AssetId', 'Bucket', ], 'members' => [ 'AssetId' => [ 'shape' => 'Id', ], 'Bucket' => [ 'shape' => '__string', ], 'Key' => [ 'shape' => '__string', ], ], ], 'AssetDetails' => [ 'type' => 'structure', 'members' => [ 'S3SnapshotAsset' => [ 'shape' => 'S3SnapshotAsset', ], 'RedshiftDataShareAsset' => [ 'shape' => 'RedshiftDataShareAsset', ], 'ApiGatewayApiAsset' => [ 'shape' => 'ApiGatewayApiAsset', ], 'S3DataAccessAsset' => [ 'shape' => 'S3DataAccessAsset', ], 'LakeFormationDataPermissionAsset' => [ 'shape' => 'LakeFormationDataPermissionAsset', ], ], ], 'AssetEntry' => [ 'type' => 'structure', 'required' => [ 'Arn', 'AssetDetails', 'AssetType', 'CreatedAt', 'DataSetId', 'Id', 'Name', 'RevisionId', 'UpdatedAt', ], 'members' => [ 'Arn' => [ 'shape' => 'Arn', ], 'AssetDetails' => [ 'shape' => 'AssetDetails', ], 'AssetType' => [ 'shape' => 'AssetType', ], 'CreatedAt' => [ 'shape' => 'Timestamp', ], 'DataSetId' => [ 'shape' => 'Id', ], 'Id' => [ 'shape' => 'Id', ], 'Name' => [ 'shape' => 'AssetName', ], 'RevisionId' => [ 'shape' => 'Id', ], 'SourceId' => [ 'shape' => 'Id', ], 'UpdatedAt' => [ 'shape' => 'Timestamp', ], ], ], 'AssetName' => [ 'type' => 'string', ], 'AssetSourceEntry' => [ 'type' => 'structure', 'required' => [ 'Bucket', 'Key', ], 'members' => [ 'Bucket' => [ 'shape' => '__string', ], 'Key' => [ 'shape' => '__string', ], ], ], 'AssetType' => [ 'type' => 'string', 'enum' => [ 'S3_SNAPSHOT', 'REDSHIFT_DATA_SHARE', 'API_GATEWAY_API', 'S3_DATA_ACCESS', 'LAKE_FORMATION_DATA_PERMISSION', ], ], 'AutoExportRevisionDestinationEntry' => [ 'type' => 'structure', 'required' => [ 'Bucket', ], 'members' => [ 'Bucket' => [ 'shape' => '__string', ], 'KeyPattern' => [ 'shape' => '__string', ], ], ], 'AutoExportRevisionToS3RequestDetails' => [ 'type' => 'structure', 'required' => [ 'RevisionDestination', ], 'members' => [ 'Encryption' => [ 'shape' => 'ExportServerSideEncryption', ], 'RevisionDestination' => [ 'shape' => 'AutoExportRevisionDestinationEntry', ], ], ], 'AwsAccountId' => [ 'type' => 'string', 'max' => 12, 'min' => 12, 'pattern' => '.*/^[\\d]{12}$/.*', ], 'CancelJobRequest' => [ 'type' => 'structure', 'required' => [ 'JobId', ], 'members' => [ 'JobId' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'JobId', ], ], ], 'ClientToken' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[\\x21-\\x7E]{1,64}', ], 'Code' => [ 'type' => 'string', 'enum' => [ 'ACCESS_DENIED_EXCEPTION', 'INTERNAL_SERVER_EXCEPTION', 'MALWARE_DETECTED', 'RESOURCE_NOT_FOUND_EXCEPTION', 'SERVICE_QUOTA_EXCEEDED_EXCEPTION', 'VALIDATION_EXCEPTION', 'MALWARE_SCAN_ENCRYPTED_FILE', ], ], 'ConflictException' => [ 'type' => 'structure', 'required' => [ 'Message', ], 'members' => [ 'Message' => [ 'shape' => '__string', ], 'ResourceId' => [ 'shape' => '__string', ], 'ResourceType' => [ 'shape' => 'ResourceType', ], ], 'error' => [ 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'CreateDataSetRequest' => [ 'type' => 'structure', 'required' => [ 'AssetType', 'Description', 'Name', ], 'members' => [ 'AssetType' => [ 'shape' => 'AssetType', ], 'Description' => [ 'shape' => 'Description', ], 'Name' => [ 'shape' => 'Name', ], 'Tags' => [ 'shape' => 'MapOf__string', ], ], ], 'CreateDataSetResponse' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'Arn', ], 'AssetType' => [ 'shape' => 'AssetType', ], 'CreatedAt' => [ 'shape' => 'Timestamp', ], 'Description' => [ 'shape' => 'Description', ], 'Id' => [ 'shape' => 'Id', ], 'Name' => [ 'shape' => 'Name', ], 'Origin' => [ 'shape' => 'Origin', ], 'OriginDetails' => [ 'shape' => 'OriginDetails', ], 'SourceId' => [ 'shape' => 'Id', ], 'Tags' => [ 'shape' => 'MapOf__string', ], 'UpdatedAt' => [ 'shape' => 'Timestamp', ], ], ], 'CreateEventActionRequest' => [ 'type' => 'structure', 'required' => [ 'Action', 'Event', ], 'members' => [ 'Action' => [ 'shape' => 'Action', ], 'Event' => [ 'shape' => 'Event', ], ], ], 'CreateEventActionResponse' => [ 'type' => 'structure', 'members' => [ 'Action' => [ 'shape' => 'Action', ], 'Arn' => [ 'shape' => 'Arn', ], 'CreatedAt' => [ 'shape' => 'Timestamp', ], 'Event' => [ 'shape' => 'Event', ], 'Id' => [ 'shape' => 'Id', ], 'UpdatedAt' => [ 'shape' => 'Timestamp', ], ], ], 'CreateJobRequest' => [ 'type' => 'structure', 'required' => [ 'Details', 'Type', ], 'members' => [ 'Details' => [ 'shape' => 'RequestDetails', ], 'Type' => [ 'shape' => 'Type', ], ], ], 'CreateJobResponse' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'Arn', ], 'CreatedAt' => [ 'shape' => 'Timestamp', ], 'Details' => [ 'shape' => 'ResponseDetails', ], 'Errors' => [ 'shape' => 'ListOfJobError', ], 'Id' => [ 'shape' => 'Id', ], 'State' => [ 'shape' => 'State', ], 'Type' => [ 'shape' => 'Type', ], 'UpdatedAt' => [ 'shape' => 'Timestamp', ], ], ], 'CreateRevisionRequest' => [ 'type' => 'structure', 'required' => [ 'DataSetId', ], 'members' => [ 'Comment' => [ 'shape' => '__stringMin0Max16384', ], 'DataSetId' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'DataSetId', ], 'Tags' => [ 'shape' => 'MapOf__string', ], ], ], 'CreateRevisionResponse' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'Arn', ], 'Comment' => [ 'shape' => '__stringMin0Max16384', ], 'CreatedAt' => [ 'shape' => 'Timestamp', ], 'DataSetId' => [ 'shape' => 'Id', ], 'Finalized' => [ 'shape' => '__boolean', ], 'Id' => [ 'shape' => 'Id', ], 'SourceId' => [ 'shape' => 'Id', ], 'Tags' => [ 'shape' => 'MapOf__string', ], 'UpdatedAt' => [ 'shape' => 'Timestamp', ], 'RevocationComment' => [ 'shape' => '__stringMin10Max512', ], 'Revoked' => [ 'shape' => '__boolean', ], 'RevokedAt' => [ 'shape' => 'Timestamp', ], ], ], 'CreateS3DataAccessFromS3BucketRequestDetails' => [ 'type' => 'structure', 'required' => [ 'AssetSource', 'DataSetId', 'RevisionId', ], 'members' => [ 'AssetSource' => [ 'shape' => 'S3DataAccessAssetSourceEntry', ], 'DataSetId' => [ 'shape' => 'Id', ], 'RevisionId' => [ 'shape' => 'Id', ], ], ], 'CreateS3DataAccessFromS3BucketResponseDetails' => [ 'type' => 'structure', 'required' => [ 'AssetSource', 'DataSetId', 'RevisionId', ], 'members' => [ 'AssetSource' => [ 'shape' => 'S3DataAccessAssetSourceEntry', ], 'DataSetId' => [ 'shape' => 'Id', ], 'RevisionId' => [ 'shape' => 'Id', ], ], ], 'DataSetEntry' => [ 'type' => 'structure', 'required' => [ 'Arn', 'AssetType', 'CreatedAt', 'Description', 'Id', 'Name', 'Origin', 'UpdatedAt', ], 'members' => [ 'Arn' => [ 'shape' => 'Arn', ], 'AssetType' => [ 'shape' => 'AssetType', ], 'CreatedAt' => [ 'shape' => 'Timestamp', ], 'Description' => [ 'shape' => 'Description', ], 'Id' => [ 'shape' => 'Id', ], 'Name' => [ 'shape' => 'Name', ], 'Origin' => [ 'shape' => 'Origin', ], 'OriginDetails' => [ 'shape' => 'OriginDetails', ], 'SourceId' => [ 'shape' => 'Id', ], 'UpdatedAt' => [ 'shape' => 'Timestamp', ], ], ], 'DataUpdateRequestDetails' => [ 'type' => 'structure', 'members' => [ 'DataUpdatedAt' => [ 'shape' => 'Timestamp', ], ], ], 'DatabaseLFTagPolicy' => [ 'type' => 'structure', 'required' => [ 'Expression', ], 'members' => [ 'Expression' => [ 'shape' => 'ListOfLFTags', ], ], ], 'DatabaseLFTagPolicyAndPermissions' => [ 'type' => 'structure', 'required' => [ 'Expression', 'Permissions', ], 'members' => [ 'Expression' => [ 'shape' => 'ListOfLFTags', ], 'Permissions' => [ 'shape' => 'ListOfDatabaseLFTagPolicyPermissions', ], ], ], 'DatabaseLFTagPolicyPermission' => [ 'type' => 'string', 'enum' => [ 'DESCRIBE', ], ], 'DeleteAssetRequest' => [ 'type' => 'structure', 'required' => [ 'AssetId', 'DataSetId', 'RevisionId', ], 'members' => [ 'AssetId' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'AssetId', ], 'DataSetId' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'DataSetId', ], 'RevisionId' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'RevisionId', ], ], ], 'DeleteDataSetRequest' => [ 'type' => 'structure', 'required' => [ 'DataSetId', ], 'members' => [ 'DataSetId' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'DataSetId', ], ], ], 'DeleteEventActionRequest' => [ 'type' => 'structure', 'required' => [ 'EventActionId', ], 'members' => [ 'EventActionId' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'EventActionId', ], ], ], 'DeleteRevisionRequest' => [ 'type' => 'structure', 'required' => [ 'DataSetId', 'RevisionId', ], 'members' => [ 'DataSetId' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'DataSetId', ], 'RevisionId' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'RevisionId', ], ], ], 'DeprecationRequestDetails' => [ 'type' => 'structure', 'required' => [ 'DeprecationAt', ], 'members' => [ 'DeprecationAt' => [ 'shape' => 'Timestamp', ], ], ], 'Description' => [ 'type' => 'string', ], 'Details' => [ 'type' => 'structure', 'members' => [ 'ImportAssetFromSignedUrlJobErrorDetails' => [ 'shape' => 'ImportAssetFromSignedUrlJobErrorDetails', ], 'ImportAssetsFromS3JobErrorDetails' => [ 'shape' => 'ListOfAssetSourceEntry', ], ], ], 'Event' => [ 'type' => 'structure', 'members' => [ 'RevisionPublished' => [ 'shape' => 'RevisionPublished', ], ], ], 'EventActionEntry' => [ 'type' => 'structure', 'required' => [ 'Action', 'Arn', 'CreatedAt', 'Event', 'Id', 'UpdatedAt', ], 'members' => [ 'Action' => [ 'shape' => 'Action', ], 'Arn' => [ 'shape' => 'Arn', ], 'CreatedAt' => [ 'shape' => 'Timestamp', ], 'Event' => [ 'shape' => 'Event', ], 'Id' => [ 'shape' => 'Id', ], 'UpdatedAt' => [ 'shape' => 'Timestamp', ], ], ], 'ExceptionCause' => [ 'type' => 'string', 'enum' => [ 'InsufficientS3BucketPolicy', 'S3AccessDenied', ], ], 'ExportAssetToSignedUrlRequestDetails' => [ 'type' => 'structure', 'required' => [ 'AssetId', 'DataSetId', 'RevisionId', ], 'members' => [ 'AssetId' => [ 'shape' => 'Id', ], 'DataSetId' => [ 'shape' => 'Id', ], 'RevisionId' => [ 'shape' => 'Id', ], ], ], 'ExportAssetToSignedUrlResponseDetails' => [ 'type' => 'structure', 'required' => [ 'AssetId', 'DataSetId', 'RevisionId', ], 'members' => [ 'AssetId' => [ 'shape' => 'Id', ], 'DataSetId' => [ 'shape' => 'Id', ], 'RevisionId' => [ 'shape' => 'Id', ], 'SignedUrl' => [ 'shape' => '__string', ], 'SignedUrlExpiresAt' => [ 'shape' => 'Timestamp', ], ], ], 'ExportAssetsToS3RequestDetails' => [ 'type' => 'structure', 'required' => [ 'AssetDestinations', 'DataSetId', 'RevisionId', ], 'members' => [ 'AssetDestinations' => [ 'shape' => 'ListOfAssetDestinationEntry', ], 'DataSetId' => [ 'shape' => 'Id', ], 'Encryption' => [ 'shape' => 'ExportServerSideEncryption', ], 'RevisionId' => [ 'shape' => 'Id', ], ], ], 'ExportAssetsToS3ResponseDetails' => [ 'type' => 'structure', 'required' => [ 'AssetDestinations', 'DataSetId', 'RevisionId', ], 'members' => [ 'AssetDestinations' => [ 'shape' => 'ListOfAssetDestinationEntry', ], 'DataSetId' => [ 'shape' => 'Id', ], 'Encryption' => [ 'shape' => 'ExportServerSideEncryption', ], 'RevisionId' => [ 'shape' => 'Id', ], ], ], 'ExportRevisionsToS3RequestDetails' => [ 'type' => 'structure', 'required' => [ 'DataSetId', 'RevisionDestinations', ], 'members' => [ 'DataSetId' => [ 'shape' => 'Id', ], 'Encryption' => [ 'shape' => 'ExportServerSideEncryption', ], 'RevisionDestinations' => [ 'shape' => 'ListOfRevisionDestinationEntry', ], ], ], 'ExportRevisionsToS3ResponseDetails' => [ 'type' => 'structure', 'required' => [ 'DataSetId', 'RevisionDestinations', ], 'members' => [ 'DataSetId' => [ 'shape' => 'Id', ], 'Encryption' => [ 'shape' => 'ExportServerSideEncryption', ], 'RevisionDestinations' => [ 'shape' => 'ListOfRevisionDestinationEntry', ], 'EventActionArn' => [ 'shape' => '__string', ], ], ], 'ExportServerSideEncryption' => [ 'type' => 'structure', 'required' => [ 'Type', ], 'members' => [ 'KmsKeyArn' => [ 'shape' => '__string', ], 'Type' => [ 'shape' => 'ServerSideEncryptionTypes', ], ], ], 'GetAssetRequest' => [ 'type' => 'structure', 'required' => [ 'AssetId', 'DataSetId', 'RevisionId', ], 'members' => [ 'AssetId' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'AssetId', ], 'DataSetId' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'DataSetId', ], 'RevisionId' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'RevisionId', ], ], ], 'GetAssetResponse' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'Arn', ], 'AssetDetails' => [ 'shape' => 'AssetDetails', ], 'AssetType' => [ 'shape' => 'AssetType', ], 'CreatedAt' => [ 'shape' => 'Timestamp', ], 'DataSetId' => [ 'shape' => 'Id', ], 'Id' => [ 'shape' => 'Id', ], 'Name' => [ 'shape' => 'AssetName', ], 'RevisionId' => [ 'shape' => 'Id', ], 'SourceId' => [ 'shape' => 'Id', ], 'UpdatedAt' => [ 'shape' => 'Timestamp', ], ], ], 'GetDataSetRequest' => [ 'type' => 'structure', 'required' => [ 'DataSetId', ], 'members' => [ 'DataSetId' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'DataSetId', ], ], ], 'GetDataSetResponse' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'Arn', ], 'AssetType' => [ 'shape' => 'AssetType', ], 'CreatedAt' => [ 'shape' => 'Timestamp', ], 'Description' => [ 'shape' => 'Description', ], 'Id' => [ 'shape' => 'Id', ], 'Name' => [ 'shape' => 'Name', ], 'Origin' => [ 'shape' => 'Origin', ], 'OriginDetails' => [ 'shape' => 'OriginDetails', ], 'SourceId' => [ 'shape' => 'Id', ], 'Tags' => [ 'shape' => 'MapOf__string', ], 'UpdatedAt' => [ 'shape' => 'Timestamp', ], ], ], 'GetEventActionRequest' => [ 'type' => 'structure', 'required' => [ 'EventActionId', ], 'members' => [ 'EventActionId' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'EventActionId', ], ], ], 'GetEventActionResponse' => [ 'type' => 'structure', 'members' => [ 'Action' => [ 'shape' => 'Action', ], 'Arn' => [ 'shape' => 'Arn', ], 'CreatedAt' => [ 'shape' => 'Timestamp', ], 'Event' => [ 'shape' => 'Event', ], 'Id' => [ 'shape' => 'Id', ], 'UpdatedAt' => [ 'shape' => 'Timestamp', ], ], ], 'GetJobRequest' => [ 'type' => 'structure', 'required' => [ 'JobId', ], 'members' => [ 'JobId' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'JobId', ], ], ], 'GetJobResponse' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'Arn', ], 'CreatedAt' => [ 'shape' => 'Timestamp', ], 'Details' => [ 'shape' => 'ResponseDetails', ], 'Errors' => [ 'shape' => 'ListOfJobError', ], 'Id' => [ 'shape' => 'Id', ], 'State' => [ 'shape' => 'State', ], 'Type' => [ 'shape' => 'Type', ], 'UpdatedAt' => [ 'shape' => 'Timestamp', ], ], ], 'GetRevisionRequest' => [ 'type' => 'structure', 'required' => [ 'DataSetId', 'RevisionId', ], 'members' => [ 'DataSetId' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'DataSetId', ], 'RevisionId' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'RevisionId', ], ], ], 'GetRevisionResponse' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'Arn', ], 'Comment' => [ 'shape' => '__stringMin0Max16384', ], 'CreatedAt' => [ 'shape' => 'Timestamp', ], 'DataSetId' => [ 'shape' => 'Id', ], 'Finalized' => [ 'shape' => '__boolean', ], 'Id' => [ 'shape' => 'Id', ], 'SourceId' => [ 'shape' => 'Id', ], 'Tags' => [ 'shape' => 'MapOf__string', ], 'UpdatedAt' => [ 'shape' => 'Timestamp', ], 'RevocationComment' => [ 'shape' => '__stringMin10Max512', ], 'Revoked' => [ 'shape' => '__boolean', ], 'RevokedAt' => [ 'shape' => 'Timestamp', ], ], ], 'Id' => [ 'type' => 'string', ], 'ImportAssetFromApiGatewayApiRequestDetails' => [ 'type' => 'structure', 'required' => [ 'ApiId', 'ApiName', 'ApiSpecificationMd5Hash', 'DataSetId', 'ProtocolType', 'RevisionId', 'Stage', ], 'members' => [ 'ApiDescription' => [ 'shape' => 'ApiDescription', ], 'ApiId' => [ 'shape' => '__string', ], 'ApiKey' => [ 'shape' => '__string', ], 'ApiName' => [ 'shape' => '__string', ], 'ApiSpecificationMd5Hash' => [ 'shape' => '__stringMin24Max24PatternAZaZ094AZaZ092AZaZ093', ], 'DataSetId' => [ 'shape' => 'Id', ], 'ProtocolType' => [ 'shape' => 'ProtocolType', ], 'RevisionId' => [ 'shape' => 'Id', ], 'Stage' => [ 'shape' => '__string', ], ], ], 'ImportAssetFromApiGatewayApiResponseDetails' => [ 'type' => 'structure', 'required' => [ 'ApiId', 'ApiName', 'ApiSpecificationMd5Hash', 'ApiSpecificationUploadUrl', 'ApiSpecificationUploadUrlExpiresAt', 'DataSetId', 'ProtocolType', 'RevisionId', 'Stage', ], 'members' => [ 'ApiDescription' => [ 'shape' => 'ApiDescription', ], 'ApiId' => [ 'shape' => '__string', ], 'ApiKey' => [ 'shape' => '__string', ], 'ApiName' => [ 'shape' => '__string', ], 'ApiSpecificationMd5Hash' => [ 'shape' => '__stringMin24Max24PatternAZaZ094AZaZ092AZaZ093', ], 'ApiSpecificationUploadUrl' => [ 'shape' => '__string', ], 'ApiSpecificationUploadUrlExpiresAt' => [ 'shape' => 'Timestamp', ], 'DataSetId' => [ 'shape' => 'Id', ], 'ProtocolType' => [ 'shape' => 'ProtocolType', ], 'RevisionId' => [ 'shape' => 'Id', ], 'Stage' => [ 'shape' => '__string', ], ], ], 'ImportAssetFromSignedUrlJobErrorDetails' => [ 'type' => 'structure', 'required' => [ 'AssetName', ], 'members' => [ 'AssetName' => [ 'shape' => 'AssetName', ], ], ], 'ImportAssetFromSignedUrlRequestDetails' => [ 'type' => 'structure', 'required' => [ 'AssetName', 'DataSetId', 'Md5Hash', 'RevisionId', ], 'members' => [ 'AssetName' => [ 'shape' => 'AssetName', ], 'DataSetId' => [ 'shape' => 'Id', ], 'Md5Hash' => [ 'shape' => '__stringMin24Max24PatternAZaZ094AZaZ092AZaZ093', ], 'RevisionId' => [ 'shape' => 'Id', ], ], ], 'ImportAssetFromSignedUrlResponseDetails' => [ 'type' => 'structure', 'required' => [ 'AssetName', 'DataSetId', 'RevisionId', ], 'members' => [ 'AssetName' => [ 'shape' => 'AssetName', ], 'DataSetId' => [ 'shape' => 'Id', ], 'Md5Hash' => [ 'shape' => '__stringMin24Max24PatternAZaZ094AZaZ092AZaZ093', ], 'RevisionId' => [ 'shape' => 'Id', ], 'SignedUrl' => [ 'shape' => '__string', ], 'SignedUrlExpiresAt' => [ 'shape' => 'Timestamp', ], ], ], 'ImportAssetsFromLakeFormationTagPolicyRequestDetails' => [ 'type' => 'structure', 'required' => [ 'CatalogId', 'RoleArn', 'DataSetId', 'RevisionId', ], 'members' => [ 'CatalogId' => [ 'shape' => 'AwsAccountId', ], 'Database' => [ 'shape' => 'DatabaseLFTagPolicyAndPermissions', ], 'Table' => [ 'shape' => 'TableLFTagPolicyAndPermissions', ], 'RoleArn' => [ 'shape' => 'RoleArn', ], 'DataSetId' => [ 'shape' => 'Id', ], 'RevisionId' => [ 'shape' => 'Id', ], ], ], 'ImportAssetsFromLakeFormationTagPolicyResponseDetails' => [ 'type' => 'structure', 'required' => [ 'CatalogId', 'RoleArn', 'DataSetId', 'RevisionId', ], 'members' => [ 'CatalogId' => [ 'shape' => 'AwsAccountId', ], 'Database' => [ 'shape' => 'DatabaseLFTagPolicyAndPermissions', ], 'Table' => [ 'shape' => 'TableLFTagPolicyAndPermissions', ], 'RoleArn' => [ 'shape' => 'RoleArn', ], 'DataSetId' => [ 'shape' => 'Id', ], 'RevisionId' => [ 'shape' => 'Id', ], ], ], 'ImportAssetsFromRedshiftDataSharesRequestDetails' => [ 'type' => 'structure', 'required' => [ 'AssetSources', 'DataSetId', 'RevisionId', ], 'members' => [ 'AssetSources' => [ 'shape' => 'ListOfRedshiftDataShareAssetSourceEntry', ], 'DataSetId' => [ 'shape' => 'Id', ], 'RevisionId' => [ 'shape' => 'Id', ], ], ], 'ImportAssetsFromRedshiftDataSharesResponseDetails' => [ 'type' => 'structure', 'required' => [ 'AssetSources', 'DataSetId', 'RevisionId', ], 'members' => [ 'AssetSources' => [ 'shape' => 'ListOfRedshiftDataShareAssetSourceEntry', ], 'DataSetId' => [ 'shape' => 'Id', ], 'RevisionId' => [ 'shape' => 'Id', ], ], ], 'ImportAssetsFromS3RequestDetails' => [ 'type' => 'structure', 'required' => [ 'AssetSources', 'DataSetId', 'RevisionId', ], 'members' => [ 'AssetSources' => [ 'shape' => 'ListOfAssetSourceEntry', ], 'DataSetId' => [ 'shape' => 'Id', ], 'RevisionId' => [ 'shape' => 'Id', ], ], ], 'ImportAssetsFromS3ResponseDetails' => [ 'type' => 'structure', 'required' => [ 'AssetSources', 'DataSetId', 'RevisionId', ], 'members' => [ 'AssetSources' => [ 'shape' => 'ListOfAssetSourceEntry', ], 'DataSetId' => [ 'shape' => 'Id', ], 'RevisionId' => [ 'shape' => 'Id', ], ], ], 'InternalServerException' => [ 'type' => 'structure', 'required' => [ 'Message', ], 'members' => [ 'Message' => [ 'shape' => '__string', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, ], 'JobEntry' => [ 'type' => 'structure', 'required' => [ 'Arn', 'CreatedAt', 'Details', 'Id', 'State', 'Type', 'UpdatedAt', ], 'members' => [ 'Arn' => [ 'shape' => 'Arn', ], 'CreatedAt' => [ 'shape' => 'Timestamp', ], 'Details' => [ 'shape' => 'ResponseDetails', ], 'Errors' => [ 'shape' => 'ListOfJobError', ], 'Id' => [ 'shape' => 'Id', ], 'State' => [ 'shape' => 'State', ], 'Type' => [ 'shape' => 'Type', ], 'UpdatedAt' => [ 'shape' => 'Timestamp', ], ], ], 'JobError' => [ 'type' => 'structure', 'required' => [ 'Code', 'Message', ], 'members' => [ 'Code' => [ 'shape' => 'Code', ], 'Details' => [ 'shape' => 'Details', ], 'LimitName' => [ 'shape' => 'JobErrorLimitName', ], 'LimitValue' => [ 'shape' => '__double', ], 'Message' => [ 'shape' => '__string', ], 'ResourceId' => [ 'shape' => '__string', ], 'ResourceType' => [ 'shape' => 'JobErrorResourceTypes', ], ], ], 'JobErrorLimitName' => [ 'type' => 'string', 'enum' => [ 'Assets per revision', 'Asset size in GB', 'Amazon Redshift datashare assets per revision', 'AWS Lake Formation data permission assets per revision', 'Amazon S3 data access assets per revision', ], ], 'JobErrorResourceTypes' => [ 'type' => 'string', 'enum' => [ 'REVISION', 'ASSET', 'DATA_SET', ], ], 'KmsKeyArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, ], 'KmsKeyToGrant' => [ 'type' => 'structure', 'required' => [ 'KmsKeyArn', ], 'members' => [ 'KmsKeyArn' => [ 'shape' => 'KmsKeyArn', ], ], ], 'LFPermission' => [ 'type' => 'string', 'enum' => [ 'DESCRIBE', 'SELECT', ], ], 'LFResourceDetails' => [ 'type' => 'structure',