<?php
// This file was auto-generated from sdk-root/src/data/eks/2017-11-01/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2017-11-01', 'endpointPrefix' => 'eks', 'jsonVersion' => '1.1', 'protocol' => 'rest-json', 'protocols' => [ 'rest-json', ], 'serviceAbbreviation' => 'Amazon EKS', 'serviceFullName' => 'Amazon Elastic Kubernetes Service', 'serviceId' => 'EKS', 'signatureVersion' => 'v4', 'signingName' => 'eks', 'uid' => 'eks-2017-11-01', 'auth' => [ 'aws.auth#sigv4', ], ], 'operations' => [ 'AssociateAccessPolicy' => [ 'name' => 'AssociateAccessPolicy', 'http' => [ 'method' => 'POST', 'requestUri' => '/clusters/{name}/access-entries/{principalArn}/access-policies', ], 'input' => [ 'shape' => 'AssociateAccessPolicyRequest', ], 'output' => [ 'shape' => 'AssociateAccessPolicyResponse', ], 'errors' => [ [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], ], ], 'AssociateEncryptionConfig' => [ 'name' => 'AssociateEncryptionConfig', 'http' => [ 'method' => 'POST', 'requestUri' => '/clusters/{name}/encryption-config/associate', ], 'input' => [ 'shape' => 'AssociateEncryptionConfigRequest', ], 'output' => [ 'shape' => 'AssociateEncryptionConfigResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceInUseException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'AssociateIdentityProviderConfig' => [ 'name' => 'AssociateIdentityProviderConfig', 'http' => [ 'method' => 'POST', 'requestUri' => '/clusters/{name}/identity-provider-configs/associate', ], 'input' => [ 'shape' => 'AssociateIdentityProviderConfigRequest', ], 'output' => [ 'shape' => 'AssociateIdentityProviderConfigResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceInUseException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'CreateAccessEntry' => [ 'name' => 'CreateAccessEntry', 'http' => [ 'method' => 'POST', 'requestUri' => '/clusters/{name}/access-entries', ], 'input' => [ 'shape' => 'CreateAccessEntryRequest', ], 'output' => [ 'shape' => 'CreateAccessEntryResponse', ], 'errors' => [ [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceLimitExceededException', ], [ 'shape' => 'ResourceInUseException', ], ], ], 'CreateAddon' => [ 'name' => 'CreateAddon', 'http' => [ 'method' => 'POST', 'requestUri' => '/clusters/{name}/addons', ], 'input' => [ 'shape' => 'CreateAddonRequest', ], 'output' => [ 'shape' => 'CreateAddonResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ResourceInUseException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], ], ], 'CreateCluster' => [ 'name' => 'CreateCluster', 'http' => [ 'method' => 'POST', 'requestUri' => '/clusters', ], 'input' => [ 'shape' => 'CreateClusterRequest', ], 'output' => [ 'shape' => 'CreateClusterResponse', ], 'errors' => [ [ 'shape' => 'ResourceInUseException', ], [ 'shape' => 'ResourceLimitExceededException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'UnsupportedAvailabilityZoneException', ], ], ], 'CreateEksAnywhereSubscription' => [ 'name' => 'CreateEksAnywhereSubscription', 'http' => [ 'method' => 'POST', 'requestUri' => '/eks-anywhere-subscriptions', ], 'input' => [ 'shape' => 'CreateEksAnywhereSubscriptionRequest', ], 'output' => [ 'shape' => 'CreateEksAnywhereSubscriptionResponse', ], 'errors' => [ [ 'shape' => 'ResourceLimitExceededException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'CreateFargateProfile' => [ 'name' => 'CreateFargateProfile', 'http' => [ 'method' => 'POST', 'requestUri' => '/clusters/{name}/fargate-profiles', ], 'input' => [ 'shape' => 'CreateFargateProfileRequest', ], 'output' => [ 'shape' => 'CreateFargateProfileResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceLimitExceededException', ], [ 'shape' => 'UnsupportedAvailabilityZoneException', ], ], ], 'CreateNodegroup' => [ 'name' => 'CreateNodegroup', 'http' => [ 'method' => 'POST', 'requestUri' => '/clusters/{name}/node-groups', ], 'input' => [ 'shape' => 'CreateNodegroupRequest', ], 'output' => [ 'shape' => 'CreateNodegroupResponse', ], 'errors' => [ [ 'shape' => 'ResourceInUseException', ], [ 'shape' => 'ResourceLimitExceededException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'CreatePodIdentityAssociation' => [ 'name' => 'CreatePodIdentityAssociation', 'http' => [ 'method' => 'POST', 'requestUri' => '/clusters/{name}/pod-identity-associations', ], 'input' => [ 'shape' => 'CreatePodIdentityAssociationRequest', ], 'output' => [ 'shape' => 'CreatePodIdentityAssociationResponse', ], 'errors' => [ [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceLimitExceededException', ], [ 'shape' => 'ResourceInUseException', ], ], ], 'DeleteAccessEntry' => [ 'name' => 'DeleteAccessEntry', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/clusters/{name}/access-entries/{principalArn}', ], 'input' => [ 'shape' => 'DeleteAccessEntryRequest', ], 'output' => [ 'shape' => 'DeleteAccessEntryResponse', ], 'errors' => [ [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'DeleteAddon' => [ 'name' => 'DeleteAddon', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/clusters/{name}/addons/{addonName}', ], 'input' => [ 'shape' => 'DeleteAddonRequest', ], 'output' => [ 'shape' => 'DeleteAddonResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], ], ], 'DeleteCluster' => [ 'name' => 'DeleteCluster', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/clusters/{name}', ], 'input' => [ 'shape' => 'DeleteClusterRequest', ], 'output' => [ 'shape' => 'DeleteClusterResponse', ], 'errors' => [ [ 'shape' => 'ResourceInUseException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'DeleteEksAnywhereSubscription' => [ 'name' => 'DeleteEksAnywhereSubscription', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/eks-anywhere-subscriptions/{id}', ], 'input' => [ 'shape' => 'DeleteEksAnywhereSubscriptionRequest', ], 'output' => [ 'shape' => 'DeleteEksAnywhereSubscriptionResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ServerException', ], ], ], 'DeleteFargateProfile' => [ 'name' => 'DeleteFargateProfile', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/clusters/{name}/fargate-profiles/{fargateProfileName}', ], 'input' => [ 'shape' => 'DeleteFargateProfileRequest', ], 'output' => [ 'shape' => 'DeleteFargateProfileResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'DeleteNodegroup' => [ 'name' => 'DeleteNodegroup', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/clusters/{name}/node-groups/{nodegroupName}', ], 'input' => [ 'shape' => 'DeleteNodegroupRequest', ], 'output' => [ 'shape' => 'DeleteNodegroupResponse', ], 'errors' => [ [ 'shape' => 'ResourceInUseException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'DeletePodIdentityAssociation' => [ 'name' => 'DeletePodIdentityAssociation', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/clusters/{name}/pod-identity-associations/{associationId}', ], 'input' => [ 'shape' => 'DeletePodIdentityAssociationRequest', ], 'output' => [ 'shape' => 'DeletePodIdentityAssociationResponse', ], 'errors' => [ [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], ], ], 'DeregisterCluster' => [ 'name' => 'DeregisterCluster', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/cluster-registrations/{name}', ], 'input' => [ 'shape' => 'DeregisterClusterRequest', ], 'output' => [ 'shape' => 'DeregisterClusterResponse', ], 'errors' => [ [ 'shape' => 'ResourceInUseException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'DescribeAccessEntry' => [ 'name' => 'DescribeAccessEntry', 'http' => [ 'method' => 'GET', 'requestUri' => '/clusters/{name}/access-entries/{principalArn}', ], 'input' => [ 'shape' => 'DescribeAccessEntryRequest', ], 'output' => [ 'shape' => 'DescribeAccessEntryResponse', ], 'errors' => [ [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'DescribeAddon' => [ 'name' => 'DescribeAddon', 'http' => [ 'method' => 'GET', 'requestUri' => '/clusters/{name}/addons/{addonName}', ], 'input' => [ 'shape' => 'DescribeAddonRequest', ], 'output' => [ 'shape' => 'DescribeAddonResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], ], ], 'DescribeAddonConfiguration' => [ 'name' => 'DescribeAddonConfiguration', 'http' => [ 'method' => 'GET', 'requestUri' => '/addons/configuration-schemas', ], 'input' => [ 'shape' => 'DescribeAddonConfigurationRequest', ], 'output' => [ 'shape' => 'DescribeAddonConfigurationResponse', ], 'errors' => [ [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidParameterException', ], ], ], 'DescribeAddonVersions' => [ 'name' => 'DescribeAddonVersions', 'http' => [ 'method' => 'GET', 'requestUri' => '/addons/supported-versions', ], 'input' => [ 'shape' => 'DescribeAddonVersionsRequest', ], 'output' => [ 'shape' => 'DescribeAddonVersionsResponse', ], 'errors' => [ [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidParameterException', ], ], ], 'DescribeCluster' => [ 'name' => 'DescribeCluster', 'http' => [ 'method' => 'GET', 'requestUri' => '/clusters/{name}', ], 'input' => [ 'shape' => 'DescribeClusterRequest', ], 'output' => [ 'shape' => 'DescribeClusterResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'DescribeEksAnywhereSubscription' => [ 'name' => 'DescribeEksAnywhereSubscription', 'http' => [ 'method' => 'GET', 'requestUri' => '/eks-anywhere-subscriptions/{id}', ], 'input' => [ 'shape' => 'DescribeEksAnywhereSubscriptionRequest', ], 'output' => [ 'shape' => 'DescribeEksAnywhereSubscriptionResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'DescribeFargateProfile' => [ 'name' => 'DescribeFargateProfile', 'http' => [ 'method' => 'GET', 'requestUri' => '/clusters/{name}/fargate-profiles/{fargateProfileName}', ], 'input' => [ 'shape' => 'DescribeFargateProfileRequest', ], 'output' => [ 'shape' => 'DescribeFargateProfileResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'DescribeIdentityProviderConfig' => [ 'name' => 'DescribeIdentityProviderConfig', 'http' => [ 'method' => 'POST', 'requestUri' => '/clusters/{name}/identity-provider-configs/describe', ], 'input' => [ 'shape' => 'DescribeIdentityProviderConfigRequest', ], 'output' => [ 'shape' => 'DescribeIdentityProviderConfigResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'DescribeInsight' => [ 'name' => 'DescribeInsight', 'http' => [ 'method' => 'GET', 'requestUri' => '/clusters/{name}/insights/{id}', ], 'input' => [ 'shape' => 'DescribeInsightRequest', ], 'output' => [ 'shape' => 'DescribeInsightResponse', ], 'errors' => [ [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], ], ], 'DescribeNodegroup' => [ 'name' => 'DescribeNodegroup', 'http' => [ 'method' => 'GET', 'requestUri' => '/clusters/{name}/node-groups/{nodegroupName}', ], 'input' => [ 'shape' => 'DescribeNodegroupRequest', ], 'output' => [ 'shape' => 'DescribeNodegroupResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'DescribePodIdentityAssociation' => [ 'name' => 'DescribePodIdentityAssociation', 'http' => [ 'method' => 'GET', 'requestUri' => '/clusters/{name}/pod-identity-associations/{associationId}', ], 'input' => [ 'shape' => 'DescribePodIdentityAssociationRequest', ], 'output' => [ 'shape' => 'DescribePodIdentityAssociationResponse', ], 'errors' => [ [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], ], ], 'DescribeUpdate' => [ 'name' => 'DescribeUpdate', 'http' => [ 'method' => 'GET', 'requestUri' => '/clusters/{name}/updates/{updateId}', ], 'input' => [ 'shape' => 'DescribeUpdateRequest', ], 'output' => [ 'shape' => 'DescribeUpdateResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'DisassociateAccessPolicy' => [ 'name' => 'DisassociateAccessPolicy', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/clusters/{name}/access-entries/{principalArn}/access-policies/{policyArn}', ], 'input' => [ 'shape' => 'DisassociateAccessPolicyRequest', ], 'output' => [ 'shape' => 'DisassociateAccessPolicyResponse', ], 'errors' => [ [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'DisassociateIdentityProviderConfig' => [ 'name' => 'DisassociateIdentityProviderConfig', 'http' => [ 'method' => 'POST', 'requestUri' => '/clusters/{name}/identity-provider-configs/disassociate', ], 'input' => [ 'shape' => 'DisassociateIdentityProviderConfigRequest', ], 'output' => [ 'shape' => 'DisassociateIdentityProviderConfigResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceInUseException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'ListAccessEntries' => [ 'name' => 'ListAccessEntries', 'http' => [ 'method' => 'GET', 'requestUri' => '/clusters/{name}/access-entries', ], 'input' => [ 'shape' => 'ListAccessEntriesRequest', ], 'output' => [ 'shape' => 'ListAccessEntriesResponse', ], 'errors' => [ [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], ], ], 'ListAccessPolicies' => [ 'name' => 'ListAccessPolicies', 'http' => [ 'method' => 'GET', 'requestUri' => '/access-policies', ], 'input' => [ 'shape' => 'ListAccessPoliciesRequest', ], 'output' => [ 'shape' => 'ListAccessPoliciesResponse', ], 'errors' => [ [ 'shape' => 'ServerException', ], ], ], 'ListAddons' => [ 'name' => 'ListAddons', 'http' => [ 'method' => 'GET', 'requestUri' => '/clusters/{name}/addons', ], 'input' => [ 'shape' => 'ListAddonsRequest', ], 'output' => [ 'shape' => 'ListAddonsResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ServerException', ], ], ], 'ListAssociatedAccessPolicies' => [ 'name' => 'ListAssociatedAccessPolicies', 'http' => [ 'method' => 'GET', 'requestUri' => '/clusters/{name}/access-entries/{principalArn}/access-policies', ], 'input' => [ 'shape' => 'ListAssociatedAccessPoliciesRequest', ], 'output' => [ 'shape' => 'ListAssociatedAccessPoliciesResponse', ], 'errors' => [ [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'ListClusters' => [ 'name' => 'ListClusters', 'http' => [ 'method' => 'GET', 'requestUri' => '/clusters', ], 'input' => [ 'shape' => 'ListClustersRequest', ], 'output' => [ 'shape' => 'ListClustersResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'ListEksAnywhereSubscriptions' => [ 'name' => 'ListEksAnywhereSubscriptions', 'http' => [ 'method' => 'GET', 'requestUri' => '/eks-anywhere-subscriptions', ], 'input' => [ 'shape' => 'ListEksAnywhereSubscriptionsRequest', ], 'output' => [ 'shape' => 'ListEksAnywhereSubscriptionsResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'ListFargateProfiles' => [ 'name' => 'ListFargateProfiles', 'http' => [ 'method' => 'GET', 'requestUri' => '/clusters/{name}/fargate-profiles', ], 'input' => [ 'shape' => 'ListFargateProfilesRequest', ], 'output' => [ 'shape' => 'ListFargateProfilesResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], ], ], 'ListIdentityProviderConfigs' => [ 'name' => 'ListIdentityProviderConfigs', 'http' => [ 'method' => 'GET', 'requestUri' => '/clusters/{name}/identity-provider-configs', ], 'input' => [ 'shape' => 'ListIdentityProviderConfigsRequest', ], 'output' => [ 'shape' => 'ListIdentityProviderConfigsResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListInsights' => [ 'name' => 'ListInsights', 'http' => [ 'method' => 'POST', 'requestUri' => '/clusters/{name}/insights', ], 'input' => [ 'shape' => 'ListInsightsRequest', ], 'output' => [ 'shape' => 'ListInsightsResponse', ], 'errors' => [ [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], ], ], 'ListNodegroups' => [ 'name' => 'ListNodegroups', 'http' => [ 'method' => 'GET', 'requestUri' => '/clusters/{name}/node-groups', ], 'input' => [ 'shape' => 'ListNodegroupsRequest', ], 'output' => [ 'shape' => 'ListNodegroupsResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListPodIdentityAssociations' => [ 'name' => 'ListPodIdentityAssociations', 'http' => [ 'method' => 'GET', 'requestUri' => '/clusters/{name}/pod-identity-associations', ], 'input' => [ 'shape' => 'ListPodIdentityAssociationsRequest', ], 'output' => [ 'shape' => 'ListPodIdentityAssociationsResponse', ], 'errors' => [ [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], ], ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/tags/{resourceArn}', ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'NotFoundException', ], ], ], 'ListUpdates' => [ 'name' => 'ListUpdates', 'http' => [ 'method' => 'GET', 'requestUri' => '/clusters/{name}/updates', ], 'input' => [ 'shape' => 'ListUpdatesRequest', ], 'output' => [ 'shape' => 'ListUpdatesResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'RegisterCluster' => [ 'name' => 'RegisterCluster', 'http' => [ 'method' => 'POST', 'requestUri' => '/cluster-registrations', ], 'input' => [ 'shape' => 'RegisterClusterRequest', ], 'output' => [ 'shape' => 'RegisterClusterResponse', ], 'errors' => [ [ 'shape' => 'ResourceLimitExceededException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceInUseException', ], [ 'shape' => 'ResourcePropagationDelayException', ], ], ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tags/{resourceArn}', ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'output' => [ 'shape' => 'TagResourceResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'NotFoundException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tags/{resourceArn}', ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'output' => [ 'shape' => 'UntagResourceResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'NotFoundException', ], ], ], 'UpdateAccessEntry' => [ 'name' => 'UpdateAccessEntry', 'http' => [ 'method' => 'POST', 'requestUri' => '/clusters/{name}/access-entries/{principalArn}', ], 'input' => [ 'shape' => 'UpdateAccessEntryRequest', ], 'output' => [ 'shape' => 'UpdateAccessEntryResponse', ], 'errors' => [ [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], ], ], 'UpdateAddon' => [ 'name' => 'UpdateAddon', 'http' => [ 'method' => 'POST', 'requestUri' => '/clusters/{name}/addons/{addonName}/update', ], 'input' => [ 'shape' => 'UpdateAddonRequest', ], 'output' => [ 'shape' => 'UpdateAddonResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ResourceInUseException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], ], ], 'UpdateClusterConfig' => [ 'name' => 'UpdateClusterConfig', 'http' => [ 'method' => 'POST', 'requestUri' => '/clusters/{name}/update-config', ], 'input' => [ 'shape' => 'UpdateClusterConfigRequest', ], 'output' => [ 'shape' => 'UpdateClusterConfigResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceInUseException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'UpdateClusterVersion' => [ 'name' => 'UpdateClusterVersion', 'http' => [ 'method' => 'POST', 'requestUri' => '/clusters/{name}/updates', ], 'input' => [ 'shape' => 'UpdateClusterVersionRequest', ], 'output' => [ 'shape' => 'UpdateClusterVersionResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceInUseException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'UpdateEksAnywhereSubscription' => [ 'name' => 'UpdateEksAnywhereSubscription', 'http' => [ 'method' => 'POST', 'requestUri' => '/eks-anywhere-subscriptions/{id}', ], 'input' => [ 'shape' => 'UpdateEksAnywhereSubscriptionRequest', ], 'output' => [ 'shape' => 'UpdateEksAnywhereSubscriptionResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'UpdateNodegroupConfig' => [ 'name' => 'UpdateNodegroupConfig', 'http' => [ 'method' => 'POST', 'requestUri' => '/clusters/{name}/node-groups/{nodegroupName}/update-config', ], 'input' => [ 'shape' => 'UpdateNodegroupConfigRequest', ], 'output' => [ 'shape' => 'UpdateNodegroupConfigResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceInUseException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'UpdateNodegroupVersion' => [ 'name' => 'UpdateNodegroupVersion', 'http' => [ 'method' => 'POST', 'requestUri' => '/clusters/{name}/node-groups/{nodegroupName}/update-version', ], 'input' => [ 'shape' => 'UpdateNodegroupVersionRequest', ], 'output' => [ 'shape' => 'UpdateNodegroupVersionResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ClientException', ], [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceInUseException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], ], ], 'UpdatePodIdentityAssociation' => [ 'name' => 'UpdatePodIdentityAssociation', 'http' => [ 'method' => 'POST', 'requestUri' => '/clusters/{name}/pod-identity-associations/{associationId}', ], 'input' => [ 'shape' => 'UpdatePodIdentityAssociationRequest', ], 'output' => [ 'shape' => 'UpdatePodIdentityAssociationResponse', ], 'errors' => [ [ 'shape' => 'ServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InvalidParameterException', ], ], ], ], 'shapes' => [ 'AMITypes' => [ 'type' => 'string', 'enum' => [ 'AL2_x86_64', 'AL2_x86_64_GPU', 'AL2_ARM_64', 'CUSTOM', 'BOTTLEROCKET_ARM_64', 'BOTTLEROCKET_x86_64', 'BOTTLEROCKET_ARM_64_NVIDIA', 'BOTTLEROCKET_x86_64_NVIDIA', 'WINDOWS_CORE_2019_x86_64', 'WINDOWS_FULL_2019_x86_64', 'WINDOWS_CORE_2022_x86_64', 'WINDOWS_FULL_2022_x86_64', 'AL2023_x86_64_STANDARD', 'AL2023_ARM_64_STANDARD', ], ], 'AccessConfigResponse' => [ 'type' => 'structure', 'members' => [ 'bootstrapClusterCreatorAdminPermissions' => [ 'shape' => 'BoxedBoolean', ], 'authenticationMode' => [ 'shape' => 'AuthenticationMode', ], ], ], 'AccessDeniedException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 403, ], 'exception' => true, ], 'AccessEntry' => [ 'type' => 'structure', 'members' => [ 'clusterName' => [ 'shape' => 'String', ], 'principalArn' => [ 'shape' => 'String', ], 'kubernetesGroups' => [ 'shape' => 'StringList', ], 'accessEntryArn' => [ 'shape' => 'String', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'modifiedAt' => [ 'shape' => 'Timestamp', ], 'tags' => [ 'shape' => 'TagMap', ], 'username' => [ 'shape' => 'String', ], 'type' => [ 'shape' => 'String', ], ], ], 'AccessPoliciesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AccessPolicy', ], ], 'AccessPolicy' => [ 'type' => 'structure', 'members' => [ 'name' => [ 'shape' => 'String', ], 'arn' => [ 'shape' => 'String', ], ], ], 'AccessScope' => [ 'type' => 'structure', 'members' => [ 'type' => [ 'shape' => 'AccessScopeType', ], 'namespaces' => [ 'shape' => 'StringList', ], ], ], 'AccessScopeType' => [ 'type' => 'string', 'enum' => [ 'cluster', 'namespace', ], ], 'AdditionalInfoMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], 'Addon' => [ 'type' => 'structure', 'members' => [ 'addonName' => [ 'shape' => 'String', ], 'clusterName' => [ 'shape' => 'ClusterName', ], 'status' => [ 'shape' => 'AddonStatus', ], 'addonVersion' => [ 'shape' => 'String', ], 'health' => [ 'shape' => 'AddonHealth', ], 'addonArn' => [ 'shape' => 'String', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'modifiedAt' => [ 'shape' => 'Timestamp', ], 'serviceAccountRoleArn' => [ 'shape' => 'String', ], 'tags' => [ 'shape' => 'TagMap', ], 'publisher' => [ 'shape' => 'String', ], 'owner' => [ 'shape' => 'String', ], 'marketplaceInformation' => [ 'shape' => 'MarketplaceInformation', ], 'configurationValues' => [ 'shape' => 'String', ], 'podIdentityAssociations' => [ 'shape' => 'StringList', ], ], ], 'AddonHealth' => [ 'type' => 'structure', 'members' => [ 'issues' => [ 'shape' => 'AddonIssueList', ], ], ], 'AddonInfo' => [ 'type' => 'structure', 'members' => [ 'addonName' => [ 'shape' => 'String', ], 'type' => [ 'shape' => 'String', ], 'addonVersions' => [ 'shape' => 'AddonVersionInfoList', ], 'publisher' => [ 'shape' => 'String', ], 'owner' => [ 'shape' => 'String', ], 'marketplaceInformation' => [ 'shape' => 'MarketplaceInformation', ], ], ], 'AddonIssue' => [ 'type' => 'structure', 'members' => [ 'code' => [ 'shape' => 'AddonIssueCode', ], 'message' => [ 'shape' => 'String', ], 'resourceIds' => [ 'shape' => 'StringList', ], ], ], 'AddonIssueCode' => [ 'type' => 'string', 'enum' => [ 'AccessDenied', 'InternalFailure', 'ClusterUnreachable', 'InsufficientNumberOfReplicas', 'ConfigurationConflict', 'AdmissionRequestDenied', 'UnsupportedAddonModification', 'K8sResourceNotFound', 'AddonSubscriptionNeeded', 'AddonPermissionFailure', ], ], 'AddonIssueList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AddonIssue', ], ], 'AddonPodIdentityAssociations' => [ 'type' => 'structure', 'required' => [ 'serviceAccount', 'roleArn', ], 'members' => [ 'serviceAccount' => [ 'shape' => 'String', ], 'roleArn' => [ 'shape' => 'String', ], ], ], 'AddonPodIdentityAssociationsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AddonPodIdentityAssociations', ], ], 'AddonPodIdentityConfiguration' => [ 'type' => 'structure', 'members' => [ 'serviceAccount' => [ 'shape' => 'String', ], 'recommendedManagedPolicies' => [ 'shape' => 'StringList', ], ], ], 'AddonPodIdentityConfigurationList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AddonPodIdentityConfiguration', ], ], 'AddonStatus' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'ACTIVE', 'CREATE_FAILED', 'UPDATING', 'DELETING', 'DELETE_FAILED', 'DEGRADED', 'UPDATE_FAILED', ], ], 'AddonVersionInfo' => [ 'type' => 'structure', 'members' => [ 'addonVersion' => [ 'shape' => 'String', ], 'architecture' => [ 'shape' => 'StringList', ], 'compatibilities' => [ 'shape' => 'Compatibilities', ], 'requiresConfiguration' => [ 'shape' => 'Boolean', ], 'requiresIamPermissions' => [ 'shape' => 'Boolean', ], ], ], 'AddonVersionInfoList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AddonVersionInfo', ], ], 'Addons' => [ 'type' => 'list', 'member' => [ 'shape' => 'AddonInfo', ], ], 'AssociateAccessPolicyRequest' => [ 'type' => 'structure', 'required' => [ 'clusterName', 'principalArn', 'policyArn', 'accessScope', ], 'members' => [ 'clusterName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'name', ], 'principalArn' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'principalArn', ], 'policyArn' => [ 'shape' => 'String', ], 'accessScope' => [ 'shape' => 'AccessScope', ], ], ], 'AssociateAccessPolicyResponse' => [ 'type' => 'structure', 'members' => [ 'clusterName' => [ 'shape' => 'String', ], 'principalArn' => [ 'shape' => 'String', ], 'associatedAccessPolicy' => [ 'shape' => 'AssociatedAccessPolicy', ], ], ], 'AssociateEncryptionConfigRequest' => [ 'type' => 'structure', 'required' => [ 'clusterName', 'encryptionConfig', ], 'members' => [ 'clusterName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'name', ], 'encryptionConfig' => [ 'shape' => 'EncryptionConfigList', ], 'clientRequestToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], ], ], 'AssociateEncryptionConfigResponse' => [ 'type' => 'structure', 'members' => [ 'update' => [ 'shape' => 'Update', ], ], ], 'AssociateIdentityProviderConfigRequest' => [ 'type' => 'structure', 'required' => [ 'clusterName', 'oidc', ], 'members' => [ 'clusterName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'name', ], 'oidc' => [ 'shape' => 'OidcIdentityProviderConfigRequest', ], 'tags' => [ 'shape' => 'TagMap', ], 'clientRequestToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], ], ], 'AssociateIdentityProviderConfigResponse' => [ 'type' => 'structure', 'members' => [ 'update' => [ 'shape' => 'Update', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'AssociatedAccessPoliciesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AssociatedAccessPolicy', ], ], 'AssociatedAccessPolicy' => [ 'type' => 'structure', 'members' => [ 'policyArn' => [ 'shape' => 'String', ], 'accessScope' => [ 'shape' => 'AccessScope', ], 'associatedAt' => [ 'shape' => 'Timestamp', ], 'modifiedAt' => [ 'shape' => 'Timestamp', ], ], ], 'AuthenticationMode' => [ 'type' => 'string', 'enum' => [ 'API', 'API_AND_CONFIG_MAP', 'CONFIG_MAP', ], ], 'AutoScalingGroup' => [ 'type' => 'structure', 'members' => [ 'name' => [ 'shape' => 'String', ], ], ], 'AutoScalingGroupList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AutoScalingGroup', ], ], 'BadRequestException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'Boolean' => [ 'type' => 'boolean', ], 'BoxedBoolean' => [ 'type' => 'boolean', 'box' => true, ], 'BoxedInteger' => [ 'type' => 'integer', 'box' => true, ], 'Capacity' => [ 'type' => 'integer', 'box' => true, 'min' => 1, ], 'CapacityTypes' => [ 'type' => 'string', 'enum' => [ 'ON_DEMAND', 'SPOT', ], ], 'Category' => [ 'type' => 'string', 'enum' => [ 'UPGRADE_READINESS', ], ], 'CategoryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Category', ], ], 'Certificate' => [ 'type' => 'structure', 'members' => [ 'data' => [ 'shape' => 'String', ], ], ], 'ClientException' => [ 'type' => 'structure', 'members' => [ 'clusterName' => [ 'shape' => 'String', ], 'nodegroupName' => [ 'shape' => 'String', ], 'addonName' => [ 'shape' => 'String', ], 'subscriptionId' => [ 'shape' => 'String', ], 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'ClientStat' => [ 'type' => 'structure', 'members' => [ 'userAgent' => [ 'shape' => 'String', ], 'numberOfRequestsLast30Days' => [ 'shape' => 'Integer', ], 'lastRequestTime' => [ 'shape' => 'Timestamp', ], ], ], 'ClientStats' => [ 'type' => 'list', 'member' => [ 'shape' => 'ClientStat', ], ], 'Cluster' => [ 'type' => 'structure', 'members' => [ 'name' => [ 'shape' => 'String', ], 'arn' => [ 'shape' => 'String', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'version' => [ 'shape' => 'String', ], 'endpoint' => [ 'shape' => 'String', ], 'roleArn' => [ 'shape' => 'String', ], 'resourcesVpcConfig' => [ 'shape' => 'VpcConfigResponse', ], 'kubernetesNetworkConfig' => [ 'shape' => 'KubernetesNetworkConfigResponse', ], 'logging' => [ 'shape' => 'Logging', ], 'identity' => [ 'shape' => 'Identity', ], 'status' => [ 'shape' => 'ClusterStatus', ], 'certificateAuthority' => [ 'shape' => 'Certificate', ], 'clientRequestToken' => [ 'shape' => 'String', ], 'platformVersion' => [ 'shape' => 'String', ], 'tags' => [ 'shape' => 'TagMap', ], 'encryptionConfig' => [ 'shape' => 'EncryptionConfigList', ], 'connectorConfig' => [ 'shape' => 'ConnectorConfigResponse', ], 'id' => [ 'shape' => 'String', ], 'health' => [ 'shape' => 'ClusterHealth', ], 'outpostConfig' => [ 'shape' => 'OutpostConfigResponse', ], 'accessConfig' => [ 'shape' => 'AccessConfigResponse', ], ], ], 'ClusterHealth' => [ 'type' => 'structure', 'members' => [ 'issues' => [ 'shape' => 'ClusterIssueList', ], ], ], 'ClusterIssue' => [ 'type' => 'structure', 'members' => [ 'code' => [ 'shape' => 'ClusterIssueCode', ], 'message' => [ 'shape' => 'String', ], 'resourceIds' => [ 'shape' => 'StringList', ], ], ], 'ClusterIssueCode' => [ 'type' => 'string', 'enum' => [ 'AccessDenied', 'ClusterUnreachable', 'ConfigurationConflict', 'InternalFailure', 'ResourceLimitExceeded', 'ResourceNotFound', 'IamRoleNotFound', 'VpcNotFound', 'InsufficientFreeAddresses', 'Ec2ServiceNotSubscribed', 'Ec2SubnetNotFound', 'Ec2SecurityGroupNotFound', 'KmsGrantRevoked', 'KmsKeyNotFound', 'KmsKeyMarkedForDeletion', 'KmsKeyDisabled', 'StsRegionalEndpointDisabled', 'UnsupportedVersion', 'Other', ], ], 'ClusterIssueList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ClusterIssue', ], ], 'ClusterName' => [ 'type' => 'string', 'max' => 100, 'min' => 1, 'pattern' => '^[0-9A-Za-z][A-Za-z0-9\\-_]*', ], 'ClusterStatus' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'ACTIVE', 'DELETING', 'FAILED', 'UPDATING', 'PENDING', ], ], 'Compatibilities' => [ 'type' => 'list', 'member' => [ 'shape' => 'Compatibility', ], ], 'Compatibility' => [ 'type' => 'structure', 'members' => [ 'clusterVersion' => [ 'shape' => 'String', ], 'platformVersions' => [ 'shape' => 'StringList', ], 'defaultVersion' => [ 'shape' => 'Boolean', ], ], ], 'ConnectorConfigProvider' => [ 'type' => 'string', 'enum' => [ 'EKS_ANYWHERE', 'ANTHOS', 'GKE', 'AKS', 'OPENSHIFT', 'TANZU', 'RANCHER', 'EC2', 'OTHER', ], ], 'ConnectorConfigRequest' => [ 'type' => 'structure', 'required' => [ 'roleArn', 'provider', ], 'members' => [ 'roleArn' => [ 'shape' => 'String', ], 'provider' => [ 'shape' => 'ConnectorConfigProvider', ], ], ], 'ConnectorConfigResponse' => [ 'type' => 'structure', 'members' => [ 'activationId' => [ 'shape' => 'String', ], 'activationCode' => [ 'shape' => 'String', ], 'activationExpiry' => [ 'shape' => 'Timestamp', ], 'provider' => [ 'shape' => 'String', ], 'roleArn' => [ 'shape' => 'String', ], ], ], 'ControlPlanePlacementRequest' => [ 'type' => 'structure', 'members' => [ 'groupName' => [ 'shape' => 'String', ], ], ], 'ControlPlanePlacementResponse' => [ 'type' => 'structure', 'members' => [ 'groupName' => [ 'shape' => 'String', ], ], ], 'CreateAccessConfigRequest' => [ 'type' => 'structure', 'members' => [ 'bootstrapClusterCreatorAdminPermissions' => [ 'shape' => 'BoxedBoolean', ], 'authenticationMode' => [ 'shape' => 'AuthenticationMode', ], ], ], 'CreateAccessEntryRequest' => [ 'type' => 'structure', 'required' => [ 'clusterName', 'principalArn', ], 'members' => [ 'clusterName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'name', ], 'principalArn' => [ 'shape' => 'String', ], 'kubernetesGroups' => [ 'shape' => 'StringList', ], 'tags' => [ 'shape' => 'TagMap', ], 'clientRequestToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], 'username' => [ 'shape' => 'String', ], 'type' => [ 'shape' => 'String', ], ], ], 'CreateAccessEntryResponse' => [ 'type' => 'structure', 'members' => [ 'accessEntry' => [ 'shape' => 'AccessEntry', ], ], ], 'CreateAddonRequest' => [ 'type' => 'structure', 'required' => [ 'clusterName', 'addonName', ], 'members' => [ 'clusterName' => [ 'shape' => 'ClusterName', 'location' => 'uri', 'locationName' => 'name', ], 'addonName' => [ 'shape' => 'String', ], 'addonVersion' => [ 'shape' => 'String', ], 'serviceAccountRoleArn' => [ 'shape' => 'RoleArn', ], 'resolveConflicts' => [ 'shape' => 'ResolveConflicts', ], 'clientRequestToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], 'tags' => [ 'shape' => 'TagMap', ], 'configurationValues' => [ 'shape' => 'String', ], 'podIdentityAssociations' => [ 'shape' => 'AddonPodIdentityAssociationsList', ], ], ], 'CreateAddonResponse' => [ 'type' => 'structure', 'members' => [ 'addon' => [ 'shape' => 'Addon', ], ], ], 'CreateClusterRequest' => [ 'type' => 'structure', 'required' => [ 'name', 'roleArn', 'resourcesVpcConfig', ], 'members' => [ 'name' => [ 'shape' => 'ClusterName', ], 'version' => [ 'shape' => 'String', ], 'roleArn' => [ 'shape' => 'String', ], 'resourcesVpcConfig' => [ 'shape' => 'VpcConfigRequest', ], 'kubernetesNetworkConfig' => [ 'shape' => 'KubernetesNetworkConfigRequest', ], 'logging' => [ 'shape' => 'Logging', ], 'clientRequestToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], 'tags' => [ 'shape' => 'TagMap', ], 'encryptionConfig' => [ 'shape' => 'EncryptionConfigList', ], 'outpostConfig' => [ 'shape' => 'OutpostConfigRequest', ], 'accessConfig' => [ 'shape' => 'CreateAccessConfigRequest', ], ], ], 'CreateClusterResponse' => [ 'type' => 'structure', 'members' => [ 'cluster' => [ 'shape' => 'Cluster', ], ], ], 'CreateEksAnywhereSubscriptionRequest' => [ 'type' => 'structure', 'required' => [ 'name', 'term', ], 'members' => [ 'name' => [ 'shape' => 'EksAnywhereSubscriptionName', ], 'term' => [ 'shape' => 'EksAnywhereSubscriptionTerm', ], 'licenseQuantity' => [ 'shape' => 'Integer', ], 'licenseType' => [ 'shape' => 'EksAnywhereSubscriptionLicenseType', ], 'autoRenew' => [ 'shape' => 'Boolean', ], 'clientRequestToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateEksAnywhereSubscriptionResponse' => [ 'type' => 'structure', 'members' => [ 'subscription' => [ 'shape' => 'EksAnywhereSubscription', ], ], ], 'CreateFargateProfileRequest' => [ 'type' => 'structure', 'required' => [ 'fargateProfileName', 'clusterName', 'podExecutionRoleArn', ], 'members' => [ 'fargateProfileName' => [ 'shape' => 'String', ], 'clusterName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'name', ], 'podExecutionRoleArn' => [ 'shape' => 'String', ], 'subnets' => [ 'shape' => 'StringList', ], 'selectors' => [ 'shape' => 'FargateProfileSelectors', ], 'clientRequestToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateFargateProfileResponse' => [ 'type' => 'structure', 'members' => [ 'fargateProfile' => [ 'shape' => 'FargateProfile', ], ], ], 'CreateNodegroupRequest' => [ 'type' => 'structure', 'required' => [ 'clusterName', 'nodegroupName', 'subnets', 'nodeRole', ], 'members' => [ 'clusterName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'name', ], 'nodegroupName' => [ 'shape' => 'String', ], 'scalingConfig' => [ 'shape' => 'NodegroupScalingConfig', ], 'diskSize' => [ 'shape' => 'BoxedInteger', ], 'subnets' => [ 'shape' => 'StringList', ], 'instanceTypes' => [ 'shape' => 'StringList', ], 'amiType' => [ 'shape' => 'AMITypes', ], 'remoteAccess' => [ 'shape' => 'RemoteAccessConfig', ], 'nodeRole' => [ 'shape' => 'String', ], 'labels' => [ 'shape' => 'labelsMap', ], 'taints' => [ 'shape' => 'taintsList', ], 'tags' => [ 'shape' => 'TagMap', ], 'clientRequestToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], 'launchTemplate' => [ 'shape' => 'LaunchTemplateSpecification', ], 'updateConfig' => [ 'shape' => 'NodegroupUpdateConfig', ], 'capacityType' => [ 'shape' => 'CapacityTypes', ], 'version' => [ 'shape' => 'String', ], 'releaseVersion' => [ 'shape' => 'String', ], ], ], 'CreateNodegroupResponse' => [ 'type' => 'structure', 'members' => [ 'nodegroup' => [ 'shape' => 'Nodegroup', ], ], ], 'CreatePodIdentityAssociationRequest' => [ 'type' => 'structure', 'required' => [ 'clusterName', 'namespace', 'serviceAccount', 'roleArn', ], 'members' => [ 'clusterName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'name', ], 'namespace' => [ 'shape' => 'String', ], 'serviceAccount' => [ 'shape' => 'String', ], 'roleArn' => [ 'shape' => 'String', ], 'clientRequestToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'CreatePodIdentityAssociationResponse' => [ 'type' => 'structure', 'members' => [ 'association' => [ 'shape' => 'PodIdentityAssociation', ], ], ], 'DeleteAccessEntryRequest' => [ 'type' => 'structure', 'required' => [ 'clusterName', 'principalArn', ], 'members' => [ 'clusterName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'name', ], 'principalArn' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'principalArn', ], ], ], 'DeleteAccessEntryResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteAddonRequest' => [ 'type' => 'structure', 'required' => [ 'clusterName', 'addonName', ], 'members' => [ 'clusterName' => [ 'shape' => 'ClusterName', 'location' => 'uri', 'locationName' => 'name', ], 'addonName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'addonName', ], 'preserve' => [ 'shape' => 'Boolean', 'location' => 'querystring', 'locationName' => 'preserve', ], ], ], 'DeleteAddonResponse' => [ 'type' => 'structure', 'members' => [ 'addon' => [ 'shape' => 'Addon', ], ], ], 'DeleteClusterRequest' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'name', ], ], ], 'DeleteClusterResponse' => [ 'type' => 'structure', 'members' => [ 'cluster' => [ 'shape' => 'Cluster', ], ], ], 'DeleteEksAnywhereSubscriptionRequest' => [ 'type' => 'structure', 'required' => [ 'id', ], 'members' => [ 'id' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'id', ], ], ], 'DeleteEksAnywhereSubscriptionResponse' => [ 'type' => 'structure', 'members' => [ 'subscription' => [ 'shape' => 'EksAnywhereSubscription', ], ], ], 'DeleteFargateProfileRequest' => [ 'type' => 'structure', 'required' => [ 'clusterName', 'fargateProfileName', ], 'members' => [ 'clusterName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'name', ], 'fargateProfileName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'fargateProfileName', ], ], ], 'DeleteFargateProfileResponse' => [ 'type' => 'structure', 'members' => [ 'fargateProfile' => [ 'shape' => 'FargateProfile', ], ], ], 'DeleteNodegroupRequest' => [ 'type' => 'structure', 'required' => [ 'clusterName', 'nodegroupName', ], 'members' => [ 'clusterName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'name', ], 'nodegroupName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'nodegroupName', ], ], ], 'DeleteNodegroupResponse' => [ 'type' => 'structure', 'members' => [ 'nodegroup' => [ 'shape' => 'Nodegroup', ], ], ], 'DeletePodIdentityAssociationRequest' => [ 'type' => 'structure', 'required' => [ 'clusterName', 'associationId', ], 'members' => [ 'clusterName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'name', ], 'associationId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'associationId', ], ], ], 'DeletePodIdentityAssociationResponse' => [ 'type' => 'structure', 'members' => [ 'association' => [ 'shape' => 'PodIdentityAssociation', ], ], ], 'DeprecationDetail' => [ 'type' => 'structure', 'members' => [ 'usage' => [ 'shape' => 'String', ], 'replacedWith' => [ 'shape' => 'String', ], 'stopServingVersion' => [ 'shape' => 'String', ], 'startServingReplacementVersion' => [ 'shape' => 'String', ], 'clientStats' => [ 'shape' => 'ClientStats', ], ], ], 'DeprecationDetails' => [ 'type' => 'list', 'member' => [ 'shape' => 'DeprecationDetail', ], ], 'DeregisterClusterRequest' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'name', ], ], ], 'DeregisterClusterResponse' => [ 'type' => 'structure', 'members' => [ 'cluster' => [ 'shape' => 'Cluster', ], ], ], 'DescribeAccessEntryRequest' => [ 'type' => 'structure', 'required' => [ 'clusterName', 'principalArn', ], 'members' => [ 'clusterName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'name', ], 'principalArn' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'principalArn', ], ], ], 'DescribeAccessEntryResponse' => [ 'type' => 'structure', 'members' => [ 'accessEntry' => [ 'shape' => 'AccessEntry', ], ], ], 'DescribeAddonConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'addonName', 'addonVersion', ], 'members' => [ 'addonName' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'addonName', ], 'addonVersion' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'addonVersion', ], ], ], 'DescribeAddonConfigurationResponse' => [ 'type' => 'structure', 'members' => [ 'addonName' => [ 'shape' => 'String', ], 'addonVersion' => [ 'shape' => 'String', ], 'configurationSchema' => [ 'shape' => 'String', ], 'podIdentityConfiguration' => [ 'shape' => 'AddonPodIdentityConfigurationList', ], ], ], 'DescribeAddonRequest' => [ 'type' => 'structure', 'required' => [ 'clusterName', 'addonName', ], 'members' => [ 'clusterName' => [ 'shape' => 'ClusterName', 'location' => 'uri', 'locationName' => 'name', ], 'addonName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'addonName', ], ], ], 'DescribeAddonResponse' => [ 'type' => 'structure', 'members' => [ 'addon' => [ 'shape' => 'Addon', ], ], ], 'DescribeAddonVersionsRequest' => [ 'type' => 'structure', 'members' => [ 'kubernetesVersion' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'kubernetesVersion', ], 'maxResults' => [ 'shape' => 'DescribeAddonVersionsRequestMaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'addonName' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'addonName', ], 'types' => [ 'shape' => 'StringList', 'location' => 'querystring', 'locationName' => 'types', ], 'publishers' => [ 'shape' => 'StringList', 'location' => 'querystring', 'locationName' => 'publishers', ], 'owners' => [ 'shape' => 'StringList', 'location' => 'querystring', 'locationName' => 'owners', ], ], ], 'DescribeAddonVersionsRequestMaxResults' => [ 'type' => 'integer', 'box' => true, 'max' => 100, 'min' => 1, ], 'DescribeAddonVersionsResponse' => [ 'type' => 'structure', 'members' => [ 'addons' => [ 'shape' => 'Addons', ], 'nextToken' => [ 'shape' => 'String', ], ], ], 'DescribeClusterRequest' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'name', ], ], ], 'DescribeClusterResponse' => [ 'type' => 'structure', 'members' => [ 'cluster' => [ 'shape' => 'Cluster', ], ], ], 'DescribeEksAnywhereSubscriptionRequest' => [ 'type' => 'structure', 'required' => [ 'id', ], 'members' => [ 'id' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'id', ], ], ], 'DescribeEksAnywhereSubscriptionResponse' => [ 'type' => 'structure', 'members' => [ 'subscription' => [ 'shape' => 'EksAnywhereSubscription', ], ], ], 'DescribeFargateProfileRequest' => [ 'type' => 'structure', 'required' => [ 'clusterName', 'fargateProfileName', ], 'members' => [ 'clusterName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'name', ], 'fargateProfileName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'fargateProfileName', ], ], ], 'DescribeFargateProfileResponse' => [ 'type' => 'structure', 'members' => [ 'fargateProfile' => [ 'shape' => 'FargateProfile', ], ], ], 'DescribeIdentityProviderConfigRequest' => [ 'type' => 'structure', 'required' => [ 'clusterName', 'identityProviderConfig', ], 'members' => [ 'clusterName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'name', ], 'identityProviderConfig' => [ 'shape' => 'IdentityProviderConfig', ], ], ], 'DescribeIdentityProviderConfigResponse' => [ 'type' => 'structure', 'members' => [ 'identityProviderConfig' => [ 'shape' => 'IdentityProviderConfigResponse', ], ], ], 'DescribeInsightRequest' => [ 'type' => 'structure', 'required' => [ 'clusterName', 'id', ], 'members' => [ 'clusterName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'name', ], 'id' => [ 'shape' => 'String', 'locati