<?php
// This file was auto-generated from sdk-root/src/data/groundstation/2019-05-23/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2019-05-23', 'endpointPrefix' => 'groundstation', 'jsonVersion' => '1.1', 'protocol' => 'rest-json', 'serviceFullName' => 'AWS Ground Station', 'serviceId' => 'GroundStation', 'signatureVersion' => 'v4', 'signingName' => 'groundstation', 'uid' => 'groundstation-2019-05-23', ], 'operations' => [ 'CancelContact' => [ 'name' => 'CancelContact', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/contact/{contactId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CancelContactRequest', ], 'output' => [ 'shape' => 'ContactIdResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'CreateConfig' => [ 'name' => 'CreateConfig', 'http' => [ 'method' => 'POST', 'requestUri' => '/config', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateConfigRequest', ], 'output' => [ 'shape' => 'ConfigIdResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceLimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'CreateDataflowEndpointGroup' => [ 'name' => 'CreateDataflowEndpointGroup', 'http' => [ 'method' => 'POST', 'requestUri' => '/dataflowEndpointGroup', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateDataflowEndpointGroupRequest', ], 'output' => [ 'shape' => 'DataflowEndpointGroupIdResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'CreateEphemeris' => [ 'name' => 'CreateEphemeris', 'http' => [ 'method' => 'POST', 'requestUri' => '/ephemeris', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateEphemerisRequest', ], 'output' => [ 'shape' => 'EphemerisIdResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'CreateMissionProfile' => [ 'name' => 'CreateMissionProfile', 'http' => [ 'method' => 'POST', 'requestUri' => '/missionprofile', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateMissionProfileRequest', ], 'output' => [ 'shape' => 'MissionProfileIdResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'DeleteConfig' => [ 'name' => 'DeleteConfig', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/config/{configType}/{configId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteConfigRequest', ], 'output' => [ 'shape' => 'ConfigIdResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'DeleteDataflowEndpointGroup' => [ 'name' => 'DeleteDataflowEndpointGroup', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/dataflowEndpointGroup/{dataflowEndpointGroupId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteDataflowEndpointGroupRequest', ], 'output' => [ 'shape' => 'DataflowEndpointGroupIdResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'DeleteEphemeris' => [ 'name' => 'DeleteEphemeris', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/ephemeris/{ephemerisId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteEphemerisRequest', ], 'output' => [ 'shape' => 'EphemerisIdResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'DeleteMissionProfile' => [ 'name' => 'DeleteMissionProfile', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/missionprofile/{missionProfileId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteMissionProfileRequest', ], 'output' => [ 'shape' => 'MissionProfileIdResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'DescribeContact' => [ 'name' => 'DescribeContact', 'http' => [ 'method' => 'GET', 'requestUri' => '/contact/{contactId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeContactRequest', ], 'output' => [ 'shape' => 'DescribeContactResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'DescribeEphemeris' => [ 'name' => 'DescribeEphemeris', 'http' => [ 'method' => 'GET', 'requestUri' => '/ephemeris/{ephemerisId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeEphemerisRequest', ], 'output' => [ 'shape' => 'DescribeEphemerisResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetAgentConfiguration' => [ 'name' => 'GetAgentConfiguration', 'http' => [ 'method' => 'GET', 'requestUri' => '/agent/{agentId}/configuration', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetAgentConfigurationRequest', ], 'output' => [ 'shape' => 'GetAgentConfigurationResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetConfig' => [ 'name' => 'GetConfig', 'http' => [ 'method' => 'GET', 'requestUri' => '/config/{configType}/{configId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetConfigRequest', ], 'output' => [ 'shape' => 'GetConfigResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetDataflowEndpointGroup' => [ 'name' => 'GetDataflowEndpointGroup', 'http' => [ 'method' => 'GET', 'requestUri' => '/dataflowEndpointGroup/{dataflowEndpointGroupId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetDataflowEndpointGroupRequest', ], 'output' => [ 'shape' => 'GetDataflowEndpointGroupResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetMinuteUsage' => [ 'name' => 'GetMinuteUsage', 'http' => [ 'method' => 'POST', 'requestUri' => '/minute-usage', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetMinuteUsageRequest', ], 'output' => [ 'shape' => 'GetMinuteUsageResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetMissionProfile' => [ 'name' => 'GetMissionProfile', 'http' => [ 'method' => 'GET', 'requestUri' => '/missionprofile/{missionProfileId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetMissionProfileRequest', ], 'output' => [ 'shape' => 'GetMissionProfileResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetSatellite' => [ 'name' => 'GetSatellite', 'http' => [ 'method' => 'GET', 'requestUri' => '/satellite/{satelliteId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetSatelliteRequest', ], 'output' => [ 'shape' => 'GetSatelliteResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListConfigs' => [ 'name' => 'ListConfigs', 'http' => [ 'method' => 'GET', 'requestUri' => '/config', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListConfigsRequest', ], 'output' => [ 'shape' => 'ListConfigsResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListContacts' => [ 'name' => 'ListContacts', 'http' => [ 'method' => 'POST', 'requestUri' => '/contacts', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListContactsRequest', ], 'output' => [ 'shape' => 'ListContactsResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListDataflowEndpointGroups' => [ 'name' => 'ListDataflowEndpointGroups', 'http' => [ 'method' => 'GET', 'requestUri' => '/dataflowEndpointGroup', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListDataflowEndpointGroupsRequest', ], 'output' => [ 'shape' => 'ListDataflowEndpointGroupsResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListEphemerides' => [ 'name' => 'ListEphemerides', 'http' => [ 'method' => 'POST', 'requestUri' => '/ephemerides', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListEphemeridesRequest', ], 'output' => [ 'shape' => 'ListEphemeridesResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListGroundStations' => [ 'name' => 'ListGroundStations', 'http' => [ 'method' => 'GET', 'requestUri' => '/groundstation', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListGroundStationsRequest', ], 'output' => [ 'shape' => 'ListGroundStationsResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListMissionProfiles' => [ 'name' => 'ListMissionProfiles', 'http' => [ 'method' => 'GET', 'requestUri' => '/missionprofile', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListMissionProfilesRequest', ], 'output' => [ 'shape' => 'ListMissionProfilesResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListSatellites' => [ 'name' => 'ListSatellites', 'http' => [ 'method' => 'GET', 'requestUri' => '/satellite', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListSatellitesRequest', ], 'output' => [ 'shape' => 'ListSatellitesResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'RegisterAgent' => [ 'name' => 'RegisterAgent', 'http' => [ 'method' => 'POST', 'requestUri' => '/agent', 'responseCode' => 200, ], 'input' => [ 'shape' => 'RegisterAgentRequest', ], 'output' => [ 'shape' => 'RegisterAgentResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ReserveContact' => [ 'name' => 'ReserveContact', 'http' => [ 'method' => 'POST', 'requestUri' => '/contact', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ReserveContactRequest', ], 'output' => [ 'shape' => 'ContactIdResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'output' => [ 'shape' => 'TagResourceResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'output' => [ 'shape' => 'UntagResourceResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'UpdateAgentStatus' => [ 'name' => 'UpdateAgentStatus', 'http' => [ 'method' => 'PUT', 'requestUri' => '/agent/{agentId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateAgentStatusRequest', ], 'output' => [ 'shape' => 'UpdateAgentStatusResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'UpdateConfig' => [ 'name' => 'UpdateConfig', 'http' => [ 'method' => 'PUT', 'requestUri' => '/config/{configType}/{configId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateConfigRequest', ], 'output' => [ 'shape' => 'ConfigIdResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'UpdateEphemeris' => [ 'name' => 'UpdateEphemeris', 'http' => [ 'method' => 'PUT', 'requestUri' => '/ephemeris/{ephemerisId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateEphemerisRequest', ], 'output' => [ 'shape' => 'EphemerisIdResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'UpdateMissionProfile' => [ 'name' => 'UpdateMissionProfile', 'http' => [ 'method' => 'PUT', 'requestUri' => '/missionprofile/{missionProfileId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateMissionProfileRequest', ], 'output' => [ 'shape' => 'MissionProfileIdResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], ], 'shapes' => [ 'AWSRegion' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '^[\\w-]+$', ], 'AgentCpuCoresList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Integer', ], 'max' => 256, 'min' => 0, ], 'AgentDetails' => [ 'type' => 'structure', 'required' => [ 'agentVersion', 'componentVersions', 'instanceId', 'instanceType', ], 'members' => [ 'agentCpuCores' => [ 'shape' => 'AgentCpuCoresList', ], 'agentVersion' => [ 'shape' => 'VersionString', ], 'componentVersions' => [ 'shape' => 'ComponentVersionList', ], 'instanceId' => [ 'shape' => 'InstanceId', ], 'instanceType' => [ 'shape' => 'InstanceType', ], 'reservedCpuCores' => [ 'shape' => 'AgentCpuCoresList', ], ], ], 'AgentStatus' => [ 'type' => 'string', 'enum' => [ 'SUCCESS', 'FAILED', 'ACTIVE', 'INACTIVE', ], ], 'AggregateStatus' => [ 'type' => 'structure', 'required' => [ 'status', ], 'members' => [ 'signatureMap' => [ 'shape' => 'SignatureMap', ], 'status' => [ 'shape' => 'AgentStatus', ], ], ], 'AngleUnits' => [ 'type' => 'string', 'enum' => [ 'DEGREE_ANGLE', 'RADIAN', ], ], 'AntennaDemodDecodeDetails' => [ 'type' => 'structure', 'members' => [ 'outputNode' => [ 'shape' => 'String', ], ], ], 'AntennaDownlinkConfig' => [ 'type' => 'structure', 'required' => [ 'spectrumConfig', ], 'members' => [ 'spectrumConfig' => [ 'shape' => 'SpectrumConfig', ], ], ], 'AntennaDownlinkDemodDecodeConfig' => [ 'type' => 'structure', 'required' => [ 'decodeConfig', 'demodulationConfig', 'spectrumConfig', ], 'members' => [ 'decodeConfig' => [ 'shape' => 'DecodeConfig', ], 'demodulationConfig' => [ 'shape' => 'DemodulationConfig', ], 'spectrumConfig' => [ 'shape' => 'SpectrumConfig', ], ], ], 'AntennaUplinkConfig' => [ 'type' => 'structure', 'required' => [ 'spectrumConfig', 'targetEirp', ], 'members' => [ 'spectrumConfig' => [ 'shape' => 'UplinkSpectrumConfig', ], 'targetEirp' => [ 'shape' => 'Eirp', ], 'transmitDisabled' => [ 'shape' => 'Boolean', ], ], ], 'AnyArn' => [ 'type' => 'string', 'max' => 1024, 'min' => 5, 'pattern' => '^(arn:aws:)[\\s\\S]{0,1024}$', ], 'AuditResults' => [ 'type' => 'string', 'enum' => [ 'HEALTHY', 'UNHEALTHY', ], ], 'AwsGroundStationAgentEndpoint' => [ 'type' => 'structure', 'required' => [ 'egressAddress', 'ingressAddress', 'name', ], 'members' => [ 'agentStatus' => [ 'shape' => 'AgentStatus', ], 'auditResults' => [ 'shape' => 'AuditResults', ], 'egressAddress' => [ 'shape' => 'ConnectionDetails', ], 'ingressAddress' => [ 'shape' => 'RangedConnectionDetails', ], 'name' => [ 'shape' => 'SafeName', ], ], ], 'BandwidthUnits' => [ 'type' => 'string', 'enum' => [ 'GHz', 'MHz', 'kHz', ], ], 'Boolean' => [ 'type' => 'boolean', 'box' => true, ], 'BucketArn' => [ 'type' => 'string', ], 'CancelContactRequest' => [ 'type' => 'structure', 'required' => [ 'contactId', ], 'members' => [ 'contactId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'contactId', ], ], ], 'CapabilityArn' => [ 'type' => 'string', ], 'CapabilityArnList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CapabilityArn', ], 'max' => 20, 'min' => 1, ], 'CapabilityHealth' => [ 'type' => 'string', 'enum' => [ 'UNHEALTHY', 'HEALTHY', ], ], 'CapabilityHealthReason' => [ 'type' => 'string', 'enum' => [ 'NO_REGISTERED_AGENT', 'INVALID_IP_OWNERSHIP', 'NOT_AUTHORIZED_TO_CREATE_SLR', 'UNVERIFIED_IP_OWNERSHIP', 'INITIALIZING_DATAPLANE', 'DATAPLANE_FAILURE', 'HEALTHY', ], ], 'CapabilityHealthReasonList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CapabilityHealthReason', ], 'max' => 500, 'min' => 0, ], 'ComponentStatusData' => [ 'type' => 'structure', 'required' => [ 'capabilityArn', 'componentType', 'dataflowId', 'status', ], 'members' => [ 'bytesReceived' => [ 'shape' => 'Long', ], 'bytesSent' => [ 'shape' => 'Long', ], 'capabilityArn' => [ 'shape' => 'CapabilityArn', ], 'componentType' => [ 'shape' => 'ComponentTypeString', ], 'dataflowId' => [ 'shape' => 'Uuid', ], 'packetsDropped' => [ 'shape' => 'Long', ], 'status' => [ 'shape' => 'AgentStatus', ], ], ], 'ComponentStatusList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ComponentStatusData', ], 'max' => 20, 'min' => 0, ], 'ComponentTypeString' => [ 'type' => 'string', 'pattern' => '^[a-zA-Z0-9_]{1,64}$', ], 'ComponentVersion' => [ 'type' => 'structure', 'required' => [ 'componentType', 'versions', ], 'members' => [ 'componentType' => [ 'shape' => 'ComponentTypeString', ], 'versions' => [ 'shape' => 'VersionStringList', ], ], ], 'ComponentVersionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ComponentVersion', ], 'max' => 20, 'min' => 1, ], 'ConfigArn' => [ 'type' => 'string', ], 'ConfigCapabilityType' => [ 'type' => 'string', 'enum' => [ 'antenna-downlink', 'antenna-downlink-demod-decode', 'antenna-uplink', 'dataflow-endpoint', 'tracking', 'uplink-echo', 's3-recording', ], ], 'ConfigDetails' => [ 'type' => 'structure', 'members' => [ 'antennaDemodDecodeDetails' => [ 'shape' => 'AntennaDemodDecodeDetails', ], 'endpointDetails' => [ 'shape' => 'EndpointDetails', ], 's3RecordingDetails' => [ 'shape' => 'S3RecordingDetails', ], ], 'union' => true, ], 'ConfigIdResponse' => [ 'type' => 'structure', 'members' => [ 'configArn' => [ 'shape' => 'ConfigArn', ], 'configId' => [ 'shape' => 'String', ], 'configType' => [ 'shape' => 'ConfigCapabilityType', ], ], ], 'ConfigList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ConfigListItem', ], ], 'ConfigListItem' => [ 'type' => 'structure', 'members' => [ 'configArn' => [ 'shape' => 'ConfigArn', ], 'configId' => [ 'shape' => 'String', ], 'configType' => [ 'shape' => 'ConfigCapabilityType', ], 'name' => [ 'shape' => 'String', ], ], ], 'ConfigTypeData' => [ 'type' => 'structure', 'members' => [ 'antennaDownlinkConfig' => [ 'shape' => 'AntennaDownlinkConfig', ], 'antennaDownlinkDemodDecodeConfig' => [ 'shape' => 'AntennaDownlinkDemodDecodeConfig', ], 'antennaUplinkConfig' => [ 'shape' => 'AntennaUplinkConfig', ], 'dataflowEndpointConfig' => [ 'shape' => 'DataflowEndpointConfig', ], 's3RecordingConfig' => [ 'shape' => 'S3RecordingConfig', ], 'trackingConfig' => [ 'shape' => 'TrackingConfig', ], 'uplinkEchoConfig' => [ 'shape' => 'UplinkEchoConfig', ], ], 'union' => true, ], 'ConnectionDetails' => [ 'type' => 'structure', 'required' => [ 'socketAddress', ], 'members' => [ 'mtu' => [ 'shape' => 'Integer', ], 'socketAddress' => [ 'shape' => 'SocketAddress', ], ], ], 'ContactData' => [ 'type' => 'structure', 'members' => [ 'contactId' => [ 'shape' => 'Uuid', ], 'contactStatus' => [ 'shape' => 'ContactStatus', ], 'endTime' => [ 'shape' => 'Timestamp', ], 'errorMessage' => [ 'shape' => 'String', ], 'groundStation' => [ 'shape' => 'String', ], 'maximumElevation' => [ 'shape' => 'Elevation', ], 'missionProfileArn' => [ 'shape' => 'MissionProfileArn', ], 'postPassEndTime' => [ 'shape' => 'Timestamp', ], 'prePassStartTime' => [ 'shape' => 'Timestamp', ], 'region' => [ 'shape' => 'String', ], 'satelliteArn' => [ 'shape' => 'satelliteArn', ], 'startTime' => [ 'shape' => 'Timestamp', ], 'tags' => [ 'shape' => 'TagsMap', ], 'visibilityEndTime' => [ 'shape' => 'Timestamp', ], 'visibilityStartTime' => [ 'shape' => 'Timestamp', ], ], ], 'ContactIdResponse' => [ 'type' => 'structure', 'members' => [ 'contactId' => [ 'shape' => 'Uuid', ], ], ], 'ContactList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ContactData', ], ], 'ContactStatus' => [ 'type' => 'string', 'enum' => [ 'AVAILABLE', 'AWS_CANCELLED', 'AWS_FAILED', 'CANCELLED', 'CANCELLING', 'COMPLETED', 'FAILED', 'FAILED_TO_SCHEDULE', 'PASS', 'POSTPASS', 'PREPASS', 'SCHEDULED', 'SCHEDULING', ], ], 'CreateConfigRequest' => [ 'type' => 'structure', 'required' => [ 'configData', 'name', ], 'members' => [ 'configData' => [ 'shape' => 'ConfigTypeData', ], 'name' => [ 'shape' => 'SafeName', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateDataflowEndpointGroupRequest' => [ 'type' => 'structure', 'required' => [ 'endpointDetails', ], 'members' => [ 'contactPostPassDurationSeconds' => [ 'shape' => 'DataflowEndpointGroupDurationInSeconds', ], 'contactPrePassDurationSeconds' => [ 'shape' => 'DataflowEndpointGroupDurationInSeconds', ], 'endpointDetails' => [ 'shape' => 'EndpointDetailsList', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateEphemerisRequest' => [ 'type' => 'structure', 'required' => [ 'name', 'satelliteId', ], 'members' => [ 'enabled' => [ 'shape' => 'Boolean', ], 'ephemeris' => [ 'shape' => 'EphemerisData', ], 'expirationTime' => [ 'shape' => 'Timestamp', ], 'kmsKeyArn' => [ 'shape' => 'KeyArn', ], 'name' => [ 'shape' => 'SafeName', ], 'priority' => [ 'shape' => 'CustomerEphemerisPriority', ], 'satelliteId' => [ 'shape' => 'Uuid', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateMissionProfileRequest' => [ 'type' => 'structure', 'required' => [ 'dataflowEdges', 'minimumViableContactDurationSeconds', 'name', 'trackingConfigArn', ], 'members' => [ 'contactPostPassDurationSeconds' => [ 'shape' => 'DurationInSeconds', ], 'contactPrePassDurationSeconds' => [ 'shape' => 'DurationInSeconds', ], 'dataflowEdges' => [ 'shape' => 'DataflowEdgeList', ], 'minimumViableContactDurationSeconds' => [ 'shape' => 'PositiveDurationInSeconds', ], 'name' => [ 'shape' => 'SafeName', ], 'streamsKmsKey' => [ 'shape' => 'KmsKey', ], 'streamsKmsRole' => [ 'shape' => 'RoleArn', ], 'tags' => [ 'shape' => 'TagsMap', ], 'trackingConfigArn' => [ 'shape' => 'ConfigArn', ], ], ], 'Criticality' => [ 'type' => 'string', 'enum' => [ 'PREFERRED', 'REMOVED', 'REQUIRED', ], ], 'CustomerEphemerisPriority' => [ 'type' => 'integer', 'box' => true, 'max' => 99999, 'min' => 1, ], 'DataflowDetail' => [ 'type' => 'structure', 'members' => [ 'destination' => [ 'shape' => 'Destination', ], 'errorMessage' => [ 'shape' => 'String', ], 'source' => [ 'shape' => 'Source', ], ], ], 'DataflowEdge' => [ 'type' => 'list', 'member' => [ 'shape' => 'ConfigArn', ], 'max' => 2, 'min' => 2, ], 'DataflowEdgeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DataflowEdge', ], 'max' => 500, 'min' => 0, ], 'DataflowEndpoint' => [ 'type' => 'structure', 'members' => [ 'address' => [ 'shape' => 'SocketAddress', ], 'mtu' => [ 'shape' => 'DataflowEndpointMtuInteger', ], 'name' => [ 'shape' => 'SafeName', ], 'status' => [ 'shape' => 'EndpointStatus', ], ], ], 'DataflowEndpointConfig' => [ 'type' => 'structure', 'required' => [ 'dataflowEndpointName', ], 'members' => [ 'dataflowEndpointName' => [ 'shape' => 'String', ], 'dataflowEndpointRegion' => [ 'shape' => 'String', ], ], ], 'DataflowEndpointGroupArn' => [ 'type' => 'string', ], 'DataflowEndpointGroupDurationInSeconds' => [ 'type' => 'integer', 'box' => true, 'max' => 480, 'min' => 120, ], 'DataflowEndpointGroupIdResponse' => [ 'type' => 'structure', 'members' => [ 'dataflowEndpointGroupId' => [ 'shape' => 'Uuid', ], ], ], 'DataflowEndpointGroupList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DataflowEndpointListItem', ], ], 'DataflowEndpointListItem' => [ 'type' => 'structure', 'members' => [ 'dataflowEndpointGroupArn' => [ 'shape' => 'DataflowEndpointGroupArn', ], 'dataflowEndpointGroupId' => [ 'shape' => 'Uuid', ], ], ], 'DataflowEndpointMtuInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 1500, 'min' => 1400, ], 'DataflowList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DataflowDetail', ], ], 'DecodeConfig' => [ 'type' => 'structure', 'required' => [ 'unvalidatedJSON', ], 'members' => [ 'unvalidatedJSON' => [ 'shape' => 'JsonString', ], ], ], 'DeleteConfigRequest' => [ 'type' => 'structure', 'required' => [ 'configId', 'configType', ], 'members' => [ 'configId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'configId', ], 'configType' => [ 'shape' => 'ConfigCapabilityType', 'location' => 'uri', 'locationName' => 'configType', ], ], ], 'DeleteDataflowEndpointGroupRequest' => [ 'type' => 'structure', 'required' => [ 'dataflowEndpointGroupId', ], 'members' => [ 'dataflowEndpointGroupId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'dataflowEndpointGroupId', ], ], ], 'DeleteEphemerisRequest' => [ 'type' => 'structure', 'required' => [ 'ephemerisId', ], 'members' => [ 'ephemerisId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'ephemerisId', ], ], ], 'DeleteMissionProfileRequest' => [ 'type' => 'structure', 'required' => [ 'missionProfileId', ], 'members' => [ 'missionProfileId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'missionProfileId', ], ], ], 'DemodulationConfig' => [ 'type' => 'structure', 'required' => [ 'unvalidatedJSON', ], 'members' => [ 'unvalidatedJSON' => [ 'shape' => 'JsonString', ], ], ], 'DependencyException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], 'parameterName' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 531, ], 'exception' => true, 'fault' => true, ], 'DescribeContactRequest' => [ 'type' => 'structure', 'required' => [ 'contactId', ], 'members' => [ 'contactId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'contactId', ], ], ], 'DescribeContactResponse' => [ 'type' => 'structure', 'members' => [ 'contactId' => [ 'shape' => 'Uuid', ], 'contactStatus' => [ 'shape' => 'ContactStatus', ], 'dataflowList' => [ 'shape' => 'DataflowList', ], 'endTime' => [ 'shape' => 'Timestamp', ], 'errorMessage' => [ 'shape' => 'String', ], 'groundStation' => [ 'shape' => 'String', ], 'maximumElevation' => [ 'shape' => 'Elevation', ], 'missionProfileArn' => [ 'shape' => 'MissionProfileArn', ], 'postPassEndTime' => [ 'shape' => 'Timestamp', ], 'prePassStartTime' => [ 'shape' => 'Timestamp', ], 'region' => [ 'shape' => 'String', ], 'satelliteArn' => [ 'shape' => 'satelliteArn', ], 'startTime' => [ 'shape' => 'Timestamp', ], 'tags' => [ 'shape' => 'TagsMap', ], 'visibilityEndTime' => [ 'shape' => 'Timestamp', ], 'visibilityStartTime' => [ 'shape' => 'Timestamp', ], ], ], 'DescribeEphemerisRequest' => [ 'type' => 'structure', 'required' => [ 'ephemerisId', ], 'members' => [ 'ephemerisId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'ephemerisId', ], ], ], 'DescribeEphemerisResponse' => [ 'type' => 'structure', 'members' => [ 'creationTime' => [ 'shape' => 'Timestamp', ], 'enabled' => [ 'shape' => 'Boolean', ], 'ephemerisId' => [ 'shape' => 'Uuid', ], 'invalidReason' => [ 'shape' => 'EphemerisInvalidReason', ], 'name' => [ 'shape' => 'SafeName', ], 'priority' => [ 'shape' => 'EphemerisPriority', ], 'satelliteId' => [ 'shape' => 'Uuid', ], 'status' => [ 'shape' => 'EphemerisStatus', ], 'suppliedData' => [ 'shape' => 'EphemerisTypeDescription', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'Destination' => [ 'type' => 'structure', 'members' => [ 'configDetails' => [ 'shape' => 'ConfigDetails', ], 'configId' => [ 'shape' => 'Uuid', ], 'configType' => [ 'shape' => 'ConfigCapabilityType', ], 'dataflowDestinationRegion' => [ 'shape' => 'String', ], ], ], 'DiscoveryData' => [ 'type' => 'structure', 'required' => [ 'capabilityArns', 'privateIpAddresses', 'publicIpAddresses', ], 'members' => [ 'capabilityArns' => [ 'shape' => 'CapabilityArnList', ], 'privateIpAddresses' => [ 'shape' => 'IpAddressList', ], 'publicIpAddresses' => [ 'shape' => 'IpAddressList', ], ], ], 'Double' => [ 'type' => 'double', 'box' => true, ], 'DurationInSeconds' => [ 'type' => 'integer', 'box' => true, 'max' => 21600, 'min' => 0, ], 'Eirp' => [ 'type' => 'structure', 'required' => [ 'units', 'value', ], 'members' => [ 'units' => [ 'shape' => 'EirpUnits', ], 'value' => [ 'shape' => 'Double', ], ], ], 'EirpUnits' => [ 'type' => 'string', 'enum' => [ 'dBW', ], ], 'Elevation' => [ 'type' => 'structure', 'required' => [ 'unit', 'value', ], 'members' => [ 'unit' => [ 'shape' => 'AngleUnits', ], 'value' => [ 'shape' => 'Double', ], ], ], 'EndpointDetails' => [ 'type' => 'structure', 'members' => [ 'awsGroundStationAgentEndpoint' => [ 'shape' => 'AwsGroundStationAgentEndpoint', ], 'endpoint' => [ 'shape' => 'DataflowEndpoint', ], 'healthReasons' => [ 'shape' => 'CapabilityHealthReasonList', ], 'healthStatus' => [ 'shape' => 'CapabilityHealth', ], 'securityDetails' => [ 'shape' => 'SecurityDetails', ], ], ], 'EndpointDetailsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'EndpointDetails', ], 'max' => 500, 'min' => 0, ], 'EndpointStatus' => [ 'type' => 'string', 'enum' => [ 'created', 'creating', 'deleted', 'deleting', 'failed', ], ], 'EphemeridesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'EphemerisItem', ], 'max' => 500, 'min' => 1, ], 'EphemerisData' => [ 'type' => 'structure', 'members' => [ 'oem' => [ 'shape' => 'OEMEphemeris', ], 'tle' => [ 'shape' => 'TLEEphemeris', ], ], 'union' => true, ], 'EphemerisDescription' => [ 'type' => 'structure', 'members' => [ 'ephemerisData' => [ 'shape' => 'UnboundedString', ], 'sourceS3Object' => [ 'shape' => 'S3Object', ], ], ], 'EphemerisIdResponse' => [ 'type' => 'structure', 'members' => [ 'ephemerisId' => [ 'shape' => 'Uuid', ], ], ], 'EphemerisInvalidReason' => [ 'type' => 'string', 'enum' => [ 'METADATA_INVALID', 'TIME_RANGE_INVALID', 'TRAJECTORY_INVALID', 'KMS_KEY_INVALID', 'VALIDATION_ERROR', ], ], 'EphemerisItem' => [ 'type' => 'structure', 'members' => [ 'creationTime' => [ 'shape' => 'Timestamp', ], 'enabled' => [ 'shape' => 'Boolean', ], 'ephemerisId' => [ 'shape' => 'Uuid', ], 'name' => [ 'shape' => 'SafeName', ], 'priority' => [ 'shape' => 'EphemerisPriority', ], 'sourceS3Object' => [ 'shape' => 'S3Object', ], 'status' => [ 'shape' => 'EphemerisStatus', ], ], ], 'EphemerisMetaData' => [ 'type' => 'structure', 'required' => [ 'source', ], 'members' => [ 'ephemerisId' => [ 'shape' => 'Uuid', ], 'epoch' => [ 'shape' => 'Timestamp', ], 'name' => [ 'shape' => 'SafeName', ], 'source' => [ 'shape' => 'EphemerisSource', ], ], ], 'EphemerisPriority' => [ 'type' => 'integer', 'box' => true, 'max' => 99999, 'min' => 0, ], 'EphemerisSource' => [ 'type' => 'string', 'enum' => [ 'CUSTOMER_PROVIDED', 'SPACE_TRACK', ], ], 'EphemerisStatus' => [ 'type' => 'string', 'enum' => [ 'VALIDATING', 'INVALID', 'ERROR', 'ENABLED', 'DISABLED', 'EXPIRED', ], ], 'EphemerisStatusList' => [ 'type' => 'list', 'member' => [ 'shape' => 'EphemerisStatus', ], 'max' => 500, 'min' => 0, ], 'EphemerisTypeDescription' => [ 'type' => 'structure', 'members' => [ 'oem' => [ 'shape' => 'EphemerisDescription', ], 'tle' => [ 'shape' => 'EphemerisDescription', ], ], 'union' => true, ], 'Frequency' => [ 'type' => 'structure', 'required' => [ 'units', 'value', ], 'members' => [ 'units' => [ 'shape' => 'FrequencyUnits', ], 'value' => [ 'shape' => 'Double', ], ], ], 'FrequencyBandwidth' => [ 'type' => 'structure', 'required' => [ 'units', 'value', ], 'members' => [ 'units' => [ 'shape' => 'BandwidthUnits', ], 'value' => [ 'shape' => 'Double', ], ], ], 'FrequencyUnits' => [ 'type' => 'string', 'enum' => [ 'GHz', 'MHz', 'kHz', ], ], 'GetAgentConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', ], 'members' => [ 'agentId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'agentId', ], ], ], 'GetAgentConfigurationResponse' => [ 'type' => 'structure', 'members' => [ 'agentId' => [ 'shape' => 'Uuid', ], 'taskingDocument' => [ 'shape' => 'String', ], ], ], 'GetConfigRequest' => [ 'type' => 'structure', 'required' => [ 'configId', 'configType', ], 'members' => [ 'configId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'configId', ], 'configType' => [ 'shape' => 'ConfigCapabilityType', 'location' => 'uri', 'locationName' => 'configType', ], ], ], 'GetConfigResponse' => [ 'type' => 'structure', 'required' => [ 'configArn', 'configData', 'configId', 'name', ], 'members' => [ 'configArn' => [ 'shape' => 'ConfigArn', ], 'configData' => [ 'shape' => 'ConfigTypeData', ], 'configId' => [ 'shape' => 'String', ], 'configType' => [ 'shape' => 'ConfigCapabilityType', ], 'name' => [ 'shape' => 'String', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'GetDataflowEndpointGroupRequest' => [ 'type' => 'structure', 'required' => [ 'dataflowEndpointGroupId', ], 'members' => [ 'dataflowEndpointGroupId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'dataflowEndpointGroupId', ], ], ], 'GetDataflowEndpointGroupResponse' => [ 'type' => 'structure', 'members' => [ 'contactPostPassDurationSeconds' => [ 'shape' => 'DataflowEndpointGroupDurationInSeconds', ], 'contactPrePassDurationSeconds' => [ 'shape' => 'DataflowEndpointGroupDurationInSeconds', ], 'dataflowEndpointGroupArn' => [ 'shape' => 'DataflowEndpointGroupArn', ], 'dataflowEndpointGroupId' => [ 'shape' => 'Uuid', ], 'endpointsDetails' => [ 'shape' => 'EndpointDetailsList', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'GetMinuteUsageRequest' => [ 'type' => 'structure', 'required' => [ 'month', 'year', ], 'members' => [ 'month' => [ 'shape' => 'Month', ], 'year' => [ 'shape' => 'Year', ], ], ], 'GetMinuteUsageResponse' => [ 'type' => 'structure', 'members' => [ 'estimatedMinutesRemaining' => [ 'shape' => 'Integer', ], 'isReservedMinutesCustomer' => [ 'shape' => 'Boolean', ], 'totalReservedMinuteAllocation' => [ 'shape' => 'Integer', ], 'totalScheduledMinutes' => [ 'shape' => 'Integer', ], 'upcomingMinutesScheduled' => [ 'shape' => 'Integer', ], ], ], 'GetMissionProfileRequest' => [ 'type' => 'structure', 'required' => [ 'missionProfileId', ], 'members' => [ 'missionProfileId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'missionProfileId', ], ], ], 'GetMissionProfileResponse' => [ 'type' => 'structure', 'members' => [ 'contactPostPassDurationSeconds' => [ 'shape' => 'DurationInSeconds', ], 'contactPrePassDurationSeconds' => [ 'shape' => 'DurationInSeconds', ], 'dataflowEdges' => [ 'shape' => 'DataflowEdgeList', ], 'minimumViableContactDurationSeconds' => [ 'shape' => 'PositiveDurationInSeconds', ], 'missionProfileArn' => [ 'shape' => 'MissionProfileArn', ], 'missionProfileId' => [ 'shape' => 'Uuid', ], 'name' => [ 'shape' => 'SafeName', ], 'region' => [ 'shape' => 'AWSRegion', ], 'streamsKmsKey' => [ 'shape' => 'KmsKey', ], 'streamsKmsRole' => [ 'shape' => 'RoleArn', ], 'tags' => [ 'shape' => 'TagsMap', ], 'trackingConfigArn' => [ 'shape' => 'ConfigArn', ], ], ], 'GetSatelliteRequest' => [ 'type' => 'structure', 'required' => [ 'satelliteId', ], 'members' => [ 'satelliteId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'satelliteId', ], ], ], 'GetSatelliteResponse' => [ 'type' => 'structure', 'members' => [ 'currentEphemeris' => [ 'shape' => 'EphemerisMetaData', ], 'groundStations' => [ 'shape' => 'GroundStationIdList', ], 'noradSatelliteID' => [ 'shape' => 'noradSatelliteID', ], 'satelliteArn' => [ 'shape' => 'satelliteArn', ], 'satelliteI