<?php
// This file was auto-generated from sdk-root/src/data/guardduty/2017-11-28/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2017-11-28', 'endpointPrefix' => 'guardduty', 'jsonVersion' => '1.1', 'protocol' => 'rest-json', 'protocols' => [ 'rest-json', ], 'serviceFullName' => 'Amazon GuardDuty', 'serviceId' => 'GuardDuty', 'signatureVersion' => 'v4', 'signingName' => 'guardduty', 'uid' => 'guardduty-2017-11-28', 'auth' => [ 'aws.auth#sigv4', ], ], 'operations' => [ 'AcceptAdministratorInvitation' => [ 'name' => 'AcceptAdministratorInvitation', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/administrator', 'responseCode' => 200, ], 'input' => [ 'shape' => 'AcceptAdministratorInvitationRequest', ], 'output' => [ 'shape' => 'AcceptAdministratorInvitationResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'AcceptInvitation' => [ 'name' => 'AcceptInvitation', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/master', 'responseCode' => 200, ], 'input' => [ 'shape' => 'AcceptInvitationRequest', ], 'output' => [ 'shape' => 'AcceptInvitationResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], 'deprecated' => true, 'deprecatedMessage' => 'This operation is deprecated, use AcceptAdministratorInvitation instead', ], 'ArchiveFindings' => [ 'name' => 'ArchiveFindings', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/findings/archive', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ArchiveFindingsRequest', ], 'output' => [ 'shape' => 'ArchiveFindingsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'CreateDetector' => [ 'name' => 'CreateDetector', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateDetectorRequest', ], 'output' => [ 'shape' => 'CreateDetectorResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'CreateFilter' => [ 'name' => 'CreateFilter', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/filter', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateFilterRequest', ], 'output' => [ 'shape' => 'CreateFilterResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'CreateIPSet' => [ 'name' => 'CreateIPSet', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/ipset', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateIPSetRequest', ], 'output' => [ 'shape' => 'CreateIPSetResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'CreateMalwareProtectionPlan' => [ 'name' => 'CreateMalwareProtectionPlan', 'http' => [ 'method' => 'POST', 'requestUri' => '/malware-protection-plan', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateMalwareProtectionPlanRequest', ], 'output' => [ 'shape' => 'CreateMalwareProtectionPlanResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'CreateMembers' => [ 'name' => 'CreateMembers', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/member', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateMembersRequest', ], 'output' => [ 'shape' => 'CreateMembersResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'CreatePublishingDestination' => [ 'name' => 'CreatePublishingDestination', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/publishingDestination', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreatePublishingDestinationRequest', ], 'output' => [ 'shape' => 'CreatePublishingDestinationResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'CreateSampleFindings' => [ 'name' => 'CreateSampleFindings', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/findings/create', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateSampleFindingsRequest', ], 'output' => [ 'shape' => 'CreateSampleFindingsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'CreateThreatIntelSet' => [ 'name' => 'CreateThreatIntelSet', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/threatintelset', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateThreatIntelSetRequest', ], 'output' => [ 'shape' => 'CreateThreatIntelSetResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'DeclineInvitations' => [ 'name' => 'DeclineInvitations', 'http' => [ 'method' => 'POST', 'requestUri' => '/invitation/decline', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeclineInvitationsRequest', ], 'output' => [ 'shape' => 'DeclineInvitationsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'DeleteDetector' => [ 'name' => 'DeleteDetector', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/detector/{detectorId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteDetectorRequest', ], 'output' => [ 'shape' => 'DeleteDetectorResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'DeleteFilter' => [ 'name' => 'DeleteFilter', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/detector/{detectorId}/filter/{filterName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteFilterRequest', ], 'output' => [ 'shape' => 'DeleteFilterResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'DeleteIPSet' => [ 'name' => 'DeleteIPSet', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/detector/{detectorId}/ipset/{ipSetId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteIPSetRequest', ], 'output' => [ 'shape' => 'DeleteIPSetResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'DeleteInvitations' => [ 'name' => 'DeleteInvitations', 'http' => [ 'method' => 'POST', 'requestUri' => '/invitation/delete', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteInvitationsRequest', ], 'output' => [ 'shape' => 'DeleteInvitationsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'DeleteMalwareProtectionPlan' => [ 'name' => 'DeleteMalwareProtectionPlan', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/malware-protection-plan/{malwareProtectionPlanId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteMalwareProtectionPlanRequest', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'DeleteMembers' => [ 'name' => 'DeleteMembers', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/member/delete', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteMembersRequest', ], 'output' => [ 'shape' => 'DeleteMembersResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'DeletePublishingDestination' => [ 'name' => 'DeletePublishingDestination', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/detector/{detectorId}/publishingDestination/{destinationId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeletePublishingDestinationRequest', ], 'output' => [ 'shape' => 'DeletePublishingDestinationResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'DeleteThreatIntelSet' => [ 'name' => 'DeleteThreatIntelSet', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/detector/{detectorId}/threatintelset/{threatIntelSetId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteThreatIntelSetRequest', ], 'output' => [ 'shape' => 'DeleteThreatIntelSetResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'DescribeMalwareScans' => [ 'name' => 'DescribeMalwareScans', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/malware-scans', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeMalwareScansRequest', ], 'output' => [ 'shape' => 'DescribeMalwareScansResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'DescribeOrganizationConfiguration' => [ 'name' => 'DescribeOrganizationConfiguration', 'http' => [ 'method' => 'GET', 'requestUri' => '/detector/{detectorId}/admin', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeOrganizationConfigurationRequest', ], 'output' => [ 'shape' => 'DescribeOrganizationConfigurationResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'DescribePublishingDestination' => [ 'name' => 'DescribePublishingDestination', 'http' => [ 'method' => 'GET', 'requestUri' => '/detector/{detectorId}/publishingDestination/{destinationId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribePublishingDestinationRequest', ], 'output' => [ 'shape' => 'DescribePublishingDestinationResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'DisableOrganizationAdminAccount' => [ 'name' => 'DisableOrganizationAdminAccount', 'http' => [ 'method' => 'POST', 'requestUri' => '/admin/disable', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DisableOrganizationAdminAccountRequest', ], 'output' => [ 'shape' => 'DisableOrganizationAdminAccountResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'DisassociateFromAdministratorAccount' => [ 'name' => 'DisassociateFromAdministratorAccount', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/administrator/disassociate', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DisassociateFromAdministratorAccountRequest', ], 'output' => [ 'shape' => 'DisassociateFromAdministratorAccountResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'DisassociateFromMasterAccount' => [ 'name' => 'DisassociateFromMasterAccount', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/master/disassociate', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DisassociateFromMasterAccountRequest', ], 'output' => [ 'shape' => 'DisassociateFromMasterAccountResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], 'deprecated' => true, 'deprecatedMessage' => 'This operation is deprecated, use DisassociateFromAdministratorAccount instead', ], 'DisassociateMembers' => [ 'name' => 'DisassociateMembers', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/member/disassociate', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DisassociateMembersRequest', ], 'output' => [ 'shape' => 'DisassociateMembersResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'EnableOrganizationAdminAccount' => [ 'name' => 'EnableOrganizationAdminAccount', 'http' => [ 'method' => 'POST', 'requestUri' => '/admin/enable', 'responseCode' => 200, ], 'input' => [ 'shape' => 'EnableOrganizationAdminAccountRequest', ], 'output' => [ 'shape' => 'EnableOrganizationAdminAccountResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'GetAdministratorAccount' => [ 'name' => 'GetAdministratorAccount', 'http' => [ 'method' => 'GET', 'requestUri' => '/detector/{detectorId}/administrator', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetAdministratorAccountRequest', ], 'output' => [ 'shape' => 'GetAdministratorAccountResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'GetCoverageStatistics' => [ 'name' => 'GetCoverageStatistics', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/coverage/statistics', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetCoverageStatisticsRequest', ], 'output' => [ 'shape' => 'GetCoverageStatisticsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'GetDetector' => [ 'name' => 'GetDetector', 'http' => [ 'method' => 'GET', 'requestUri' => '/detector/{detectorId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetDetectorRequest', ], 'output' => [ 'shape' => 'GetDetectorResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'GetFilter' => [ 'name' => 'GetFilter', 'http' => [ 'method' => 'GET', 'requestUri' => '/detector/{detectorId}/filter/{filterName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetFilterRequest', ], 'output' => [ 'shape' => 'GetFilterResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'GetFindings' => [ 'name' => 'GetFindings', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/findings/get', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetFindingsRequest', ], 'output' => [ 'shape' => 'GetFindingsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'GetFindingsStatistics' => [ 'name' => 'GetFindingsStatistics', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/findings/statistics', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetFindingsStatisticsRequest', ], 'output' => [ 'shape' => 'GetFindingsStatisticsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'GetIPSet' => [ 'name' => 'GetIPSet', 'http' => [ 'method' => 'GET', 'requestUri' => '/detector/{detectorId}/ipset/{ipSetId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetIPSetRequest', ], 'output' => [ 'shape' => 'GetIPSetResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'GetInvitationsCount' => [ 'name' => 'GetInvitationsCount', 'http' => [ 'method' => 'GET', 'requestUri' => '/invitation/count', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetInvitationsCountRequest', ], 'output' => [ 'shape' => 'GetInvitationsCountResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'GetMalwareProtectionPlan' => [ 'name' => 'GetMalwareProtectionPlan', 'http' => [ 'method' => 'GET', 'requestUri' => '/malware-protection-plan/{malwareProtectionPlanId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetMalwareProtectionPlanRequest', ], 'output' => [ 'shape' => 'GetMalwareProtectionPlanResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetMalwareScanSettings' => [ 'name' => 'GetMalwareScanSettings', 'http' => [ 'method' => 'GET', 'requestUri' => '/detector/{detectorId}/malware-scan-settings', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetMalwareScanSettingsRequest', ], 'output' => [ 'shape' => 'GetMalwareScanSettingsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'GetMasterAccount' => [ 'name' => 'GetMasterAccount', 'http' => [ 'method' => 'GET', 'requestUri' => '/detector/{detectorId}/master', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetMasterAccountRequest', ], 'output' => [ 'shape' => 'GetMasterAccountResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], 'deprecated' => true, 'deprecatedMessage' => 'This operation is deprecated, use GetAdministratorAccount instead', ], 'GetMemberDetectors' => [ 'name' => 'GetMemberDetectors', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/member/detector/get', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetMemberDetectorsRequest', ], 'output' => [ 'shape' => 'GetMemberDetectorsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'GetMembers' => [ 'name' => 'GetMembers', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/member/get', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetMembersRequest', ], 'output' => [ 'shape' => 'GetMembersResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'GetOrganizationStatistics' => [ 'name' => 'GetOrganizationStatistics', 'http' => [ 'method' => 'GET', 'requestUri' => '/organization/statistics', 'responseCode' => 200, ], 'output' => [ 'shape' => 'GetOrganizationStatisticsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'GetRemainingFreeTrialDays' => [ 'name' => 'GetRemainingFreeTrialDays', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/freeTrial/daysRemaining', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetRemainingFreeTrialDaysRequest', ], 'output' => [ 'shape' => 'GetRemainingFreeTrialDaysResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'GetThreatIntelSet' => [ 'name' => 'GetThreatIntelSet', 'http' => [ 'method' => 'GET', 'requestUri' => '/detector/{detectorId}/threatintelset/{threatIntelSetId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetThreatIntelSetRequest', ], 'output' => [ 'shape' => 'GetThreatIntelSetResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'GetUsageStatistics' => [ 'name' => 'GetUsageStatistics', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/usage/statistics', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetUsageStatisticsRequest', ], 'output' => [ 'shape' => 'GetUsageStatisticsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'InviteMembers' => [ 'name' => 'InviteMembers', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/member/invite', 'responseCode' => 200, ], 'input' => [ 'shape' => 'InviteMembersRequest', ], 'output' => [ 'shape' => 'InviteMembersResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'ListCoverage' => [ 'name' => 'ListCoverage', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/coverage', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListCoverageRequest', ], 'output' => [ 'shape' => 'ListCoverageResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'ListDetectors' => [ 'name' => 'ListDetectors', 'http' => [ 'method' => 'GET', 'requestUri' => '/detector', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListDetectorsRequest', ], 'output' => [ 'shape' => 'ListDetectorsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'ListFilters' => [ 'name' => 'ListFilters', 'http' => [ 'method' => 'GET', 'requestUri' => '/detector/{detectorId}/filter', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListFiltersRequest', ], 'output' => [ 'shape' => 'ListFiltersResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'ListFindings' => [ 'name' => 'ListFindings', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/findings', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListFindingsRequest', ], 'output' => [ 'shape' => 'ListFindingsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'ListIPSets' => [ 'name' => 'ListIPSets', 'http' => [ 'method' => 'GET', 'requestUri' => '/detector/{detectorId}/ipset', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListIPSetsRequest', ], 'output' => [ 'shape' => 'ListIPSetsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'ListInvitations' => [ 'name' => 'ListInvitations', 'http' => [ 'method' => 'GET', 'requestUri' => '/invitation', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListInvitationsRequest', ], 'output' => [ 'shape' => 'ListInvitationsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'ListMalwareProtectionPlans' => [ 'name' => 'ListMalwareProtectionPlans', 'http' => [ 'method' => 'GET', 'requestUri' => '/malware-protection-plan', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListMalwareProtectionPlansRequest', ], 'output' => [ 'shape' => 'ListMalwareProtectionPlansResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'ListMembers' => [ 'name' => 'ListMembers', 'http' => [ 'method' => 'GET', 'requestUri' => '/detector/{detectorId}/member', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListMembersRequest', ], 'output' => [ 'shape' => 'ListMembersResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'ListOrganizationAdminAccounts' => [ 'name' => 'ListOrganizationAdminAccounts', 'http' => [ 'method' => 'GET', 'requestUri' => '/admin', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListOrganizationAdminAccountsRequest', ], 'output' => [ 'shape' => 'ListOrganizationAdminAccountsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'ListPublishingDestinations' => [ 'name' => 'ListPublishingDestinations', 'http' => [ 'method' => 'GET', 'requestUri' => '/detector/{detectorId}/publishingDestination', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListPublishingDestinationsRequest', ], 'output' => [ 'shape' => 'ListPublishingDestinationsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'ListThreatIntelSets' => [ 'name' => 'ListThreatIntelSets', 'http' => [ 'method' => 'GET', 'requestUri' => '/detector/{detectorId}/threatintelset', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListThreatIntelSetsRequest', ], 'output' => [ 'shape' => 'ListThreatIntelSetsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'StartMalwareScan' => [ 'name' => 'StartMalwareScan', 'http' => [ 'method' => 'POST', 'requestUri' => '/malware-scan/start', 'responseCode' => 200, ], 'input' => [ 'shape' => 'StartMalwareScanRequest', ], 'output' => [ 'shape' => 'StartMalwareScanResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'StartMonitoringMembers' => [ 'name' => 'StartMonitoringMembers', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/member/start', 'responseCode' => 200, ], 'input' => [ 'shape' => 'StartMonitoringMembersRequest', ], 'output' => [ 'shape' => 'StartMonitoringMembersResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'StopMonitoringMembers' => [ 'name' => 'StopMonitoringMembers', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/member/stop', 'responseCode' => 200, ], 'input' => [ 'shape' => 'StopMonitoringMembersRequest', ], 'output' => [ 'shape' => 'StopMonitoringMembersResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'output' => [ 'shape' => 'TagResourceResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'UnarchiveFindings' => [ 'name' => 'UnarchiveFindings', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/findings/unarchive', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UnarchiveFindingsRequest', ], 'output' => [ 'shape' => 'UnarchiveFindingsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'output' => [ 'shape' => 'UntagResourceResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'UpdateDetector' => [ 'name' => 'UpdateDetector', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateDetectorRequest', ], 'output' => [ 'shape' => 'UpdateDetectorResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'UpdateFilter' => [ 'name' => 'UpdateFilter', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/filter/{filterName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateFilterRequest', ], 'output' => [ 'shape' => 'UpdateFilterResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'UpdateFindingsFeedback' => [ 'name' => 'UpdateFindingsFeedback', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/findings/feedback', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateFindingsFeedbackRequest', ], 'output' => [ 'shape' => 'UpdateFindingsFeedbackResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'UpdateIPSet' => [ 'name' => 'UpdateIPSet', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/ipset/{ipSetId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateIPSetRequest', ], 'output' => [ 'shape' => 'UpdateIPSetResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'UpdateMalwareProtectionPlan' => [ 'name' => 'UpdateMalwareProtectionPlan', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/malware-protection-plan/{malwareProtectionPlanId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateMalwareProtectionPlanRequest', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'UpdateMalwareScanSettings' => [ 'name' => 'UpdateMalwareScanSettings', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/malware-scan-settings', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateMalwareScanSettingsRequest', ], 'output' => [ 'shape' => 'UpdateMalwareScanSettingsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'UpdateMemberDetectors' => [ 'name' => 'UpdateMemberDetectors', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/member/detector/update', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateMemberDetectorsRequest', ], 'output' => [ 'shape' => 'UpdateMemberDetectorsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'UpdateOrganizationConfiguration' => [ 'name' => 'UpdateOrganizationConfiguration', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/admin', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateOrganizationConfigurationRequest', ], 'output' => [ 'shape' => 'UpdateOrganizationConfigurationResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'UpdatePublishingDestination' => [ 'name' => 'UpdatePublishingDestination', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/publishingDestination/{destinationId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdatePublishingDestinationRequest', ], 'output' => [ 'shape' => 'UpdatePublishingDestinationResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'UpdateThreatIntelSet' => [ 'name' => 'UpdateThreatIntelSet', 'http' => [ 'method' => 'POST', 'requestUri' => '/detector/{detectorId}/threatintelset/{threatIntelSetId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateThreatIntelSetRequest', ], 'output' => [ 'shape' => 'UpdateThreatIntelSetResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], ], 'shapes' => [ 'AcceptAdministratorInvitationRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', 'AdministratorId', 'InvitationId', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], 'AdministratorId' => [ 'shape' => 'String', 'locationName' => 'administratorId', ], 'InvitationId' => [ 'shape' => 'String', 'locationName' => 'invitationId', ], ], ], 'AcceptAdministratorInvitationResponse' => [ 'type' => 'structure', 'members' => [], ], 'AcceptInvitationRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', 'MasterId', 'InvitationId', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], 'MasterId' => [ 'shape' => 'String', 'locationName' => 'masterId', ], 'InvitationId' => [ 'shape' => 'String', 'locationName' => 'invitationId', ], ], 'deprecated' => true, 'deprecatedMessage' => 'This input is deprecated, use AcceptAdministratorInvitationRequest instead', ], 'AcceptInvitationResponse' => [ 'type' => 'structure', 'members' => [], 'deprecated' => true, 'deprecatedMessage' => 'This output is deprecated, use AcceptAdministratorInvitationResponse instead', ], 'AccessControlList' => [ 'type' => 'structure', 'members' => [ 'AllowsPublicReadAccess' => [ 'shape' => 'Boolean', 'locationName' => 'allowsPublicReadAccess', ], 'AllowsPublicWriteAccess' => [ 'shape' => 'Boolean', 'locationName' => 'allowsPublicWriteAccess', ], ], ], 'AccessDeniedException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', 'locationName' => 'message', ], 'Type' => [ 'shape' => 'String', 'locationName' => '__type', ], ], 'error' => [ 'httpStatusCode' => 403, ], 'exception' => true, ], 'AccessKeyDetails' => [ 'type' => 'structure', 'members' => [ 'AccessKeyId' => [ 'shape' => 'String', 'locationName' => 'accessKeyId', ], 'PrincipalId' => [ 'shape' => 'String', 'locationName' => 'principalId', ], 'UserName' => [ 'shape' => 'String', 'locationName' => 'userName', ], 'UserType' => [ 'shape' => 'String', 'locationName' => 'userType', ], ], ], 'AccountDetail' => [ 'type' => 'structure', 'required' => [ 'AccountId', 'Email', ], 'members' => [ 'AccountId' => [ 'shape' => 'AccountId', 'locationName' => 'accountId', ], 'Email' => [ 'shape' => 'Email', 'locationName' => 'email', ], ], ], 'AccountDetails' => [ 'type' => 'list', 'member' => [ 'shape' => 'AccountDetail', ], 'max' => 50, 'min' => 1, ], 'AccountFreeTrialInfo' => [ 'type' => 'structure', 'members' => [ 'AccountId' => [ 'shape' => 'String', 'locationName' => 'accountId', ], 'DataSources' => [ 'shape' => 'DataSourcesFreeTrial', 'deprecated' => true, 'deprecatedMessage' => 'This parameter is deprecated, use Features instead', 'locationName' => 'dataSources', ], 'Features' => [ 'shape' => 'FreeTrialFeatureConfigurationsResults', 'locationName' => 'features', ], ], ], 'AccountFreeTrialInfos' => [ 'type' => 'list', 'member' => [ 'shape' => 'AccountFreeTrialInfo', ], ], 'AccountId' => [ 'type' => 'string', 'max' => 12, 'min' => 12, ], 'AccountIds' => [ 'type' => 'list', 'member' => [ 'shape' => 'AccountId', ], 'max' => 50, 'min' => 1, ], 'AccountLevelPermissions' => [ 'type' => 'structure', 'members' => [ 'BlockPublicAccess' => [ 'shape' => 'BlockPublicAccess', 'locationName' => 'blockPublicAccess', ], ], ], 'Action' => [ 'type' => 'structure', 'members' => [ 'ActionType' => [ 'shape' => 'String', 'locationName' => 'actionType', ], 'AwsApiCallAction' => [ 'shape' => 'AwsApiCallAction', 'locationName' => 'awsApiCallAction', ], 'DnsRequestAction' => [ 'shape' => 'DnsRequestAction', 'locationName' => 'dnsRequestAction', ], 'NetworkConnectionAction' => [ 'shape' => 'NetworkConnectionAction', 'locationName' => 'networkConnectionAction', ], 'PortProbeAction' => [ 'shape' => 'PortProbeAction', 'locationName' => 'portProbeAction', ], 'KubernetesApiCallAction' => [ 'shape' => 'KubernetesApiCallAction', 'locationName' => 'kubernetesApiCallAction', ], 'RdsLoginAttemptAction' => [ 'shape' => 'RdsLoginAttemptAction', 'locationName' => 'rdsLoginAttemptAction', ], 'KubernetesPermissionCheckedDetails' => [ 'shape' => 'KubernetesPermissionCheckedDetails', 'locationName' => 'kubernetesPermissionCheckedDetails', ], 'KubernetesRoleBindingDetails' => [ 'shape' => 'KubernetesRoleBindingDetails', 'locationName' => 'kubernetesRoleBindingDetails', ], 'KubernetesRoleDetails' => [ 'shape' => 'KubernetesRoleDetails', 'locationName' => 'kubernetesRoleDetails', ], ], ], 'AddonDetails' => [ 'type' => 'structure', 'members' => [ 'AddonVersion' => [ 'shape' => 'String', 'locationName' => 'addonVersion', ], 'AddonStatus' => [ 'shape' => 'String', 'locationName' => 'addonStatus', ], ], ], 'AdminAccount' => [ 'type' => 'structure', 'members' => [ 'AdminAccountId' => [ 'shape' => 'String', 'locationName' => 'adminAccountId', ], 'AdminStatus' => [ 'shape' => 'AdminStatus', 'locationName' => 'adminStatus', ], ], ], 'AdminAccounts' => [ 'type' => 'list', 'member' => [ 'shape' => 'AdminAccount', ], 'max' => 1, 'min' => 0, ], 'AdminStatus' => [ 'type' => 'string', 'enum' => [ 'ENABLED', 'DISABLE_IN_PROGRESS', ], 'max' => 300, 'min' => 1, ], 'Administrator' => [ 'type' => 'structure', 'members' => [ 'AccountId' => [ 'shape' => 'AccountId', 'locationName' => 'accountId', ], 'InvitationId' => [ 'shape' => 'String', 'locationName' => 'invitationId', ], 'RelationshipStatus' => [ 'shape' => 'String', 'locationName' => 'relationshipStatus', ], 'InvitedAt' => [ 'shape' => 'String', 'locationName' => 'invitedAt', ], ], ], 'AffectedResources' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], 'AgentDetails' => [ 'type' => 'structure', 'members' => [ 'Version' => [ 'shape' => 'String', 'locationName' => 'version', ], ], ], 'Anomaly' => [ 'type' => 'structure', 'members' => [ 'Profiles' => [ 'shape' => 'AnomalyProfiles', 'locationName' => 'profiles', ], 'Unusual' => [ 'shape' => 'AnomalyUnusual', 'locationName' => 'unusual', ], ], ], 'AnomalyObject' => [ 'type' => 'structure', 'members' => [ 'ProfileType' => [ 'shape' => 'ProfileType', 'locationName' => 'profileType', ], 'ProfileSubtype' => [ 'shape' => 'ProfileSubtype', 'locationName' => 'profileSubtype', ], 'Observations' => [ 'shape' => 'Observations', 'locationName' => 'observations', ], ], ], 'AnomalyProfileFeatureObjects' => [ 'type' => 'list', 'member' => [ 'shape' => 'AnomalyObject', ], ], 'AnomalyProfileFeatures' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'AnomalyProfileFeatureObjects', ], ], 'AnomalyProfiles' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'AnomalyProfileFeatures', ], ], 'AnomalyUnusual' => [ 'type' => 'structure', 'members' => [ 'Behavior' => [ 'shape' => 'Behavior', 'locationName' => 'behavior', ], ], ], 'AnomalyUnusualBehaviorFeature' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'AnomalyObject', ], ], 'ArchiveFindingsRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', 'FindingIds', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], 'FindingIds' => [ 'shape' => 'FindingIds', 'locationName' => 'findingIds', ], ], ], 'ArchiveFindingsResponse' => [ 'type' => 'structure', 'members' => [], ], 'AutoEnableMembers' => [ 'type' => 'string', 'enum' => [ 'NEW', 'ALL', 'NONE', ], ], 'AwsApiCallAction' => [ 'type' => 'structure', 'members' => [ 'Api' => [ 'shape' => 'String', 'locationName' => 'api', ], 'CallerType' => [ 'shape' => 'String', 'locationName' => 'callerType', ], 'DomainDetails' => [ 'shape' => 'DomainDetails', 'locationName' => 'domainDetails', ], 'ErrorCode' => [ 'shape' => 'String', 'locationName' => 'errorCode', ], 'UserAgent' => [ 'shape' => 'String', 'locationName' => 'userAgent', ], 'RemoteIpDetails' => [ 'shape' => 'RemoteIpDetails', 'locationName' => 'remoteIpDetails', ], 'ServiceName' => [ 'shape' => 'String', 'locationName' => 'serviceName', ], 'RemoteAccountDetails' => [ 'shape' => 'RemoteAccountDetails', 'locationName' => 'remoteAccountDetails', ], 'AffectedResources' => [ 'shape' => 'AffectedResources', 'locationName' => 'affectedResources', ], ], ], 'BadRequestException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', 'locationName' => 'message', ], 'Type' => [ 'shape' => 'String', 'locationName' => '__type', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'Behavior' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'AnomalyUnusualBehaviorFeature', ], ], 'BlockPublicAccess' => [ 'type' => 'structure', 'members' => [ 'IgnorePublicAcls' => [ 'shape' => 'Boolean', 'locationName' => 'ignorePublicAcls', ], 'RestrictPublicBuckets' => [ 'shape' => 'Boolean', 'locationName' => 'restrictPublicBuckets', ], 'BlockPublicAcls' => [ 'shape' => 'Boolean', 'locationName' => 'blockPublicAcls', ], 'BlockPublicPolicy' => [ 'shape' => 'Boolean', 'locationName' => 'blockPublicPolicy', ], ], ], 'Boolean' => [ 'type' => 'boolean', ], 'BucketLevelPermissions' => [ 'type' => 'structure', 'members' => [ 'AccessControlList' => [ 'shape' => 'AccessControlList', 'locationName' => 'accessControlList', ], 'BucketPolicy' => [ 'shape' => 'BucketPolicy', 'locationName' => 'bucketPolicy', ], 'BlockPublicAccess' => [ 'shape' => 'BlockPublicAccess', 'locationName' => 'blockPublicAccess', ], ], ], 'BucketPolicy' => [ 'type' => 'structure', 'members' => [ 'AllowsPublicReadAccess' => [ 'shape' => 'Boolean', 'locationName' => 'allowsPublicReadAccess', ], 'AllowsPublicWriteAccess' => [ 'shape' => 'Boolean', 'locationName' => 'allowsPublicWriteAccess', ], ], ], 'City' => [ 'type' => 'structure', 'members' => [ 'CityName' => [ 'shape' => 'String', 'locationName' => 'cityName', ], ], ], 'ClientToken' => [ 'type' => 'string', 'max' => 64, 'min' => 0, ], 'CloudTrailConfigurationResult' => [ 'type' => 'structure', 'required' => [ 'Status', ], 'members' => [ 'Status' => [ 'shape' => 'DataSourceStatus', 'locationName' => 'status', ], ], ], 'Condition' => [ 'type' => 'structure', 'members' => [ 'Eq' => [ 'shape' => 'Eq', 'deprecated' => true, 'locationName' => 'eq', ], 'Neq' => [ 'shape' => 'Neq', 'deprecated' => true, 'locationName' => 'neq', ], 'Gt' => [ 'shape' => 'Integer', 'deprecated' => true, 'locationName' => 'gt', ], 'Gte' => [ 'shape' => 'Integer', 'deprecated' => true, 'locationName' => 'gte', ], 'Lt' => [ 'shape' => 'Integer', 'deprecated' => true, 'locationName' => 'lt', ], 'Lte' => [ 'shape' => 'Integer', 'deprecated' => true, 'locationName' => 'lte', ], 'Equals' => [ 'shape' => 'Equals', 'locationName' => 'equals', ], 'NotEquals' => [ 'shape' => 'NotEquals', 'locationName' => 'notEquals', ], 'GreaterThan' => [ 'shape' => 'Long', 'locationName' => 'greaterThan', ], 'GreaterThanOrEqual' => [ 'shape' => 'Long', 'locationName' => 'greaterThanOrEqual', ], 'LessThan' => [ 'shape' => 'Long', 'locationName' => 'lessThan', ], 'LessThanOrEqual' => [ 'shape' => 'Long', 'locationName' => 'lessThanOrEqual', ], ], ], 'ConflictException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'String', 'locationName' => 'message', ], 'Type' => [ 'shape' => 'String', 'locationName' => '__type', ], ], 'error' => [ 'httpStatusCode' => 409, ], 'exception' => true, ], 'Container' => [ 'type' => 'structure', 'members' => [ 'ContainerRuntime' => [ 'shape' => 'String', 'locationName' => 'containerRuntime', ], 'Id' => [ 'shape' => 'String', 'locationName' => 'id', ], 'Name' => [ 'shape' => 'String', 'locationName' => 'name', ], 'Image' => [ 'shape' => 'String', 'locationName' => 'image', ], 'ImagePrefix' => [ 'shape' => 'String', 'locationName' => 'imagePrefix', ], 'VolumeMounts' => [ 'shape' => 'VolumeMounts', 'locationName' => 'volumeMounts', ], 'SecurityContext' => [ 'shape' => 'SecurityContext', 'locationName' => 'securityContext', ], ], ], 'ContainerInstanceDetails' => [ 'type' => 'structure', 'members' => [ 'CoveredContainerInstances' => [ 'shape' => 'Long', 'locationName' => 'coveredContainerInstances', ], 'CompatibleContainerInstances' => [ 'shape' => 'Long', 'locationName' => 'compatibleContainerInstances', ], ], ], 'Containers' => [ 'type' => 'list', 'member' => [ 'shape' => 'Container', ], ], 'CountByCoverageStatus' => [ 'type' => 'map', 'key' => [ 'shape' => 'CoverageStatus', ], 'value' => [ 'shape' => 'Long', ], ], 'CountByResourceType' => [ 'type' => 'map', 'key' => [ 'shape' => 'ResourceType', ], 'value' => [ 'shape' => 'Long', ], ], 'CountBySeverity' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'Integer', ], ], 'Country' => [ 'type' => 'structure', 'members' => [ 'CountryCode' => [ 'shape' => 'String', 'locationName' => 'countryCode', ], 'CountryName' => [ 'shape' => 'String', 'locationName' => 'countryName', ], ], ], 'CoverageEc2InstanceDetails' => [ 'type' => 'structure', 'members' => [ 'InstanceId' => [ 'shape' => 'String', 'locationName' => 'instanceId', ], 'InstanceType' => [ 'shape' => 'String', 'locationName' => 'instanceType', ], 'ClusterArn' => [ 'shape' => 'String', 'locationName' => 'clusterArn', ], 'AgentDetails' => [ 'shape' => 'AgentDetails', 'locationName' => 'agentDetails', ], 'ManagementType' => [ 'shape' => 'ManagementType', 'locationName' => 'managementType', ], ], ], 'CoverageEcsClusterDetails' => [ 'type' => 'structure', 'members' => [ 'ClusterName' => [ 'shape' => 'String', 'locationName' => 'clusterName', ], 'FargateDetails' => [ 'shape' => 'FargateDetails', 'locationName' => 'fargateDetails', ], 'ContainerInstanceDetails' => [ 'shape' => 'ContainerInstanceDetails', 'locationName' => 'containerInstanceDetails', ], ], ], 'CoverageEksClusterDetails' => [ 'type' => 'structure', 'members' => [ 'ClusterName' => [ 'shape' => 'String', 'locationName' => 'clusterName', ], 'CoveredNodes' => [ 'shape' => 'Long', 'locationName' => 'coveredNodes', ], 'CompatibleNodes' => [ 'shape' => 'Long', 'locationName' => 'compatibleNodes', ], 'AddonDetails' => [ 'shape' => 'AddonDetails', 'locationName' => 'addonDetails', ], 'ManagementType' => [ 'shape' => 'ManagementType', 'locationName' => 'managementType', ], ], ], 'CoverageFilterCondition' => [ 'type' => 'structure', 'members' => [ 'Equals' => [ 'shape' => 'Equals', 'locationName' => 'equals', ], 'NotEquals' => [ 'shape' => 'NotEquals', 'locationName' => 'notEquals', ], ], ], 'CoverageFilterCriteria' => [ 'type' => 'structure', 'members' => [ 'FilterCriterion' => [ 'shape' => 'CoverageFilterCriterionList', 'locationName' => 'filterCriterion', ], ], ], 'CoverageFilterCriterion' => [ 'type' => 'structure', 'members' => [ 'CriterionKey' => [ 'shape' => 'CoverageFilterCriterionKey', 'locationName' => 'criterionKey', ], 'FilterCondition' => [ 'shape' => 'CoverageFilterCondition', 'locationName' => 'filterCondition', ], ], ], 'CoverageFilterCriterionKey' => [ 'type' => 'string', 'enum' => [ 'ACCOUNT_ID', 'CLUSTER_NAME', 'RESOURCE_TYPE', 'COVERAGE_STATUS', 'ADDON_VERSION', 'MANAGEMENT_TYPE', 'EKS_CLUSTER_NAME', 'ECS_CLUSTER_NAME', 'AGENT_VERSION', 'INSTANCE_ID', 'CLUSTER_ARN', ], ], 'CoverageFilterCriterionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CoverageFilterCriterion', ], 'max' => 50, 'min' => 0, ], 'CoverageResource' => [ 'type' => 'structure', 'members' => [ 'ResourceId' => [ 'shape' => 'String', 'locationName' => 'resourceId', ], 'DetectorId' => [ 'shape' => 'DetectorId', 'locationName' => 'detectorId', ], 'AccountId' => [ 'shape' => 'AccountId', 'locationName' => 'accountId', ], 'ResourceDetails' => [ 'shape' => 'CoverageResourceDetails', 'locationName' => 'resourceDetails', ], 'CoverageStatus' => [ 'shape' => 'CoverageStatus', 'locationName' => 'coverageStatus', ], 'Issue' => [ 'shape' => 'String', 'locationName' => 'issue', ], 'UpdatedAt' => [ 'shape' => 'Timestamp', 'locationName' => 'updatedAt', ], ], ], 'CoverageResourceDetails' => [ 'type' => 'structure', 'members' => [ 'EksClusterDetails' => [ 'shape' => 'CoverageEksClusterDetails', 'locationName' => 'eksClusterDetails', ], 'ResourceType' => [ 'shape' => 'ResourceType', 'locationName' => 'resourceType', ], 'EcsClusterDetails' => [ 'shape' => 'CoverageEcsClusterDetails', 'locationName' => 'ecsClusterDetails', ], 'Ec2InstanceDetails' => [ 'shape' => 'CoverageEc2InstanceDetails', 'locationName' => 'ec2InstanceDetails', ], ], ], 'CoverageResources' => [ 'type' => 'list', 'member' => [ 'shape' => 'CoverageResource', ], ], 'CoverageSortCriteria' => [ 'type' => 'structure', 'members' => [ 'AttributeName' => [ 'shape' => 'CoverageSortKey', 'locationName' => 'attributeName', ], 'OrderBy' => [ 'shape' => 'OrderBy', 'locationName' => 'orderBy', ], ], ], 'CoverageSortKey' => [ 'type' => 'string', 'enum' => [ 'ACCOUNT_ID', 'CLUSTER_NAME', 'COVERAGE_STATUS', 'ISSUE', 'ADDON_VERSION', 'UPDATED_AT', 'EKS_CLUSTER_NAME', 'ECS_CLUSTER_NAME', 'INSTANCE_ID', ], ], 'CoverageStatistics' => [ 'type' => 'structure', 'members' => [ 'CountByResourceType' => [ 'shape' => 'CountByResourceType', 'locationName' => 'countByResourceType', ], 'CountByCoverageStatus' => [ 'shape' => 'CountByCoverageStatus', 'locationName' => 'countByCoverageStatus', ], ], ], 'CoverageStatisticsType' => [ 'type' => 'string', 'enum' => [ 'COUNT_BY_RESOURCE_TYPE', 'COUNT_BY_COVERAGE_STATUS', ], ], 'CoverageStatisticsTypeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CoverageStatisticsType', ], ], 'CoverageStatus' => [ 'type' => 'string', 'enum' => [ 'HEALTHY', 'UNHEALTHY', ], ], 'CreateDetectorRequest' => [ 'type' => 'structure', 'required' => [ 'Enable', ], 'members' => [ 'Enable' => [ 'shape' => 'Boolean', 'locationName' => 'enable', ], 'ClientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, 'locationName' => 'clientToken', ], 'FindingPublishingFrequency' => [ 'shape' => 'FindingPublishingFrequency', 'locationName' => 'findingPublishingFrequency', ], 'DataSources' => [ 'shape' => 'DataSourceConfigurations', 'deprecated' => true, 'deprecatedMessage' => 'This parameter is deprecated, use Features instead', 'locationName' => 'dataSources', ], 'Tags' => [ 'shape' => 'TagMap', 'locationName' => 'tags', ], 'Features' => [ 'shape' => 'DetectorFeatureConfigurations', 'locationName' => 'features', ], ], ], 'CreateDetectorResponse' => [ 'type' => 'structure', 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'locationName' => 'detectorId', ], 'UnprocessedDataSources' => [ 'shape' => 'UnprocessedDataSourcesResult', 'locationName' => 'unprocessedDataSources', ], ], ], 'CreateFilterRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', 'Name', 'FindingCriteria', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], 'Name' => [ 'shape' => 'FilterName', 'locationName' => 'name', ], 'Description' => [ 'shape' => 'FilterDescription', 'locationName' => 'description', ], 'Action' => [ 'shape' => 'FilterAction', 'locationName' => 'action', ], 'Rank' => [ 'shape' => 'FilterRank', 'locationName' => 'rank', ], 'FindingCriteria' => [ 'shape' => 'FindingCriteria', 'locationName' => 'findingCriteria', ], 'ClientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, 'locationName' => 'clientToken', ], 'Tags' => [ 'shape' => 'TagMap', 'locationName' => 'tags', ], ], ], 'CreateFilterResponse' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'FilterName', 'locationName' => 'name', ], ], ], 'CreateIPSetRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', 'Name', 'Format', 'Location', 'Activate', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], 'Name' => [ 'shape' => 'Name', 'locationName' => 'name', ], 'Format' => [ 'shape' => 'IpSetFormat', 'locationName' => 'format', ], 'Location' => [ 'shape' => 'Location', 'locationName' => 'location', ], 'Activate' => [ 'shape' => 'Boolean', 'locationName' => 'activate', ], 'ClientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, 'locationName' => 'clientToken', ], 'Tags' => [ 'shape' => 'TagMap', 'locationName' => 'tags', ], ], ], 'CreateIPSetResponse' => [ 'type' => 'structure', 'required' => [ 'IpSetId', ], 'members' => [ 'IpSetId' => [ 'shape' => 'String', 'locationName' => 'ipSetId', ], ], ], 'CreateMalwareProtectionPlanRequest' => [ 'type' => 'structure', 'required' => [ 'Role', 'ProtectedResource', ], 'members' => [ 'ClientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, 'locationName' => 'clientToken', ], 'Role' => [ 'shape' => 'String', 'locationName' => 'role', ], 'ProtectedResource' => [ 'shape' => 'CreateProtectedResource', 'locationName' => 'protectedResource', ], 'Actions' => [ 'shape' => 'MalwareProtectionPlanActions', 'locationName' => 'actions', ], 'Tags' => [ 'shape' => 'TagMap', 'locationName' => 'tags', ], ], ], 'CreateMalwareProtectionPlanResponse' => [ 'type' => 'structure', 'members' => [ 'MalwareProtectionPlanId' => [ 'shape' => 'String', 'locationName' => 'malwareProtectionPlanId', ], ], ], 'CreateMembersRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', 'AccountDetails', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], 'AccountDetails' => [ 'shape' => 'AccountDetails', 'locationName' => 'accountDetails', ], ], ], 'CreateMembersResponse' => [ 'type' => 'structure', 'required' => [ 'UnprocessedAccounts', ], 'members' => [ 'UnprocessedAccounts' => [ 'shape' => 'UnprocessedAccounts', 'locationName' => 'unprocessedAccounts', ], ], ], 'CreateProtectedResource' => [ 'type' => 'structure', 'members' => [ 'S3Bucket' => [ 'shape' => 'CreateS3BucketResource', 'locationName' => 's3Bucket', ], ], ], 'CreatePublishingDestinationRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', 'DestinationType', 'DestinationProperties', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], 'DestinationType' => [ 'shape' => 'DestinationType', 'locationName' => 'destinationType', ], 'DestinationProperties' => [ 'shape' => 'DestinationProperties', 'locationName' => 'destinationProperties', ], 'ClientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, 'locationName' => 'clientToken', ], ], ], 'CreatePublishingDestinationResponse' => [ 'type' => 'structure', 'required' => [ 'DestinationId', ], 'members' => [ 'DestinationId' => [ 'shape' => 'String', 'locationName' => 'destinationId', ], ], ], 'CreateS3BucketResource' => [ 'type' => 'structure', 'members' => [ 'BucketName' => [ 'shape' => 'String', 'locationName' => 'bucketName', ], 'ObjectPrefixes' => [ 'shape' => 'MalwareProtectionPlanObjectPrefixesList', 'locationName' => 'objectPrefixes', ], ], ], 'CreateSampleFindingsRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], 'FindingTypes' => [ 'shape' => 'FindingTypes', 'locationName' => 'findingTypes', ], ], ], 'CreateSampleFindingsResponse' => [ 'type' => 'structure', 'members' => [], ], 'CreateThreatIntelSetRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', 'Name', 'Format', 'Location', 'Activate', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], 'Name' => [ 'shape' => 'Name', 'locationName' => 'name', ], 'Format' => [ 'shape' => 'ThreatIntelSetFormat', 'locationName' => 'format', ], 'Location' => [ 'shape' => 'Location', 'locationName' => 'location', ], 'Activate' => [ 'shape' => 'Boolean', 'locationName' => 'activate', ], 'ClientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, 'locationName' => 'clientToken', ], 'Tags' => [ 'shape' => 'TagMap', 'locationName' => 'tags', ], ], ], 'CreateThreatIntelSetResponse' => [ 'type' => 'structure', 'required' => [ 'ThreatIntelSetId', ], 'members' => [ 'ThreatIntelSetId' => [ 'shape' => 'String', 'locationName' => 'threatIntelSetId', ], ], ], 'Criterion' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'Condition', ], ], 'CriterionKey' => [ 'type' => 'string', 'enum' => [ 'EC2_INSTANCE_ARN', 'SCAN_ID', 'ACCOUNT_ID', 'GUARDDUTY_FINDING_ID', 'SCAN_START_TIME', 'SCAN_STATUS', 'SCAN_TYPE', ], ], 'DNSLogsConfigurationResult' => [ 'type' => 'structure', 'required' => [ 'Status', ], 'members' => [ 'Status' => [ 'shape' => 'DataSourceStatus', 'locationName' => 'status', ], ], ], 'DataSource' => [ 'type' => 'string', 'enum' => [ 'FLOW_LOGS', 'CLOUD_TRAIL', 'DNS_LOGS', 'S3_LOGS', 'KUBERNETES_AUDIT_LOGS', 'EC2_MALWARE_SCAN', ], ], 'DataSourceConfigurations' => [ 'type' => 'structure', 'members' => [ 'S3Logs' => [ 'shape' => 'S3LogsConfiguration', 'locationName' => 's3Logs', ], 'Kubernetes' => [ 'shape' => 'KubernetesConfiguration', 'locationName' => 'kubernetes', ], 'MalwareProtection' => [ 'shape' => 'MalwareProtectionConfiguration', 'locationName' => 'malwareProtection', ], ], ], 'DataSourceConfigurationsResult' => [ 'type' => 'structure', 'required' => [ 'CloudTrail', 'DNSLogs', 'FlowLogs', 'S3Logs', ], 'members' => [ 'CloudTrail' => [ 'shape' => 'CloudTrailConfigurationResult', 'locationName' => 'cloudTrail', ], 'DNSLogs' => [ 'shape' => 'DNSLogsConfigurationResult', 'locationName' => 'dnsLogs', ], 'FlowLogs' => [ 'shape' => 'FlowLogsConfigurationResult', 'locationName' => 'flowLogs', ], 'S3Logs' => [ 'shape' => 'S3LogsConfigurationResult', 'locationName' => 's3Logs', ], 'Kubernetes' => [ 'shape' => 'KubernetesConfigurationResult', 'locationName' => 'kubernetes', ], 'MalwareProtection' => [ 'shape' => 'MalwareProtectionConfigurationResult', 'locationName' => 'malwareProtection', ], ], ], 'DataSourceFreeTrial' => [ 'type' => 'structure', 'members' => [ 'FreeTrialDaysRemaining' => [ 'shape' => 'Integer', 'locationName' => 'freeTrialDaysRemaining', ], ], ], 'DataSourceList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DataSource', ], ], 'DataSourceStatus' => [ 'type' => 'string', 'enum' => [ 'ENABLED', 'DISABLED', ], 'max' => 300, 'min' => 1, ], 'DataSourcesFreeTrial' => [ 'type' => 'structure', 'members' => [ 'CloudTrail' => [ 'shape' => 'DataSourceFreeTrial', 'locationName' => 'cloudTrail', ], 'DnsLogs' => [ 'shape' => 'DataSourceFreeTrial', 'locationName' => 'dnsLogs', ], 'FlowLogs' => [ 'shape' => 'DataSourceFreeTrial', 'locationName' => 'flowLogs', ], 'S3Logs' => [ 'shape' => 'DataSourceFreeTrial', 'locationName' => 's3Logs', ], 'Kubernetes' => [ 'shape' => 'KubernetesDataSourceFreeTrial', 'locationName' => 'kubernetes', ], 'MalwareProtection' => [ 'shape' => 'MalwareProtectionDataSourceFreeTrial', 'locationName' => 'malwareProtection', ], ], ], 'DeclineInvitationsRequest' => [ 'type' => 'structure', 'required' => [ 'AccountIds', ], 'members' => [ 'AccountIds' => [ 'shape' => 'AccountIds', 'locationName' => 'accountIds', ], ], ], 'DeclineInvitationsResponse' => [ 'type' => 'structure', 'required' => [ 'UnprocessedAccounts', ], 'members' => [ 'UnprocessedAccounts' => [ 'shape' => 'UnprocessedAccounts', 'locationName' => 'unprocessedAccounts', ], ], ], 'DefaultServerSideEncryption' => [ 'type' => 'structure', 'members' => [ 'EncryptionType' => [ 'shape' => 'String', 'locationName' => 'encryptionType', ], 'KmsMasterKeyArn' => [ 'shape' => 'String', 'locationName' => 'kmsMasterKeyArn', ], ], ], 'DeleteDetectorRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], ], ], 'DeleteDetectorResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteFilterRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', 'FilterName', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], 'FilterName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'filterName', ], ], ], 'DeleteFilterResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteIPSetRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', 'IpSetId', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], 'IpSetId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'ipSetId', ], ], ], 'DeleteIPSetResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteInvitationsRequest' => [ 'type' => 'structure', 'required' => [ 'AccountIds', ], 'members' => [ 'AccountIds' => [ 'shape' => 'AccountIds', 'locationName' => 'accountIds', ], ], ], 'DeleteInvitationsResponse' => [ 'type' => 'structure', 'required' => [ 'UnprocessedAccounts', ], 'members' => [ 'UnprocessedAccounts' => [ 'shape' => 'UnprocessedAccounts', 'locationName' => 'unprocessedAccounts', ], ], ], 'DeleteMalwareProtectionPlanRequest' => [ 'type' => 'structure', 'required' => [ 'MalwareProtectionPlanId', ], 'members' => [ 'MalwareProtectionPlanId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'malwareProtectionPlanId', ], ], ], 'DeleteMembersRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', 'AccountIds', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], 'AccountIds' => [ 'shape' => 'AccountIds', 'locationName' => 'accountIds', ], ], ], 'DeleteMembersResponse' => [ 'type' => 'structure', 'required' => [ 'UnprocessedAccounts', ], 'members' => [ 'UnprocessedAccounts' => [ 'shape' => 'UnprocessedAccounts', 'locationName' => 'unprocessedAccounts', ], ], ], 'DeletePublishingDestinationRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', 'DestinationId', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], 'DestinationId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'destinationId', ], ], ], 'DeletePublishingDestinationResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteThreatIntelSetRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', 'ThreatIntelSetId', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], 'ThreatIntelSetId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'threatIntelSetId', ], ], ], 'DeleteThreatIntelSetResponse' => [ 'type' => 'structure', 'members' => [], ], 'DescribeMalwareScansRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], 'NextToken' => [ 'shape' => 'String', 'locationName' => 'nextToken', ], 'MaxResults' => [ 'shape' => 'IntegerValueWithMax', 'locationName' => 'maxResults', ], 'FilterCriteria' => [ 'shape' => 'FilterCriteria', 'locationName' => 'filterCriteria', ], 'SortCriteria' => [ 'shape' => 'SortCriteria', 'locationName' => 'sortCriteria', ], ], ], 'DescribeMalwareScansResponse' => [ 'type' => 'structure', 'required' => [ 'Scans', ], 'members' => [ 'Scans' => [ 'shape' => 'Scans', 'locationName' => 'scans', ], 'NextToken' => [ 'shape' => 'String', 'locationName' => 'nextToken', ], ], ], 'DescribeOrganizationConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'NextToken' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'DescribeOrganizationConfigurationResponse' => [ 'type' => 'structure', 'required' => [ 'MemberAccountLimitReached', ], 'members' => [ 'AutoEnable' => [ 'shape' => 'Boolean', 'deprecated' => true, 'deprecatedMessage' => 'This field is deprecated, use AutoEnableOrganizationMembers instead', 'locationName' => 'autoEnable', ], 'MemberAccountLimitReached' => [ 'shape' => 'Boolean', 'locationName' => 'memberAccountLimitReached', ], 'DataSources' => [ 'shape' => 'OrganizationDataSourceConfigurationsResult', 'deprecated' => true, 'deprecatedMessage' => 'This parameter is deprecated, use Features instead', 'locationName' => 'dataSources', ], 'Features' => [ 'shape' => 'OrganizationFeaturesConfigurationsResults', 'locationName' => 'features', ], 'NextToken' => [ 'shape' => 'String', 'locationName' => 'nextToken', ], 'AutoEnableOrganizationMembers' => [ 'shape' => 'AutoEnableMembers', 'locationName' => 'autoEnableOrganizationMembers', ], ], ], 'DescribePublishingDestinationRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', 'DestinationId', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], 'DestinationId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'destinationId', ], ], ], 'DescribePublishingDestinationResponse' => [ 'type' => 'structure', 'required' => [ 'DestinationId', 'DestinationType', 'Status', 'PublishingFailureStartTimestamp', 'DestinationProperties', ], 'members' => [ 'DestinationId' => [ 'shape' => 'String', 'locationName' => 'destinationId', ], 'DestinationType' => [ 'shape' => 'DestinationType', 'locationName' => 'destinationType', ], 'Status' => [ 'shape' => 'PublishingStatus', 'locationName' => 'status', ], 'PublishingFailureStartTimestamp' => [ 'shape' => 'Long', 'locationName' => 'publishingFailureStartTimestamp', ], 'DestinationProperties' => [ 'shape' => 'DestinationProperties', 'locationName' => 'destinationProperties', ], ], ], 'Destination' => [ 'type' => 'structure', 'required' => [ 'DestinationId', 'DestinationType', 'Status', ], 'members' => [ 'DestinationId' => [ 'shape' => 'String', 'locationName' => 'destinationId', ], 'DestinationType' => [ 'shape' => 'DestinationType', 'locationName' => 'destinationType', ], 'Status' => [ 'shape' => 'PublishingStatus', 'locationName' => 'status', ], ], ], 'DestinationProperties' => [ 'type' => 'structure', 'members' => [ 'DestinationArn' => [ 'shape' => 'String', 'locationName' => 'destinationArn', ], 'KmsKeyArn' => [ 'shape' => 'String', 'locationName' => 'kmsKeyArn', ], ], ], 'DestinationType' => [ 'type' => 'string', 'enum' => [ 'S3', ], 'max' => 300, 'min' => 1, ], 'Destinations' => [ 'type' => 'list', 'member' => [ 'shape' => 'Destination', ], ], 'Detection' => [ 'type' => 'structure', 'members' => [ 'Anomaly' => [ 'shape' => 'Anomaly', 'locationName' => 'anomaly', ], ], ], 'DetectorAdditionalConfiguration' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'FeatureAdditionalConfiguration', 'locationName' => 'name', ], 'Status' => [ 'shape' => 'FeatureStatus', 'locationName' => 'status', ], ], ], 'DetectorAdditionalConfigurationResult' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'FeatureAdditionalConfiguration', 'locationName' => 'name', ], 'Status' => [ 'shape' => 'FeatureStatus', 'locationName' => 'status', ], 'UpdatedAt' => [ 'shape' => 'Timestamp', 'locationName' => 'updatedAt', ], ], ], 'DetectorAdditionalConfigurationResults' => [ 'type' => 'list', 'member' => [ 'shape' => 'DetectorAdditionalConfigurationResult', ], ], 'DetectorAdditionalConfigurations' => [ 'type' => 'list', 'member' => [ 'shape' => 'DetectorAdditionalConfiguration', ], ], 'DetectorFeature' => [ 'type' => 'string', 'enum' => [ 'S3_DATA_EVENTS', 'EKS_AUDIT_LOGS', 'EBS_MALWARE_PROTECTION', 'RDS_LOGIN_EVENTS', 'EKS_RUNTIME_MONITORING', 'LAMBDA_NETWORK_LOGS', 'RUNTIME_MONITORING', ], ], 'DetectorFeatureConfiguration' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'DetectorFeature', 'locationName' => 'name', ], 'Status' => [ 'shape' => 'FeatureStatus', 'locationName' => 'status', ], 'AdditionalConfiguration' => [ 'shape' => 'DetectorAdditionalConfigurations', 'locationName' => 'additionalConfiguration', ], ], ], 'DetectorFeatureConfigurationResult' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'DetectorFeatureResult', 'locationName' => 'name', ], 'Status' => [ 'shape' => 'FeatureStatus', 'locationName' => 'status', ], 'UpdatedAt' => [ 'shape' => 'Timestamp', 'locationName' => 'updatedAt', ], 'AdditionalConfiguration' => [ 'shape' => 'DetectorAdditionalConfigurationResults', 'locationName' => 'additionalConfiguration', ], ], ], 'DetectorFeatureConfigurations' => [ 'type' => 'list', 'member' => [ 'shape' => 'DetectorFeatureConfiguration', ], ], 'DetectorFeatureConfigurationsResults' => [ 'type' => 'list', 'member' => [ 'shape' => 'DetectorFeatureConfigurationResult', ], ], 'DetectorFeatureResult' => [ 'type' => 'string', 'enum' => [ 'FLOW_LOGS', 'CLOUD_TRAIL', 'DNS_LOGS', 'S3_DATA_EVENTS', 'EKS_AUDIT_LOGS', 'EBS_MALWARE_PROTECTION', 'RDS_LOGIN_EVENTS', 'EKS_RUNTIME_MONITORING', 'LAMBDA_NETWORK_LOGS', 'RUNTIME_MONITORING', ], ], 'DetectorId' => [ 'type' => 'string', 'max' => 300, 'min' => 1, ], 'DetectorIds' => [ 'type' => 'list', 'member' => [ 'shape' => 'DetectorId', ], 'max' => 50, 'min' => 0, ], 'DetectorStatus' => [ 'type' => 'string', 'enum' => [ 'ENABLED', 'DISABLED', ], 'max' => 300, 'min' => 1, ], 'DisableOrganizationAdminAccountRequest' => [ 'type' => 'structure', 'required' => [ 'AdminAccountId', ], 'members' => [ 'AdminAccountId' => [ 'shape' => 'String', 'locationName' => 'adminAccountId', ], ], ], 'DisableOrganizationAdminAccountResponse' => [ 'type' => 'structure', 'members' => [], ], 'DisassociateFromAdministratorAccountRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], ], ], 'DisassociateFromAdministratorAccountResponse' => [ 'type' => 'structure', 'members' => [], ], 'DisassociateFromMasterAccountRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], ], 'deprecated' => true, 'deprecatedMessage' => 'This input is deprecated, use DisassociateFromAdministratorAccountRequest instead', ], 'DisassociateFromMasterAccountResponse' => [ 'type' => 'structure', 'members' => [], 'deprecated' => true, 'deprecatedMessage' => 'This output is deprecated, use DisassociateFromAdministratorAccountResponse instead', ], 'DisassociateMembersRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', 'AccountIds', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], 'AccountIds' => [ 'shape' => 'AccountIds', 'locationName' => 'accountIds', ], ], ], 'DisassociateMembersResponse' => [ 'type' => 'structure', 'required' => [ 'UnprocessedAccounts', ], 'members' => [ 'UnprocessedAccounts' => [ 'shape' => 'UnprocessedAccounts', 'locationName' => 'unprocessedAccounts', ], ], ], 'DnsRequestAction' => [ 'type' => 'structure', 'members' => [ 'Domain' => [ 'shape' => 'String', 'locationName' => 'domain', ], 'Protocol' => [ 'shape' => 'String', 'locationName' => 'protocol', ], 'Blocked' => [ 'shape' => 'Boolean', 'locationName' => 'blocked', ], 'DomainWithSuffix' => [ 'shape' => 'String', 'locationName' => 'domainWithSuffix', ], ], ], 'DomainDetails' => [ 'type' => 'structure', 'members' => [ 'Domain' => [ 'shape' => 'String', 'locationName' => 'domain', ], ], ], 'Double' => [ 'type' => 'double', ], 'EbsSnapshotPreservation' => [ 'type' => 'string', 'enum' => [ 'NO_RETENTION', 'RETENTION_WITH_FINDING', ], ], 'EbsVolumeDetails' => [ 'type' => 'structure', 'members' => [ 'ScannedVolumeDetails' => [ 'shape' => 'VolumeDetails', 'locationName' => 'scannedVolumeDetails', ], 'SkippedVolumeDetails' => [ 'shape' => 'VolumeDetails', 'locationName' => 'skippedVolumeDetails', ], ], ], 'EbsVolumeScanDetails' => [ 'type' => 'structure', 'members' => [ 'ScanId' => [ 'shape' => 'String', 'locationName' => 'scanId', ], 'ScanStartedAt' => [ 'shape' => 'Timestamp', 'locationName' => 'scanStartedAt', ], 'ScanCompletedAt' => [ 'shape' => 'Timestamp', 'locationName' => 'scanCompletedAt', ], 'TriggerFindingId' => [ 'shape' => 'String', 'locationName' => 'triggerFindingId', ], 'Sources' => [ 'shape' => 'Sources', 'locationName' => 'sources', ], 'ScanDetections' => [ 'shape' => 'ScanDetections', 'locationName' => 'scanDetections', ], 'ScanType' => [ 'shape' => 'ScanType', 'locationName' => 'scanType', ], ], ], 'EbsVolumesResult' => [ 'type' => 'structure', 'members' => [ 'Status' => [ 'shape' => 'DataSourceStatus', 'locationName' => 'status', ], 'Reason' => [ 'shape' => 'String', 'locationName' => 'reason', ], ], ], 'EcsClusterDetails' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'String', 'locationName' => 'name', ], 'Arn' => [ 'shape' => 'String', 'locationName' => 'arn', ], 'Status' => [ 'shape' => 'String', 'locationName' => 'status', ], 'ActiveServicesCount' => [ 'shape' => 'Integer', 'locationName' => 'activeServicesCount', ], 'RegisteredContainerInstancesCount' => [ 'shape' => 'Integer', 'locationName' => 'registeredContainerInstancesCount', ], 'RunningTasksCount' => [ 'shape' => 'Integer', 'locationName' => 'runningTasksCount', ], 'Tags' => [ 'shape' => 'Tags', 'locationName' => 'tags', ], 'TaskDetails' => [ 'shape' => 'EcsTaskDetails', 'locationName' => 'taskDetails', ], ], ], 'EcsTaskDetails' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'String', 'locationName' => 'arn', ], 'DefinitionArn' => [ 'shape' => 'String', 'locationName' => 'definitionArn', ], 'Version' => [ 'shape' => 'String', 'locationName' => 'version', ], 'TaskCreatedAt' => [ 'shape' => 'Timestamp', 'locationName' => 'createdAt', ], 'StartedAt' => [ 'shape' => 'Timestamp', 'locationName' => 'startedAt', ], 'StartedBy' => [ 'shape' => 'String', 'locationName' => 'startedBy', ], 'Tags' => [ 'shape' => 'Tags', 'locationName' => 'tags', ], 'Volumes' => [ 'shape' => 'Volumes', 'locationName' => 'volumes', ], 'Containers' => [ 'shape' => 'Containers', 'locationName' => 'containers', ], 'Group' => [ 'shape' => 'String', 'locationName' => 'group', ], ], ], 'EksClusterDetails' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'String', 'locationName' => 'name', ], 'Arn' => [ 'shape' => 'String', 'locationName' => 'arn', ], 'VpcId' => [ 'shape' => 'String', 'locationName' => 'vpcId', ], 'Status' => [ 'shape' => 'String', 'locationName' => 'status', ], 'Tags' => [ 'shape' => 'Tags', 'locationName' => 'tags', ], 'CreatedAt' => [ 'shape' => 'Timestamp', 'locationName' => 'createdAt', ], ], ], 'Email' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'sensitive' => true, ], 'EnableOrganizationAdminAccountRequest' => [ 'type' => 'structure', 'required' => [ 'AdminAccountId', ], 'members' => [ 'AdminAccountId' => [ 'shape' => 'String', 'locationName' => 'adminAccountId', ], ], ], 'EnableOrganizationAdminAccountResponse' => [ 'type' => 'structure', 'members' => [], ], 'Eq' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], ], 'Equals' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], ], 'Evidence' => [ 'type' => 'structure', 'members' => [ 'ThreatIntelligenceDetails' => [ 'shape' => 'ThreatIntelligenceDetails', 'locationName' => 'threatIntelligenceDetails', ], ], ], 'FargateDetails' => [ 'type' => 'structure', 'members' => [ 'Issues' => [ 'shape' => 'Issues', 'locationName' => 'issues', ], 'ManagementType' => [ 'shape' => 'ManagementType', 'locationName' => 'managementType', ], ], ], 'FeatureAdditionalConfiguration' => [ 'type' => 'string', 'enum' => [ 'EKS_ADDON_MANAGEMENT', 'ECS_FARGATE_AGENT_MANAGEMENT', 'EC2_AGENT_MANAGEMENT', ], ], 'FeatureStatus' => [ 'type' => 'string', 'enum' => [ 'ENABLED', 'DISABLED', ], ], 'Feedback' => [ 'type' => 'string', 'enum' => [ 'USEFUL', 'NOT_USEFUL', ], ], 'FilePaths' => [ 'type' => 'list', 'member' => [ 'shape' => 'ScanFilePath', ], ], 'FilterAction' => [ 'type' => 'string', 'enum' => [ 'NOOP', 'ARCHIVE', ], 'max' => 300, 'min' => 1, ], 'FilterCondition' => [ 'type' => 'structure', 'members' => [ 'EqualsValue' => [ 'shape' => 'NonEmptyString', 'locationName' => 'equalsValue', ], 'GreaterThan' => [ 'shape' => 'LongValue', 'locationName' => 'greaterThan', ], 'LessThan' => [ 'shape' => 'LongValue', 'locationName' => 'lessThan', ], ], ], 'FilterCriteria' => [ 'type' => 'structure', 'members' => [ 'FilterCriterion' => [ 'shape' => 'FilterCriterionList', 'locationName' => 'filterCriterion', ], ], ], 'FilterCriterion' => [ 'type' => 'structure', 'members' => [ 'CriterionKey' => [ 'shape' => 'CriterionKey', 'locationName' => 'criterionKey', ], 'FilterCondition' => [ 'shape' => 'FilterCondition', 'locationName' => 'filterCondition', ], ], ], 'FilterCriterionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FilterCriterion', ], 'max' => 1, 'min' => 0, ], 'FilterDescription' => [ 'type' => 'string', 'max' => 512, 'min' => 0, ], 'FilterName' => [ 'type' => 'string', 'max' => 64, 'min' => 3, ], 'FilterNames' => [ 'type' => 'list', 'member' => [ 'shape' => 'FilterName', ], 'max' => 50, 'min' => 0, ], 'FilterRank' => [ 'type' => 'integer', 'max' => 100, 'min' => 1, ], 'Finding' => [ 'type' => 'structure', 'required' => [ 'AccountId', 'Arn', 'CreatedAt', 'Id', 'Region', 'Resource', 'SchemaVersion', 'Severity', 'Type', 'UpdatedAt', ], 'members' => [ 'AccountId' => [ 'shape' => 'String', 'locationName' => 'accountId', ], 'Arn' => [ 'shape' => 'String', 'locationName' => 'arn', ], 'Confidence' => [ 'shape' => 'Double', 'locationName' => 'confidence', ], 'CreatedAt' => [ 'shape' => 'String', 'locationName' => 'createdAt', ], 'Description' => [ 'shape' => 'String', 'locationName' => 'description', ], 'Id' => [ 'shape' => 'String', 'locationName' => 'id', ], 'Partition' => [ 'shape' => 'String', 'locationName' => 'partition', ], 'Region' => [ 'shape' => 'String', 'locationName' => 'region', ], 'Resource' => [ 'shape' => 'Resource', 'locationName' => 'resource', ], 'SchemaVersion' => [ 'shape' => 'String', 'locationName' => 'schemaVersion', ], 'Service' => [ 'shape' => 'Service', 'locationName' => 'service', ], 'Severity' => [ 'shape' => 'Double', 'locationName' => 'severity', ], 'Title' => [ 'shape' => 'String', 'locationName' => 'title', ], 'Type' => [ 'shape' => 'FindingType', 'locationName' => 'type', ], 'UpdatedAt' => [ 'shape' => 'String', 'locationName' => 'updatedAt', ], ], ], 'FindingCriteria' => [ 'type' => 'structure', 'members' => [ 'Criterion' => [ 'shape' => 'Criterion', 'locationName' => 'criterion', ], ], ], 'FindingId' => [ 'type' => 'string', 'max' => 300, 'min' => 1, ], 'FindingIds' => [ 'type' => 'list', 'member' => [ 'shape' => 'FindingId', ], 'max' => 50, 'min' => 0, ], 'FindingPublishingFrequency' => [ 'type' => 'string', 'enum' => [ 'FIFTEEN_MINUTES', 'ONE_HOUR', 'SIX_HOURS', ], ], 'FindingStatisticType' => [ 'type' => 'string', 'enum' => [ 'COUNT_BY_SEVERITY', ], ], 'FindingStatisticTypes' => [ 'type' => 'list', 'member' => [ 'shape' => 'FindingStatisticType', ], 'max' => 10, 'min' => 0, ], 'FindingStatistics' => [ 'type' => 'structure', 'members' => [ 'CountBySeverity' => [ 'shape' => 'CountBySeverity', 'locationName' => 'countBySeverity', ], ], ], 'FindingType' => [ 'type' => 'string', 'max' => 50, 'min' => 1, ], 'FindingTypes' => [ 'type' => 'list', 'member' => [ 'shape' => 'FindingType', ], 'max' => 50, 'min' => 0, ], 'Findings' => [ 'type' => 'list', 'member' => [ 'shape' => 'Finding', ], 'max' => 50, 'min' => 0, ], 'FlagsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], ], 'FlowLogsConfigurationResult' => [ 'type' => 'structure', 'required' => [ 'Status', ], 'members' => [ 'Status' => [ 'shape' => 'DataSourceStatus', 'locationName' => 'status', ], ], ], 'FreeTrialFeatureConfigurationResult' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'FreeTrialFeatureResult', 'locationName' => 'name', ], 'FreeTrialDaysRemaining' => [ 'shape' => 'Integer', 'locationName' => 'freeTrialDaysRemaining', ], ], ], 'FreeTrialFeatureConfigurationsResults' => [ 'type' => 'list', 'member' => [ 'shape' => 'FreeTrialFeatureConfigurationResult', ], ], 'FreeTrialFeatureResult' => [ 'type' => 'string', 'enum' => [ 'FLOW_LOGS', 'CLOUD_TRAIL', 'DNS_LOGS', 'S3_DATA_EVENTS', 'EKS_AUDIT_LOGS', 'EBS_MALWARE_PROTECTION', 'RDS_LOGIN_EVENTS', 'EKS_RUNTIME_MONITORING', 'LAMBDA_NETWORK_LOGS', 'FARGATE_RUNTIME_MONITORING', 'EC2_RUNTIME_MONITORING', ], ], 'GeoLocation' => [ 'type' => 'structure', 'members' => [ 'Lat' => [ 'shape' => 'Double', 'locationName' => 'lat', ], 'Lon' => [ 'shape' => 'Double', 'locationName' => 'lon', ], ], ], 'GetAdministratorAccountRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], ], ], 'GetAdministratorAccountResponse' => [ 'type' => 'structure', 'required' => [ 'Administrator', ], 'members' => [ 'Administrator' => [ 'shape' => 'Administrator', 'locationName' => 'administrator', ], ], ], 'GetCoverageStatisticsRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', 'StatisticsType', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], 'FilterCriteria' => [ 'shape' => 'CoverageFilterCriteria', 'locationName' => 'filterCriteria', ], 'StatisticsType' => [ 'shape' => 'CoverageStatisticsTypeList', 'locationName' => 'statisticsType', ], ], ], 'GetCoverageStatisticsResponse' => [ 'type' => 'structure', 'members' => [ 'CoverageStatistics' => [ 'shape' => 'CoverageStatistics', 'locationName' => 'coverageStatistics', ], ], ], 'GetDetectorRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], ], ], 'GetDetectorResponse' => [ 'type' => 'structure', 'required' => [ 'ServiceRole', 'Status', ], 'members' => [ 'CreatedAt' => [ 'shape' => 'String', 'locationName' => 'createdAt', ], 'FindingPublishingFrequency' => [ 'shape' => 'FindingPublishingFrequency', 'locationName' => 'findingPublishingFrequency', ], 'ServiceRole' => [ 'shape' => 'String', 'locationName' => 'serviceRole', ], 'Status' => [ 'shape' => 'DetectorStatus', 'locationName' => 'status', ], 'UpdatedAt' => [ 'shape' => 'String', 'locationName' => 'updatedAt', ], 'DataSources' => [ 'shape' => 'DataSourceConfigurationsResult', 'deprecated' => true, 'deprecatedMessage' => 'This parameter is deprecated, use Features instead', 'locationName' => 'dataSources', ], 'Tags' => [ 'shape' => 'TagMap', 'locationName' => 'tags', ], 'Features' => [ 'shape' => 'DetectorFeatureConfigurationsResults', 'locationName' => 'features', ], ], ], 'GetFilterRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', 'FilterName', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], 'FilterName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'filterName', ], ], ], 'GetFilterResponse' => [ 'type' => 'structure', 'required' => [ 'Name', 'Action', 'FindingCriteria', ], 'members' => [ 'Name' => [ 'shape' => 'FilterName', 'locationName' => 'name', ], 'Description' => [ 'shape' => 'FilterDescription', 'locationName' => 'description', ], 'Action' => [ 'shape' => 'FilterAction', 'locationName' => 'action', ], 'Rank' => [ 'shape' => 'FilterRank', 'locationName' => 'rank', ], 'FindingCriteria' => [ 'shape' => 'FindingCriteria', 'locationName' => 'findingCriteria', ], 'Tags' => [ 'shape' => 'TagMap', 'locationName' => 'tags', ], ], ], 'GetFindingsRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', 'FindingIds', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], 'FindingIds' => [ 'shape' => 'FindingIds', 'locationName' => 'findingIds', ], 'SortCriteria' => [ 'shape' => 'SortCriteria', 'locationName' => 'sortCriteria', ], ], ], 'GetFindingsResponse' => [ 'type' => 'structure', 'required' => [ 'Findings', ], 'members' => [ 'Findings' => [ 'shape' => 'Findings', 'locationName' => 'findings', ], ], ], 'GetFindingsStatisticsRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', 'FindingStatisticTypes', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], 'FindingStatisticTypes' => [ 'shape' => 'FindingStatisticTypes', 'locationName' => 'findingStatisticTypes', ], 'FindingCriteria' => [ 'shape' => 'FindingCriteria', 'locationName' => 'findingCriteria', ], ], ], 'GetFindingsStatisticsResponse' => [ 'type' => 'structure', 'required' => [ 'FindingStatistics', ], 'members' => [ 'FindingStatistics' => [ 'shape' => 'FindingStatistics', 'locationName' => 'findingStatistics', ], ], ], 'GetIPSetRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', 'IpSetId', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], 'IpSetId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'ipSetId', ], ], ], 'GetIPSetResponse' => [ 'type' => 'structure', 'required' => [ 'Name', 'Format', 'Location', 'Status', ], 'members' => [ 'Name' => [ 'shape' => 'Name', 'locationName' => 'name', ], 'Format' => [ 'shape' => 'IpSetFormat', 'locationName' => 'format', ], 'Location' => [ 'shape' => 'Location', 'locationName' => 'location', ], 'Status' => [ 'shape' => 'IpSetStatus', 'locationName' => 'status', ], 'Tags' => [ 'shape' => 'TagMap', 'locationName' => 'tags', ], ], ], 'GetInvitationsCountRequest' => [ 'type' => 'structure', 'members' => [], ], 'GetInvitationsCountResponse' => [ 'type' => 'structure', 'members' => [ 'InvitationsCount' => [ 'shape' => 'Integer', 'locationName' => 'invitationsCount', ], ], ], 'GetMalwareProtectionPlanRequest' => [ 'type' => 'structure', 'required' => [ 'MalwareProtectionPlanId', ], 'members' => [ 'MalwareProtectionPlanId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'malwareProtectionPlanId', ], ], ], 'GetMalwareProtectionPlanResponse' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'String', 'locationName' => 'arn', ], 'Role' => [ 'shape' => 'String', 'locationName' => 'role', ], 'ProtectedResource' => [ 'shape' => 'CreateProtectedResource', 'locationName' => 'protectedResource', ], 'Actions' => [ 'shape' => 'MalwareProtectionPlanActions', 'locationName' => 'actions', ], 'CreatedAt' => [ 'shape' => 'Timestamp', 'locationName' => 'createdAt', ], 'Status' => [ 'shape' => 'MalwareProtectionPlanStatus', 'locationName' => 'status', ], 'StatusReasons' => [ 'shape' => 'MalwareProtectionPlanStatusReasonsList', 'locationName' => 'statusReasons', ], 'Tags' => [ 'shape' => 'TagMap', 'locationName' => 'tags', ], ], ], 'GetMalwareScanSettingsRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], ], ], 'GetMalwareScanSettingsResponse' => [ 'type' => 'structure', 'members' => [ 'ScanResourceCriteria' => [ 'shape' => 'ScanResourceCriteria', 'locationName' => 'scanResourceCriteria', ], 'EbsSnapshotPreservation' => [ 'shape' => 'EbsSnapshotPreservation', 'locationName' => 'ebsSnapshotPreservation', ], ], ], 'GetMasterAccountRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], ], 'deprecated' => true, 'deprecatedMessage' => 'This input is deprecated, use GetAdministratorAccountRequest instead', ], 'GetMasterAccountResponse' => [ 'type' => 'structure', 'required' => [ 'Master', ], 'members' => [ 'Master' => [ 'shape' => 'Master', 'locationName' => 'master', ], ], 'deprecated' => true, 'deprecatedMessage' => 'This output is deprecated, use GetAdministratorAccountResponse instead', ], 'GetMemberDetectorsRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', 'AccountIds', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], 'AccountIds' => [ 'shape' => 'AccountIds', 'locationName' => 'accountIds', ], ], ], 'GetMemberDetectorsResponse' => [ 'type' => 'structure', 'required' => [ 'MemberDataSourceConfigurations', 'UnprocessedAccounts', ], 'members' => [ 'MemberDataSourceConfigurations' => [ 'shape' => 'MemberDataSourceConfigurations', 'locationName' => 'members', ], 'UnprocessedAccounts' => [ 'shape' => 'UnprocessedAccounts', 'locationName' => 'unprocessedAccounts', ], ], ], 'GetMembersRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', 'AccountIds', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], 'AccountIds' => [ 'shape' => 'AccountIds', 'locationName' => 'accountIds', ], ], ], 'GetMembersResponse' => [ 'type' => 'structure', 'required' => [ 'Members', 'UnprocessedAccounts', ], 'members' => [ 'Members' => [ 'shape' => 'Members', 'locationName' => 'members', ], 'UnprocessedAccounts' => [ 'shape' => 'UnprocessedAccounts', 'locationName' => 'unprocessedAccounts', ], ], ], 'GetOrganizationStatisticsResponse' => [ 'type' => 'structure', 'members' => [ 'OrganizationDetails' => [ 'shape' => 'OrganizationDetails', 'locationName' => 'organizationDetails', ], ], ], 'GetRemainingFreeTrialDaysRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], 'AccountIds' => [ 'shape' => 'AccountIds', 'locationName' => 'accountIds', ], ], ], 'GetRemainingFreeTrialDaysResponse' => [ 'type' => 'structure', 'members' => [ 'Accounts' => [ 'shape' => 'AccountFreeTrialInfos', 'locationName' => 'accounts', ], 'UnprocessedAccounts' => [ 'shape' => 'UnprocessedAccounts', 'locationName' => 'unprocessedAccounts', ], ], ], 'GetThreatIntelSetRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', 'ThreatIntelSetId', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], 'ThreatIntelSetId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'threatIntelSetId', ], ], ], 'GetThreatIntelSetResponse' => [ 'type' => 'structure', 'required' => [ 'Name', 'Format', 'Location', 'Status', ], 'members' => [ 'Name' => [ 'shape' => 'Name', 'locationName' => 'name', ], 'Format' => [ 'shape' => 'ThreatIntelSetFormat', 'locationName' => 'format', ], 'Location' => [ 'shape' => 'Location', 'locationName' => 'location', ], 'Status' => [ 'shape' => 'ThreatIntelSetStatus', 'locationName' => 'status', ], 'Tags' => [ 'shape' => 'TagMap', 'locationName' => 'tags', ], ], ], 'GetUsageStatisticsRequest' => [ 'type' => 'structure', 'required' => [ 'DetectorId', 'UsageStatisticType', 'UsageCriteria', ], 'members' => [ 'DetectorId' => [ 'shape' => 'DetectorId', 'location' => 'uri', 'locationName' => 'detectorId', ], 'UsageStatisticType' => [ 'shape' => 'UsageStatisticType', 'locationName' => 'usageStatisticsType', ], 'UsageCriteria' => [ 'shape' => 'UsageCriteria', 'locationName' => 'usageCriteria', ], 'Unit' => [ 'shape' => 'String', 'locationName' => 'unit', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'locationName' => 'maxResults', ], 'NextToken' => [ 'shape' => 'String', 'locationName' => 'nextToken', ], ], ], 'GetUsageStatisticsResponse' => [ 'type' => 'structure', 'members' => [ 'UsageStatistics' => [ 'shape' => 'U