<?php
// This file was auto-generated from sdk-root/src/data/kafka/2018-11-14/api-2.json
return [ 'metadata' => [ 'apiVersion' => '2018-11-14', 'endpointPrefix' => 'kafka', 'signingName' => 'kafka', 'serviceFullName' => 'Managed Streaming for Kafka', 'serviceAbbreviation' => 'Kafka', 'serviceId' => 'Kafka', 'protocol' => 'rest-json', 'jsonVersion' => '1.1', 'uid' => 'kafka-2018-11-14', 'signatureVersion' => 'v4', ], 'operations' => [ 'BatchAssociateScramSecret' => [ 'name' => 'BatchAssociateScramSecret', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/clusters/{clusterArn}/scram-secrets', 'responseCode' => 200, ], 'input' => [ 'shape' => 'BatchAssociateScramSecretRequest', ], 'output' => [ 'shape' => 'BatchAssociateScramSecretResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'CreateCluster' => [ 'name' => 'CreateCluster', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/clusters', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateClusterRequest', ], 'output' => [ 'shape' => 'CreateClusterResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], ], ], 'CreateClusterV2' => [ 'name' => 'CreateClusterV2', 'http' => [ 'method' => 'POST', 'requestUri' => '/api/v2/clusters', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateClusterV2Request', ], 'output' => [ 'shape' => 'CreateClusterV2Response', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], ], ], 'CreateConfiguration' => [ 'name' => 'CreateConfiguration', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/configurations', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateConfigurationRequest', ], 'output' => [ 'shape' => 'CreateConfigurationResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], ], ], 'CreateReplicator' => [ 'name' => 'CreateReplicator', 'http' => [ 'method' => 'POST', 'requestUri' => '/replication/v1/replicators', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateReplicatorRequest', ], 'output' => [ 'shape' => 'CreateReplicatorResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], ], ], 'CreateVpcConnection' => [ 'name' => 'CreateVpcConnection', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/vpc-connection', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateVpcConnectionRequest', ], 'output' => [ 'shape' => 'CreateVpcConnectionResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], ], ], 'DeleteCluster' => [ 'name' => 'DeleteCluster', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v1/clusters/{clusterArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteClusterRequest', ], 'output' => [ 'shape' => 'DeleteClusterResponse', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], ], ], 'DeleteConfiguration' => [ 'name' => 'DeleteConfiguration', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v1/configurations/{arn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteConfigurationRequest', ], 'output' => [ 'shape' => 'DeleteConfigurationResponse', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], ], ], 'DeleteReplicator' => [ 'name' => 'DeleteReplicator', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/replication/v1/replicators/{replicatorArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteReplicatorRequest', ], 'output' => [ 'shape' => 'DeleteReplicatorResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'DeleteVpcConnection' => [ 'name' => 'DeleteVpcConnection', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v1/vpc-connection/{arn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteVpcConnectionRequest', ], 'output' => [ 'shape' => 'DeleteVpcConnectionResponse', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], ], ], 'DescribeCluster' => [ 'name' => 'DescribeCluster', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/clusters/{clusterArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeClusterRequest', ], 'output' => [ 'shape' => 'DescribeClusterResponse', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], ], ], 'DescribeClusterV2' => [ 'name' => 'DescribeClusterV2', 'http' => [ 'method' => 'GET', 'requestUri' => '/api/v2/clusters/{clusterArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeClusterV2Request', ], 'output' => [ 'shape' => 'DescribeClusterV2Response', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], ], ], 'DescribeClusterOperation' => [ 'name' => 'DescribeClusterOperation', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/operations/{clusterOperationArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeClusterOperationRequest', ], 'output' => [ 'shape' => 'DescribeClusterOperationResponse', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], ], ], 'DescribeClusterOperationV2' => [ 'name' => 'DescribeClusterOperationV2', 'http' => [ 'method' => 'GET', 'requestUri' => '/api/v2/operations/{clusterOperationArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeClusterOperationV2Request', ], 'output' => [ 'shape' => 'DescribeClusterOperationV2Response', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'DescribeConfiguration' => [ 'name' => 'DescribeConfiguration', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/configurations/{arn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeConfigurationRequest', ], 'output' => [ 'shape' => 'DescribeConfigurationResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'DescribeConfigurationRevision' => [ 'name' => 'DescribeConfigurationRevision', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/configurations/{arn}/revisions/{revision}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeConfigurationRevisionRequest', ], 'output' => [ 'shape' => 'DescribeConfigurationRevisionResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'DescribeReplicator' => [ 'name' => 'DescribeReplicator', 'http' => [ 'method' => 'GET', 'requestUri' => '/replication/v1/replicators/{replicatorArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeReplicatorRequest', ], 'output' => [ 'shape' => 'DescribeReplicatorResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'DescribeVpcConnection' => [ 'name' => 'DescribeVpcConnection', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/vpc-connection/{arn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeVpcConnectionRequest', ], 'output' => [ 'shape' => 'DescribeVpcConnectionResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'BatchDisassociateScramSecret' => [ 'name' => 'BatchDisassociateScramSecret', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/v1/clusters/{clusterArn}/scram-secrets', 'responseCode' => 200, ], 'input' => [ 'shape' => 'BatchDisassociateScramSecretRequest', ], 'output' => [ 'shape' => 'BatchDisassociateScramSecretResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'GetBootstrapBrokers' => [ 'name' => 'GetBootstrapBrokers', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/clusters/{clusterArn}/bootstrap-brokers', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetBootstrapBrokersRequest', ], 'output' => [ 'shape' => 'GetBootstrapBrokersResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ForbiddenException', ], ], ], 'GetCompatibleKafkaVersions' => [ 'name' => 'GetCompatibleKafkaVersions', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/compatible-kafka-versions', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetCompatibleKafkaVersionsRequest', ], 'output' => [ 'shape' => 'GetCompatibleKafkaVersionsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'ListClusterOperations' => [ 'name' => 'ListClusterOperations', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/clusters/{clusterArn}/operations', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListClusterOperationsRequest', ], 'output' => [ 'shape' => 'ListClusterOperationsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ForbiddenException', ], ], ], 'ListClusterOperationsV2' => [ 'name' => 'ListClusterOperationsV2', 'http' => [ 'method' => 'GET', 'requestUri' => '/api/v2/clusters/{clusterArn}/operations', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListClusterOperationsV2Request', ], 'output' => [ 'shape' => 'ListClusterOperationsV2Response', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'ListClusters' => [ 'name' => 'ListClusters', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/clusters', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListClustersRequest', ], 'output' => [ 'shape' => 'ListClustersResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ForbiddenException', ], ], ], 'ListClustersV2' => [ 'name' => 'ListClustersV2', 'http' => [ 'method' => 'GET', 'requestUri' => '/api/v2/clusters', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListClustersV2Request', ], 'output' => [ 'shape' => 'ListClustersV2Response', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ForbiddenException', ], ], ], 'ListConfigurationRevisions' => [ 'name' => 'ListConfigurationRevisions', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/configurations/{arn}/revisions', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListConfigurationRevisionsRequest', ], 'output' => [ 'shape' => 'ListConfigurationRevisionsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'ListConfigurations' => [ 'name' => 'ListConfigurations', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/configurations', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListConfigurationsRequest', ], 'output' => [ 'shape' => 'ListConfigurationsResponse', ], 'errors' => [ [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], ], ], 'ListKafkaVersions' => [ 'name' => 'ListKafkaVersions', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/kafka-versions', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListKafkaVersionsRequest', ], 'output' => [ 'shape' => 'ListKafkaVersionsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], ], ], 'ListNodes' => [ 'name' => 'ListNodes', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/clusters/{clusterArn}/nodes', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListNodesRequest', ], 'output' => [ 'shape' => 'ListNodesResponse', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], ], ], 'ListReplicators' => [ 'name' => 'ListReplicators', 'http' => [ 'method' => 'GET', 'requestUri' => '/replication/v1/replicators', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListReplicatorsRequest', ], 'output' => [ 'shape' => 'ListReplicatorsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'ListScramSecrets' => [ 'name' => 'ListScramSecrets', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/clusters/{clusterArn}/scram-secrets', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListScramSecretsRequest', ], 'output' => [ 'shape' => 'ListScramSecretsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'ListClientVpcConnections' => [ 'name' => 'ListClientVpcConnections', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/clusters/{clusterArn}/client-vpc-connections', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListClientVpcConnectionsRequest', ], 'output' => [ 'shape' => 'ListClientVpcConnectionsResponse', ], 'errors' => [ [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], ], ], 'ListVpcConnections' => [ 'name' => 'ListVpcConnections', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/vpc-connections', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListVpcConnectionsRequest', ], 'output' => [ 'shape' => 'ListVpcConnectionsResponse', ], 'errors' => [ [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], ], ], 'RejectClientVpcConnection' => [ 'name' => 'RejectClientVpcConnection', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/clusters/{clusterArn}/client-vpc-connection', 'responseCode' => 200, ], 'input' => [ 'shape' => 'RejectClientVpcConnectionRequest', ], 'output' => [ 'shape' => 'RejectClientVpcConnectionResponse', ], 'errors' => [ [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], ], ], 'DeleteClusterPolicy' => [ 'name' => 'DeleteClusterPolicy', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v1/clusters/{clusterArn}/policy', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteClusterPolicyRequest', ], 'output' => [ 'shape' => 'DeleteClusterPolicyResponse', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], ], ], 'GetClusterPolicy' => [ 'name' => 'GetClusterPolicy', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/clusters/{clusterArn}/policy', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetClusterPolicyRequest', ], 'output' => [ 'shape' => 'GetClusterPolicyResponse', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], ], ], 'PutClusterPolicy' => [ 'name' => 'PutClusterPolicy', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/clusters/{clusterArn}/policy', 'responseCode' => 200, ], 'input' => [ 'shape' => 'PutClusterPolicyRequest', ], 'output' => [ 'shape' => 'PutClusterPolicyResponse', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], ], ], 'RebootBroker' => [ 'name' => 'RebootBroker', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/clusters/{clusterArn}/reboot-broker', 'responseCode' => 200, ], 'input' => [ 'shape' => 'RebootBrokerRequest', ], 'output' => [ 'shape' => 'RebootBrokerResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/tags/{resourceArn}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v1/tags/{resourceArn}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], ], ], 'UpdateBrokerCount' => [ 'name' => 'UpdateBrokerCount', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/clusters/{clusterArn}/nodes/count', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateBrokerCountRequest', ], 'output' => [ 'shape' => 'UpdateBrokerCountResponse', ], 'errors' => [ [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], ], ], 'UpdateBrokerType' => [ 'name' => 'UpdateBrokerType', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/clusters/{clusterArn}/nodes/type', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateBrokerTypeRequest', ], 'output' => [ 'shape' => 'UpdateBrokerTypeResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'UpdateBrokerStorage' => [ 'name' => 'UpdateBrokerStorage', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/clusters/{clusterArn}/nodes/storage', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateBrokerStorageRequest', ], 'output' => [ 'shape' => 'UpdateBrokerStorageResponse', ], 'errors' => [ [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], ], ], 'UpdateConfiguration' => [ 'name' => 'UpdateConfiguration', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/configurations/{arn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateConfigurationRequest', ], 'output' => [ 'shape' => 'UpdateConfigurationResponse', ], 'errors' => [ [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], ], ], 'UpdateClusterConfiguration' => [ 'name' => 'UpdateClusterConfiguration', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/clusters/{clusterArn}/configuration', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateClusterConfigurationRequest', ], 'output' => [ 'shape' => 'UpdateClusterConfigurationResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'UpdateClusterKafkaVersion' => [ 'name' => 'UpdateClusterKafkaVersion', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/clusters/{clusterArn}/version', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateClusterKafkaVersionRequest', ], 'output' => [ 'shape' => 'UpdateClusterKafkaVersionResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'UpdateConnectivity' => [ 'name' => 'UpdateConnectivity', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/clusters/{clusterArn}/connectivity', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateConnectivityRequest', ], 'output' => [ 'shape' => 'UpdateConnectivityResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'UpdateMonitoring' => [ 'name' => 'UpdateMonitoring', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/clusters/{clusterArn}/monitoring', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateMonitoringRequest', ], 'output' => [ 'shape' => 'UpdateMonitoringResponse', ], 'errors' => [ [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], ], ], 'UpdateReplicationInfo' => [ 'name' => 'UpdateReplicationInfo', 'http' => [ 'method' => 'PUT', 'requestUri' => '/replication/v1/replicators/{replicatorArn}/replication-info', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateReplicationInfoRequest', ], 'output' => [ 'shape' => 'UpdateReplicationInfoResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'UpdateSecurity' => [ 'name' => 'UpdateSecurity', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/v1/clusters/{clusterArn}/security', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateSecurityRequest', ], 'output' => [ 'shape' => 'UpdateSecurityResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'UpdateStorage' => [ 'name' => 'UpdateStorage', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/clusters/{clusterArn}/storage', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateStorageRequest', ], 'output' => [ 'shape' => 'UpdateStorageResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], ], 'shapes' => [ 'AmazonMskCluster' => [ 'type' => 'structure', 'members' => [ 'MskClusterArn' => [ 'shape' => '__string', 'locationName' => 'mskClusterArn', ], ], 'required' => [ 'MskClusterArn', ], ], 'BatchAssociateScramSecretRequest' => [ 'type' => 'structure', 'members' => [ 'ClusterArn' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'clusterArn', ], 'SecretArnList' => [ 'shape' => '__listOf__string', 'locationName' => 'secretArnList', ], ], 'required' => [ 'ClusterArn', 'SecretArnList', ], ], 'BatchAssociateScramSecretResponse' => [ 'type' => 'structure', 'members' => [ 'ClusterArn' => [ 'shape' => '__string', 'locationName' => 'clusterArn', ], 'UnprocessedScramSecrets' => [ 'shape' => '__listOfUnprocessedScramSecret', 'locationName' => 'unprocessedScramSecrets', ], ], ], 'BadRequestException' => [ 'type' => 'structure', 'members' => [ 'InvalidParameter' => [ 'shape' => '__string', 'locationName' => 'invalidParameter', ], 'Message' => [ 'shape' => '__string', 'locationName' => 'message', ], ], 'exception' => true, 'error' => [ 'httpStatusCode' => 400, ], ], 'BrokerAZDistribution' => [ 'type' => 'string', 'enum' => [ 'DEFAULT', ], ], 'BrokerEBSVolumeInfo' => [ 'type' => 'structure', 'members' => [ 'KafkaBrokerNodeId' => [ 'shape' => '__string', 'locationName' => 'kafkaBrokerNodeId', ], 'ProvisionedThroughput' => [ 'shape' => 'ProvisionedThroughput', 'locationName' => 'provisionedThroughput', ], 'VolumeSizeGB' => [ 'shape' => '__integer', 'locationName' => 'volumeSizeGB', ], ], 'required' => [ 'KafkaBrokerNodeId', ], ], 'BrokerLogs' => [ 'type' => 'structure', 'members' => [ 'CloudWatchLogs' => [ 'shape' => 'CloudWatchLogs', 'locationName' => 'cloudWatchLogs', ], 'Firehose' => [ 'shape' => 'Firehose', 'locationName' => 'firehose', ], 'S3' => [ 'shape' => 'S3', 'locationName' => 's3', ], ], ], 'BrokerNodeGroupInfo' => [ 'type' => 'structure', 'members' => [ 'BrokerAZDistribution' => [ 'shape' => 'BrokerAZDistribution', 'locationName' => 'brokerAZDistribution', ], 'ClientSubnets' => [ 'shape' => '__listOf__string', 'locationName' => 'clientSubnets', ], 'InstanceType' => [ 'shape' => '__stringMin5Max32', 'locationName' => 'instanceType', ], 'SecurityGroups' => [ 'shape' => '__listOf__string', 'locationName' => 'securityGroups', ], 'StorageInfo' => [ 'shape' => 'StorageInfo', 'locationName' => 'storageInfo', ], 'ConnectivityInfo' => [ 'shape' => 'ConnectivityInfo', 'locationName' => 'connectivityInfo', ], 'ZoneIds' => [ 'shape' => '__listOf__string', 'locationName' => 'zoneIds', ], ], 'required' => [ 'ClientSubnets', 'InstanceType', ], ], 'BrokerNodeInfo' => [ 'type' => 'structure', 'members' => [ 'AttachedENIId' => [ 'shape' => '__string', 'locationName' => 'attachedENIId', ], 'BrokerId' => [ 'shape' => '__double', 'locationName' => 'brokerId', ], 'ClientSubnet' => [ 'shape' => '__string', 'locationName' => 'clientSubnet', ], 'ClientVpcIpAddress' => [ 'shape' => '__string', 'locationName' => 'clientVpcIpAddress', ], 'CurrentBrokerSoftwareInfo' => [ 'shape' => 'BrokerSoftwareInfo', 'locationName' => 'currentBrokerSoftwareInfo', ], 'Endpoints' => [ 'shape' => '__listOf__string', 'locationName' => 'endpoints', ], ], ], 'BrokerSoftwareInfo' => [ 'type' => 'structure', 'members' => [ 'ConfigurationArn' => [ 'shape' => '__string', 'locationName' => 'configurationArn', ], 'ConfigurationRevision' => [ 'shape' => '__long', 'locationName' => 'configurationRevision', ], 'KafkaVersion' => [ 'shape' => '__string', 'locationName' => 'kafkaVersion', ], ], ], 'ClientAuthentication' => [ 'type' => 'structure', 'members' => [ 'Sasl' => [ 'shape' => 'Sasl', 'locationName' => 'sasl', ], 'Tls' => [ 'shape' => 'Tls', 'locationName' => 'tls', ], 'Unauthenticated' => [ 'shape' => 'Unauthenticated', 'locationName' => 'unauthenticated', ], ], ], 'VpcConnectivityClientAuthentication' => [ 'type' => 'structure', 'members' => [ 'Sasl' => [ 'shape' => 'VpcConnectivitySasl', 'locationName' => 'sasl', ], 'Tls' => [ 'shape' => 'VpcConnectivityTls', 'locationName' => 'tls', ], ], ], 'ClientBroker' => [ 'type' => 'string', 'enum' => [ 'TLS', 'TLS_PLAINTEXT', 'PLAINTEXT', ], ], 'CloudWatchLogs' => [ 'type' => 'structure', 'members' => [ 'Enabled' => [ 'shape' => '__boolean', 'locationName' => 'enabled', ], 'LogGroup' => [ 'shape' => '__string', 'locationName' => 'logGroup', ], ], 'required' => [ 'Enabled', ], ], 'ClusterInfo' => [ 'type' => 'structure', 'members' => [ 'ActiveOperationArn' => [ 'shape' => '__string', 'locationName' => 'activeOperationArn', ], 'BrokerNodeGroupInfo' => [ 'shape' => 'BrokerNodeGroupInfo', 'locationName' => 'brokerNodeGroupInfo', ], 'ClientAuthentication' => [ 'shape' => 'ClientAuthentication', 'locationName' => 'clientAuthentication', ], 'ClusterArn' => [ 'shape' => '__string', 'locationName' => 'clusterArn', ], 'ClusterName' => [ 'shape' => '__string', 'locationName' => 'clusterName', ], 'CreationTime' => [ 'shape' => '__timestampIso8601', 'locationName' => 'creationTime', ], 'CurrentBrokerSoftwareInfo' => [ 'shape' => 'BrokerSoftwareInfo', 'locationName' => 'currentBrokerSoftwareInfo', ], 'LoggingInfo' => [ 'shape' => 'LoggingInfo', 'locationName' => 'loggingInfo', ], 'CurrentVersion' => [ 'shape' => '__string', 'locationName' => 'currentVersion', ], 'EncryptionInfo' => [ 'shape' => 'EncryptionInfo', 'locationName' => 'encryptionInfo', ], 'EnhancedMonitoring' => [ 'shape' => 'EnhancedMonitoring', 'locationName' => 'enhancedMonitoring', ], 'NumberOfBrokerNodes' => [ 'shape' => '__integer', 'locationName' => 'numberOfBrokerNodes', ], 'OpenMonitoring' => [ 'shape' => 'OpenMonitoring', 'locationName' => 'openMonitoring', ], 'State' => [ 'shape' => 'ClusterState', 'locationName' => 'state', ], 'StateInfo' => [ 'shape' => 'StateInfo', 'locationName' => 'stateInfo', ], 'Tags' => [ 'shape' => '__mapOf__string', 'locationName' => 'tags', ], 'ZookeeperConnectString' => [ 'shape' => '__string', 'locationName' => 'zookeeperConnectString', ], 'ZookeeperConnectStringTls' => [ 'shape' => '__string', 'locationName' => 'zookeeperConnectStringTls', ], 'StorageMode' => [ 'shape' => 'StorageMode', 'locationName' => 'storageMode', ], 'CustomerActionStatus' => [ 'shape' => 'CustomerActionStatus', 'locationName' => 'customerActionStatus', ], ], ], 'ClusterOperationInfo' => [ 'type' => 'structure', 'members' => [ 'ClientRequestId' => [ 'shape' => '__string', 'locationName' => 'clientRequestId', ], 'ClusterArn' => [ 'shape' => '__string', 'locationName' => 'clusterArn', ], 'CreationTime' => [ 'shape' => '__timestampIso8601', 'locationName' => 'creationTime', ], 'EndTime' => [ 'shape' => '__timestampIso8601', 'locationName' => 'endTime', ], 'ErrorInfo' => [ 'shape' => 'ErrorInfo', 'locationName' => 'errorInfo', ], 'OperationSteps' => [ 'shape' => '__listOfClusterOperationStep', 'locationName' => 'operationSteps', ], 'OperationArn' => [ 'shape' => '__string', 'locationName' => 'operationArn', ], 'OperationState' => [ 'shape' => '__string', 'locationName' => 'operationState', ], 'OperationType' => [ 'shape' => '__string', 'locationName' => 'operationType', ], 'SourceClusterInfo' => [ 'shape' => 'MutableClusterInfo', 'locationName' => 'sourceClusterInfo', ], 'TargetClusterInfo' => [ 'shape' => 'MutableClusterInfo', 'locationName' => 'targetClusterInfo', ], 'VpcConnectionInfo' => [ 'shape' => 'VpcConnectionInfo', 'locationName' => 'vpcConnectionInfo', ], ], ], 'ClusterOperationStep' => [ 'type' => 'structure', 'members' => [ 'StepInfo' => [ 'shape' => 'ClusterOperationStepInfo', 'locationName' => 'stepInfo', ], 'StepName' => [ 'shape' => '__string', 'locationName' => 'stepName', ], ], ], 'ClusterOperationStepInfo' => [ 'type' => 'structure', 'members' => [ 'StepStatus' => [ 'shape' => '__string', 'locationName' => 'stepStatus', ], ], ], 'ClusterOperationV2' => [ 'type' => 'structure', 'members' => [ 'ClusterArn' => [ 'shape' => '__string', 'locationName' => 'clusterArn', ], 'ClusterType' => [ 'shape' => 'ClusterType', 'locationName' => 'clusterType', ], 'StartTime' => [ 'shape' => '__timestampIso8601', 'locationName' => 'startTime', ], 'EndTime' => [ 'shape' => '__timestampIso8601', 'locationName' => 'endTime', ], 'OperationArn' => [ 'shape' => '__string', 'locationName' => 'operationArn', ], 'OperationState' => [ 'shape' => '__string', 'locationName' => 'operationState', ], 'OperationType' => [ 'shape' => '__string', 'locationName' => 'operationType', ], 'Provisioned' => [ 'shape' => 'ClusterOperationV2Provisioned', 'locationName' => 'provisioned', ], 'Serverless' => [ 'shape' => 'ClusterOperationV2Serverless', 'locationName' => 'serverless', ], ], ], 'ClusterOperationV2Provisioned' => [ 'type' => 'structure', 'members' => [ 'OperationSteps' => [ 'shape' => '__listOfClusterOperationStep', 'locationName' => 'operationSteps', ], 'SourceClusterInfo' => [ 'shape' => 'MutableClusterInfo', 'locationName' => 'sourceClusterInfo', ], 'TargetClusterInfo' => [ 'shape' => 'MutableClusterInfo', 'locationName' => 'targetClusterInfo', ], 'VpcConnectionInfo' => [ 'shape' => 'VpcConnectionInfo', 'locationName' => 'vpcConnectionInfo', ], ], ], 'ClusterOperationV2Serverless' => [ 'type' => 'structure', 'members' => [ 'VpcConnectionInfo' => [ 'shape' => 'VpcConnectionInfoServerless', 'locationName' => 'vpcConnectionInfo', ], ], ], 'ClusterOperationV2Summary' => [ 'type' => 'structure', 'members' => [ 'ClusterArn' => [ 'shape' => '__string', 'locationName' => 'clusterArn', ], 'ClusterType' => [ 'shape' => 'ClusterType', 'locationName' => 'clusterType', ], 'StartTime' => [ 'shape' => '__timestampIso8601', 'locationName' => 'startTime', ], 'EndTime' => [ 'shape' => '__timestampIso8601', 'locationName' => 'endTime', ], 'OperationArn' => [ 'shape' => '__string', 'locationName' => 'operationArn', ], 'OperationState' => [ 'shape' => '__string', 'locationName' => 'operationState', ], 'OperationType' => [ 'shape' => '__string', 'locationName' => 'operationType', ], ], ], 'ClusterState' => [ 'type' => 'string', 'enum' => [ 'ACTIVE', 'CREATING', 'DELETING', 'FAILED', 'HEALING', 'MAINTENANCE', 'REBOOTING_BROKER', 'UPDATING', ], ], 'ClientVpcConnection' => [ 'type' => 'structure', 'members' => [ 'Authentication' => [ 'shape' => '__string', 'locationName' => 'authentication', ], 'CreationTime' => [ 'shape' => '__timestampIso8601', 'locationName' => 'creationTime', ], 'State' => [ 'shape' => 'VpcConnectionState', 'locationName' => 'state', ], 'VpcConnectionArn' => [ 'shape' => '__string', 'locationName' => 'vpcConnectionArn', ], 'Owner' => [ 'shape' => '__string', 'locationName' => 'owner', ], ], 'required' => [ 'VpcConnectionArn', ], ], 'VpcConnection' => [ 'type' => 'structure', 'members' => [ 'VpcConnectionArn' => [ 'shape' => '__string', 'locationName' => 'vpcConnectionArn', ], 'TargetClusterArn' => [ 'shape' => '__string', 'locationName' => 'targetClusterArn', ], 'CreationTime' => [ 'shape' => '__timestampIso8601', 'locationName' => 'creationTime', ], 'Authentication' => [ 'shape' => '__string', 'locationName' => 'authentication', ], 'VpcId' => [ 'shape' => '__string', 'locationName' => 'vpcId', ], 'State' => [ 'shape' => 'VpcConnectionState', 'locationName' => 'state', ], ], 'required' => [ 'VpcConnectionArn', 'TargetClusterArn', ], ], 'CompatibleKafkaVersion' => [ 'type' => 'structure', 'members' => [ 'SourceVersion' => [ 'shape' => '__string', 'locationName' => 'sourceVersion', ], 'TargetVersions' => [ 'shape' => '__listOf__string', 'locationName' => 'targetVersions', ], ], ], 'Configuration' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => '__string', 'locationName' => 'arn', ], 'CreationTime' => [ 'shape' => '__timestampIso8601', 'locationName' => 'creationTime', ], 'Description' => [ 'shape' => '__string', 'locationName' => 'description', ], 'KafkaVersions' => [ 'shape' => '__listOf__string', 'locationName' => 'kafkaVersions', ], 'LatestRevision' => [ 'shape' => 'ConfigurationRevision', 'locationName' => 'latestRevision', ], 'Name' => [ 'shape' => '__string', 'locationName' => 'name', ], 'State' => [ 'shape' => 'ConfigurationState', 'locationName' => 'state', ], ], 'required' => [ 'Description', 'LatestRevision', 'CreationTime', 'KafkaVersions', 'Arn', 'Name', 'State', ], ], 'ConfigurationInfo' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => '__string', 'locationName' => 'arn', ], 'Revision' => [ 'shape' => '__long', 'locationName' => 'revision', ], ], 'required' => [ 'Revision', 'Arn', ], ], 'ConfigurationRevision' => [ 'type' => 'structure', 'members' => [ 'CreationTime' => [ 'shape' => '__timestampIso8601', 'locationName' => 'creationTime', ], 'Description' => [ 'shape' => '__string', 'locationName' => 'description', ], 'Revision' => [ 'shape' => '__long', 'locationName' => 'revision', ], ], 'required' => [ 'Revision', 'CreationTime', ], ], 'ConfigurationState' => [ 'type' => 'string', 'enum' => [ 'ACTIVE', 'DELETING', 'DELETE_FAILED', ], ], 'ConflictException' => [ 'type' => 'structure', 'members' => [ 'InvalidParameter' => [ 'shape' => '__string', 'locationName' => 'invalidParameter', ], 'Message' => [ 'shape' => '__string', 'locationName' => 'message', ], ], 'exception' => true, 'error' => [ 'httpStatusCode' => 409, ], ], 'ConnectivityInfo' => [ 'type' => 'structure', 'members' => [ 'PublicAccess' => [ 'shape' => 'PublicAccess', 'locationName' => 'publicAccess', ], 'VpcConnectivity' => [ 'shape' => 'VpcConnectivity', 'locationName' => 'vpcConnectivity', ], ], ], 'BrokerCountUpdateInfo' => [ 'type' => 'structure', 'members' => [ 'CreatedBrokerIds' => [ 'shape' => '__listOf__double', 'locationName' => 'createdBrokerIds', ], 'DeletedBrokerIds' => [ 'shape' => '__listOf__double', 'locationName' => 'deletedBrokerIds', ], ], ], 'ConsumerGroupReplication' => [ 'type' => 'structure', 'members' => [ 'ConsumerGroupsToExclude' => [ 'shape' => '__listOf__stringMax256', 'locationName' => 'consumerGroupsToExclude', ], 'ConsumerGroupsToReplicate' => [ 'shape' => '__listOf__stringMax256', 'locationName' => 'consumerGroupsToReplicate', ], 'DetectAndCopyNewConsumerGroups' => [ 'shape' => '__boolean', 'locationName' => 'detectAndCopyNewConsumerGroups', ], 'SynchroniseConsumerGroupOffsets' => [ 'shape' => '__boolean', 'locationName' => 'synchroniseConsumerGroupOffsets', ], ], 'required' => [ 'ConsumerGroupsToReplicate', ], ], 'ConsumerGroupReplicationUpdate' => [ 'type' => 'structure', 'members' => [ 'ConsumerGroupsToExclude' => [ 'shape' => '__listOf__stringMax256', 'locationName' => 'consumerGroupsToExclude', ], 'ConsumerGroupsToReplicate' => [ 'shape' => '__listOf__stringMax256', 'locationName' => 'consumerGroupsToReplicate', ], 'DetectAndCopyNewConsumerGroups' => [ 'shape' => '__boolean', 'locationName' => 'detectAndCopyNewConsumerGroups', ], 'SynchroniseConsumerGroupOffsets' => [ 'shape' => '__boolean', 'locationName' => 'synchroniseConsumerGroupOffsets', ], ], 'required' => [ 'ConsumerGroupsToReplicate', 'ConsumerGroupsToExclude', 'SynchroniseConsumerGroupOffsets', 'DetectAndCopyNewConsumerGroups', ], ], 'CreateClusterRequest' => [ 'type' => 'structure', 'members' => [ 'BrokerNodeGroupInfo' => [ 'shape' => 'BrokerNodeGroupInfo', 'locationName' => 'brokerNodeGroupInfo', ], 'ClientAuthentication' => [ 'shape' => 'ClientAuthentication', 'locationName' => 'clientAuthentication', ], 'ClusterName' => [ 'shape' => '__stringMin1Max64', 'locationName' => 'clusterName', ], 'ConfigurationInfo' => [ 'shape' => 'ConfigurationInfo', 'locationName' => 'configurationInfo', ], 'EncryptionInfo' => [ 'shape' => 'EncryptionInfo', 'locationName' => 'encryptionInfo', ], 'EnhancedMonitoring' => [ 'shape' => 'EnhancedMonitoring', 'locationName' => 'enhancedMonitoring', ], 'KafkaVersion' => [ 'shape' => '__stringMin1Max128', 'locationName' => 'kafkaVersion', ], 'LoggingInfo' => [ 'shape' => 'LoggingInfo', 'locationName' => 'loggingInfo', ], 'NumberOfBrokerNodes' => [ 'shape' => '__integerMin1Max15', 'locationName' => 'numberOfBrokerNodes', ], 'OpenMonitoring' => [ 'shape' => 'OpenMonitoringInfo', 'locationName' => 'openMonitoring', ], 'Tags' => [ 'shape' => '__mapOf__string', 'locationName' => 'tags', ], 'StorageMode' => [ 'shape' => 'StorageMode', 'locationName' => 'storageMode', ], ], 'required' => [ 'BrokerNodeGroupInfo', 'KafkaVersion', 'NumberOfBrokerNodes', 'ClusterName', ], ], 'CreateClusterResponse' => [ 'type' => 'structure', 'members' => [ 'ClusterArn' => [ 'shape' => '__string', 'locationName' => 'clusterArn', ], 'ClusterName' => [ 'shape' => '__string', 'locationName' => 'clusterName', ], 'State' => [ 'shape' => 'ClusterState', 'locationName' => 'state', ], ], ], 'CreateConfigurationRequest' => [ 'type' => 'structure', 'members' => [ 'Description' => [ 'shape' => '__string', 'locationName' => 'description', ], 'KafkaVersions' => [ 'shape' => '__listOf__string', 'locationName' => 'kafkaVersions', ], 'Name' => [ 'shape' => '__string', 'locationName' => 'name', ], 'ServerProperties' => [ 'shape' => '__blob', 'locationName' => 'serverProperties', ], ], 'required' => [ 'ServerProperties', 'Name', ], ], 'CreateConfigurationResponse' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => '__string', 'locationName' => 'arn', ], 'CreationTime' => [ 'shape' => '__timestampIso8601', 'locationName' => 'creationTime', ], 'LatestRevision' => [ 'shape' => 'ConfigurationRevision', 'locationName' => 'latestRevision', ], 'Name' => [ 'shape' => '__string', 'locationName' => 'name', ], 'State' => [ 'shape' => 'ConfigurationState', 'locationName' => 'state', ], ], ], 'CreateReplicatorRequest' => [ 'type' => 'structure', 'members' => [ 'Description' => [ 'shape' => '__stringMax1024', 'locationName' => 'description', ], 'KafkaClusters' => [ 'shape' => '__listOfKafkaCluster', 'locationName' => 'kafkaClusters', ], 'ReplicationInfoList' => [ 'shape' => '__listOfReplicationInfo', 'locationName' => 'replicationInfoList', ], 'ReplicatorName' => [ 'shape' => '__stringMin1Max128Pattern09AZaZ09AZaZ0', 'locationName' => 'replicatorName', ], 'ServiceExecutionRoleArn' => [ 'shape' => '__string', 'locationName' => 'serviceExecutionRoleArn', ], 'Tags' => [ 'shape' => '__mapOf__string', 'locationName' => 'tags', ], ], 'required' => [ 'ServiceExecutionRoleArn', 'ReplicatorName', 'ReplicationInfoList', 'KafkaClusters', ], ], 'CreateReplicatorResponse' => [ 'type' => 'structure', 'members' => [ 'ReplicatorArn' => [ 'shape' => '__string', 'locationName' => 'replicatorArn', ], 'ReplicatorName' => [ 'shape' => '__string', 'locationName' => 'replicatorName', ], 'ReplicatorState' => [ 'shape' => 'ReplicatorState', 'locationName' => 'replicatorState', ], ], ], 'CreateVpcConnectionRequest' => [ 'type' => 'structure', 'members' => [ 'TargetClusterArn' => [ 'shape' => '__string', 'locationName' => 'targetClusterArn', ], 'Authentication' => [ 'shape' => '__string', 'locationName' => 'authentication', ], 'VpcId' => [ 'shape' => '__string', 'locationName' => 'vpcId', ], 'ClientSubnets' => [ 'shape' => '__listOf__string', 'locationName' => 'clientSubnets', ], 'SecurityGroups' => [ 'shape' => '__listOf__string', 'locationName' => 'securityGroups', ], 'Tags' => [ 'shape' => '__mapOf__string', 'locationName' => 'tags', 'documentation' => ' <p>A map of tags for the VPC connection.</p> ', ], ], 'required' => [ 'TargetClusterArn', 'Authentication', 'VpcId', 'ClientSubnets', 'SecurityGroups', ], ], 'CreateVpcConnectionResponse' => [ 'type' => 'structure', 'members' => [ 'VpcConnectionArn' => [ 'shape' => '__string', 'locationName' => 'vpcConnectionArn', ], 'State' => [ 'shape' => 'VpcConnectionState', 'locationName' => 'state', ], 'Authentication' => [ 'shape' => '__string', 'locationName' => 'authentication', ], 'VpcId' => [ 'shape' => '__string', 'locationName' => 'vpcId', ], 'ClientSubnets' => [ 'shape' => '__listOf__string', 'locationName' => 'clientSubnets', ], 'SecurityGroups' => [ 'shape' => '__listOf__string', 'locationName' => 'securityGroups', ], 'CreationTime' => [ 'shape' => '__timestampIso8601', 'locationName' => 'creationTime', ], 'Tags' => [ 'shape' => '__mapOf__string', 'locationName' => 'tags', 'documentation' => ' <p>A map of tags that you want the vpc connection to have.</p> ', ], ], ], 'DeleteClusterRequest' => [ 'type' => 'structure', 'members' => [ 'ClusterArn' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'clusterArn', ], 'CurrentVersion' => [ 'shape' => '__string', 'location' => 'querystring', 'locationName' => 'currentVersion', ], ], 'required' => [ 'ClusterArn', ], ], 'DeleteClusterResponse' => [ 'type' => 'structure', 'members' => [ 'ClusterArn' => [ 'shape' => '__string', 'locationName' => 'clusterArn', ], 'State' => [ 'shape' => 'ClusterState', 'locationName' => 'state', ], ], ], 'DeleteConfigurationRequest' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'arn', ], ], 'required' => [ 'Arn', ], ], 'DeleteConfigurationResponse' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => '__string', 'locationName' => 'arn', ], 'State' => [ 'shape' => 'ConfigurationState', 'locationName' => 'state', ], ], ], 'DeleteReplicatorRequest' => [ 'type' => 'structure', 'members' => [ 'CurrentVersion' => [ 'shape' => '__string', 'location' => 'querystring', 'locationName' => 'currentVersion', ], 'ReplicatorArn' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'replicatorArn', ], ], 'required' => [ 'ReplicatorArn', ], ], 'DeleteReplicatorResponse' => [ 'type' => 'structure', 'members' => [ 'ReplicatorArn' => [ 'shape' => '__string', 'locationName' => 'replicatorArn', ], 'ReplicatorState' => [ 'shape' => 'ReplicatorState', 'locationName' => 'replicatorState', ], ], ], 'DeleteVpcConnectionRequest' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'arn', ], ], 'required' => [ 'Arn', ], ], 'DeleteVpcConnectionResponse' => [ 'type' => 'structure', 'members' => [ 'VpcConnectionArn' => [ 'shape' => '__string', 'locationName' => 'vpcConnectionArn', ], 'State' => [ 'shape' => 'VpcConnectionState', 'locationName' => 'state', ], ], ], 'DescribeClusterOperationRequest' => [ 'type' => 'structure', 'members' => [ 'ClusterOperationArn' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'clusterOperationArn', ], ], 'required' => [ 'ClusterOperationArn', ], ], 'DescribeClusterOperationV2Request' => [ 'type' => 'structure', 'members' => [ 'ClusterOperationArn' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'clusterOperationArn', ], ], 'required' => [ 'ClusterOperationArn', ], ], 'DescribeClusterOperationResponse' => [ 'type' => 'structure', 'members' => [ 'ClusterOperationInfo' => [ 'shape' => 'ClusterOperationInfo', 'locationName' => 'clusterOperationInfo', ], ], ], 'DescribeClusterOperationV2Response' => [ 'type' => 'structure', 'members' => [ 'ClusterOperationInfo' => [ 'shape' => 'ClusterOperationV2', 'locationName' => 'clusterOperationInfo', ], ], ], 'DescribeClusterRequest' => [ 'type' => 'structure', 'members' => [ 'ClusterArn' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'clusterArn', ], ], 'required' => [ 'ClusterArn', ], ], 'DescribeClusterResponse' => [ 'type' => 'structure', 'members' => [ 'ClusterInfo' => [ 'shape' => 'ClusterInfo', 'locationName' => 'clusterInfo', ], ], ], 'DescribeConfigurationRequest' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'arn', ], ], 'required' => [ 'Arn', ], ], 'DescribeConfigurationResponse' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => '__string', 'locationName' => 'arn', ], 'CreationTime' => [ 'shape' => '__timestampIso8601', 'locationName' => 'creationTime', ], 'Description' => [ 'shape' => '__string', 'locationName' => 'description', ], 'KafkaVersions' => [ 'shape' => '__listOf__string', 'locationName' => 'kafkaVersions', ], 'LatestRevision' => [ 'shape' => 'ConfigurationRevision', 'locationName' => 'latestRevision', ], 'Name' => [ 'shape' => '__string', 'locationName' => 'name', ], 'State' => [ 'shape' => 'ConfigurationState', 'locationName' => 'state', ], ], ], 'DescribeConfigurationRevisionRequest' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'arn', ], 'Revision' => [ 'shape' => '__long', 'location' => 'uri', 'locationName' => 'revision', ], ], 'required' => [ 'Revision', 'Arn', ], ], 'DescribeConfigurationRevisionResponse' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => '__string', 'locationName' => 'arn', ], 'CreationTime' => [ 'shape' => '__timestampIso8601', 'locationName' => 'creationTime', ], 'Description' => [ 'shape' => '__string', 'locationName' => 'description', ], 'Revision' => [ 'shape' => '__long', 'locationName' => 'revision', ], 'ServerProperties' => [ 'shape' => '__blob', 'locationName' => 'serverProperties', ], ], ], 'DescribeReplicatorRequest' => [ 'type' => 'structure', 'members' => [ 'ReplicatorArn' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'replicatorArn', ], ], 'required' => [ 'ReplicatorArn', ], ], 'DescribeReplicatorResponse' => [ 'type' => 'structure', 'members' => [ 'CreationTime' => [ 'shape' => '__timestampIso8601', 'locationName' => 'creationTime', ], 'CurrentVersion' => [ 'shape' => '__string', 'locationName' => 'currentVersion', ], 'IsReplicatorReference' => [ 'shape' => '__boolean', 'locationName' => 'isReplicatorReference', ], 'KafkaClusters' => [ 'shape' => '__listOfKafkaClusterDescription', 'locationName' => 'kafkaClusters', ], 'ReplicationInfoList' => [ 'shape' => '__listOfReplicationInfoDescription', 'locationName' => 'replicationInfoList', ], 'ReplicatorArn' => [ 'shape' => '__string', 'locationName' => 'replicatorArn', ], 'ReplicatorDescription' => [ 'shape' => '__string', 'locationName' => 'replicatorDescription', ], 'ReplicatorName' => [ 'shape' => '__string', 'locationName' => 'replicatorName', ], 'ReplicatorResourceArn' => [ 'shape' => '__string', 'locationName' => 'replicatorResourceArn', ], 'ReplicatorState' => [ 'shape' => 'ReplicatorState', 'locationName' => 'replicatorState', ], 'ServiceExecutionRoleArn' => [ 'shape' => '__string', 'locationName' => 'serviceExecutionRoleArn', ], 'StateInfo' => [ 'shape' => 'ReplicationStateInfo', 'locationName' => 'stateInfo', ], 'Tags' => [ 'shape' => '__mapOf__string', 'locationName' => 'tags', ], ], ], 'DescribeVpcConnectionRequest' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'arn', ], ], 'required' => [ 'Arn', ], ], 'DescribeVpcConnectionResponse' => [ 'type' => 'structure', 'members' => [ 'VpcConnectionArn' => [ 'shape' => '__string', 'locationName' => 'vpcConnectionArn', ], 'TargetClusterArn' => [ 'shape' => '__string', 'locationName' => 'targetClusterArn', ], 'State' => [ 'shape' => 'VpcConnectionState', 'locationName' => 'state', ], 'Authentication' => [ 'shape' => '__string', 'locationName' => 'authentication', ], 'VpcId' => [ 'shape' => '__string', 'locationName' => 'vpcId', ], 'Subnets' => [ 'shape' => '__listOf__string', 'locationName' => 'subnets', ], 'SecurityGroups' => [ 'shape' => '__listOf__string', 'locationName' => 'securityGroups', ], 'CreationTime' => [ 'shape' => '__timestampIso8601', 'locationName' => 'creationTime', ], 'Tags' => [ 'shape' => '__mapOf__string', 'locationName' => 'tags', 'documentation' => ' <p>A map of tags that you want the vpc connection to have.</p> ', ], ], ], 'BatchDisassociateScramSecretRequest' => [ 'type' => 'structure', 'members' => [ 'ClusterArn' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'clusterArn', ], 'SecretArnList' => [ 'shape' => '__listOf__string', 'locationName' => 'secretArnList', ], ], 'required' => [ 'ClusterArn', 'SecretArnList', ], ], 'BatchDisassociateScramSecretResponse' => [ 'type' => 'structure', 'members' => [ 'ClusterArn' => [ 'shape' => '__string', 'locationName' => 'clusterArn', ], 'UnprocessedScramSecrets' => [ 'shape' => '__listOfUnprocessedScramSecret', 'locationName' => 'unprocessedScramSecrets', ], ], ], 'EBSStorageInfo' => [ 'type' => 'structure', 'members' => [ 'ProvisionedThroughput' => [ 'shape' => 'ProvisionedThroughput', 'locationName' => 'provisionedThroughput', ], 'VolumeSize' => [ 'shape' => '__integerMin1Max16384', 'locationName' => 'volumeSize', ], ], ], 'EncryptionAtRest' => [ 'type' => 'structure', 'members' => [ 'DataVolumeKMSKeyId' => [ 'shape' => '__string', 'locationName' => 'dataVolumeKMSKeyId', ], ], 'required' => [ 'DataVolumeKMSKeyId', ], ], 'EncryptionInTransit' => [ 'type' => 'structure', 'members' => [ 'ClientBroker' => [ 'shape' => 'ClientBroker', 'locationName' => 'clientBroker', ], 'InCluster' => [ 'shape' => '__boolean', 'locationName' => 'inCluster', ], ], ], 'EncryptionInfo' => [ 'type' => 'structure', 'members' => [ 'EncryptionAtRest' => [ 'shape' => 'EncryptionAtRest', 'locationName' => 'encryptionAtRest', ], 'EncryptionInTransit' => [ '