<?php
// This file was auto-generated from sdk-root/src/data/mgn/2020-02-26/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2020-02-26', 'endpointPrefix' => 'mgn', 'jsonVersion' => '1.1', 'protocol' => 'rest-json', 'serviceAbbreviation' => 'mgn', 'serviceFullName' => 'Application Migration Service', 'serviceId' => 'mgn', 'signatureVersion' => 'v4', 'signingName' => 'mgn', 'uid' => 'mgn-2020-02-26', ], 'operations' => [ 'ArchiveApplication' => [ 'name' => 'ArchiveApplication', 'http' => [ 'method' => 'POST', 'requestUri' => '/ArchiveApplication', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ArchiveApplicationRequest', ], 'output' => [ 'shape' => 'Application', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], ], ], 'ArchiveWave' => [ 'name' => 'ArchiveWave', 'http' => [ 'method' => 'POST', 'requestUri' => '/ArchiveWave', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ArchiveWaveRequest', ], 'output' => [ 'shape' => 'Wave', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], ], ], 'AssociateApplications' => [ 'name' => 'AssociateApplications', 'http' => [ 'method' => 'POST', 'requestUri' => '/AssociateApplications', 'responseCode' => 200, ], 'input' => [ 'shape' => 'AssociateApplicationsRequest', ], 'output' => [ 'shape' => 'AssociateApplicationsResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'AssociateSourceServers' => [ 'name' => 'AssociateSourceServers', 'http' => [ 'method' => 'POST', 'requestUri' => '/AssociateSourceServers', 'responseCode' => 200, ], 'input' => [ 'shape' => 'AssociateSourceServersRequest', ], 'output' => [ 'shape' => 'AssociateSourceServersResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'ChangeServerLifeCycleState' => [ 'name' => 'ChangeServerLifeCycleState', 'http' => [ 'method' => 'POST', 'requestUri' => '/ChangeServerLifeCycleState', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ChangeServerLifeCycleStateRequest', ], 'output' => [ 'shape' => 'SourceServer', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], ], ], 'CreateApplication' => [ 'name' => 'CreateApplication', 'http' => [ 'method' => 'POST', 'requestUri' => '/CreateApplication', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateApplicationRequest', ], 'output' => [ 'shape' => 'Application', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'CreateConnector' => [ 'name' => 'CreateConnector', 'http' => [ 'method' => 'POST', 'requestUri' => '/CreateConnector', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateConnectorRequest', ], 'output' => [ 'shape' => 'Connector', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'CreateLaunchConfigurationTemplate' => [ 'name' => 'CreateLaunchConfigurationTemplate', 'http' => [ 'method' => 'POST', 'requestUri' => '/CreateLaunchConfigurationTemplate', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateLaunchConfigurationTemplateRequest', ], 'output' => [ 'shape' => 'LaunchConfigurationTemplate', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'CreateReplicationConfigurationTemplate' => [ 'name' => 'CreateReplicationConfigurationTemplate', 'http' => [ 'method' => 'POST', 'requestUri' => '/CreateReplicationConfigurationTemplate', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateReplicationConfigurationTemplateRequest', ], 'output' => [ 'shape' => 'ReplicationConfigurationTemplate', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'CreateWave' => [ 'name' => 'CreateWave', 'http' => [ 'method' => 'POST', 'requestUri' => '/CreateWave', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateWaveRequest', ], 'output' => [ 'shape' => 'Wave', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DeleteApplication' => [ 'name' => 'DeleteApplication', 'http' => [ 'method' => 'POST', 'requestUri' => '/DeleteApplication', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteApplicationRequest', ], 'output' => [ 'shape' => 'DeleteApplicationResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DeleteConnector' => [ 'name' => 'DeleteConnector', 'http' => [ 'method' => 'POST', 'requestUri' => '/DeleteConnector', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteConnectorRequest', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'DeleteJob' => [ 'name' => 'DeleteJob', 'http' => [ 'method' => 'POST', 'requestUri' => '/DeleteJob', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteJobRequest', ], 'output' => [ 'shape' => 'DeleteJobResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DeleteLaunchConfigurationTemplate' => [ 'name' => 'DeleteLaunchConfigurationTemplate', 'http' => [ 'method' => 'POST', 'requestUri' => '/DeleteLaunchConfigurationTemplate', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteLaunchConfigurationTemplateRequest', ], 'output' => [ 'shape' => 'DeleteLaunchConfigurationTemplateResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DeleteReplicationConfigurationTemplate' => [ 'name' => 'DeleteReplicationConfigurationTemplate', 'http' => [ 'method' => 'POST', 'requestUri' => '/DeleteReplicationConfigurationTemplate', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteReplicationConfigurationTemplateRequest', ], 'output' => [ 'shape' => 'DeleteReplicationConfigurationTemplateResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DeleteSourceServer' => [ 'name' => 'DeleteSourceServer', 'http' => [ 'method' => 'POST', 'requestUri' => '/DeleteSourceServer', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteSourceServerRequest', ], 'output' => [ 'shape' => 'DeleteSourceServerResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DeleteVcenterClient' => [ 'name' => 'DeleteVcenterClient', 'http' => [ 'method' => 'POST', 'requestUri' => '/DeleteVcenterClient', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteVcenterClientRequest', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'DeleteWave' => [ 'name' => 'DeleteWave', 'http' => [ 'method' => 'POST', 'requestUri' => '/DeleteWave', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteWaveRequest', ], 'output' => [ 'shape' => 'DeleteWaveResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DescribeJobLogItems' => [ 'name' => 'DescribeJobLogItems', 'http' => [ 'method' => 'POST', 'requestUri' => '/DescribeJobLogItems', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeJobLogItemsRequest', ], 'output' => [ 'shape' => 'DescribeJobLogItemsResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ValidationException', ], ], ], 'DescribeJobs' => [ 'name' => 'DescribeJobs', 'http' => [ 'method' => 'POST', 'requestUri' => '/DescribeJobs', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeJobsRequest', ], 'output' => [ 'shape' => 'DescribeJobsResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ValidationException', ], ], ], 'DescribeLaunchConfigurationTemplates' => [ 'name' => 'DescribeLaunchConfigurationTemplates', 'http' => [ 'method' => 'POST', 'requestUri' => '/DescribeLaunchConfigurationTemplates', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeLaunchConfigurationTemplatesRequest', ], 'output' => [ 'shape' => 'DescribeLaunchConfigurationTemplatesResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], ], ], 'DescribeReplicationConfigurationTemplates' => [ 'name' => 'DescribeReplicationConfigurationTemplates', 'http' => [ 'method' => 'POST', 'requestUri' => '/DescribeReplicationConfigurationTemplates', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeReplicationConfigurationTemplatesRequest', ], 'output' => [ 'shape' => 'DescribeReplicationConfigurationTemplatesResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], ], ], 'DescribeSourceServers' => [ 'name' => 'DescribeSourceServers', 'http' => [ 'method' => 'POST', 'requestUri' => '/DescribeSourceServers', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeSourceServersRequest', ], 'output' => [ 'shape' => 'DescribeSourceServersResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ValidationException', ], ], ], 'DescribeVcenterClients' => [ 'name' => 'DescribeVcenterClients', 'http' => [ 'method' => 'GET', 'requestUri' => '/DescribeVcenterClients', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeVcenterClientsRequest', ], 'output' => [ 'shape' => 'DescribeVcenterClientsResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], ], ], 'DisassociateApplications' => [ 'name' => 'DisassociateApplications', 'http' => [ 'method' => 'POST', 'requestUri' => '/DisassociateApplications', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DisassociateApplicationsRequest', ], 'output' => [ 'shape' => 'DisassociateApplicationsResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DisassociateSourceServers' => [ 'name' => 'DisassociateSourceServers', 'http' => [ 'method' => 'POST', 'requestUri' => '/DisassociateSourceServers', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DisassociateSourceServersRequest', ], 'output' => [ 'shape' => 'DisassociateSourceServersResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DisconnectFromService' => [ 'name' => 'DisconnectFromService', 'http' => [ 'method' => 'POST', 'requestUri' => '/DisconnectFromService', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DisconnectFromServiceRequest', ], 'output' => [ 'shape' => 'SourceServer', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], ], 'FinalizeCutover' => [ 'name' => 'FinalizeCutover', 'http' => [ 'method' => 'POST', 'requestUri' => '/FinalizeCutover', 'responseCode' => 200, ], 'input' => [ 'shape' => 'FinalizeCutoverRequest', ], 'output' => [ 'shape' => 'SourceServer', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], ], ], 'GetLaunchConfiguration' => [ 'name' => 'GetLaunchConfiguration', 'http' => [ 'method' => 'POST', 'requestUri' => '/GetLaunchConfiguration', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetLaunchConfigurationRequest', ], 'output' => [ 'shape' => 'LaunchConfiguration', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetReplicationConfiguration' => [ 'name' => 'GetReplicationConfiguration', 'http' => [ 'method' => 'POST', 'requestUri' => '/GetReplicationConfiguration', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetReplicationConfigurationRequest', ], 'output' => [ 'shape' => 'ReplicationConfiguration', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'InitializeService' => [ 'name' => 'InitializeService', 'http' => [ 'method' => 'POST', 'requestUri' => '/InitializeService', 'responseCode' => 204, ], 'input' => [ 'shape' => 'InitializeServiceRequest', ], 'output' => [ 'shape' => 'InitializeServiceResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'ListApplications' => [ 'name' => 'ListApplications', 'http' => [ 'method' => 'POST', 'requestUri' => '/ListApplications', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListApplicationsRequest', ], 'output' => [ 'shape' => 'ListApplicationsResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], ], ], 'ListConnectors' => [ 'name' => 'ListConnectors', 'http' => [ 'method' => 'POST', 'requestUri' => '/ListConnectors', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListConnectorsRequest', ], 'output' => [ 'shape' => 'ListConnectorsResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ValidationException', ], ], ], 'ListExportErrors' => [ 'name' => 'ListExportErrors', 'http' => [ 'method' => 'POST', 'requestUri' => '/ListExportErrors', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListExportErrorsRequest', ], 'output' => [ 'shape' => 'ListExportErrorsResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ValidationException', ], ], ], 'ListExports' => [ 'name' => 'ListExports', 'http' => [ 'method' => 'POST', 'requestUri' => '/ListExports', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListExportsRequest', ], 'output' => [ 'shape' => 'ListExportsResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], ], ], 'ListImportErrors' => [ 'name' => 'ListImportErrors', 'http' => [ 'method' => 'POST', 'requestUri' => '/ListImportErrors', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListImportErrorsRequest', ], 'output' => [ 'shape' => 'ListImportErrorsResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ValidationException', ], ], ], 'ListImports' => [ 'name' => 'ListImports', 'http' => [ 'method' => 'POST', 'requestUri' => '/ListImports', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListImportsRequest', ], 'output' => [ 'shape' => 'ListImportsResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ValidationException', ], ], ], 'ListManagedAccounts' => [ 'name' => 'ListManagedAccounts', 'http' => [ 'method' => 'POST', 'requestUri' => '/ListManagedAccounts', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListManagedAccountsRequest', ], 'output' => [ 'shape' => 'ListManagedAccountsResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ValidationException', ], ], ], 'ListSourceServerActions' => [ 'name' => 'ListSourceServerActions', 'http' => [ 'method' => 'POST', 'requestUri' => '/ListSourceServerActions', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListSourceServerActionsRequest', ], 'output' => [ 'shape' => 'ListSourceServerActionsResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListTemplateActions' => [ 'name' => 'ListTemplateActions', 'http' => [ 'method' => 'POST', 'requestUri' => '/ListTemplateActions', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTemplateActionsRequest', ], 'output' => [ 'shape' => 'ListTemplateActionsResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListWaves' => [ 'name' => 'ListWaves', 'http' => [ 'method' => 'POST', 'requestUri' => '/ListWaves', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListWavesRequest', ], 'output' => [ 'shape' => 'ListWavesResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], ], ], 'MarkAsArchived' => [ 'name' => 'MarkAsArchived', 'http' => [ 'method' => 'POST', 'requestUri' => '/MarkAsArchived', 'responseCode' => 200, ], 'input' => [ 'shape' => 'MarkAsArchivedRequest', ], 'output' => [ 'shape' => 'SourceServer', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], ], 'PauseReplication' => [ 'name' => 'PauseReplication', 'http' => [ 'method' => 'POST', 'requestUri' => '/PauseReplication', 'responseCode' => 200, ], 'input' => [ 'shape' => 'PauseReplicationRequest', ], 'output' => [ 'shape' => 'SourceServer', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], ], ], 'PutSourceServerAction' => [ 'name' => 'PutSourceServerAction', 'http' => [ 'method' => 'POST', 'requestUri' => '/PutSourceServerAction', 'responseCode' => 200, ], 'input' => [ 'shape' => 'PutSourceServerActionRequest', ], 'output' => [ 'shape' => 'SourceServerActionDocument', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], ], ], 'PutTemplateAction' => [ 'name' => 'PutTemplateAction', 'http' => [ 'method' => 'POST', 'requestUri' => '/PutTemplateAction', 'responseCode' => 200, ], 'input' => [ 'shape' => 'PutTemplateActionRequest', ], 'output' => [ 'shape' => 'TemplateActionDocument', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], ], ], 'RemoveSourceServerAction' => [ 'name' => 'RemoveSourceServerAction', 'http' => [ 'method' => 'POST', 'requestUri' => '/RemoveSourceServerAction', 'responseCode' => 204, ], 'input' => [ 'shape' => 'RemoveSourceServerActionRequest', ], 'output' => [ 'shape' => 'RemoveSourceServerActionResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], ], ], 'RemoveTemplateAction' => [ 'name' => 'RemoveTemplateAction', 'http' => [ 'method' => 'POST', 'requestUri' => '/RemoveTemplateAction', 'responseCode' => 204, ], 'input' => [ 'shape' => 'RemoveTemplateActionRequest', ], 'output' => [ 'shape' => 'RemoveTemplateActionResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], ], ], 'ResumeReplication' => [ 'name' => 'ResumeReplication', 'http' => [ 'method' => 'POST', 'requestUri' => '/ResumeReplication', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ResumeReplicationRequest', ], 'output' => [ 'shape' => 'SourceServer', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], ], ], 'RetryDataReplication' => [ 'name' => 'RetryDataReplication', 'http' => [ 'method' => 'POST', 'requestUri' => '/RetryDataReplication', 'responseCode' => 200, ], 'input' => [ 'shape' => 'RetryDataReplicationRequest', ], 'output' => [ 'shape' => 'SourceServer', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], ], ], 'StartCutover' => [ 'name' => 'StartCutover', 'http' => [ 'method' => 'POST', 'requestUri' => '/StartCutover', 'responseCode' => 202, ], 'input' => [ 'shape' => 'StartCutoverRequest', ], 'output' => [ 'shape' => 'StartCutoverResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], ], ], 'StartExport' => [ 'name' => 'StartExport', 'http' => [ 'method' => 'POST', 'requestUri' => '/StartExport', 'responseCode' => 202, ], 'input' => [ 'shape' => 'StartExportRequest', ], 'output' => [ 'shape' => 'StartExportResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], ], 'StartImport' => [ 'name' => 'StartImport', 'http' => [ 'method' => 'POST', 'requestUri' => '/StartImport', 'responseCode' => 202, ], 'input' => [ 'shape' => 'StartImportRequest', ], 'output' => [ 'shape' => 'StartImportResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], ], ], 'StartReplication' => [ 'name' => 'StartReplication', 'http' => [ 'method' => 'POST', 'requestUri' => '/StartReplication', 'responseCode' => 200, ], 'input' => [ 'shape' => 'StartReplicationRequest', ], 'output' => [ 'shape' => 'SourceServer', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], ], ], 'StartTest' => [ 'name' => 'StartTest', 'http' => [ 'method' => 'POST', 'requestUri' => '/StartTest', 'responseCode' => 202, ], 'input' => [ 'shape' => 'StartTestRequest', ], 'output' => [ 'shape' => 'StartTestResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], ], ], 'StopReplication' => [ 'name' => 'StopReplication', 'http' => [ 'method' => 'POST', 'requestUri' => '/StopReplication', 'responseCode' => 200, ], 'input' => [ 'shape' => 'StopReplicationRequest', ], 'output' => [ 'shape' => 'SourceServer', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], ], ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'TerminateTargetInstances' => [ 'name' => 'TerminateTargetInstances', 'http' => [ 'method' => 'POST', 'requestUri' => '/TerminateTargetInstances', 'responseCode' => 202, ], 'input' => [ 'shape' => 'TerminateTargetInstancesRequest', ], 'output' => [ 'shape' => 'TerminateTargetInstancesResponse', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], ], ], 'UnarchiveApplication' => [ 'name' => 'UnarchiveApplication', 'http' => [ 'method' => 'POST', 'requestUri' => '/UnarchiveApplication', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UnarchiveApplicationRequest', ], 'output' => [ 'shape' => 'Application', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], ], 'UnarchiveWave' => [ 'name' => 'UnarchiveWave', 'http' => [ 'method' => 'POST', 'requestUri' => '/UnarchiveWave', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UnarchiveWaveRequest', ], 'output' => [ 'shape' => 'Wave', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'UpdateApplication' => [ 'name' => 'UpdateApplication', 'http' => [ 'method' => 'POST', 'requestUri' => '/UpdateApplication', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateApplicationRequest', ], 'output' => [ 'shape' => 'Application', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'UpdateConnector' => [ 'name' => 'UpdateConnector', 'http' => [ 'method' => 'POST', 'requestUri' => '/UpdateConnector', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateConnectorRequest', ], 'output' => [ 'shape' => 'Connector', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'UpdateLaunchConfiguration' => [ 'name' => 'UpdateLaunchConfiguration', 'http' => [ 'method' => 'POST', 'requestUri' => '/UpdateLaunchConfiguration', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateLaunchConfigurationRequest', ], 'output' => [ 'shape' => 'LaunchConfiguration', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'UpdateLaunchConfigurationTemplate' => [ 'name' => 'UpdateLaunchConfigurationTemplate', 'http' => [ 'method' => 'POST', 'requestUri' => '/UpdateLaunchConfigurationTemplate', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateLaunchConfigurationTemplateRequest', ], 'output' => [ 'shape' => 'LaunchConfigurationTemplate', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'UpdateReplicationConfiguration' => [ 'name' => 'UpdateReplicationConfiguration', 'http' => [ 'method' => 'POST', 'requestUri' => '/UpdateReplicationConfiguration', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateReplicationConfigurationRequest', ], 'output' => [ 'shape' => 'ReplicationConfiguration', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'UpdateReplicationConfigurationTemplate' => [ 'name' => 'UpdateReplicationConfigurationTemplate', 'http' => [ 'method' => 'POST', 'requestUri' => '/UpdateReplicationConfigurationTemplate', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateReplicationConfigurationTemplateRequest', ], 'output' => [ 'shape' => 'ReplicationConfigurationTemplate', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'UpdateSourceServer' => [ 'name' => 'UpdateSourceServer', 'http' => [ 'method' => 'POST', 'requestUri' => '/UpdateSourceServer', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateSourceServerRequest', ], 'output' => [ 'shape' => 'SourceServer', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'UpdateSourceServerReplicationType' => [ 'name' => 'UpdateSourceServerReplicationType', 'http' => [ 'method' => 'POST', 'requestUri' => '/UpdateSourceServerReplicationType', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateSourceServerReplicationTypeRequest', ], 'output' => [ 'shape' => 'SourceServer', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], ], ], 'UpdateWave' => [ 'name' => 'UpdateWave', 'http' => [ 'method' => 'POST', 'requestUri' => '/UpdateWave', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateWaveRequest', ], 'output' => [ 'shape' => 'Wave', ], 'errors' => [ [ 'shape' => 'UninitializedAccountException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], ], 'shapes' => [ 'ARN' => [ 'type' => 'string', 'max' => 2048, 'min' => 20, ], 'AccessDeniedException' => [ 'type' => 'structure', 'members' => [ 'code' => [ 'shape' => 'LargeBoundedString', ], 'message' => [ 'shape' => 'LargeBoundedString', ], ], 'error' => [ 'httpStatusCode' => 403, 'senderFault' => true, ], 'exception' => true, ], 'AccountID' => [ 'type' => 'string', 'max' => 12, 'min' => 12, 'pattern' => '[0-9]{12,}', ], 'ActionCategory' => [ 'type' => 'string', 'enum' => [ 'DISASTER_RECOVERY', 'OPERATING_SYSTEM', 'LICENSE_AND_SUBSCRIPTION', 'VALIDATION', 'OBSERVABILITY', 'REFACTORING', 'SECURITY', 'NETWORKING', 'CONFIGURATION', 'BACKUP', 'OTHER', ], ], 'ActionDescription' => [ 'type' => 'string', 'max' => 256, 'min' => 0, 'pattern' => '^[0-9a-zA-Z ():/.,\'-_#*; ]*$', ], 'ActionID' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[0-9a-zA-Z]$', ], 'ActionIDs' => [ 'type' => 'list', 'member' => [ 'shape' => 'ActionID', ], 'max' => 100, 'min' => 0, ], 'ActionName' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '^[^\\s\\x00]( *[^\\s\\x00])*$', ], 'Application' => [ 'type' => 'structure', 'members' => [ 'applicationAggregatedStatus' => [ 'shape' => 'ApplicationAggregatedStatus', ], 'applicationID' => [ 'shape' => 'ApplicationID', ], 'arn' => [ 'shape' => 'ARN', ], 'creationDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'description' => [ 'shape' => 'ApplicationDescription', ], 'isArchived' => [ 'shape' => 'Boolean', ], 'lastModifiedDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'name' => [ 'shape' => 'ApplicationName', ], 'tags' => [ 'shape' => 'TagsMap', ], 'waveID' => [ 'shape' => 'WaveID', ], ], ], 'ApplicationAggregatedStatus' => [ 'type' => 'structure', 'members' => [ 'healthStatus' => [ 'shape' => 'ApplicationHealthStatus', ], 'lastUpdateDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'progressStatus' => [ 'shape' => 'ApplicationProgressStatus', ], 'totalSourceServers' => [ 'shape' => 'PositiveInteger', ], ], ], 'ApplicationDescription' => [ 'type' => 'string', 'max' => 600, 'min' => 0, 'pattern' => '^[^\\x00]*$', ], 'ApplicationHealthStatus' => [ 'type' => 'string', 'enum' => [ 'HEALTHY', 'LAGGING', 'ERROR', ], ], 'ApplicationID' => [ 'type' => 'string', 'max' => 21, 'min' => 21, 'pattern' => '^app-[0-9a-zA-Z]{17}$', ], 'ApplicationIDs' => [ 'type' => 'list', 'member' => [ 'shape' => 'ApplicationID', ], 'max' => 50, 'min' => 1, ], 'ApplicationIDsFilter' => [ 'type' => 'list', 'member' => [ 'shape' => 'ApplicationID', ], 'max' => 200, 'min' => 0, ], 'ApplicationName' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '^[^\\s\\x00]( *[^\\s\\x00])*$', ], 'ApplicationProgressStatus' => [ 'type' => 'string', 'enum' => [ 'NOT_STARTED', 'IN_PROGRESS', 'COMPLETED', ], ], 'ApplicationsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Application', ], ], 'ArchiveApplicationRequest' => [ 'type' => 'structure', 'required' => [ 'applicationID', ], 'members' => [ 'accountID' => [ 'shape' => 'AccountID', ], 'applicationID' => [ 'shape' => 'ApplicationID', ], ], ], 'ArchiveWaveRequest' => [ 'type' => 'structure', 'required' => [ 'waveID', ], 'members' => [ 'accountID' => [ 'shape' => 'AccountID', ], 'waveID' => [ 'shape' => 'WaveID', ], ], ], 'AssociateApplicationsRequest' => [ 'type' => 'structure', 'required' => [ 'applicationIDs', 'waveID', ], 'members' => [ 'accountID' => [ 'shape' => 'AccountID', ], 'applicationIDs' => [ 'shape' => 'ApplicationIDs', ], 'waveID' => [ 'shape' => 'WaveID', ], ], ], 'AssociateApplicationsResponse' => [ 'type' => 'structure', 'members' => [], ], 'AssociateSourceServersRequest' => [ 'type' => 'structure', 'required' => [ 'applicationID', 'sourceServerIDs', ], 'members' => [ 'accountID' => [ 'shape' => 'AccountID', ], 'applicationID' => [ 'shape' => 'ApplicationID', ], 'sourceServerIDs' => [ 'shape' => 'AssociateSourceServersRequestSourceServerIDs', ], ], ], 'AssociateSourceServersRequestSourceServerIDs' => [ 'type' => 'list', 'member' => [ 'shape' => 'SourceServerID', ], 'max' => 50, 'min' => 1, ], 'AssociateSourceServersResponse' => [ 'type' => 'structure', 'members' => [], ], 'BandwidthThrottling' => [ 'type' => 'long', 'max' => 10000, 'min' => 0, ], 'Boolean' => [ 'type' => 'boolean', 'box' => true, ], 'BootMode' => [ 'type' => 'string', 'enum' => [ 'LEGACY_BIOS', 'UEFI', 'USE_SOURCE', ], ], 'BoundedString' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'CPU' => [ 'type' => 'structure', 'members' => [ 'cores' => [ 'shape' => 'PositiveInteger', ], 'modelName' => [ 'shape' => 'BoundedString', ], ], ], 'ChangeServerLifeCycleStateRequest' => [ 'type' => 'structure', 'required' => [ 'lifeCycle', 'sourceServerID', ], 'members' => [ 'accountID' => [ 'shape' => 'AccountID', ], 'lifeCycle' => [ 'shape' => 'ChangeServerLifeCycleStateSourceServerLifecycle', ], 'sourceServerID' => [ 'shape' => 'SourceServerID', ], ], ], 'ChangeServerLifeCycleStateSourceServerLifecycle' => [ 'type' => 'structure', 'required' => [ 'state', ], 'members' => [ 'state' => [ 'shape' => 'ChangeServerLifeCycleStateSourceServerLifecycleState', ], ], ], 'ChangeServerLifeCycleStateSourceServerLifecycleState' => [ 'type' => 'string', 'enum' => [ 'READY_FOR_TEST', 'READY_FOR_CUTOVER', 'CUTOVER', ], ], 'ClientIdempotencyToken' => [ 'type' => 'string', 'max' => 64, 'min' => 0, ], 'CloudWatchLogGroupName' => [ 'type' => 'string', 'max' => 512, 'min' => 1, 'pattern' => '^[\\.\\-_/#A-Za-z0-9]+$', ], 'ConflictException' => [ 'type' => 'structure', 'members' => [ 'code' => [ 'shape' => 'LargeBoundedString', ], 'errors' => [ 'shape' => 'ConflictExceptionErrors', ], 'message' => [ 'shape' => 'LargeBoundedString', ], 'resourceId' => [ 'shape' => 'LargeBoundedString', ], 'resourceType' => [ 'shape' => 'LargeBoundedString', ], ], 'error' => [ 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'ConflictExceptionErrors' => [ 'type' => 'list', 'member' => [ 'shape' => 'ErrorDetails', ], ], 'Connector' => [ 'type' => 'structure', 'members' => [ 'arn' => [ 'shape' => 'ARN', ], 'connectorID' => [ 'shape' => 'ConnectorID', ], 'name' => [ 'shape' => 'ConnectorName', ], 'ssmCommandConfig' => [ 'shape' => 'ConnectorSsmCommandConfig', ], 'ssmInstanceID' => [ 'shape' => 'SsmInstanceID', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'ConnectorArn' => [ 'type' => 'string', 'max' => 100, 'min' => 27, 'pattern' => '^arn:[\\w-]+:mgn:([a-z]{2}-(gov-)?[a-z]+-\\d{1})?:(\\d{12})?:connector\\/(connector-[0-9a-zA-Z]{17})$', ], 'ConnectorID' => [ 'type' => 'string', 'max' => 27, 'min' => 27, 'pattern' => '^connector-[0-9a-zA-Z]{17}$', ], 'ConnectorIDsFilter' => [ 'type' => 'list', 'member' => [ 'shape' => 'ConnectorID', ], 'max' => 20, 'min' => 0, ], 'ConnectorName' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '^[A-Za-z0-9_-]+$', ], 'ConnectorSsmCommandConfig' => [ 'type' => 'structure', 'required' => [ 'cloudWatchOutputEnabled', 's3OutputEnabled', ], 'members' => [ 'cloudWatchLogGroupName' => [ 'shape' => 'CloudWatchLogGroupName', ], 'cloudWatchOutputEnabled' => [ 'shape' => 'Boolean', ], 'outputS3BucketName' => [ 'shape' => 'S3BucketName', ], 's3OutputEnabled' => [ 'shape' => 'Boolean', ], ], ], 'ConnectorsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Connector', ], ], 'Cpus' => [ 'type' => 'list', 'member' => [ 'shape' => 'CPU', ], 'max' => 256, 'min' => 0, ], 'CreateApplicationRequest' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'accountID' => [ 'shape' => 'AccountID', ], 'description' => [ 'shape' => 'ApplicationDescription', ], 'name' => [ 'shape' => 'ApplicationName', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateConnectorRequest' => [ 'type' => 'structure', 'required' => [ 'name', 'ssmInstanceID', ], 'members' => [ 'name' => [ 'shape' => 'ConnectorName', ], 'ssmCommandConfig' => [ 'shape' => 'ConnectorSsmCommandConfig', ], 'ssmInstanceID' => [ 'shape' => 'SsmInstanceID', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateLaunchConfigurationTemplateRequest' => [ 'type' => 'structure', 'members' => [ 'associatePublicIpAddress' => [ 'shape' => 'Boolean', ], 'bootMode' => [ 'shape' => 'BootMode', ], 'copyPrivateIp' => [ 'shape' => 'Boolean', ], 'copyTags' => [ 'shape' => 'Boolean', ], 'enableMapAutoTagging' => [ 'shape' => 'Boolean', ], 'largeVolumeConf' => [ 'shape' => 'LaunchTemplateDiskConf', ], 'launchDisposition' => [ 'shape' => 'LaunchDisposition', ], 'licensing' => [ 'shape' => 'Licensing', ], 'mapAutoTaggingMpeID' => [ 'shape' => 'TagValue', ], 'postLaunchActions' => [ 'shape' => 'PostLaunchActions', ], 'smallVolumeConf' => [ 'shape' => 'LaunchTemplateDiskConf', ], 'smallVolumeMaxSize' => [ 'shape' => 'PositiveInteger', ], 'tags' => [ 'shape' => 'TagsMap', ], 'targetInstanceTypeRightSizingMethod' => [ 'shape' => 'TargetInstanceTypeRightSizingMethod', ], ], ], 'CreateReplicationConfigurationTemplateRequest' => [ 'type' => 'structure', 'required' => [ 'associateDefaultSecurityGroup', 'bandwidthThrottling', 'createPublicIP', 'dataPlaneRouting', 'defaultLargeStagingDiskType', 'ebsEncryption', 'replicationServerInstanceType', 'replicationServersSecurityGroupsIDs', 'stagingAreaSubnetId', 'stagingAreaTags', 'useDedicatedReplicationServer', ], 'members' => [ 'associateDefaultSecurityGroup' => [ 'shape' => 'Boolean', ], 'bandwidthThrottling' => [ 'shape' => 'BandwidthThrottling', ], 'createPublicIP' => [ 'shape' => 'Boolean', ], 'dataPlaneRouting' => [ 'shape' => 'ReplicationConfigurationDataPlaneRouting', ], 'defaultLargeStagingDiskType' => [ 'shape' => 'ReplicationConfigurationDefaultLargeStagingDiskType', ], 'ebsEncryption' => [ 'shape' => 'ReplicationConfigurationEbsEncryption', ], 'ebsEncryptionKeyArn' => [ 'shape' => 'ARN', ], 'replicationServerInstanceType' => [ 'shape' => 'EC2InstanceType', ], 'replicationServersSecurityGroupsIDs' => [ 'shape' => 'ReplicationServersSecurityGroupsIDs', ], 'stagingAreaSubnetId' => [ 'shape' => 'SubnetID', ], 'stagingAreaTags' => [ 'shape' => 'TagsMap', ], 'tags' => [ 'shape' => 'TagsMap', ], 'useDedicatedReplicationServer' => [ 'shape' => 'Boolean', ], 'useFipsEndpoint' => [ 'shape' => 'Boolean', ], ], ], 'CreateWaveRequest' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'accountID' => [ 'shape' => 'AccountID', ], 'description' => [ 'shape' => 'WaveDescription', ], 'name' => [ 'shape' => 'WaveName', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'DataReplicationError' => [ 'type' => 'structure', 'members' => [ 'error' => [ 'shape' => 'DataReplicationErrorString', ], 'rawError' => [ 'shape' => 'LargeBoundedString', ], ], ], 'DataReplicationErrorString' => [ 'type' => 'string', 'enum' => [ 'AGENT_NOT_SEEN', 'SNAPSHOTS_FAILURE', 'NOT_CONVERGING', 'UNSTABLE_NETWORK', 'FAILED_TO_CREATE_SECURITY_GROUP', 'FAILED_TO_LAUNCH_REPLICATION_SERVER', 'FAILED_TO_BOOT_REPLICATION_SERVER', 'FAILED_TO_AUTHENTICATE_WITH_SERVICE', 'FAILED_TO_DOWNLOAD_REPLICATION_SOFTWARE', 'FAILED_TO_CREATE_STAGING_DISKS', 'FAILED_TO_ATTACH_STAGING_DISKS', 'FAILED_TO_PAIR_REPLICATION_SERVER_WITH_AGENT', 'FAILED_TO_CONNECT_AGENT_TO_REPLICATION_SERVER', 'FAILED_TO_START_DATA_TRANSFER', 'UNSUPPORTED_VM_CONFIGURATION', 'LAST_SNAPSHOT_JOB_FAILED', ], ], 'DataReplicationInfo' => [ 'type' => 'structure', 'members' => [ 'dataReplicationError' => [ 'shape' => 'DataReplicationError', ], 'dataReplicationInitiation' => [ 'shape' => 'DataReplicationInitiation', ], 'dataReplicationState' => [ 'shape' => 'DataReplicationState', ], 'etaDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'lagDuration' => [ 'shape' => 'ISO8601DurationString', ], 'lastSnapshotDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'replicatedDisks' => [ 'shape' => 'DataReplicationInfoReplicatedDisks', ], ], ], 'DataReplicationInfoReplicatedDisk' => [ 'type' => 'structure', 'members' => [ 'backloggedStorageBytes' => [ 'shape' => 'PositiveInteger', ], 'deviceName' => [ 'shape' => 'BoundedString', ], 'replicatedStorageBytes' => [ 'shape' => 'PositiveInteger', ], 'rescannedStorageBytes' => [ 'shape' => 'PositiveInteger', ], 'totalStorageBytes' => [ 'shape' => 'PositiveInteger', ], ], ], 'DataReplicationInfoReplicatedDisks' => [ 'type' => 'list', 'member' => [ 'shape' => 'DataReplicationInfoReplicatedDisk', ], 'max' => 60, 'min' => 0, ], 'DataReplicationInitiation' => [ 'type' => 'structure', 'members' => [ 'nextAttemptDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'startDateTime' => [ 'shape' => 'ISO8601DatetimeString', ], 'steps' => [ 'shape' => 'DataReplicationInitiationSteps', ], ], ], 'DataReplicationInitiationStep' => [ 'type' => 'structure', 'members' => [ 'name' => [ 'shape' => 'DataReplicationInitiationStepName', ], 'status' => [ 'shape' => 'DataReplicationInitiationStepStatus', ], ], ], 'DataReplicationInitiationStepName' => [ 'type' => 'string', 'enum' => [ 'WAIT', 'CREATE_SECURITY_GROUP', 'LAUNCH_REPLICATION_SERVER', 'BOOT_REPLICATION_SERVER', 'AUTHENTICATE_WITH_SERVICE', 'DOWNLOAD_REPLICATION_SOFTWARE', 'CREATE_STAGING_DISKS', 'ATTACH_STAGING_DISKS', 'PAIR_REPLICATION_SERVER_WITH_AGENT', 'CONNECT_AGENT_TO_REPLICATION_SERVER', 'START_DATA_TRANSFER', ], ], 'DataReplicationInitiationStepStatus' => [ 'type' => 'string', 'enum' => [ 'NOT_STARTED', 'IN_PROGRESS', 'SUCCEEDED', 'FAILED', 'SKIPPED', ], ], 'DataReplicationInitiationSteps' => [ 'type' => 'list', 'member' => [ 'shape' => 'DataReplicationInitiationStep', ], ], 'DataReplicationState' => [ 'type' => 'string', 'enum' => [ 'STOPPED', 'INITIATING', 'INITIAL_SYNC', 'BACKLOG', 'CREATING_SNAPSHOT', 'CONTINUOUS', 'PAUSED', 'RESCAN', 'STALLED', 'DISCONNECTED', 'PENDING_SNAPSHOT_SHIPPING', 'SHIPPING_SNAPSHOT', ], ], 'DeleteApplicationRequest' => [ 'type' => 'structure', 'required' => [ 'applicationID', ], 'members' => [ 'accountID' => [ 'shape' => 'AccountID', ], 'applicationID' => [ 'shape' => 'ApplicationID', ], ], ], 'DeleteApplicationResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteConnectorRequest' => [ 'type' => 'structure', 'required' => [ 'connectorID', ], 'members' => [ 'connectorID' => [ 'shape' => 'ConnectorID', ], ], ], 'DeleteJobRequest' => [ 'type' => 'structure', 'required' => [ 'jobID', ], 'members' => [ 'accountID' => [ 'shape' => 'AccountID', ], 'jobID' => [ 'shape' => 'JobID', ], ], ], 'DeleteJobResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteL