<?php
// This file was auto-generated from sdk-root/src/data/networkmanager/2019-07-05/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2019-07-05', 'endpointPrefix' => 'networkmanager', 'jsonVersion' => '1.1', 'protocol' => 'rest-json', 'protocols' => [ 'rest-json', ], 'serviceAbbreviation' => 'NetworkManager', 'serviceFullName' => 'AWS Network Manager', 'serviceId' => 'NetworkManager', 'signatureVersion' => 'v4', 'signingName' => 'networkmanager', 'uid' => 'networkmanager-2019-07-05', 'auth' => [ 'aws.auth#sigv4', ], ], 'operations' => [ 'AcceptAttachment' => [ 'name' => 'AcceptAttachment', 'http' => [ 'method' => 'POST', 'requestUri' => '/attachments/{attachmentId}/accept', ], 'input' => [ 'shape' => 'AcceptAttachmentRequest', ], 'output' => [ 'shape' => 'AcceptAttachmentResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'AssociateConnectPeer' => [ 'name' => 'AssociateConnectPeer', 'http' => [ 'method' => 'POST', 'requestUri' => '/global-networks/{globalNetworkId}/connect-peer-associations', ], 'input' => [ 'shape' => 'AssociateConnectPeerRequest', ], 'output' => [ 'shape' => 'AssociateConnectPeerResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'AssociateCustomerGateway' => [ 'name' => 'AssociateCustomerGateway', 'http' => [ 'method' => 'POST', 'requestUri' => '/global-networks/{globalNetworkId}/customer-gateway-associations', ], 'input' => [ 'shape' => 'AssociateCustomerGatewayRequest', ], 'output' => [ 'shape' => 'AssociateCustomerGatewayResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'AssociateLink' => [ 'name' => 'AssociateLink', 'http' => [ 'method' => 'POST', 'requestUri' => '/global-networks/{globalNetworkId}/link-associations', ], 'input' => [ 'shape' => 'AssociateLinkRequest', ], 'output' => [ 'shape' => 'AssociateLinkResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'AssociateTransitGatewayConnectPeer' => [ 'name' => 'AssociateTransitGatewayConnectPeer', 'http' => [ 'method' => 'POST', 'requestUri' => '/global-networks/{globalNetworkId}/transit-gateway-connect-peer-associations', ], 'input' => [ 'shape' => 'AssociateTransitGatewayConnectPeerRequest', ], 'output' => [ 'shape' => 'AssociateTransitGatewayConnectPeerResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateConnectAttachment' => [ 'name' => 'CreateConnectAttachment', 'http' => [ 'method' => 'POST', 'requestUri' => '/connect-attachments', ], 'input' => [ 'shape' => 'CreateConnectAttachmentRequest', ], 'output' => [ 'shape' => 'CreateConnectAttachmentResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateConnectPeer' => [ 'name' => 'CreateConnectPeer', 'http' => [ 'method' => 'POST', 'requestUri' => '/connect-peers', ], 'input' => [ 'shape' => 'CreateConnectPeerRequest', ], 'output' => [ 'shape' => 'CreateConnectPeerResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateConnection' => [ 'name' => 'CreateConnection', 'http' => [ 'method' => 'POST', 'requestUri' => '/global-networks/{globalNetworkId}/connections', ], 'input' => [ 'shape' => 'CreateConnectionRequest', ], 'output' => [ 'shape' => 'CreateConnectionResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateCoreNetwork' => [ 'name' => 'CreateCoreNetwork', 'http' => [ 'method' => 'POST', 'requestUri' => '/core-networks', ], 'input' => [ 'shape' => 'CreateCoreNetworkRequest', ], 'output' => [ 'shape' => 'CreateCoreNetworkResponse', ], 'errors' => [ [ 'shape' => 'CoreNetworkPolicyException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateDevice' => [ 'name' => 'CreateDevice', 'http' => [ 'method' => 'POST', 'requestUri' => '/global-networks/{globalNetworkId}/devices', ], 'input' => [ 'shape' => 'CreateDeviceRequest', ], 'output' => [ 'shape' => 'CreateDeviceResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateGlobalNetwork' => [ 'name' => 'CreateGlobalNetwork', 'http' => [ 'method' => 'POST', 'requestUri' => '/global-networks', ], 'input' => [ 'shape' => 'CreateGlobalNetworkRequest', ], 'output' => [ 'shape' => 'CreateGlobalNetworkResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateLink' => [ 'name' => 'CreateLink', 'http' => [ 'method' => 'POST', 'requestUri' => '/global-networks/{globalNetworkId}/links', ], 'input' => [ 'shape' => 'CreateLinkRequest', ], 'output' => [ 'shape' => 'CreateLinkResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateSite' => [ 'name' => 'CreateSite', 'http' => [ 'method' => 'POST', 'requestUri' => '/global-networks/{globalNetworkId}/sites', ], 'input' => [ 'shape' => 'CreateSiteRequest', ], 'output' => [ 'shape' => 'CreateSiteResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateSiteToSiteVpnAttachment' => [ 'name' => 'CreateSiteToSiteVpnAttachment', 'http' => [ 'method' => 'POST', 'requestUri' => '/site-to-site-vpn-attachments', ], 'input' => [ 'shape' => 'CreateSiteToSiteVpnAttachmentRequest', ], 'output' => [ 'shape' => 'CreateSiteToSiteVpnAttachmentResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateTransitGatewayPeering' => [ 'name' => 'CreateTransitGatewayPeering', 'http' => [ 'method' => 'POST', 'requestUri' => '/transit-gateway-peerings', ], 'input' => [ 'shape' => 'CreateTransitGatewayPeeringRequest', ], 'output' => [ 'shape' => 'CreateTransitGatewayPeeringResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateTransitGatewayRouteTableAttachment' => [ 'name' => 'CreateTransitGatewayRouteTableAttachment', 'http' => [ 'method' => 'POST', 'requestUri' => '/transit-gateway-route-table-attachments', ], 'input' => [ 'shape' => 'CreateTransitGatewayRouteTableAttachmentRequest', ], 'output' => [ 'shape' => 'CreateTransitGatewayRouteTableAttachmentResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateVpcAttachment' => [ 'name' => 'CreateVpcAttachment', 'http' => [ 'method' => 'POST', 'requestUri' => '/vpc-attachments', ], 'input' => [ 'shape' => 'CreateVpcAttachmentRequest', ], 'output' => [ 'shape' => 'CreateVpcAttachmentResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteAttachment' => [ 'name' => 'DeleteAttachment', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/attachments/{attachmentId}', ], 'input' => [ 'shape' => 'DeleteAttachmentRequest', ], 'output' => [ 'shape' => 'DeleteAttachmentResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteConnectPeer' => [ 'name' => 'DeleteConnectPeer', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/connect-peers/{connectPeerId}', ], 'input' => [ 'shape' => 'DeleteConnectPeerRequest', ], 'output' => [ 'shape' => 'DeleteConnectPeerResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteConnection' => [ 'name' => 'DeleteConnection', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/global-networks/{globalNetworkId}/connections/{connectionId}', ], 'input' => [ 'shape' => 'DeleteConnectionRequest', ], 'output' => [ 'shape' => 'DeleteConnectionResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteCoreNetwork' => [ 'name' => 'DeleteCoreNetwork', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/core-networks/{coreNetworkId}', ], 'input' => [ 'shape' => 'DeleteCoreNetworkRequest', ], 'output' => [ 'shape' => 'DeleteCoreNetworkResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteCoreNetworkPolicyVersion' => [ 'name' => 'DeleteCoreNetworkPolicyVersion', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/core-networks/{coreNetworkId}/core-network-policy-versions/{policyVersionId}', ], 'input' => [ 'shape' => 'DeleteCoreNetworkPolicyVersionRequest', ], 'output' => [ 'shape' => 'DeleteCoreNetworkPolicyVersionResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ConflictException', ], ], ], 'DeleteDevice' => [ 'name' => 'DeleteDevice', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/global-networks/{globalNetworkId}/devices/{deviceId}', ], 'input' => [ 'shape' => 'DeleteDeviceRequest', ], 'output' => [ 'shape' => 'DeleteDeviceResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteGlobalNetwork' => [ 'name' => 'DeleteGlobalNetwork', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/global-networks/{globalNetworkId}', ], 'input' => [ 'shape' => 'DeleteGlobalNetworkRequest', ], 'output' => [ 'shape' => 'DeleteGlobalNetworkResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteLink' => [ 'name' => 'DeleteLink', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/global-networks/{globalNetworkId}/links/{linkId}', ], 'input' => [ 'shape' => 'DeleteLinkRequest', ], 'output' => [ 'shape' => 'DeleteLinkResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeletePeering' => [ 'name' => 'DeletePeering', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/peerings/{peeringId}', ], 'input' => [ 'shape' => 'DeletePeeringRequest', ], 'output' => [ 'shape' => 'DeletePeeringResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteResourcePolicy' => [ 'name' => 'DeleteResourcePolicy', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/resource-policy/{resourceArn}', ], 'input' => [ 'shape' => 'DeleteResourcePolicyRequest', ], 'output' => [ 'shape' => 'DeleteResourcePolicyResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteSite' => [ 'name' => 'DeleteSite', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/global-networks/{globalNetworkId}/sites/{siteId}', ], 'input' => [ 'shape' => 'DeleteSiteRequest', ], 'output' => [ 'shape' => 'DeleteSiteResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeregisterTransitGateway' => [ 'name' => 'DeregisterTransitGateway', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/global-networks/{globalNetworkId}/transit-gateway-registrations/{transitGatewayArn}', ], 'input' => [ 'shape' => 'DeregisterTransitGatewayRequest', ], 'output' => [ 'shape' => 'DeregisterTransitGatewayResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DescribeGlobalNetworks' => [ 'name' => 'DescribeGlobalNetworks', 'http' => [ 'method' => 'GET', 'requestUri' => '/global-networks', ], 'input' => [ 'shape' => 'DescribeGlobalNetworksRequest', ], 'output' => [ 'shape' => 'DescribeGlobalNetworksResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DisassociateConnectPeer' => [ 'name' => 'DisassociateConnectPeer', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/global-networks/{globalNetworkId}/connect-peer-associations/{connectPeerId}', ], 'input' => [ 'shape' => 'DisassociateConnectPeerRequest', ], 'output' => [ 'shape' => 'DisassociateConnectPeerResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DisassociateCustomerGateway' => [ 'name' => 'DisassociateCustomerGateway', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/global-networks/{globalNetworkId}/customer-gateway-associations/{customerGatewayArn}', ], 'input' => [ 'shape' => 'DisassociateCustomerGatewayRequest', ], 'output' => [ 'shape' => 'DisassociateCustomerGatewayResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DisassociateLink' => [ 'name' => 'DisassociateLink', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/global-networks/{globalNetworkId}/link-associations', ], 'input' => [ 'shape' => 'DisassociateLinkRequest', ], 'output' => [ 'shape' => 'DisassociateLinkResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DisassociateTransitGatewayConnectPeer' => [ 'name' => 'DisassociateTransitGatewayConnectPeer', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/global-networks/{globalNetworkId}/transit-gateway-connect-peer-associations/{transitGatewayConnectPeerArn}', ], 'input' => [ 'shape' => 'DisassociateTransitGatewayConnectPeerRequest', ], 'output' => [ 'shape' => 'DisassociateTransitGatewayConnectPeerResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ExecuteCoreNetworkChangeSet' => [ 'name' => 'ExecuteCoreNetworkChangeSet', 'http' => [ 'method' => 'POST', 'requestUri' => '/core-networks/{coreNetworkId}/core-network-change-sets/{policyVersionId}/execute', ], 'input' => [ 'shape' => 'ExecuteCoreNetworkChangeSetRequest', ], 'output' => [ 'shape' => 'ExecuteCoreNetworkChangeSetResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ConflictException', ], ], ], 'GetConnectAttachment' => [ 'name' => 'GetConnectAttachment', 'http' => [ 'method' => 'GET', 'requestUri' => '/connect-attachments/{attachmentId}', ], 'input' => [ 'shape' => 'GetConnectAttachmentRequest', ], 'output' => [ 'shape' => 'GetConnectAttachmentResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetConnectPeer' => [ 'name' => 'GetConnectPeer', 'http' => [ 'method' => 'GET', 'requestUri' => '/connect-peers/{connectPeerId}', ], 'input' => [ 'shape' => 'GetConnectPeerRequest', ], 'output' => [ 'shape' => 'GetConnectPeerResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetConnectPeerAssociations' => [ 'name' => 'GetConnectPeerAssociations', 'http' => [ 'method' => 'GET', 'requestUri' => '/global-networks/{globalNetworkId}/connect-peer-associations', ], 'input' => [ 'shape' => 'GetConnectPeerAssociationsRequest', ], 'output' => [ 'shape' => 'GetConnectPeerAssociationsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetConnections' => [ 'name' => 'GetConnections', 'http' => [ 'method' => 'GET', 'requestUri' => '/global-networks/{globalNetworkId}/connections', ], 'input' => [ 'shape' => 'GetConnectionsRequest', ], 'output' => [ 'shape' => 'GetConnectionsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetCoreNetwork' => [ 'name' => 'GetCoreNetwork', 'http' => [ 'method' => 'GET', 'requestUri' => '/core-networks/{coreNetworkId}', ], 'input' => [ 'shape' => 'GetCoreNetworkRequest', ], 'output' => [ 'shape' => 'GetCoreNetworkResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetCoreNetworkChangeEvents' => [ 'name' => 'GetCoreNetworkChangeEvents', 'http' => [ 'method' => 'GET', 'requestUri' => '/core-networks/{coreNetworkId}/core-network-change-events/{policyVersionId}', ], 'input' => [ 'shape' => 'GetCoreNetworkChangeEventsRequest', ], 'output' => [ 'shape' => 'GetCoreNetworkChangeEventsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetCoreNetworkChangeSet' => [ 'name' => 'GetCoreNetworkChangeSet', 'http' => [ 'method' => 'GET', 'requestUri' => '/core-networks/{coreNetworkId}/core-network-change-sets/{policyVersionId}', ], 'input' => [ 'shape' => 'GetCoreNetworkChangeSetRequest', ], 'output' => [ 'shape' => 'GetCoreNetworkChangeSetResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetCoreNetworkPolicy' => [ 'name' => 'GetCoreNetworkPolicy', 'http' => [ 'method' => 'GET', 'requestUri' => '/core-networks/{coreNetworkId}/core-network-policy', ], 'input' => [ 'shape' => 'GetCoreNetworkPolicyRequest', ], 'output' => [ 'shape' => 'GetCoreNetworkPolicyResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetCustomerGatewayAssociations' => [ 'name' => 'GetCustomerGatewayAssociations', 'http' => [ 'method' => 'GET', 'requestUri' => '/global-networks/{globalNetworkId}/customer-gateway-associations', ], 'input' => [ 'shape' => 'GetCustomerGatewayAssociationsRequest', ], 'output' => [ 'shape' => 'GetCustomerGatewayAssociationsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetDevices' => [ 'name' => 'GetDevices', 'http' => [ 'method' => 'GET', 'requestUri' => '/global-networks/{globalNetworkId}/devices', ], 'input' => [ 'shape' => 'GetDevicesRequest', ], 'output' => [ 'shape' => 'GetDevicesResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetLinkAssociations' => [ 'name' => 'GetLinkAssociations', 'http' => [ 'method' => 'GET', 'requestUri' => '/global-networks/{globalNetworkId}/link-associations', ], 'input' => [ 'shape' => 'GetLinkAssociationsRequest', ], 'output' => [ 'shape' => 'GetLinkAssociationsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetLinks' => [ 'name' => 'GetLinks', 'http' => [ 'method' => 'GET', 'requestUri' => '/global-networks/{globalNetworkId}/links', ], 'input' => [ 'shape' => 'GetLinksRequest', ], 'output' => [ 'shape' => 'GetLinksResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetNetworkResourceCounts' => [ 'name' => 'GetNetworkResourceCounts', 'http' => [ 'method' => 'GET', 'requestUri' => '/global-networks/{globalNetworkId}/network-resource-count', ], 'input' => [ 'shape' => 'GetNetworkResourceCountsRequest', ], 'output' => [ 'shape' => 'GetNetworkResourceCountsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetNetworkResourceRelationships' => [ 'name' => 'GetNetworkResourceRelationships', 'http' => [ 'method' => 'GET', 'requestUri' => '/global-networks/{globalNetworkId}/network-resource-relationships', ], 'input' => [ 'shape' => 'GetNetworkResourceRelationshipsRequest', ], 'output' => [ 'shape' => 'GetNetworkResourceRelationshipsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetNetworkResources' => [ 'name' => 'GetNetworkResources', 'http' => [ 'method' => 'GET', 'requestUri' => '/global-networks/{globalNetworkId}/network-resources', ], 'input' => [ 'shape' => 'GetNetworkResourcesRequest', ], 'output' => [ 'shape' => 'GetNetworkResourcesResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetNetworkRoutes' => [ 'name' => 'GetNetworkRoutes', 'http' => [ 'method' => 'POST', 'requestUri' => '/global-networks/{globalNetworkId}/network-routes', ], 'input' => [ 'shape' => 'GetNetworkRoutesRequest', ], 'output' => [ 'shape' => 'GetNetworkRoutesResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetNetworkTelemetry' => [ 'name' => 'GetNetworkTelemetry', 'http' => [ 'method' => 'GET', 'requestUri' => '/global-networks/{globalNetworkId}/network-telemetry', ], 'input' => [ 'shape' => 'GetNetworkTelemetryRequest', ], 'output' => [ 'shape' => 'GetNetworkTelemetryResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetResourcePolicy' => [ 'name' => 'GetResourcePolicy', 'http' => [ 'method' => 'GET', 'requestUri' => '/resource-policy/{resourceArn}', ], 'input' => [ 'shape' => 'GetResourcePolicyRequest', ], 'output' => [ 'shape' => 'GetResourcePolicyResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetRouteAnalysis' => [ 'name' => 'GetRouteAnalysis', 'http' => [ 'method' => 'GET', 'requestUri' => '/global-networks/{globalNetworkId}/route-analyses/{routeAnalysisId}', ], 'input' => [ 'shape' => 'GetRouteAnalysisRequest', ], 'output' => [ 'shape' => 'GetRouteAnalysisResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetSiteToSiteVpnAttachment' => [ 'name' => 'GetSiteToSiteVpnAttachment', 'http' => [ 'method' => 'GET', 'requestUri' => '/site-to-site-vpn-attachments/{attachmentId}', ], 'input' => [ 'shape' => 'GetSiteToSiteVpnAttachmentRequest', ], 'output' => [ 'shape' => 'GetSiteToSiteVpnAttachmentResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetSites' => [ 'name' => 'GetSites', 'http' => [ 'method' => 'GET', 'requestUri' => '/global-networks/{globalNetworkId}/sites', ], 'input' => [ 'shape' => 'GetSitesRequest', ], 'output' => [ 'shape' => 'GetSitesResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetTransitGatewayConnectPeerAssociations' => [ 'name' => 'GetTransitGatewayConnectPeerAssociations', 'http' => [ 'method' => 'GET', 'requestUri' => '/global-networks/{globalNetworkId}/transit-gateway-connect-peer-associations', ], 'input' => [ 'shape' => 'GetTransitGatewayConnectPeerAssociationsRequest', ], 'output' => [ 'shape' => 'GetTransitGatewayConnectPeerAssociationsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetTransitGatewayPeering' => [ 'name' => 'GetTransitGatewayPeering', 'http' => [ 'method' => 'GET', 'requestUri' => '/transit-gateway-peerings/{peeringId}', ], 'input' => [ 'shape' => 'GetTransitGatewayPeeringRequest', ], 'output' => [ 'shape' => 'GetTransitGatewayPeeringResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetTransitGatewayRegistrations' => [ 'name' => 'GetTransitGatewayRegistrations', 'http' => [ 'method' => 'GET', 'requestUri' => '/global-networks/{globalNetworkId}/transit-gateway-registrations', ], 'input' => [ 'shape' => 'GetTransitGatewayRegistrationsRequest', ], 'output' => [ 'shape' => 'GetTransitGatewayRegistrationsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetTransitGatewayRouteTableAttachment' => [ 'name' => 'GetTransitGatewayRouteTableAttachment', 'http' => [ 'method' => 'GET', 'requestUri' => '/transit-gateway-route-table-attachments/{attachmentId}', ], 'input' => [ 'shape' => 'GetTransitGatewayRouteTableAttachmentRequest', ], 'output' => [ 'shape' => 'GetTransitGatewayRouteTableAttachmentResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetVpcAttachment' => [ 'name' => 'GetVpcAttachment', 'http' => [ 'method' => 'GET', 'requestUri' => '/vpc-attachments/{attachmentId}', ], 'input' => [ 'shape' => 'GetVpcAttachmentRequest', ], 'output' => [ 'shape' => 'GetVpcAttachmentResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListAttachments' => [ 'name' => 'ListAttachments', 'http' => [ 'method' => 'GET', 'requestUri' => '/attachments', ], 'input' => [ 'shape' => 'ListAttachmentsRequest', ], 'output' => [ 'shape' => 'ListAttachmentsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListConnectPeers' => [ 'name' => 'ListConnectPeers', 'http' => [ 'method' => 'GET', 'requestUri' => '/connect-peers', ], 'input' => [ 'shape' => 'ListConnectPeersRequest', ], 'output' => [ 'shape' => 'ListConnectPeersResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListCoreNetworkPolicyVersions' => [ 'name' => 'ListCoreNetworkPolicyVersions', 'http' => [ 'method' => 'GET', 'requestUri' => '/core-networks/{coreNetworkId}/core-network-policy-versions', ], 'input' => [ 'shape' => 'ListCoreNetworkPolicyVersionsRequest', ], 'output' => [ 'shape' => 'ListCoreNetworkPolicyVersionsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListCoreNetworks' => [ 'name' => 'ListCoreNetworks', 'http' => [ 'method' => 'GET', 'requestUri' => '/core-networks', ], 'input' => [ 'shape' => 'ListCoreNetworksRequest', ], 'output' => [ 'shape' => 'ListCoreNetworksResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListOrganizationServiceAccessStatus' => [ 'name' => 'ListOrganizationServiceAccessStatus', 'http' => [ 'method' => 'GET', 'requestUri' => '/organizations/service-access', ], 'input' => [ 'shape' => 'ListOrganizationServiceAccessStatusRequest', ], 'output' => [ 'shape' => 'ListOrganizationServiceAccessStatusResponse', ], ], 'ListPeerings' => [ 'name' => 'ListPeerings', 'http' => [ 'method' => 'GET', 'requestUri' => '/peerings', ], 'input' => [ 'shape' => 'ListPeeringsRequest', ], 'output' => [ 'shape' => 'ListPeeringsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/tags/{resourceArn}', ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'PutCoreNetworkPolicy' => [ 'name' => 'PutCoreNetworkPolicy', 'http' => [ 'method' => 'POST', 'requestUri' => '/core-networks/{coreNetworkId}/core-network-policy', ], 'input' => [ 'shape' => 'PutCoreNetworkPolicyRequest', ], 'output' => [ 'shape' => 'PutCoreNetworkPolicyResponse', ], 'errors' => [ [ 'shape' => 'CoreNetworkPolicyException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ConflictException', ], ], ], 'PutResourcePolicy' => [ 'name' => 'PutResourcePolicy', 'http' => [ 'method' => 'POST', 'requestUri' => '/resource-policy/{resourceArn}', ], 'input' => [ 'shape' => 'PutResourcePolicyRequest', ], 'output' => [ 'shape' => 'PutResourcePolicyResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'RegisterTransitGateway' => [ 'name' => 'RegisterTransitGateway', 'http' => [ 'method' => 'POST', 'requestUri' => '/global-networks/{globalNetworkId}/transit-gateway-registrations', ], 'input' => [ 'shape' => 'RegisterTransitGatewayRequest', ], 'output' => [ 'shape' => 'RegisterTransitGatewayResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'RejectAttachment' => [ 'name' => 'RejectAttachment', 'http' => [ 'method' => 'POST', 'requestUri' => '/attachments/{attachmentId}/reject', ], 'input' => [ 'shape' => 'RejectAttachmentRequest', ], 'output' => [ 'shape' => 'RejectAttachmentResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'RestoreCoreNetworkPolicyVersion' => [ 'name' => 'RestoreCoreNetworkPolicyVersion', 'http' => [ 'method' => 'POST', 'requestUri' => '/core-networks/{coreNetworkId}/core-network-policy-versions/{policyVersionId}/restore', ], 'input' => [ 'shape' => 'RestoreCoreNetworkPolicyVersionRequest', ], 'output' => [ 'shape' => 'RestoreCoreNetworkPolicyVersionResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ConflictException', ], ], ], 'StartOrganizationServiceAccessUpdate' => [ 'name' => 'StartOrganizationServiceAccessUpdate', 'http' => [ 'method' => 'POST', 'requestUri' => '/organizations/service-access', ], 'input' => [ 'shape' => 'StartOrganizationServiceAccessUpdateRequest', ], 'output' => [ 'shape' => 'StartOrganizationServiceAccessUpdateResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'StartRouteAnalysis' => [ 'name' => 'StartRouteAnalysis', 'http' => [ 'method' => 'POST', 'requestUri' => '/global-networks/{globalNetworkId}/route-analyses', ], 'input' => [ 'shape' => 'StartRouteAnalysisRequest', ], 'output' => [ 'shape' => 'StartRouteAnalysisResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tags/{resourceArn}', ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'output' => [ 'shape' => 'TagResourceResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tags/{resourceArn}', ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'output' => [ 'shape' => 'UntagResourceResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UpdateConnection' => [ 'name' => 'UpdateConnection', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/global-networks/{globalNetworkId}/connections/{connectionId}', ], 'input' => [ 'shape' => 'UpdateConnectionRequest', ], 'output' => [ 'shape' => 'UpdateConnectionResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UpdateCoreNetwork' => [ 'name' => 'UpdateCoreNetwork', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/core-networks/{coreNetworkId}', ], 'input' => [ 'shape' => 'UpdateCoreNetworkRequest', ], 'output' => [ 'shape' => 'UpdateCoreNetworkResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UpdateDevice' => [ 'name' => 'UpdateDevice', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/global-networks/{globalNetworkId}/devices/{deviceId}', ], 'input' => [ 'shape' => 'UpdateDeviceRequest', ], 'output' => [ 'shape' => 'UpdateDeviceResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UpdateGlobalNetwork' => [ 'name' => 'UpdateGlobalNetwork', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/global-networks/{globalNetworkId}', ], 'input' => [ 'shape' => 'UpdateGlobalNetworkRequest', ], 'output' => [ 'shape' => 'UpdateGlobalNetworkResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UpdateLink' => [ 'name' => 'UpdateLink', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/global-networks/{globalNetworkId}/links/{linkId}', ], 'input' => [ 'shape' => 'UpdateLinkRequest', ], 'output' => [ 'shape' => 'UpdateLinkResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UpdateNetworkResourceMetadata' => [ 'name' => 'UpdateNetworkResourceMetadata', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/global-networks/{globalNetworkId}/network-resources/{resourceArn}/metadata', ], 'input' => [ 'shape' => 'UpdateNetworkResourceMetadataRequest', ], 'output' => [ 'shape' => 'UpdateNetworkResourceMetadataResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UpdateSite' => [ 'name' => 'UpdateSite', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/global-networks/{globalNetworkId}/sites/{siteId}', ], 'input' => [ 'shape' => 'UpdateSiteRequest', ], 'output' => [ 'shape' => 'UpdateSiteResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UpdateVpcAttachment' => [ 'name' => 'UpdateVpcAttachment', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/vpc-attachments/{attachmentId}', ], 'input' => [ 'shape' => 'UpdateVpcAttachmentRequest', ], 'output' => [ 'shape' => 'UpdateVpcAttachmentResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], ], 'shapes' => [ 'AWSAccountId' => [ 'type' => 'string', 'max' => 12, 'min' => 12, 'pattern' => '[\\s\\S]*', ], 'AWSLocation' => [ 'type' => 'structure', 'members' => [ 'Zone' => [ 'shape' => 'ConstrainedString', ], 'SubnetArn' => [ 'shape' => 'SubnetArn', ], ], ], 'AcceptAttachmentRequest' => [ 'type' => 'structure', 'required' => [ 'AttachmentId', ], 'members' => [ 'AttachmentId' => [ 'shape' => 'AttachmentId', 'location' => 'uri', 'locationName' => 'attachmentId', ], ], ], 'AcceptAttachmentResponse' => [ 'type' => 'structure', 'members' => [ 'Attachment' => [ 'shape' => 'Attachment', ], ], ], 'AccessDeniedException' => [ 'type' => 'structure', 'required' => [ 'Message', ], 'members' => [ 'Message' => [ 'shape' => 'ServerSideString', ], ], 'error' => [ 'httpStatusCode' => 403, ], 'exception' => true, ], 'AccountId' => [ 'type' => 'string', 'max' => 50, 'min' => 0, ], 'AccountStatus' => [ 'type' => 'structure', 'members' => [ 'AccountId' => [ 'shape' => 'AccountId', ], 'SLRDeploymentStatus' => [ 'shape' => 'SLRDeploymentStatus', ], ], ], 'AccountStatusList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AccountStatus', ], ], 'Action' => [ 'type' => 'string', 'max' => 50, 'min' => 0, ], 'AssociateConnectPeerRequest' => [ 'type' => 'structure', 'required' => [ 'GlobalNetworkId', 'ConnectPeerId', 'DeviceId', ], 'members' => [ 'GlobalNetworkId' => [ 'shape' => 'GlobalNetworkId', 'location' => 'uri', 'locationName' => 'globalNetworkId', ], 'ConnectPeerId' => [ 'shape' => 'ConnectPeerId', ], 'DeviceId' => [ 'shape' => 'DeviceId', ], 'LinkId' => [ 'shape' => 'LinkId', ], ], ], 'AssociateConnectPeerResponse' => [ 'type' => 'structure', 'members' => [ 'ConnectPeerAssociation' => [ 'shape' => 'ConnectPeerAssociation', ], ], ], 'AssociateCustomerGatewayRequest' => [ 'type' => 'structure', 'required' => [ 'CustomerGatewayArn', 'GlobalNetworkId', 'DeviceId', ], 'members' => [ 'CustomerGatewayArn' => [ 'shape' => 'CustomerGatewayArn', ], 'GlobalNetworkId' => [ 'shape' => 'GlobalNetworkId', 'location' => 'uri', 'locationName' => 'globalNetworkId', ], 'DeviceId' => [ 'shape' => 'DeviceId', ], 'LinkId' => [ 'shape' => 'LinkId', ], ], ], 'AssociateCustomerGatewayResponse' => [ 'type' => 'structure', 'members' => [ 'CustomerGatewayAssociation' => [ 'shape' => 'CustomerGatewayAssociation', ], ], ], 'AssociateLinkRequest' => [ 'type' => 'structure', 'required' => [ 'GlobalNetworkId', 'DeviceId', 'LinkId', ], 'members' => [ 'GlobalNetworkId' => [ 'shape' => 'GlobalNetworkId', 'location' => 'uri', 'locationName' => 'globalNetworkId', ], 'DeviceId' => [ 'shape' => 'DeviceId', ], 'LinkId' => [ 'shape' => 'LinkId', ], ], ], 'AssociateLinkResponse' => [ 'type' => 'structure', 'members' => [ 'LinkAssociation' => [ 'shape' => 'LinkAssociation', ], ], ], 'AssociateTransitGatewayConnectPeerRequest' => [ 'type' => 'structure', 'required' => [ 'GlobalNetworkId', 'TransitGatewayConnectPeerArn', 'DeviceId', ], 'members' => [ 'GlobalNetworkId' => [ 'shape' => 'GlobalNetworkId', 'location' => 'uri', 'locationName' => 'globalNetworkId', ], 'TransitGatewayConnectPeerArn' => [ 'shape' => 'TransitGatewayConnectPeerArn', ], 'DeviceId' => [ 'shape' => 'DeviceId', ], 'LinkId' => [ 'shape' => 'LinkId', ], ], ], 'AssociateTransitGatewayConnectPeerResponse' => [ 'type' => 'structure', 'members' => [ 'TransitGatewayConnectPeerAssociation' => [ 'shape' => 'TransitGatewayConnectPeerAssociation', ], ], ], 'Attachment' => [ '