<?php
// This file was auto-generated from sdk-root/src/data/securityhub/2018-10-26/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2018-10-26', 'endpointPrefix' => 'securityhub', 'jsonVersion' => '1.1', 'protocol' => 'rest-json', 'protocols' => [ 'rest-json', ], 'serviceFullName' => 'AWS SecurityHub', 'serviceId' => 'SecurityHub', 'signatureVersion' => 'v4', 'signingName' => 'securityhub', 'uid' => 'securityhub-2018-10-26', ], 'operations' => [ 'AcceptAdministratorInvitation' => [ 'name' => 'AcceptAdministratorInvitation', 'http' => [ 'method' => 'POST', 'requestUri' => '/administrator', ], 'input' => [ 'shape' => 'AcceptAdministratorInvitationRequest', ], 'output' => [ 'shape' => 'AcceptAdministratorInvitationResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidAccessException', ], ], ], 'AcceptInvitation' => [ 'name' => 'AcceptInvitation', 'http' => [ 'method' => 'POST', 'requestUri' => '/master', ], 'input' => [ 'shape' => 'AcceptInvitationRequest', ], 'output' => [ 'shape' => 'AcceptInvitationResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidAccessException', ], ], 'deprecated' => true, 'deprecatedMessage' => 'This API has been deprecated, use AcceptAdministratorInvitation API instead.', ], 'BatchDeleteAutomationRules' => [ 'name' => 'BatchDeleteAutomationRules', 'http' => [ 'method' => 'POST', 'requestUri' => '/automationrules/delete', ], 'input' => [ 'shape' => 'BatchDeleteAutomationRulesRequest', ], 'output' => [ 'shape' => 'BatchDeleteAutomationRulesResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'BatchDisableStandards' => [ 'name' => 'BatchDisableStandards', 'http' => [ 'method' => 'POST', 'requestUri' => '/standards/deregister', ], 'input' => [ 'shape' => 'BatchDisableStandardsRequest', ], 'output' => [ 'shape' => 'BatchDisableStandardsResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'BatchEnableStandards' => [ 'name' => 'BatchEnableStandards', 'http' => [ 'method' => 'POST', 'requestUri' => '/standards/register', ], 'input' => [ 'shape' => 'BatchEnableStandardsRequest', ], 'output' => [ 'shape' => 'BatchEnableStandardsResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'BatchGetAutomationRules' => [ 'name' => 'BatchGetAutomationRules', 'http' => [ 'method' => 'POST', 'requestUri' => '/automationrules/get', ], 'input' => [ 'shape' => 'BatchGetAutomationRulesRequest', ], 'output' => [ 'shape' => 'BatchGetAutomationRulesResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'BatchGetConfigurationPolicyAssociations' => [ 'name' => 'BatchGetConfigurationPolicyAssociations', 'http' => [ 'method' => 'POST', 'requestUri' => '/configurationPolicyAssociation/batchget', ], 'input' => [ 'shape' => 'BatchGetConfigurationPolicyAssociationsRequest', ], 'output' => [ 'shape' => 'BatchGetConfigurationPolicyAssociationsResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'BatchGetSecurityControls' => [ 'name' => 'BatchGetSecurityControls', 'http' => [ 'method' => 'POST', 'requestUri' => '/securityControls/batchGet', ], 'input' => [ 'shape' => 'BatchGetSecurityControlsRequest', ], 'output' => [ 'shape' => 'BatchGetSecurityControlsResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'InvalidInputException', ], ], ], 'BatchGetStandardsControlAssociations' => [ 'name' => 'BatchGetStandardsControlAssociations', 'http' => [ 'method' => 'POST', 'requestUri' => '/associations/batchGet', ], 'input' => [ 'shape' => 'BatchGetStandardsControlAssociationsRequest', ], 'output' => [ 'shape' => 'BatchGetStandardsControlAssociationsResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'InvalidInputException', ], ], ], 'BatchImportFindings' => [ 'name' => 'BatchImportFindings', 'http' => [ 'method' => 'POST', 'requestUri' => '/findings/import', ], 'input' => [ 'shape' => 'BatchImportFindingsRequest', ], 'output' => [ 'shape' => 'BatchImportFindingsResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'InvalidAccessException', ], ], ], 'BatchUpdateAutomationRules' => [ 'name' => 'BatchUpdateAutomationRules', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/automationrules/update', ], 'input' => [ 'shape' => 'BatchUpdateAutomationRulesRequest', ], 'output' => [ 'shape' => 'BatchUpdateAutomationRulesResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'BatchUpdateFindings' => [ 'name' => 'BatchUpdateFindings', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/findings/batchupdate', ], 'input' => [ 'shape' => 'BatchUpdateFindingsRequest', ], 'output' => [ 'shape' => 'BatchUpdateFindingsResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'InvalidAccessException', ], ], ], 'BatchUpdateStandardsControlAssociations' => [ 'name' => 'BatchUpdateStandardsControlAssociations', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/associations', ], 'input' => [ 'shape' => 'BatchUpdateStandardsControlAssociationsRequest', ], 'output' => [ 'shape' => 'BatchUpdateStandardsControlAssociationsResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'CreateActionTarget' => [ 'name' => 'CreateActionTarget', 'http' => [ 'method' => 'POST', 'requestUri' => '/actionTargets', ], 'input' => [ 'shape' => 'CreateActionTargetRequest', ], 'output' => [ 'shape' => 'CreateActionTargetResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceConflictException', ], ], ], 'CreateAutomationRule' => [ 'name' => 'CreateAutomationRule', 'http' => [ 'method' => 'POST', 'requestUri' => '/automationrules/create', ], 'input' => [ 'shape' => 'CreateAutomationRuleRequest', ], 'output' => [ 'shape' => 'CreateAutomationRuleResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'LimitExceededException', ], ], ], 'CreateConfigurationPolicy' => [ 'name' => 'CreateConfigurationPolicy', 'http' => [ 'method' => 'POST', 'requestUri' => '/configurationPolicy/create', ], 'input' => [ 'shape' => 'CreateConfigurationPolicyRequest', ], 'output' => [ 'shape' => 'CreateConfigurationPolicyResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceConflictException', ], ], ], 'CreateFindingAggregator' => [ 'name' => 'CreateFindingAggregator', 'http' => [ 'method' => 'POST', 'requestUri' => '/findingAggregator/create', ], 'input' => [ 'shape' => 'CreateFindingAggregatorRequest', ], 'output' => [ 'shape' => 'CreateFindingAggregatorResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InvalidInputException', ], ], ], 'CreateInsight' => [ 'name' => 'CreateInsight', 'http' => [ 'method' => 'POST', 'requestUri' => '/insights', ], 'input' => [ 'shape' => 'CreateInsightRequest', ], 'output' => [ 'shape' => 'CreateInsightResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'ResourceConflictException', ], ], ], 'CreateMembers' => [ 'name' => 'CreateMembers', 'http' => [ 'method' => 'POST', 'requestUri' => '/members', ], 'input' => [ 'shape' => 'CreateMembersRequest', ], 'output' => [ 'shape' => 'CreateMembersResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'ResourceConflictException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'DeclineInvitations' => [ 'name' => 'DeclineInvitations', 'http' => [ 'method' => 'POST', 'requestUri' => '/invitations/decline', ], 'input' => [ 'shape' => 'DeclineInvitationsRequest', ], 'output' => [ 'shape' => 'DeclineInvitationsResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'DeleteActionTarget' => [ 'name' => 'DeleteActionTarget', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/actionTargets/{ActionTargetArn+}', ], 'input' => [ 'shape' => 'DeleteActionTargetRequest', ], 'output' => [ 'shape' => 'DeleteActionTargetResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'DeleteConfigurationPolicy' => [ 'name' => 'DeleteConfigurationPolicy', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/configurationPolicy/{Identifier}', ], 'input' => [ 'shape' => 'DeleteConfigurationPolicyRequest', ], 'output' => [ 'shape' => 'DeleteConfigurationPolicyResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ResourceConflictException', ], ], ], 'DeleteFindingAggregator' => [ 'name' => 'DeleteFindingAggregator', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/findingAggregator/delete/{FindingAggregatorArn+}', ], 'input' => [ 'shape' => 'DeleteFindingAggregatorRequest', ], 'output' => [ 'shape' => 'DeleteFindingAggregatorResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'DeleteInsight' => [ 'name' => 'DeleteInsight', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/insights/{InsightArn+}', ], 'input' => [ 'shape' => 'DeleteInsightRequest', ], 'output' => [ 'shape' => 'DeleteInsightResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'DeleteInvitations' => [ 'name' => 'DeleteInvitations', 'http' => [ 'method' => 'POST', 'requestUri' => '/invitations/delete', ], 'input' => [ 'shape' => 'DeleteInvitationsRequest', ], 'output' => [ 'shape' => 'DeleteInvitationsResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidAccessException', ], ], ], 'DeleteMembers' => [ 'name' => 'DeleteMembers', 'http' => [ 'method' => 'POST', 'requestUri' => '/members/delete', ], 'input' => [ 'shape' => 'DeleteMembersRequest', ], 'output' => [ 'shape' => 'DeleteMembersResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'DescribeActionTargets' => [ 'name' => 'DescribeActionTargets', 'http' => [ 'method' => 'POST', 'requestUri' => '/actionTargets/get', ], 'input' => [ 'shape' => 'DescribeActionTargetsRequest', ], 'output' => [ 'shape' => 'DescribeActionTargetsResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'DescribeHub' => [ 'name' => 'DescribeHub', 'http' => [ 'method' => 'GET', 'requestUri' => '/accounts', ], 'input' => [ 'shape' => 'DescribeHubRequest', ], 'output' => [ 'shape' => 'DescribeHubResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'DescribeOrganizationConfiguration' => [ 'name' => 'DescribeOrganizationConfiguration', 'http' => [ 'method' => 'GET', 'requestUri' => '/organization/configuration', ], 'input' => [ 'shape' => 'DescribeOrganizationConfigurationRequest', ], 'output' => [ 'shape' => 'DescribeOrganizationConfigurationResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], ], ], 'DescribeProducts' => [ 'name' => 'DescribeProducts', 'http' => [ 'method' => 'GET', 'requestUri' => '/products', ], 'input' => [ 'shape' => 'DescribeProductsRequest', ], 'output' => [ 'shape' => 'DescribeProductsResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'InvalidInputException', ], ], ], 'DescribeStandards' => [ 'name' => 'DescribeStandards', 'http' => [ 'method' => 'GET', 'requestUri' => '/standards', ], 'input' => [ 'shape' => 'DescribeStandardsRequest', ], 'output' => [ 'shape' => 'DescribeStandardsResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], ], ], 'DescribeStandardsControls' => [ 'name' => 'DescribeStandardsControls', 'http' => [ 'method' => 'GET', 'requestUri' => '/standards/controls/{StandardsSubscriptionArn+}', ], 'input' => [ 'shape' => 'DescribeStandardsControlsRequest', ], 'output' => [ 'shape' => 'DescribeStandardsControlsResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'DisableImportFindingsForProduct' => [ 'name' => 'DisableImportFindingsForProduct', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/productSubscriptions/{ProductSubscriptionArn+}', ], 'input' => [ 'shape' => 'DisableImportFindingsForProductRequest', ], 'output' => [ 'shape' => 'DisableImportFindingsForProductResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], ], ], 'DisableOrganizationAdminAccount' => [ 'name' => 'DisableOrganizationAdminAccount', 'http' => [ 'method' => 'POST', 'requestUri' => '/organization/admin/disable', ], 'input' => [ 'shape' => 'DisableOrganizationAdminAccountRequest', ], 'output' => [ 'shape' => 'DisableOrganizationAdminAccountResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'DisableSecurityHub' => [ 'name' => 'DisableSecurityHub', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/accounts', ], 'input' => [ 'shape' => 'DisableSecurityHubRequest', ], 'output' => [ 'shape' => 'DisableSecurityHubResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'DisassociateFromAdministratorAccount' => [ 'name' => 'DisassociateFromAdministratorAccount', 'http' => [ 'method' => 'POST', 'requestUri' => '/administrator/disassociate', ], 'input' => [ 'shape' => 'DisassociateFromAdministratorAccountRequest', ], 'output' => [ 'shape' => 'DisassociateFromAdministratorAccountResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'DisassociateFromMasterAccount' => [ 'name' => 'DisassociateFromMasterAccount', 'http' => [ 'method' => 'POST', 'requestUri' => '/master/disassociate', ], 'input' => [ 'shape' => 'DisassociateFromMasterAccountRequest', ], 'output' => [ 'shape' => 'DisassociateFromMasterAccountResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'deprecated' => true, 'deprecatedMessage' => 'This API has been deprecated, use DisassociateFromAdministratorAccount API instead.', ], 'DisassociateMembers' => [ 'name' => 'DisassociateMembers', 'http' => [ 'method' => 'POST', 'requestUri' => '/members/disassociate', ], 'input' => [ 'shape' => 'DisassociateMembersRequest', ], 'output' => [ 'shape' => 'DisassociateMembersResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'EnableImportFindingsForProduct' => [ 'name' => 'EnableImportFindingsForProduct', 'http' => [ 'method' => 'POST', 'requestUri' => '/productSubscriptions', ], 'input' => [ 'shape' => 'EnableImportFindingsForProductRequest', ], 'output' => [ 'shape' => 'EnableImportFindingsForProductResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'ResourceConflictException', ], [ 'shape' => 'LimitExceededException', ], ], ], 'EnableOrganizationAdminAccount' => [ 'name' => 'EnableOrganizationAdminAccount', 'http' => [ 'method' => 'POST', 'requestUri' => '/organization/admin/enable', ], 'input' => [ 'shape' => 'EnableOrganizationAdminAccountRequest', ], 'output' => [ 'shape' => 'EnableOrganizationAdminAccountResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'EnableSecurityHub' => [ 'name' => 'EnableSecurityHub', 'http' => [ 'method' => 'POST', 'requestUri' => '/accounts', ], 'input' => [ 'shape' => 'EnableSecurityHubRequest', ], 'output' => [ 'shape' => 'EnableSecurityHubResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'ResourceConflictException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'GetAdministratorAccount' => [ 'name' => 'GetAdministratorAccount', 'http' => [ 'method' => 'GET', 'requestUri' => '/administrator', ], 'input' => [ 'shape' => 'GetAdministratorAccountRequest', ], 'output' => [ 'shape' => 'GetAdministratorAccountResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetConfigurationPolicy' => [ 'name' => 'GetConfigurationPolicy', 'http' => [ 'method' => 'GET', 'requestUri' => '/configurationPolicy/get/{Identifier}', ], 'input' => [ 'shape' => 'GetConfigurationPolicyRequest', ], 'output' => [ 'shape' => 'GetConfigurationPolicyResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'GetConfigurationPolicyAssociation' => [ 'name' => 'GetConfigurationPolicyAssociation', 'http' => [ 'method' => 'POST', 'requestUri' => '/configurationPolicyAssociation/get', ], 'input' => [ 'shape' => 'GetConfigurationPolicyAssociationRequest', ], 'output' => [ 'shape' => 'GetConfigurationPolicyAssociationResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'GetEnabledStandards' => [ 'name' => 'GetEnabledStandards', 'http' => [ 'method' => 'POST', 'requestUri' => '/standards/get', ], 'input' => [ 'shape' => 'GetEnabledStandardsRequest', ], 'output' => [ 'shape' => 'GetEnabledStandardsResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], ], ], 'GetFindingAggregator' => [ 'name' => 'GetFindingAggregator', 'http' => [ 'method' => 'GET', 'requestUri' => '/findingAggregator/get/{FindingAggregatorArn+}', ], 'input' => [ 'shape' => 'GetFindingAggregatorRequest', ], 'output' => [ 'shape' => 'GetFindingAggregatorResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetFindingHistory' => [ 'name' => 'GetFindingHistory', 'http' => [ 'method' => 'POST', 'requestUri' => '/findingHistory/get', ], 'input' => [ 'shape' => 'GetFindingHistoryRequest', ], 'output' => [ 'shape' => 'GetFindingHistoryResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], ], ], 'GetFindings' => [ 'name' => 'GetFindings', 'http' => [ 'method' => 'POST', 'requestUri' => '/findings', ], 'input' => [ 'shape' => 'GetFindingsRequest', ], 'output' => [ 'shape' => 'GetFindingsResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], ], ], 'GetInsightResults' => [ 'name' => 'GetInsightResults', 'http' => [ 'method' => 'GET', 'requestUri' => '/insights/results/{InsightArn+}', ], 'input' => [ 'shape' => 'GetInsightResultsRequest', ], 'output' => [ 'shape' => 'GetInsightResultsResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetInsights' => [ 'name' => 'GetInsights', 'http' => [ 'method' => 'POST', 'requestUri' => '/insights/get', ], 'input' => [ 'shape' => 'GetInsightsRequest', ], 'output' => [ 'shape' => 'GetInsightsResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetInvitationsCount' => [ 'name' => 'GetInvitationsCount', 'http' => [ 'method' => 'GET', 'requestUri' => '/invitations/count', ], 'input' => [ 'shape' => 'GetInvitationsCountRequest', ], 'output' => [ 'shape' => 'GetInvitationsCountResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], ], ], 'GetMasterAccount' => [ 'name' => 'GetMasterAccount', 'http' => [ 'method' => 'GET', 'requestUri' => '/master', ], 'input' => [ 'shape' => 'GetMasterAccountRequest', ], 'output' => [ 'shape' => 'GetMasterAccountResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'deprecated' => true, 'deprecatedMessage' => 'This API has been deprecated, use GetAdministratorAccount API instead.', ], 'GetMembers' => [ 'name' => 'GetMembers', 'http' => [ 'method' => 'POST', 'requestUri' => '/members/get', ], 'input' => [ 'shape' => 'GetMembersRequest', ], 'output' => [ 'shape' => 'GetMembersResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetSecurityControlDefinition' => [ 'name' => 'GetSecurityControlDefinition', 'http' => [ 'method' => 'GET', 'requestUri' => '/securityControl/definition', ], 'input' => [ 'shape' => 'GetSecurityControlDefinitionRequest', ], 'output' => [ 'shape' => 'GetSecurityControlDefinitionResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'InviteMembers' => [ 'name' => 'InviteMembers', 'http' => [ 'method' => 'POST', 'requestUri' => '/members/invite', ], 'input' => [ 'shape' => 'InviteMembersRequest', ], 'output' => [ 'shape' => 'InviteMembersResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListAutomationRules' => [ 'name' => 'ListAutomationRules', 'http' => [ 'method' => 'GET', 'requestUri' => '/automationrules/list', ], 'input' => [ 'shape' => 'ListAutomationRulesRequest', ], 'output' => [ 'shape' => 'ListAutomationRulesResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'LimitExceededException', ], ], ], 'ListConfigurationPolicies' => [ 'name' => 'ListConfigurationPolicies', 'http' => [ 'method' => 'GET', 'requestUri' => '/configurationPolicy/list', ], 'input' => [ 'shape' => 'ListConfigurationPoliciesRequest', ], 'output' => [ 'shape' => 'ListConfigurationPoliciesResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'ListConfigurationPolicyAssociations' => [ 'name' => 'ListConfigurationPolicyAssociations', 'http' => [ 'method' => 'POST', 'requestUri' => '/configurationPolicyAssociation/list', ], 'input' => [ 'shape' => 'ListConfigurationPolicyAssociationsRequest', ], 'output' => [ 'shape' => 'ListConfigurationPolicyAssociationsResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'ListEnabledProductsForImport' => [ 'name' => 'ListEnabledProductsForImport', 'http' => [ 'method' => 'GET', 'requestUri' => '/productSubscriptions', ], 'input' => [ 'shape' => 'ListEnabledProductsForImportRequest', ], 'output' => [ 'shape' => 'ListEnabledProductsForImportResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'InvalidAccessException', ], ], ], 'ListFindingAggregators' => [ 'name' => 'ListFindingAggregators', 'http' => [ 'method' => 'GET', 'requestUri' => '/findingAggregator/list', ], 'input' => [ 'shape' => 'ListFindingAggregatorsRequest', ], 'output' => [ 'shape' => 'ListFindingAggregatorsResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InvalidInputException', ], ], ], 'ListInvitations' => [ 'name' => 'ListInvitations', 'http' => [ 'method' => 'GET', 'requestUri' => '/invitations', ], 'input' => [ 'shape' => 'ListInvitationsRequest', ], 'output' => [ 'shape' => 'ListInvitationsResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], ], ], 'ListMembers' => [ 'name' => 'ListMembers', 'http' => [ 'method' => 'GET', 'requestUri' => '/members', ], 'input' => [ 'shape' => 'ListMembersRequest', ], 'output' => [ 'shape' => 'ListMembersResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], ], ], 'ListOrganizationAdminAccounts' => [ 'name' => 'ListOrganizationAdminAccounts', 'http' => [ 'method' => 'GET', 'requestUri' => '/organization/admin', ], 'input' => [ 'shape' => 'ListOrganizationAdminAccountsRequest', ], 'output' => [ 'shape' => 'ListOrganizationAdminAccountsResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], ], ], 'ListSecurityControlDefinitions' => [ 'name' => 'ListSecurityControlDefinitions', 'http' => [ 'method' => 'GET', 'requestUri' => '/securityControls/definitions', ], 'input' => [ 'shape' => 'ListSecurityControlDefinitionsRequest', ], 'output' => [ 'shape' => 'ListSecurityControlDefinitionsResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], ], ], 'ListStandardsControlAssociations' => [ 'name' => 'ListStandardsControlAssociations', 'http' => [ 'method' => 'GET', 'requestUri' => '/associations', ], 'input' => [ 'shape' => 'ListStandardsControlAssociationsRequest', ], 'output' => [ 'shape' => 'ListStandardsControlAssociationsResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'InvalidInputException', ], ], ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/tags/{ResourceArn}', ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'StartConfigurationPolicyAssociation' => [ 'name' => 'StartConfigurationPolicyAssociation', 'http' => [ 'method' => 'POST', 'requestUri' => '/configurationPolicyAssociation/associate', ], 'input' => [ 'shape' => 'StartConfigurationPolicyAssociationRequest', ], 'output' => [ 'shape' => 'StartConfigurationPolicyAssociationResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'StartConfigurationPolicyDisassociation' => [ 'name' => 'StartConfigurationPolicyDisassociation', 'http' => [ 'method' => 'POST', 'requestUri' => '/configurationPolicyAssociation/disassociate', ], 'input' => [ 'shape' => 'StartConfigurationPolicyDisassociationRequest', ], 'output' => [ 'shape' => 'StartConfigurationPolicyDisassociationResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tags/{ResourceArn}', ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'output' => [ 'shape' => 'TagResourceResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tags/{ResourceArn}', ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'output' => [ 'shape' => 'UntagResourceResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'UpdateActionTarget' => [ 'name' => 'UpdateActionTarget', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/actionTargets/{ActionTargetArn+}', ], 'input' => [ 'shape' => 'UpdateActionTargetRequest', ], 'output' => [ 'shape' => 'UpdateActionTargetResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'UpdateConfigurationPolicy' => [ 'name' => 'UpdateConfigurationPolicy', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/configurationPolicy/{Identifier}', ], 'input' => [ 'shape' => 'UpdateConfigurationPolicyRequest', ], 'output' => [ 'shape' => 'UpdateConfigurationPolicyResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceConflictException', ], ], ], 'UpdateFindingAggregator' => [ 'name' => 'UpdateFindingAggregator', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/findingAggregator/update', ], 'input' => [ 'shape' => 'UpdateFindingAggregatorRequest', ], 'output' => [ 'shape' => 'UpdateFindingAggregatorResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'UpdateFindings' => [ 'name' => 'UpdateFindings', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/findings', ], 'input' => [ 'shape' => 'UpdateFindingsRequest', ], 'output' => [ 'shape' => 'UpdateFindingsResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'UpdateInsight' => [ 'name' => 'UpdateInsight', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/insights/{InsightArn+}', ], 'input' => [ 'shape' => 'UpdateInsightRequest', ], 'output' => [ 'shape' => 'UpdateInsightResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'UpdateOrganizationConfiguration' => [ 'name' => 'UpdateOrganizationConfiguration', 'http' => [ 'method' => 'POST', 'requestUri' => '/organization/configuration', ], 'input' => [ 'shape' => 'UpdateOrganizationConfigurationRequest', ], 'output' => [ 'shape' => 'UpdateOrganizationConfigurationResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ResourceConflictException', ], ], ], 'UpdateSecurityControl' => [ 'name' => 'UpdateSecurityControl', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/securityControl/update', ], 'input' => [ 'shape' => 'UpdateSecurityControlRequest', ], 'output' => [ 'shape' => 'UpdateSecurityControlResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ResourceInUseException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ResourceInUseException', ], ], ], 'UpdateSecurityHubConfiguration' => [ 'name' => 'UpdateSecurityHubConfiguration', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/accounts', ], 'input' => [ 'shape' => 'UpdateSecurityHubConfigurationRequest', ], 'output' => [ 'shape' => 'UpdateSecurityHubConfigurationResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'UpdateStandardsControl' => [ 'name' => 'UpdateStandardsControl', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/standards/control/{StandardsControlArn+}', ], 'input' => [ 'shape' => 'UpdateStandardsControlRequest', ], 'output' => [ 'shape' => 'UpdateStandardsControlResponse', ], 'errors' => [ [ 'shape' => 'InternalException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'InvalidAccessException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], ], ], ], 'shapes' => [ 'AcceptAdministratorInvitationRequest' => [ 'type' => 'structure', 'required' => [ 'AdministratorId', 'InvitationId', ], 'members' => [ 'AdministratorId' => [ 'shape' => 'NonEmptyString', ], 'InvitationId' => [ 'shape' => 'NonEmptyString', ], ], ], 'AcceptAdministratorInvitationResponse' => [ 'type' => 'structure', 'members' => [], ], 'AcceptInvitationRequest' => [ 'type' => 'structure', 'required' => [ 'MasterId', 'InvitationId', ], 'members' => [ 'MasterId' => [ 'shape' => 'NonEmptyString', ], 'InvitationId' => [ 'shape' => 'NonEmptyString', ], ], ], 'AcceptInvitationResponse' => [ 'type' => 'structure', 'members' => [], ], 'AccessDeniedException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'NonEmptyString', ], 'Code' => [ 'shape' => 'NonEmptyString', ], ], 'error' => [ 'httpStatusCode' => 403, ], 'exception' => true, ], 'AccountDetails' => [ 'type' => 'structure', 'required' => [ 'AccountId', ], 'members' => [ 'AccountId' => [ 'shape' => 'AccountId', ], 'Email' => [ 'shape' => 'NonEmptyString', ], ], ], 'AccountDetailsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AccountDetails', ], 'max' => 50, 'min' => 1, ], 'AccountId' => [ 'type' => 'string', ], 'AccountIdList' => [ 'type' => 'list', 'member' => [ 'shape' => 'NonEmptyString', ], ], 'Action' => [ 'type' => 'structure', 'members' => [ 'ActionType' => [ 'shape' => 'NonEmptyString', ], 'NetworkConnectionAction' => [ 'shape' => 'NetworkConnectionAction', ], 'AwsApiCallAction' => [ 'shape' => 'AwsApiCallAction', ], 'DnsRequestAction' => [ 'shape' => 'DnsRequestAction', ], 'PortProbeAction' => [ 'shape' => 'PortProbeAction', ], ], ], 'ActionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AutomationRulesAction', ], 'max' => 1, 'min' => 1, ], 'ActionLocalIpDetails' => [ 'type' => 'structure', 'members' => [ 'IpAddressV4' => [ 'shape' => 'NonEmptyString', ], ], ], 'ActionLocalPortDetails' => [ 'type' => 'structure', 'members' => [ 'Port' => [ 'shape' => 'Integer', ], 'PortName' => [ 'shape' => 'NonEmptyString', ], ], ], 'ActionRemoteIpDetails' => [ 'type' => 'structure', 'members' => [ 'IpAddressV4' => [ 'shape' => 'NonEmptyString', ], 'Organization' => [ 'shape' => 'IpOrganizationDetails', ], 'Country' => [ 'shape' => 'Country', ], 'City' => [ 'shape' => 'City', ], 'GeoLocation' => [ 'shape' => 'GeoLocation', ], ], ], 'ActionRemotePortDetails' => [ 'type' => 'structure', 'members' => [ 'Port' => [ 'shape' => 'Integer', ], 'PortName' => [ 'shape' => 'NonEmptyString', ], ], ], 'ActionTarget' => [ 'type' => 'structure', 'required' => [ 'ActionTargetArn', 'Name', 'Description', ], 'members' => [ 'ActionTargetArn' => [ 'shape' => 'NonEmptyString', ], 'Name' => [ 'shape' => 'NonEmptyString', ], 'Description' => [ 'shape' => 'NonEmptyString', ], ], ], 'ActionTargetList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ActionTarget', ], ], 'Adjustment' => [ 'type' => 'structure', 'members' => [ 'Metric' => [ 'shape' => 'NonEmptyString', ], 'Reason' => [ 'shape' => 'NonEmptyString', ], ], ], 'AdjustmentList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Adjustment', ], ], 'AdminAccount' => [ 'type' => 'structure', 'members' => [ 'AccountId' => [ 'shape' => 'NonEmptyString', ], 'Status' => [ 'shape' => 'AdminStatus', ], ], ], 'AdminAccounts' => [ 'type' => 'list', 'member' => [ 'shape' => 'AdminAccount', ], ], 'AdminStatus' => [ 'type' => 'string', 'enum' => [ 'ENABLED', 'DISABLE_IN_PROGRESS', ], ], 'AdminsMaxResults' => [ 'type' => 'integer', 'max' => 10, 'min' => 1, ], 'AlphaNumericNonEmptyString' => [ 'type' => 'string', 'pattern' => '^([^\\u0000-\\u007F]|[-_ a-zA-Z0-9])+$', ], 'ArnList' => [ 'type' => 'list', 'member' => [ 'shape' => 'NonEmptyString', ], ], 'AssociatedStandard' => [ 'type' => 'structure', 'members' => [ 'StandardsId' => [ 'shape' => 'NonEmptyString', ], ], ], 'AssociatedStandardsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AssociatedStandard', ], ], 'AssociationFilters' => [ 'type' => 'structure', 'members' => [ 'ConfigurationPolicyId' => [ 'shape' => 'NonEmptyString', ], 'AssociationType' => [ 'shape' => 'AssociationType', ], 'AssociationStatus' => [ 'shape' => 'ConfigurationPolicyAssociationStatus', ], ], ], 'AssociationSetDetails' => [ 'type' => 'structure', 'members' => [ 'AssociationState' => [ 'shape' => 'AssociationStateDetails', ], 'GatewayId' => [ 'shape' => 'NonEmptyString', ], 'Main' => [ 'shape' => 'Boolean', ], 'RouteTableAssociationId' => [ 'shape' => 'NonEmptyString', ], 'RouteTableId' => [ 'shape' => 'NonEmptyString', ], 'SubnetId' => [ 'shape' => 'NonEmptyString', ], ], ], 'AssociationSetList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AssociationSetDetails', ], ], 'AssociationStateDetails' => [ 'type' => 'structure', 'members' => [ 'State' => [ 'shape' => 'NonEmptyString', ], 'StatusMessage' => [ 'shape' => 'NonEmptyString', ], ], ], 'AssociationStatus' => [ 'type' => 'string', 'enum' => [ 'ENABLED', 'DISABLED', ], ], 'AssociationType' => [ 'type' => 'string', 'enum' => [ 'INHERITED', 'APPLIED', ], ], 'AutoEnableStandards' => [ 'type' => 'string', 'enum' => [ 'NONE', 'DEFAULT', ], ], 'AutomationRulesAction' => [ 'type' => 'structure', 'members' => [ 'Type' => [ 'shape' => 'AutomationRulesActionType', ], 'FindingFieldsUpdate' => [ 'shape' => 'AutomationRulesFindingFieldsUpdate', ], ], ], 'AutomationRulesActionType' => [ 'type' => 'string', 'enum' => [ 'FINDING_FIELDS_UPDATE', ], ], 'AutomationRulesArnsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'NonEmptyString', ], 'max' => 100, 'min' => 1, ], 'AutomationRulesConfig' => [ 'type' => 'structure', 'members' => [ 'RuleArn' => [ 'shape' => 'NonEmptyString', ], 'RuleStatus' => [ 'shape' => 'RuleStatus', ], 'RuleOrder' => [ 'shape' => 'RuleOrderValue', ], 'RuleName' => [ 'shape' => 'NonEmptyString', ], 'Description' => [ 'shape' => 'NonEmptyString', ], 'IsTerminal' => [ 'shape' => 'Boolean', ], 'Criteria' => [ 'shape' => 'AutomationRulesFindingFilters', ], 'Actions' => [ 'shape' => 'ActionList', ], 'CreatedAt' => [ 'shape' => 'Timestamp', ], 'UpdatedAt' => [ 'shape' => 'Timestamp', ], 'CreatedBy' => [ 'shape' => 'NonEmptyString', ], ], ], 'AutomationRulesConfigList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AutomationRulesConfig', ], ], 'AutomationRulesFindingFieldsUpdate' => [ 'type' => 'structure', 'members' => [ 'Note' => [ 'shape' => 'NoteUpdate', ], 'Severity' => [ 'shape' => 'SeverityUpdate', ], 'VerificationState' => [ 'shape' => 'VerificationState', ], 'Confidence' => [ 'shape' => 'RatioScale', ], 'Criticality' => [ 'shape' => 'RatioScale', ], 'Types' => [ 'shape' => 'TypeList', ], 'UserDefinedFields' => [ 'shape' => 'FieldMap', ], 'Workflow' => [ 'shape' => 'WorkflowUpdate', ], 'RelatedFindings' => [ 'shape' => 'RelatedFindingList', ], ], ], 'AutomationRulesFindingFilters' => [ 'type' => 'structure', 'members' => [ 'ProductArn' => [ 'shape' => 'StringFilterList', ], 'AwsAccountId' => [ 'shape' => 'StringFilterList', ], 'Id' => [ 'shape' => 'StringFilterList', ], 'GeneratorId' => [ 'shape' => 'StringFilterList', ], 'Type' => [ 'shape' => 'StringFilterList', ], 'FirstObservedAt' => [ 'shape' => 'DateFilterList', ], 'LastObservedAt' => [ 'shape' => 'DateFilterList', ], 'CreatedAt' => [ 'shape' => 'DateFilterList', ], 'UpdatedAt' => [ 'shape' => 'DateFilterList', ], 'Confidence' => [ 'shape' => 'NumberFilterList', ], 'Criticality' => [ 'shape' => 'NumberFilterList', ], 'Title' => [ 'shape' => 'StringFilterList', ], 'Description' => [ 'shape' => 'StringFilterList', ], 'SourceUrl' => [ 'shape' => 'StringFilterList', ], 'ProductName' => [ 'shape' => 'StringFilterList', ], 'CompanyName' => [ 'shape' => 'StringFilterList', ], 'SeverityLabel' => [ 'shape' => 'StringFilterList', ], 'ResourceType' => [ 'shape' => 'StringFilterList', ], 'ResourceId' => [ 'shape' => 'StringFilterList', ], 'ResourcePartition' => [ 'shape' => 'StringFilterList', ], 'ResourceRegion' => [ 'shape' => 'StringFilterList', ], 'ResourceTags' => [ 'shape' => 'MapFilterList', ], 'ResourceDetailsOther' => [ 'shape' => 'MapFilterList', ], 'ComplianceStatus' => [ 'shape' => 'StringFilterList', ], 'ComplianceSecurityControlId' => [ 'shape' => 'StringFilterList', ], 'ComplianceAssociatedStandardsId' => [ 'shape' => 'StringFilterList', ], 'VerificationState' => [ 'shape' => 'StringFilterList', ], 'WorkflowStatus' => [ 'shape' => 'StringFilterList', ], 'RecordState' => [ 'shape' => 'StringFilterList', ], 'RelatedFindingsProductArn' => [ 'shape' => 'StringFilterList', ], 'RelatedFindingsId' => [ 'shape' => 'StringFilterList', ], 'NoteText' => [ 'shape' => 'StringFilterList', ], 'NoteUpdatedAt' => [ 'shape' => 'DateFilterList', ], 'NoteUpdatedBy' => [ 'shape' => 'StringFilterList', ], 'UserDefinedFields' => [ 'shape' => 'MapFilterList', ], 'ResourceApplicationArn' => [ 'shape' => 'StringFilterList', ], 'ResourceApplicationName' => [ 'shape' => 'StringFilterList', ], 'AwsAccountName' => [ 'shape' => 'StringFilterList', ], ], ], 'AutomationRulesMetadata' => [ 'type' => 'structure', 'members' => [ 'RuleArn' => [ 'shape' => 'NonEmptyString', ], 'RuleStatus' => [ 'shape' => 'RuleStatus', ], 'RuleOrder' => [ 'shape' => 'RuleOrderValue', ], 'RuleName' => [ 'shape' => 'NonEmptyString', ], 'Description' => [ 'shape' => 'NonEmptyString', ], 'IsTerminal' => [ 'shape' => 'Boolean', ], 'CreatedAt' => [ 'shape' => 'Timestamp', ], 'UpdatedAt' => [ 'shape' => 'Timestamp', ], 'CreatedBy' => [ 'shape' => 'NonEmptyString', ], ], ], 'AutomationRulesMetadataList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AutomationRulesMetadata', ], ], 'AvailabilityZone' => [ 'type' => 'structure', 'members' => [ 'ZoneName' => [ 'shape' => 'NonEmptyString', ], 'SubnetId' => [ 'shape' => 'NonEmptyString', ], ], ], 'AvailabilityZones' => [ 'type' => 'list', 'member' => [ 'shape' => 'AvailabilityZone', ], ], 'AwsAmazonMqBrokerDetails' => [ 'type' => 'structure', 'members' => [ 'AuthenticationStrategy' => [ 'shape' => 'NonEmptyString', ], 'AutoMinorVersionUpgrade' => [ 'shape' => 'Boolean', ], 'BrokerArn' => [ 'shape' => 'NonEmptyString', ], 'BrokerName' => [ 'shape' => 'NonEmptyString', ], 'DeploymentMode' => [ 'shape' => 'NonEmptyString', ], 'EncryptionOptions' => [ 'shape' => 'AwsAmazonMqBrokerEncryptionOptionsDetails', ], 'EngineType' => [ 'shape' => 'NonEmptyString', ], 'EngineVersion' => [ 'shape' => 'NonEmptyString', ], 'HostInstanceType' => [ 'shape' => 'NonEmptyString', ], 'BrokerId' => [ 'shape' => 'NonEmptyString', ], 'LdapServerMetadata' => [ 'shape' => 'AwsAmazonMqBrokerLdapServerMetadataDetails', ], 'Logs' => [ 'shape' => 'AwsAmazonMqBrokerLogsDetails', ], 'MaintenanceWindowStartTime' => [ 'shape' => 'AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails', ], 'PubliclyAccessible' => [ 'shape' => 'Boolean', ], 'SecurityGroups' => [ 'shape' => 'StringList', ], 'StorageType' => [ 'shape' => 'NonEmptyString', ], 'SubnetIds' => [ 'shape' => 'StringList', ], 'Users' => [ 'shape' => 'AwsAmazonMqBrokerUsersList', ], ], ], 'AwsAmazonMqBrokerEncryptionOptionsDetails' => [ 'type' => 'structure', 'members' => [ 'KmsKeyId' => [ 'shape' => 'NonEmptyString', ], 'UseAwsOwnedKey' => [ 'shape' => 'Boolean', ], ], ], 'AwsAmazonMqBrokerLdapServerMetadataDetails' => [ 'type' => 'structure', 'members' => [ 'Hosts' => [ 'shape' => 'StringList', ], 'RoleBase' => [ 'shape' => 'NonEmptyString', ], 'RoleName' => [ 'shape' => 'NonEmptyString', ], 'RoleSearchMatching' => [ 'shape' => 'NonEmptyString', ], 'RoleSearchSubtree' => [ 'shape' => 'Boolean', ], 'ServiceAccountUsername' => [ 'shape' => 'NonEmptyString', ], 'UserBase' => [ 'shape' => 'NonEmptyString', ], 'UserRoleName' => [ 'shape' => 'NonEmptyString', ], 'UserSearchMatching' => [ 'shape' => 'NonEmptyString', ], 'UserSearchSubtree' => [ 'shape' => 'Boolean', ], ], ], 'AwsAmazonMqBrokerLogsDetails' => [ 'type' => 'structure', 'members' => [ 'Audit' => [ 'shape' => 'Boolean', ], 'General' => [ 'shape' => 'Boolean', ], 'AuditLogGroup' => [ 'shape' => 'NonEmptyString', ], 'GeneralLogGroup' => [ 'shape' => 'NonEmptyString', ], 'Pending' => [ 'shape' => 'AwsAmazonMqBrokerLogsPendingDetails', ], ], ], 'AwsAmazonMqBrokerLogsPendingDetails' => [ 'type' => 'structure', 'members' => [ 'Audit' => [ 'shape' => 'Boolean', ], 'General' => [ 'shape' => 'Boolean', ], ], ], 'AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails' => [ 'type' => 'structure', 'members' => [ 'DayOfWeek' => [ 'shape' => 'NonEmptyString', ], 'TimeOfDay' => [ 'shape' => 'NonEmptyString', ], 'TimeZone' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsAmazonMqBrokerUsersDetails' => [ 'type' => 'structure', 'members' => [ 'PendingChange' => [ 'shape' => 'NonEmptyString', ], 'Username' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsAmazonMqBrokerUsersList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsAmazonMqBrokerUsersDetails', ], ], 'AwsApiCallAction' => [ 'type' => 'structure', 'members' => [ 'Api' => [ 'shape' => 'NonEmptyString', ], 'ServiceName' => [ 'shape' => 'NonEmptyString', ], 'CallerType' => [ 'shape' => 'NonEmptyString', ], 'RemoteIpDetails' => [ 'shape' => 'ActionRemoteIpDetails', ], 'DomainDetails' => [ 'shape' => 'AwsApiCallActionDomainDetails', ], 'AffectedResources' => [ 'shape' => 'FieldMap', ], 'FirstSeen' => [ 'shape' => 'NonEmptyString', ], 'LastSeen' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsApiCallActionDomainDetails' => [ 'type' => 'structure', 'members' => [ 'Domain' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsApiGatewayAccessLogSettings' => [ 'type' => 'structure', 'members' => [ 'Format' => [ 'shape' => 'NonEmptyString', ], 'DestinationArn' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsApiGatewayCanarySettings' => [ 'type' => 'structure', 'members' => [ 'PercentTraffic' => [ 'shape' => 'Double', ], 'DeploymentId' => [ 'shape' => 'NonEmptyString', ], 'StageVariableOverrides' => [ 'shape' => 'FieldMap', ], 'UseStageCache' => [ 'shape' => 'Boolean', ], ], ], 'AwsApiGatewayEndpointConfiguration' => [ 'type' => 'structure', 'members' => [ 'Types' => [ 'shape' => 'NonEmptyStringList', ], ], ], 'AwsApiGatewayMethodSettings' => [ 'type' => 'structure', 'members' => [ 'MetricsEnabled' => [ 'shape' => 'Boolean', ], 'LoggingLevel' => [ 'shape' => 'NonEmptyString', ], 'DataTraceEnabled' => [ 'shape' => 'Boolean', ], 'ThrottlingBurstLimit' => [ 'shape' => 'Integer', ], 'ThrottlingRateLimit' => [ 'shape' => 'Double', ], 'CachingEnabled' => [ 'shape' => 'Boolean', ], 'CacheTtlInSeconds' => [ 'shape' => 'Integer', ], 'CacheDataEncrypted' => [ 'shape' => 'Boolean', ], 'RequireAuthorizationForCacheControl' => [ 'shape' => 'Boolean', ], 'UnauthorizedCacheControlHeaderStrategy' => [ 'shape' => 'NonEmptyString', ], 'HttpMethod' => [ 'shape' => 'NonEmptyString', ], 'ResourcePath' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsApiGatewayMethodSettingsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsApiGatewayMethodSettings', ], ], 'AwsApiGatewayRestApiDetails' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'NonEmptyString', ], 'Name' => [ 'shape' => 'NonEmptyString', ], 'Description' => [ 'shape' => 'NonEmptyString', ], 'CreatedDate' => [ 'shape' => 'NonEmptyString', ], 'Version' => [ 'shape' => 'NonEmptyString', ], 'BinaryMediaTypes' => [ 'shape' => 'NonEmptyStringList', ], 'MinimumCompressionSize' => [ 'shape' => 'Integer', ], 'ApiKeySource' => [ 'shape' => 'NonEmptyString', ], 'EndpointConfiguration' => [ 'shape' => 'AwsApiGatewayEndpointConfiguration', ], ], ], 'AwsApiGatewayStageDetails' => [ 'type' => 'structure', 'members' => [ 'DeploymentId' => [ 'shape' => 'NonEmptyString', ], 'ClientCertificateId' => [ 'shape' => 'NonEmptyString', ], 'StageName' => [ 'shape' => 'NonEmptyString', ], 'Description' => [ 'shape' => 'NonEmptyString', ], 'CacheClusterEnabled' => [ 'shape' => 'Boolean', ], 'CacheClusterSize' => [ 'shape' => 'NonEmptyString', ], 'CacheClusterStatus' => [ 'shape' => 'NonEmptyString', ], 'MethodSettings' => [ 'shape' => 'AwsApiGatewayMethodSettingsList', ], 'Variables' => [ 'shape' => 'FieldMap', ], 'DocumentationVersion' => [ 'shape' => 'NonEmptyString', ], 'AccessLogSettings' => [ 'shape' => 'AwsApiGatewayAccessLogSettings', ], 'CanarySettings' => [ 'shape' => 'AwsApiGatewayCanarySettings', ], 'TracingEnabled' => [ 'shape' => 'Boolean', ], 'CreatedDate' => [ 'shape' => 'NonEmptyString', ], 'LastUpdatedDate' => [ 'shape' => 'NonEmptyString', ], 'WebAclArn' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsApiGatewayV2ApiDetails' => [ 'type' => 'structure', 'members' => [ 'ApiEndpoint' => [ 'shape' => 'NonEmptyString', ], 'ApiId' => [ 'shape' => 'NonEmptyString', ], 'ApiKeySelectionExpression' => [ 'shape' => 'NonEmptyString', ], 'CreatedDate' => [ 'shape' => 'NonEmptyString', ], 'Description' => [ 'shape' => 'NonEmptyString', ], 'Version' => [ 'shape' => 'NonEmptyString', ], 'Name' => [ 'shape' => 'NonEmptyString', ], 'ProtocolType' => [ 'shape' => 'NonEmptyString', ], 'RouteSelectionExpression' => [ 'shape' => 'NonEmptyString', ], 'CorsConfiguration' => [ 'shape' => 'AwsCorsConfiguration', ], ], ], 'AwsApiGatewayV2RouteSettings' => [ 'type' => 'structure', 'members' => [ 'DetailedMetricsEnabled' => [ 'shape' => 'Boolean', ], 'LoggingLevel' => [ 'shape' => 'NonEmptyString', ], 'DataTraceEnabled' => [ 'shape' => 'Boolean', ], 'ThrottlingBurstLimit' => [ 'shape' => 'Integer', ], 'ThrottlingRateLimit' => [ 'shape' => 'Double', ], ], ], 'AwsApiGatewayV2StageDetails' => [ 'type' => 'structure', 'members' => [ 'ClientCertificateId' => [ 'shape' => 'NonEmptyString', ], 'CreatedDate' => [ 'shape' => 'NonEmptyString', ], 'Description' => [ 'shape' => 'NonEmptyString', ], 'DefaultRouteSettings' => [ 'shape' => 'AwsApiGatewayV2RouteSettings', ], 'DeploymentId' => [ 'shape' => 'NonEmptyString', ], 'LastUpdatedDate' => [ 'shape' => 'NonEmptyString', ], 'RouteSettings' => [ 'shape' => 'AwsApiGatewayV2RouteSettings', ], 'StageName' => [ 'shape' => 'NonEmptyString', ], 'StageVariables' => [ 'shape' => 'FieldMap', ], 'AccessLogSettings' => [ 'shape' => 'AwsApiGatewayAccessLogSettings', ], 'AutoDeploy' => [ 'shape' => 'Boolean', ], 'LastDeploymentStatusMessage' => [ 'shape' => 'NonEmptyString', ], 'ApiGatewayManaged' => [ 'shape' => 'Boolean', ], ], ], 'AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails' => [ 'type' => 'structure', 'members' => [ 'AuthenticationType' => [ 'shape' => 'NonEmptyString', ], 'LambdaAuthorizerConfig' => [ 'shape' => 'AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails', ], 'OpenIdConnectConfig' => [ 'shape' => 'AwsAppSyncGraphQlApiOpenIdConnectConfigDetails', ], 'UserPoolConfig' => [ 'shape' => 'AwsAppSyncGraphQlApiUserPoolConfigDetails', ], ], ], 'AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails', ], ], 'AwsAppSyncGraphQlApiDetails' => [ 'type' => 'structure', 'members' => [ 'ApiId' => [ 'shape' => 'NonEmptyString', ], 'Id' => [ 'shape' => 'NonEmptyString', ], 'OpenIdConnectConfig' => [ 'shape' => 'AwsAppSyncGraphQlApiOpenIdConnectConfigDetails', ], 'Name' => [ 'shape' => 'NonEmptyString', ], 'LambdaAuthorizerConfig' => [ 'shape' => 'AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails', ], 'XrayEnabled' => [ 'shape' => 'Boolean', ], 'Arn' => [ 'shape' => 'NonEmptyString', ], 'UserPoolConfig' => [ 'shape' => 'AwsAppSyncGraphQlApiUserPoolConfigDetails', ], 'AuthenticationType' => [ 'shape' => 'NonEmptyString', ], 'LogConfig' => [ 'shape' => 'AwsAppSyncGraphQlApiLogConfigDetails', ], 'AdditionalAuthenticationProviders' => [ 'shape' => 'AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersList', ], 'WafWebAclArn' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails' => [ 'type' => 'structure', 'members' => [ 'AuthorizerResultTtlInSeconds' => [ 'shape' => 'Integer', ], 'AuthorizerUri' => [ 'shape' => 'NonEmptyString', ], 'IdentityValidationExpression' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsAppSyncGraphQlApiLogConfigDetails' => [ 'type' => 'structure', 'members' => [ 'CloudWatchLogsRoleArn' => [ 'shape' => 'NonEmptyString', ], 'ExcludeVerboseContent' => [ 'shape' => 'Boolean', ], 'FieldLogLevel' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsAppSyncGraphQlApiOpenIdConnectConfigDetails' => [ 'type' => 'structure', 'members' => [ 'AuthTtL' => [ 'shape' => 'Long', ], 'ClientId' => [ 'shape' => 'NonEmptyString', ], 'IatTtL' => [ 'shape' => 'Long', ], 'Issuer' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsAppSyncGraphQlApiUserPoolConfigDetails' => [ 'type' => 'structure', 'members' => [ 'AppIdClientRegex' => [ 'shape' => 'NonEmptyString', ], 'AwsRegion' => [ 'shape' => 'NonEmptyString', ], 'DefaultAction' => [ 'shape' => 'NonEmptyString', ], 'UserPoolId' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsAthenaWorkGroupConfigurationDetails' => [ 'type' => 'structure', 'members' => [ 'ResultConfiguration' => [ 'shape' => 'AwsAthenaWorkGroupConfigurationResultConfigurationDetails', ], ], ], 'AwsAthenaWorkGroupConfigurationResultConfigurationDetails' => [ 'type' => 'structure', 'members' => [ 'EncryptionConfiguration' => [ 'shape' => 'AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails', ], ], ], 'AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails' => [ 'type' => 'structure', 'members' => [ 'EncryptionOption' => [ 'shape' => 'NonEmptyString', ], 'KmsKey' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsAthenaWorkGroupDetails' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'NonEmptyString', ], 'Description' => [ 'shape' => 'NonEmptyString', ], 'State' => [ 'shape' => 'NonEmptyString', ], 'Configuration' => [ 'shape' => 'AwsAthenaWorkGroupConfigurationDetails', ], ], ], 'AwsAutoScalingAutoScalingGroupAvailabilityZonesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails', ], ], 'AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails' => [ 'type' => 'structure', 'members' => [ 'Value' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsAutoScalingAutoScalingGroupDetails' => [ 'type' => 'structure', 'members' => [ 'LaunchConfigurationName' => [ 'shape' => 'NonEmptyString', ], 'LoadBalancerNames' => [ 'shape' => 'StringList', ], 'HealthCheckType' => [ 'shape' => 'NonEmptyString', ], 'HealthCheckGracePeriod' => [ 'shape' => 'Integer', ], 'CreatedTime' => [ 'shape' => 'NonEmptyString', ], 'MixedInstancesPolicy' => [ 'shape' => 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails', ], 'AvailabilityZones' => [ 'shape' => 'AwsAutoScalingAutoScalingGroupAvailabilityZonesList', ], 'LaunchTemplate' => [ 'shape' => 'AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification', ], 'CapacityRebalance' => [ 'shape' => 'Boolean', ], ], ], 'AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification' => [ 'type' => 'structure', 'members' => [ 'LaunchTemplateId' => [ 'shape' => 'NonEmptyString', ], 'LaunchTemplateName' => [ 'shape' => 'NonEmptyString', ], 'Version' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails' => [ 'type' => 'structure', 'members' => [ 'InstancesDistribution' => [ 'shape' => 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails', ], 'LaunchTemplate' => [ 'shape' => 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails', ], ], ], 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails' => [ 'type' => 'structure', 'members' => [ 'OnDemandAllocationStrategy' => [ 'shape' => 'NonEmptyString', ], 'OnDemandBaseCapacity' => [ 'shape' => 'Integer', ], 'OnDemandPercentageAboveBaseCapacity' => [ 'shape' => 'Integer', ], 'SpotAllocationStrategy' => [ 'shape' => 'NonEmptyString', ], 'SpotInstancePools' => [ 'shape' => 'Integer', ], 'SpotMaxPrice' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails' => [ 'type' => 'structure', 'members' => [ 'LaunchTemplateSpecification' => [ 'shape' => 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification', ], 'Overrides' => [ 'shape' => 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesList', ], ], ], 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification' => [ 'type' => 'structure', 'members' => [ 'LaunchTemplateId' => [ 'shape' => 'NonEmptyString', ], 'LaunchTemplateName' => [ 'shape' => 'NonEmptyString', ], 'Version' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails', ], ], 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails' => [ 'type' => 'structure', 'members' => [ 'InstanceType' => [ 'shape' => 'NonEmptyString', ], 'WeightedCapacity' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails' => [ 'type' => 'structure', 'members' => [ 'DeviceName' => [ 'shape' => 'NonEmptyString', ], 'Ebs' => [ 'shape' => 'AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails', ], 'NoDevice' => [ 'shape' => 'Boolean', ], 'VirtualName' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails' => [ 'type' => 'structure', 'members' => [ 'DeleteOnTermination' => [ 'shape' => 'Boolean', ], 'Encrypted' => [ 'shape' => 'Boolean', ], 'Iops' => [ 'shape' => 'Integer', ], 'SnapshotId' => [ 'shape' => 'NonEmptyString', ], 'VolumeSize' => [ 'shape' => 'Integer', ], 'VolumeType' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsAutoScalingLaunchConfigurationBlockDeviceMappingsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails', ], ], 'AwsAutoScalingLaunchConfigurationDetails' => [ 'type' => 'structure', 'members' => [ 'AssociatePublicIpAddress' => [ 'shape' => 'Boolean', ], 'BlockDeviceMappings' => [ 'shape' => 'AwsAutoScalingLaunchConfigurationBlockDeviceMappingsList', ], 'ClassicLinkVpcId' => [ 'shape' => 'NonEmptyString', ], 'ClassicLinkVpcSecurityGroups' => [ 'shape' => 'NonEmptyStringList', ], 'CreatedTime' => [ 'shape' => 'NonEmptyString', ], 'EbsOptimized' => [ 'shape' => 'Boolean', ], 'IamInstanceProfile' => [ 'shape' => 'NonEmptyString', ], 'ImageId' => [ 'shape' => 'NonEmptyString', ], 'InstanceMonitoring' => [ 'shape' => 'AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails', ], 'InstanceType' => [ 'shape' => 'NonEmptyString', ], 'KernelId' => [ 'shape' => 'NonEmptyString', ], 'KeyName' => [ 'shape' => 'NonEmptyString', ], 'LaunchConfigurationName' => [ 'shape' => 'NonEmptyString', ], 'PlacementTenancy' => [ 'shape' => 'NonEmptyString', ], 'RamdiskId' => [ 'shape' => 'NonEmptyString', ], 'SecurityGroups' => [ 'shape' => 'NonEmptyStringList', ], 'SpotPrice' => [ 'shape' => 'NonEmptyString', ], 'UserData' => [ 'shape' => 'NonEmptyString', ], 'MetadataOptions' => [ 'shape' => 'AwsAutoScalingLaunchConfigurationMetadataOptions', ], ], ], 'AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails' => [ 'type' => 'structure', 'members' => [ 'Enabled' => [ 'shape' => 'Boolean', ], ], ], 'AwsAutoScalingLaunchConfigurationMetadataOptions' => [ 'type' => 'structure', 'members' => [ 'HttpEndpoint' => [ 'shape' => 'NonEmptyString', ], 'HttpPutResponseHopLimit' => [ 'shape' => 'Integer', ], 'HttpTokens' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsBackupBackupPlanAdvancedBackupSettingsDetails' => [ 'type' => 'structure', 'members' => [ 'BackupOptions' => [ 'shape' => 'FieldMap', ], 'ResourceType' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsBackupBackupPlanAdvancedBackupSettingsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsBackupBackupPlanAdvancedBackupSettingsDetails', ], ], 'AwsBackupBackupPlanBackupPlanDetails' => [ 'type' => 'structure', 'members' => [ 'BackupPlanName' => [ 'shape' => 'NonEmptyString', ], 'AdvancedBackupSettings' => [ 'shape' => 'AwsBackupBackupPlanAdvancedBackupSettingsList', ], 'BackupPlanRule' => [ 'shape' => 'AwsBackupBackupPlanRuleList', ], ], ], 'AwsBackupBackupPlanDetails' => [ 'type' => 'structure', 'members' => [ 'BackupPlan' => [ 'shape' => 'AwsBackupBackupPlanBackupPlanDetails', ], 'BackupPlanArn' => [ 'shape' => 'NonEmptyString', ], 'BackupPlanId' => [ 'shape' => 'NonEmptyString', ], 'VersionId' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsBackupBackupPlanLifecycleDetails' => [ 'type' => 'structure', 'members' => [ 'DeleteAfterDays' => [ 'shape' => 'Long', ], 'MoveToColdStorageAfterDays' => [ 'shape' => 'Long', ], ], ], 'AwsBackupBackupPlanRuleCopyActionsDetails' => [ 'type' => 'structure', 'members' => [ 'DestinationBackupVaultArn' => [ 'shape' => 'NonEmptyString', ], 'Lifecycle' => [ 'shape' => 'AwsBackupBackupPlanLifecycleDetails', ], ], ], 'AwsBackupBackupPlanRuleCopyActionsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsBackupBackupPlanRuleCopyActionsDetails', ], ], 'AwsBackupBackupPlanRuleDetails' => [ 'type' => 'structure', 'members' => [ 'TargetBackupVault' => [ 'shape' => 'NonEmptyString', ], 'StartWindowMinutes' => [ 'shape' => 'Long', ], 'ScheduleExpression' => [ 'shape' => 'NonEmptyString', ], 'RuleName' => [ 'shape' => 'NonEmptyString', ], 'RuleId' => [ 'shape' => 'NonEmptyString', ], 'EnableContinuousBackup' => [ 'shape' => 'Boolean', ], 'CompletionWindowMinutes' => [ 'shape' => 'Long', ], 'CopyActions' => [ 'shape' => 'AwsBackupBackupPlanRuleCopyActionsList', ], 'Lifecycle' => [ 'shape' => 'AwsBackupBackupPlanLifecycleDetails', ], ], ], 'AwsBackupBackupPlanRuleList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsBackupBackupPlanRuleDetails', ], ], 'AwsBackupBackupVaultDetails' => [ 'type' => 'structure', 'members' => [ 'BackupVaultArn' => [ 'shape' => 'NonEmptyString', ], 'BackupVaultName' => [ 'shape' => 'NonEmptyString', ], 'EncryptionKeyArn' => [ 'shape' => 'NonEmptyString', ], 'Notifications' => [ 'shape' => 'AwsBackupBackupVaultNotificationsDetails', ], 'AccessPolicy' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsBackupBackupVaultNotificationsDetails' => [ 'type' => 'structure', 'members' => [ 'BackupVaultEvents' => [ 'shape' => 'NonEmptyStringList', ], 'SnsTopicArn' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsBackupRecoveryPointCalculatedLifecycleDetails' => [ 'type' => 'structure', 'members' => [ 'DeleteAt' => [ 'shape' => 'NonEmptyString', ], 'MoveToColdStorageAt' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsBackupRecoveryPointCreatedByDetails' => [ 'type' => 'structure', 'members' => [ 'BackupPlanArn' => [ 'shape' => 'NonEmptyString', ], 'BackupPlanId' => [ 'shape' => 'NonEmptyString', ], 'BackupPlanVersion' => [ 'shape' => 'NonEmptyString', ], 'BackupRuleId' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsBackupRecoveryPointDetails' => [ 'type' => 'structure', 'members' => [ 'BackupSizeInBytes' => [ 'shape' => 'Long', ], 'BackupVaultArn' => [ 'shape' => 'NonEmptyString', ], 'BackupVaultName' => [ 'shape' => 'NonEmptyString', ], 'CalculatedLifecycle' => [ 'shape' => 'AwsBackupRecoveryPointCalculatedLifecycleDetails', ], 'CompletionDate' => [ 'shape' => 'NonEmptyString', ], 'CreatedBy' => [ 'shape' => 'AwsBackupRecoveryPointCreatedByDetails', ], 'CreationDate' => [ 'shape' => 'NonEmptyString', ], 'EncryptionKeyArn' => [ 'shape' => 'NonEmptyString', ], 'IamRoleArn' => [ 'shape' => 'NonEmptyString', ], 'IsEncrypted' => [ 'shape' => 'Boolean', ], 'LastRestoreTime' => [ 'shape' => 'NonEmptyString', ], 'Lifecycle' => [ 'shape' => 'AwsBackupRecoveryPointLifecycleDetails', ], 'RecoveryPointArn' => [ 'shape' => 'NonEmptyString', ], 'ResourceArn' => [ 'shape' => 'NonEmptyString', ], 'ResourceType' => [ 'shape' => 'NonEmptyString', ], 'SourceBackupVaultArn' => [ 'shape' => 'NonEmptyString', ], 'Status' => [ 'shape' => 'NonEmptyString', ], 'StatusMessage' => [ 'shape' => 'NonEmptyString', ], 'StorageClass' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsBackupRecoveryPointLifecycleDetails' => [ 'type' => 'structure', 'members' => [ 'DeleteAfterDays' => [ 'shape' => 'Long', ], 'MoveToColdStorageAfterDays' => [ 'shape' => 'Long', ], ], ], 'AwsCertificateManagerCertificateDetails' => [ 'type' => 'structure', 'members' => [ 'CertificateAuthorityArn' => [ 'shape' => 'NonEmptyString', ], 'CreatedAt' => [ 'shape' => 'NonEmptyString', ], 'DomainName' => [ 'shape' => 'NonEmptyString', ], 'DomainValidationOptions' => [ 'shape' => 'AwsCertificateManagerCertificateDomainValidationOptions', ], 'ExtendedKeyUsages' => [ 'shape' => 'AwsCertificateManagerCertificateExtendedKeyUsages', ], 'FailureReason' => [ 'shape' => 'NonEmptyString', ], 'ImportedAt' => [ 'shape' => 'NonEmptyString', ], 'InUseBy' => [ 'shape' => 'StringList', ], 'IssuedAt' => [ 'shape' => 'NonEmptyString', ], 'Issuer' => [ 'shape' => 'NonEmptyString', ], 'KeyAlgorithm' => [ 'shape' => 'NonEmptyString', ], 'KeyUsages' => [ 'shape' => 'AwsCertificateManagerCertificateKeyUsages', ], 'NotAfter' => [ 'shape' => 'NonEmptyString', ], 'NotBefore' => [ 'shape' => 'NonEmptyString', ], 'Options' => [ 'shape' => 'AwsCertificateManagerCertificateOptions', ], 'RenewalEligibility' => [ 'shape' => 'NonEmptyString', ], 'RenewalSummary' => [ 'shape' => 'AwsCertificateManagerCertificateRenewalSummary', ], 'Serial' => [ 'shape' => 'NonEmptyString', ], 'SignatureAlgorithm' => [ 'shape' => 'NonEmptyString', ], 'Status' => [ 'shape' => 'NonEmptyString', ], 'Subject' => [ 'shape' => 'NonEmptyString', ], 'SubjectAlternativeNames' => [ 'shape' => 'StringList', ], 'Type' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsCertificateManagerCertificateDomainValidationOption' => [ 'type' => 'structure', 'members' => [ 'DomainName' => [ 'shape' => 'NonEmptyString', ], 'ResourceRecord' => [ 'shape' => 'AwsCertificateManagerCertificateResourceRecord', ], 'ValidationDomain' => [ 'shape' => 'NonEmptyString', ], 'ValidationEmails' => [ 'shape' => 'StringList', ], 'ValidationMethod' => [ 'shape' => 'NonEmptyString', ], 'ValidationStatus' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsCertificateManagerCertificateDomainValidationOptions' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsCertificateManagerCertificateDomainValidationOption', ], ], 'AwsCertificateManagerCertificateExtendedKeyUsage' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'NonEmptyString', ], 'OId' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsCertificateManagerCertificateExtendedKeyUsages' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsCertificateManagerCertificateExtendedKeyUsage', ], ], 'AwsCertificateManagerCertificateKeyUsage' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsCertificateManagerCertificateKeyUsages' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsCertificateManagerCertificateKeyUsage', ], ], 'AwsCertificateManagerCertificateOptions' => [ 'type' => 'structure', 'members' => [ 'CertificateTransparencyLoggingPreference' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsCertificateManagerCertificateRenewalSummary' => [ 'type' => 'structure', 'members' => [ 'DomainValidationOptions' => [ 'shape' => 'AwsCertificateManagerCertificateDomainValidationOptions', ], 'RenewalStatus' => [ 'shape' => 'NonEmptyString', ], 'RenewalStatusReason' => [ 'shape' => 'NonEmptyString', ], 'UpdatedAt' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsCertificateManagerCertificateResourceRecord' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'NonEmptyString', ], 'Type' => [ 'shape' => 'NonEmptyString', ], 'Value' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsCloudFormationStackDetails' => [ 'type' => 'structure', 'members' => [ 'Capabilities' => [ 'shape' => 'NonEmptyStringList', ], 'CreationTime' => [ 'shape' => 'NonEmptyString', ], 'Description' => [ 'shape' => 'NonEmptyString', ], 'DisableRollback' => [ 'shape' => 'Boolean', ], 'DriftInformation' => [ 'shape' => 'AwsCloudFormationStackDriftInformationDetails', ], 'EnableTerminationProtection' => [ 'shape' => 'Boolean', ], 'LastUpdatedTime' => [ 'shape' => 'NonEmptyString', ], 'NotificationArns' => [ 'shape' => 'NonEmptyStringList', ], 'Outputs' => [ 'shape' => 'AwsCloudFormationStackOutputsList', ], 'RoleArn' => [ 'shape' => 'NonEmptyString', ], 'StackId' => [ 'shape' => 'NonEmptyString', ], 'StackName' => [ 'shape' => 'NonEmptyString', ], 'StackStatus' => [ 'shape' => 'NonEmptyString', ], 'StackStatusReason' => [ 'shape' => 'NonEmptyString', ], 'TimeoutInMinutes' => [ 'shape' => 'Integer', ], ], ], 'AwsCloudFormationStackDriftInformationDetails' => [ 'type' => 'structure', 'members' => [ 'StackDriftStatus' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsCloudFormationStackOutputsDetails' => [ 'type' => 'structure', 'members' => [ 'Description' => [ 'shape' => 'NonEmptyString', ], 'OutputKey' => [ 'shape' => 'NonEmptyString', ], 'OutputValue' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsCloudFormationStackOutputsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsCloudFormationStackOutputsDetails', ], ], 'AwsCloudFrontDistributionCacheBehavior' => [ 'type' => 'structure', 'members' => [ 'ViewerProtocolPolicy' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsCloudFrontDistributionCacheBehaviors' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'AwsCloudFrontDistributionCacheBehaviorsItemList', ], ], ], 'AwsCloudFrontDistributionCacheBehaviorsItemList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsCloudFrontDistributionCacheBehavior', ], ], 'AwsCloudFrontDistributionDefaultCacheBehavior' => [ 'type' => 'structure', 'members' => [ 'ViewerProtocolPolicy' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsCloudFrontDistributionDetails' => [ 'type' => 'structure', 'members' => [ 'CacheBehaviors' => [ 'shape' => 'AwsCloudFrontDistributionCacheBehaviors', ], 'DefaultCacheBehavior' => [ 'shape' => 'AwsCloudFrontDistributionDefaultCacheBehavior', ], 'DefaultRootObject' => [ 'shape' => 'NonEmptyString', ], 'DomainName' => [ 'shape' => 'NonEmptyString', ], 'ETag' => [ 'shape' => 'NonEmptyString', ], 'LastModifiedTime' => [ 'shape' => 'NonEmptyString', ], 'Logging' => [ 'shape' => 'AwsCloudFrontDistributionLogging', ], 'Origins' => [ 'shape' => 'AwsCloudFrontDistributionOrigins', ], 'OriginGroups' => [ 'shape' => 'AwsCloudFrontDistributionOriginGroups', ], 'ViewerCertificate' => [ 'shape' => 'AwsCloudFrontDistributionViewerCertificate', ], 'Status' => [ 'shape' => 'NonEmptyString', ], 'WebAclId' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsCloudFrontDistributionLogging' => [ 'type' => 'structure', 'members' => [ 'Bucket' => [ 'shape' => 'NonEmptyString', ], 'Enabled' => [ 'shape' => 'Boolean', ], 'IncludeCookies' => [ 'shape' => 'Boolean', ], 'Prefix' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsCloudFrontDistributionOriginCustomOriginConfig' => [ 'type' => 'structure', 'members' => [ 'HttpPort' => [ 'shape' => 'Integer', ], 'HttpsPort' => [ 'shape' => 'Integer', ], 'OriginKeepaliveTimeout' => [ 'shape' => 'Integer', ], 'OriginProtocolPolicy' => [ 'shape' => 'NonEmptyString', ], 'OriginReadTimeout' => [ 'shape' => 'Integer', ], 'OriginSslProtocols' => [ 'shape' => 'AwsCloudFrontDistributionOriginSslProtocols', ], ], ], 'AwsCloudFrontDistributionOriginGroup' => [ 'type' => 'structure', 'members' => [ 'FailoverCriteria' => [ 'shape' => 'AwsCloudFrontDistributionOriginGroupFailover', ], ], ], 'AwsCloudFrontDistributionOriginGroupFailover' => [ 'type' => 'structure', 'members' => [ 'StatusCodes' => [ 'shape' => 'AwsCloudFrontDistributionOriginGroupFailoverStatusCodes', ], ], ], 'AwsCloudFrontDistributionOriginGroupFailoverStatusCodes' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'AwsCloudFrontDistributionOriginGroupFailoverStatusCodesItemList', ], 'Quantity' => [ 'shape' => 'Integer', ], ], ], 'AwsCloudFrontDistributionOriginGroupFailoverStatusCodesItemList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Integer', ], ], 'AwsCloudFrontDistributionOriginGroups' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'AwsCloudFrontDistributionOriginGroupsItemList', ], ], ], 'AwsCloudFrontDistributionOriginGroupsItemList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsCloudFrontDistributionOriginGroup', ], ], 'AwsCloudFrontDistributionOriginItem' => [ 'type' => 'structure', 'members' => [ 'DomainName' => [ 'shape' => 'NonEmptyString', ], 'Id' => [ 'shape' => 'NonEmptyString', ], 'OriginPath' => [ 'shape' => 'NonEmptyString', ], 'S3OriginConfig' => [ 'shape' => 'AwsCloudFrontDistributionOriginS3OriginConfig', ], 'CustomOriginConfig' => [ 'shape' => 'AwsCloudFrontDistributionOriginCustomOriginConfig', ], ], ], 'AwsCloudFrontDistributionOriginItemList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsCloudFrontDistributionOriginItem', ], ], 'AwsCloudFrontDistributionOriginS3OriginConfig' => [ 'type' => 'structure', 'members' => [ 'OriginAccessIdentity' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsCloudFrontDistributionOriginSslProtocols' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'NonEmptyStringList', ], 'Quantity' => [ 'shape' => 'Integer', ], ], ], 'AwsCloudFrontDistributionOrigins' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'AwsCloudFrontDistributionOriginItemList', ], ], ], 'AwsCloudFrontDistributionViewerCertificate' => [ 'type' => 'structure', 'members' => [ 'AcmCertificateArn' => [ 'shape' => 'NonEmptyString', ], 'Certificate' => [ 'shape' => 'NonEmptyString', ], 'CertificateSource' => [ 'shape' => 'NonEmptyString', ], 'CloudFrontDefaultCertificate' => [ 'shape' => 'Boolean', ], 'IamCertificateId' => [ 'shape' => 'NonEmptyString', ], 'MinimumProtocolVersion' => [ 'shape' => 'NonEmptyString', ], 'SslSupportMethod' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsCloudTrailTrailDetails' => [ 'type' => 'structure', 'members' => [ 'CloudWatchLogsLogGroupArn' => [ 'shape' => 'NonEmptyString', ], 'CloudWatchLogsRoleArn' => [ 'shape' => 'NonEmptyString', ], 'HasCustomEventSelectors' => [ 'shape' => 'Boolean', ], 'HomeRegion' => [ 'shape' => 'NonEmptyString', ], 'IncludeGlobalServiceEvents' => [ 'shape' => 'Boolean', ], 'IsMultiRegionTrail' => [ 'shape' => 'Boolean', ], 'IsOrganizationTrail' => [ 'shape' => 'Boolean', ], 'KmsKeyId' => [ 'shape' => 'NonEmptyString', ], 'LogFileValidationEnabled' => [ 'shape' => 'Boolean', ], 'Name' => [ 'shape' => 'NonEmptyString', ], 'S3BucketName' => [ 'shape' => 'NonEmptyString', ], 'S3KeyPrefix' => [ 'shape' => 'NonEmptyString', ], 'SnsTopicArn' => [ 'shape' => 'NonEmptyString', ], 'SnsTopicName' => [ 'shape' => 'NonEmptyString', ], 'TrailArn' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsCloudWatchAlarmDetails' => [ 'type' => 'structure', 'members' => [ 'ActionsEnabled' => [ 'shape' => 'Boolean', ], 'AlarmActions' => [ 'shape' => 'NonEmptyStringList', ], 'AlarmArn' => [ 'shape' => 'NonEmptyString', ], 'AlarmConfigurationUpdatedTimestamp' => [ 'shape' => 'NonEmptyString', ], 'AlarmDescription' => [ 'shape' => 'NonEmptyString', ], 'AlarmName' => [ 'shape' => 'NonEmptyString', ], 'ComparisonOperator' => [ 'shape' => 'NonEmptyString', ], 'DatapointsToAlarm' => [ 'shape' => 'Integer', ], 'Dimensions' => [ 'shape' => 'AwsCloudWatchAlarmDimensionsList', ], 'EvaluateLowSampleCountPercentile' => [ 'shape' => 'NonEmptyString', ], 'EvaluationPeriods' => [ 'shape' => 'Integer', ], 'ExtendedStatistic' => [ 'shape' => 'NonEmptyString', ], 'InsufficientDataActions' => [ 'shape' => 'NonEmptyStringList', ], 'MetricName' => [ 'shape' => 'NonEmptyString', ], 'Namespace' => [ 'shape' => 'NonEmptyString', ], 'OkActions' => [ 'shape' => 'NonEmptyStringList', ], 'Period' => [ 'shape' => 'Integer', ], 'Statistic' => [ 'shape' => 'NonEmptyString', ], 'Threshold' => [ 'shape' => 'Double', ], 'ThresholdMetricId' => [ 'shape' => 'NonEmptyString', ], 'TreatMissingData' => [ 'shape' => 'NonEmptyString', ], 'Unit' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsCloudWatchAlarmDimensionsDetails' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'NonEmptyString', ], 'Value' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsCloudWatchAlarmDimensionsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsCloudWatchAlarmDimensionsDetails', ], ], 'AwsCodeBuildProjectArtifactsDetails' => [ 'type' => 'structure', 'members' => [ 'ArtifactIdentifier' => [ 'shape' => 'NonEmptyString', ], 'EncryptionDisabled' => [ 'shape' => 'Boolean', ], 'Location' => [ 'shape' => 'NonEmptyString', ], 'Name' => [ 'shape' => 'NonEmptyString', ], 'NamespaceType' => [ 'shape' => 'NonEmptyString', ], 'OverrideArtifactName' => [ 'shape' => 'Boolean', ], 'Packaging' => [ 'shape' => 'NonEmptyString', ], 'Path' => [ 'shape' => 'NonEmptyString', ], 'Type' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsCodeBuildProjectArtifactsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsCodeBuildProjectArtifactsDetails', ], ], 'AwsCodeBuildProjectDetails' => [ 'type' => 'structure', 'members' => [ 'EncryptionKey' => [ 'shape' => 'NonEmptyString', ], 'Artifacts' => [ 'shape' => 'AwsCodeBuildProjectArtifactsList', ], 'Environment' => [ 'shape' => 'AwsCodeBuildProjectEnvironment', ], 'Name' => [ 'shape' => 'NonEmptyString', ], 'Source' => [ 'shape' => 'AwsCodeBuildProjectSource', ], 'ServiceRole' => [ 'shape' => 'NonEmptyString', ], 'LogsConfig' => [ 'shape' => 'AwsCodeBuildProjectLogsConfigDetails', ], 'VpcConfig' => [ 'shape' => 'AwsCodeBuildProjectVpcConfig', ], 'SecondaryArtifacts' => [ 'shape' => 'AwsCodeBuildProjectArtifactsList', ], ], ], 'AwsCodeBuildProjectEnvironment' => [ 'type' => 'structure', 'members' => [ 'Certificate' => [ 'shape' => 'NonEmptyString', ], 'EnvironmentVariables' => [ 'shape' => 'AwsCodeBuildProjectEnvironmentEnvironmentVariablesList', ], 'PrivilegedMode' => [ 'shape' => 'Boolean', ], 'ImagePullCredentialsType' => [ 'shape' => 'NonEmptyString', ], 'RegistryCredential' => [ 'shape' => 'AwsCodeBuildProjectEnvironmentRegistryCredential', ], 'Type' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'NonEmptyString', ], 'Type' => [ 'shape' => 'NonEmptyString', ], 'Value' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsCodeBuildProjectEnvironmentEnvironmentVariablesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails', ], ], 'AwsCodeBuildProjectEnvironmentRegistryCredential' => [ 'type' => 'structure', 'members' => [ 'Credential' => [ 'shape' => 'NonEmptyString', ], 'CredentialProvider' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails' => [ 'type' => 'structure', 'members' => [ 'GroupName' => [ 'shape' => 'NonEmptyString', ], 'Status' => [ 'shape' => 'NonEmptyString', ], 'StreamName' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsCodeBuildProjectLogsConfigDetails' => [ 'type' => 'structure', 'members' => [ 'CloudWatchLogs' => [ 'shape' => 'AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails', ], 'S3Logs' => [ 'shape' => 'AwsCodeBuildProjectLogsConfigS3LogsDetails', ], ], ], 'AwsCodeBuildProjectLogsConfigS3LogsDetails' => [ 'type' => 'structure', 'members' => [ 'EncryptionDisabled' => [ 'shape' => 'Boolean', ], 'Location' => [ 'shape' => 'NonEmptyString', ], 'Status' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsCodeBuildProjectSource' => [ 'type' => 'structure', 'members' => [ 'Type' => [ 'shape' => 'NonEmptyString', ], 'Location' => [ 'shape' => 'NonEmptyString', ], 'GitCloneDepth' => [ 'shape' => 'Integer', ], 'InsecureSsl' => [ 'shape' => 'Boolean', ], ], ], 'AwsCodeBuildProjectVpcConfig' => [ 'type' => 'structure', 'members' => [ 'VpcId' => [ 'shape' => 'NonEmptyString', ], 'Subnets' => [ 'shape' => 'NonEmptyStringList', ], 'SecurityGroupIds' => [ 'shape' => 'NonEmptyStringList', ], ], ], 'AwsCorsConfiguration' => [ 'type' => 'structure', 'members' => [ 'AllowOrigins' => [ 'shape' => 'NonEmptyStringList', ], 'AllowCredentials' => [ 'shape' => 'Boolean', ], 'ExposeHeaders' => [ 'shape' => 'NonEmptyStringList', ], 'MaxAge' => [ 'shape' => 'Integer', ], 'AllowMethods' => [ 'shape' => 'NonEmptyStringList', ], 'AllowHeaders' => [ 'shape' => 'NonEmptyStringList', ], ], ], 'AwsDmsEndpointDetails' => [ 'type' => 'structure', 'members' => [ 'CertificateArn' => [ 'shape' => 'NonEmptyString', ], 'DatabaseName' => [ 'shape' => 'NonEmptyString', ], 'EndpointArn' => [ 'shape' => 'NonEmptyString', ], 'EndpointIdentifier' => [ 'shape' => 'NonEmptyString', ], 'EndpointType' => [ 'shape' => 'NonEmptyString', ], 'EngineName' => [ 'shape' => 'NonEmptyString', ], 'ExternalId' => [ 'shape' => 'NonEmptyString', ], 'ExtraConnectionAttributes' => [ 'shape' => 'NonEmptyString', ], 'KmsKeyId' => [ 'shape' => 'NonEmptyString', ], 'Port' => [ 'shape' => 'Integer', ], 'ServerName' => [ 'shape' => 'NonEmptyString', ], 'SslMode' => [ 'shape' => 'NonEmptyString', ], 'Username' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsDmsReplicationInstanceDetails' => [ 'type' => 'structure', 'members' => [ 'AllocatedStorage' => [ 'shape' => 'Integer', ], 'AutoMinorVersionUpgrade' => [ 'shape' => 'Boolean', ], 'AvailabilityZone' => [ 'shape' => 'NonEmptyString', ], 'EngineVersion' => [ 'shape' => 'NonEmptyString', ], 'KmsKeyId' => [ 'shape' => 'NonEmptyString', ], 'MultiAZ' => [ 'shape' => 'Boolean', ], 'PreferredMaintenanceWindow' => [ 'shape' => 'NonEmptyString', ], 'PubliclyAccessible' => [ 'shape' => 'Boolean', ], 'ReplicationInstanceClass' => [ 'shape' => 'NonEmptyString', ], 'ReplicationInstanceIdentifier' => [ 'shape' => 'NonEmptyString', ], 'ReplicationSubnetGroup' => [ 'shape' => 'AwsDmsReplicationInstanceReplicationSubnetGroupDetails', ], 'VpcSecurityGroups' => [ 'shape' => 'AwsDmsReplicationInstanceVpcSecurityGroupsList', ], ], ], 'AwsDmsReplicationInstanceReplicationSubnetGroupDetails' => [ 'type' => 'structure', 'members' => [ 'ReplicationSubnetGroupIdentifier' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsDmsReplicationInstanceVpcSecurityGroupsDetails' => [ 'type' => 'structure', 'members' => [ 'VpcSecurityGroupId' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsDmsReplicationInstanceVpcSecurityGroupsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsDmsReplicationInstanceVpcSecurityGroupsDetails', ], ], 'AwsDmsReplicationTaskDetails' => [ 'type' => 'structure', 'members' => [ 'CdcStartPosition' => [ 'shape' => 'NonEmptyString', ], 'CdcStartTime' => [ 'shape' => 'NonEmptyString', ], 'CdcStopPosition' => [ 'shape' => 'NonEmptyString', ], 'MigrationType' => [ 'shape' => 'NonEmptyString', ], 'Id' => [ 'shape' => 'NonEmptyString', ], 'ResourceIdentifier' => [ 'shape' => 'NonEmptyString', ], 'ReplicationInstanceArn' => [ 'shape' => 'NonEmptyString', ], 'ReplicationTaskIdentifier' => [ 'shape' => 'NonEmptyString', ], 'ReplicationTaskSettings' => [ 'shape' => 'NonEmptyString', ], 'SourceEndpointArn' => [ 'shape' => 'NonEmptyString', ], 'TableMappings' => [ 'shape' => 'NonEmptyString', ], 'TargetEndpointArn' => [ 'shape' => 'NonEmptyString', ], 'TaskData' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsDynamoDbTableAttributeDefinition' => [ 'type' => 'structure', 'members' => [ 'AttributeName' => [ 'shape' => 'NonEmptyString', ], 'AttributeType' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsDynamoDbTableAttributeDefinitionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsDynamoDbTableAttributeDefinition', ], ], 'AwsDynamoDbTableBillingModeSummary' => [ 'type' => 'structure', 'members' => [ 'BillingMode' => [ 'shape' => 'NonEmptyString', ], 'LastUpdateToPayPerRequestDateTime' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsDynamoDbTableDetails' => [ 'type' => 'structure', 'members' => [ 'AttributeDefinitions' => [ 'shape' => 'AwsDynamoDbTableAttributeDefinitionList', ], 'BillingModeSummary' => [ 'shape' => 'AwsDynamoDbTableBillingModeSummary', ], 'CreationDateTime' => [ 'shape' => 'NonEmptyString', ], 'GlobalSecondaryIndexes' => [ 'shape' => 'AwsDynamoDbTableGlobalSecondaryIndexList', ], 'GlobalTableVersion' => [ 'shape' => 'NonEmptyString', ], 'ItemCount' => [ 'shape' => 'Integer', ], 'KeySchema' => [ 'shape' => 'AwsDynamoDbTableKeySchemaList', ], 'LatestStreamArn' => [ 'shape' => 'NonEmptyString', ], 'LatestStreamLabel' => [ 'shape' => 'NonEmptyString', ], 'LocalSecondaryIndexes' => [ 'shape' => 'AwsDynamoDbTableLocalSecondaryIndexList', ], 'ProvisionedThroughput' => [ 'shape' => 'AwsDynamoDbTableProvisionedThroughput', ], 'Replicas' => [ 'shape' => 'AwsDynamoDbTableReplicaList', ], 'RestoreSummary' => [ 'shape' => 'AwsDynamoDbTableRestoreSummary', ], 'SseDescription' => [ 'shape' => 'AwsDynamoDbTableSseDescription', ], 'StreamSpecification' => [ 'shape' => 'AwsDynamoDbTableStreamSpecification', ], 'TableId' => [ 'shape' => 'NonEmptyString', ], 'TableName' => [ 'shape' => 'NonEmptyString', ], 'TableSizeBytes' => [ 'shape' => 'SizeBytes', ], 'TableStatus' => [ 'shape' => 'NonEmptyString', ], 'DeletionProtectionEnabled' => [ 'shape' => 'Boolean', ], ], ], 'AwsDynamoDbTableGlobalSecondaryIndex' => [ 'type' => 'structure', 'members' => [ 'Backfilling' => [ 'shape' => 'Boolean', ], 'IndexArn' => [ 'shape' => 'NonEmptyString', ], 'IndexName' => [ 'shape' => 'NonEmptyString', ], 'IndexSizeBytes' => [ 'shape' => 'SizeBytes', ], 'IndexStatus' => [ 'shape' => 'NonEmptyString', ], 'ItemCount' => [ 'shape' => 'Integer', ], 'KeySchema' => [ 'shape' => 'AwsDynamoDbTableKeySchemaList', ], 'Projection' => [ 'shape' => 'AwsDynamoDbTableProjection', ], 'ProvisionedThroughput' => [ 'shape' => 'AwsDynamoDbTableProvisionedThroughput', ], ], ], 'AwsDynamoDbTableGlobalSecondaryIndexList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsDynamoDbTableGlobalSecondaryIndex', ], ], 'AwsDynamoDbTableKeySchema' => [ 'type' => 'structure', 'members' => [ 'AttributeName' => [ 'shape' => 'NonEmptyString', ], 'KeyType' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsDynamoDbTableKeySchemaList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsDynamoDbTableKeySchema', ], ], 'AwsDynamoDbTableLocalSecondaryIndex' => [ 'type' => 'structure', 'members' => [ 'IndexArn' => [ 'shape' => 'NonEmptyString', ], 'IndexName' => [ 'shape' => 'NonEmptyString', ], 'KeySchema' => [ 'shape' => 'AwsDynamoDbTableKeySchemaList', ], 'Projection' => [ 'shape' => 'AwsDynamoDbTableProjection', ], ], ], 'AwsDynamoDbTableLocalSecondaryIndexList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsDynamoDbTableLocalSecondaryIndex', ], ], 'AwsDynamoDbTableProjection' => [ 'type' => 'structure', 'members' => [ 'NonKeyAttributes' => [ 'shape' => 'StringList', ], 'ProjectionType' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsDynamoDbTableProvisionedThroughput' => [ 'type' => 'structure', 'members' => [ 'LastDecreaseDateTime' => [ 'shape' => 'NonEmptyString', ], 'LastIncreaseDateTime' => [ 'shape' => 'NonEmptyString', ], 'NumberOfDecreasesToday' => [ 'shape' => 'Integer', ], 'ReadCapacityUnits' => [ 'shape' => 'Integer', ], 'WriteCapacityUnits' => [ 'shape' => 'Integer', ], ], ], 'AwsDynamoDbTableProvisionedThroughputOverride' => [ 'type' => 'structure', 'members' => [ 'ReadCapacityUnits' => [ 'shape' => 'Integer', ], ], ], 'AwsDynamoDbTableReplica' => [ 'type' => 'structure', 'members' => [ 'GlobalSecondaryIndexes' => [ 'shape' => 'AwsDynamoDbTableReplicaGlobalSecondaryIndexList', ], 'KmsMasterKeyId' => [ 'shape' => 'NonEmptyString', ], 'ProvisionedThroughputOverride' => [ 'shape' => 'AwsDynamoDbTableProvisionedThroughputOverride', ], 'RegionName' => [ 'shape' => 'NonEmptyString', ], 'ReplicaStatus' => [ 'shape' => 'NonEmptyString', ], 'ReplicaStatusDescription' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsDynamoDbTableReplicaGlobalSecondaryIndex' => [ 'type' => 'structure', 'members' => [ 'IndexName' => [ 'shape' => 'NonEmptyString', ], 'ProvisionedThroughputOverride' => [ 'shape' => 'AwsDynamoDbTableProvisionedThroughputOverride', ], ], ], 'AwsDynamoDbTableReplicaGlobalSecondaryIndexList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsDynamoDbTableReplicaGlobalSecondaryIndex', ], ], 'AwsDynamoDbTableReplicaList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsDynamoDbTableReplica', ], ], 'AwsDynamoDbTableRestoreSummary' => [ 'type' => 'structure', 'members' => [ 'SourceBackupArn' => [ 'shape' => 'NonEmptyString', ], 'SourceTableArn' => [ 'shape' => 'NonEmptyString', ], 'RestoreDateTime' => [ 'shape' => 'NonEmptyString', ], 'RestoreInProgress' => [ 'shape' => 'Boolean', ], ], ], 'AwsDynamoDbTableSseDescription' => [ 'type' => 'structure', 'members' => [ 'InaccessibleEncryptionDateTime' => [ 'shape' => 'NonEmptyString', ], 'Status' => [ 'shape' => 'NonEmptyString', ], 'SseType' => [ 'shape' => 'NonEmptyString', ], 'KmsMasterKeyArn' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsDynamoDbTableStreamSpecification' => [ 'type' => 'structure', 'members' => [ 'StreamEnabled' => [ 'shape' => 'Boolean', ], 'StreamViewType' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails' => [ 'type' => 'structure', 'members' => [ 'DirectoryId' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2ClientVpnEndpointAuthenticationOptionsDetails' => [ 'type' => 'structure', 'members' => [ 'Type' => [ 'shape' => 'NonEmptyString', ], 'ActiveDirectory' => [ 'shape' => 'AwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails', ], 'MutualAuthentication' => [ 'shape' => 'AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails', ], 'FederatedAuthentication' => [ 'shape' => 'AwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails', ], ], ], 'AwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails' => [ 'type' => 'structure', 'members' => [ 'SamlProviderArn' => [ 'shape' => 'NonEmptyString', ], 'SelfServiceSamlProviderArn' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2ClientVpnEndpointAuthenticationOptionsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEc2ClientVpnEndpointAuthenticationOptionsDetails', ], ], 'AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails' => [ 'type' => 'structure', 'members' => [ 'ClientRootCertificateChain' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2ClientVpnEndpointClientConnectOptionsDetails' => [ 'type' => 'structure', 'members' => [ 'Enabled' => [ 'shape' => 'Boolean', ], 'LambdaFunctionArn' => [ 'shape' => 'NonEmptyString', ], 'Status' => [ 'shape' => 'AwsEc2ClientVpnEndpointClientConnectOptionsStatusDetails', ], ], ], 'AwsEc2ClientVpnEndpointClientConnectOptionsStatusDetails' => [ 'type' => 'structure', 'members' => [ 'Code' => [ 'shape' => 'NonEmptyString', ], 'Message' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails' => [ 'type' => 'structure', 'members' => [ 'Enabled' => [ 'shape' => 'Boolean', ], 'BannerText' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2ClientVpnEndpointConnectionLogOptionsDetails' => [ 'type' => 'structure', 'members' => [ 'Enabled' => [ 'shape' => 'Boolean', ], 'CloudwatchLogGroup' => [ 'shape' => 'NonEmptyString', ], 'CloudwatchLogStream' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2ClientVpnEndpointDetails' => [ 'type' => 'structure', 'members' => [ 'ClientVpnEndpointId' => [ 'shape' => 'NonEmptyString', ], 'Description' => [ 'shape' => 'NonEmptyString', ], 'ClientCidrBlock' => [ 'shape' => 'NonEmptyString', ], 'DnsServer' => [ 'shape' => 'StringList', ], 'SplitTunnel' => [ 'shape' => 'Boolean', ], 'TransportProtocol' => [ 'shape' => 'NonEmptyString', ], 'VpnPort' => [ 'shape' => 'Integer', ], 'ServerCertificateArn' => [ 'shape' => 'NonEmptyString', ], 'AuthenticationOptions' => [ 'shape' => 'AwsEc2ClientVpnEndpointAuthenticationOptionsList', ], 'ConnectionLogOptions' => [ 'shape' => 'AwsEc2ClientVpnEndpointConnectionLogOptionsDetails', ], 'SecurityGroupIdSet' => [ 'shape' => 'StringList', ], 'VpcId' => [ 'shape' => 'NonEmptyString', ], 'SelfServicePortalUrl' => [ 'shape' => 'NonEmptyString', ], 'ClientConnectOptions' => [ 'shape' => 'AwsEc2ClientVpnEndpointClientConnectOptionsDetails', ], 'SessionTimeoutHours' => [ 'shape' => 'Integer', ], 'ClientLoginBannerOptions' => [ 'shape' => 'AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails', ], ], ], 'AwsEc2EipDetails' => [ 'type' => 'structure', 'members' => [ 'InstanceId' => [ 'shape' => 'NonEmptyString', ], 'PublicIp' => [ 'shape' => 'NonEmptyString', ], 'AllocationId' => [ 'shape' => 'NonEmptyString', ], 'AssociationId' => [ 'shape' => 'NonEmptyString', ], 'Domain' => [ 'shape' => 'NonEmptyString', ], 'PublicIpv4Pool' => [ 'shape' => 'NonEmptyString', ], 'NetworkBorderGroup' => [ 'shape' => 'NonEmptyString', ], 'NetworkInterfaceId' => [ 'shape' => 'NonEmptyString', ], 'NetworkInterfaceOwnerId' => [ 'shape' => 'NonEmptyString', ], 'PrivateIpAddress' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2InstanceDetails' => [ 'type' => 'structure', 'members' => [ 'Type' => [ 'shape' => 'NonEmptyString', ], 'ImageId' => [ 'shape' => 'NonEmptyString', ], 'IpV4Addresses' => [ 'shape' => 'StringList', ], 'IpV6Addresses' => [ 'shape' => 'StringList', ], 'KeyName' => [ 'shape' => 'NonEmptyString', ], 'IamInstanceProfileArn' => [ 'shape' => 'NonEmptyString', ], 'VpcId' => [ 'shape' => 'NonEmptyString', ], 'SubnetId' => [ 'shape' => 'NonEmptyString', ], 'LaunchedAt' => [ 'shape' => 'NonEmptyString', ], 'NetworkInterfaces' => [ 'shape' => 'AwsEc2InstanceNetworkInterfacesList', ], 'VirtualizationType' => [ 'shape' => 'NonEmptyString', ], 'MetadataOptions' => [ 'shape' => 'AwsEc2InstanceMetadataOptions', ], 'Monitoring' => [ 'shape' => 'AwsEc2InstanceMonitoringDetails', ], ], ], 'AwsEc2InstanceMetadataOptions' => [ 'type' => 'structure', 'members' => [ 'HttpEndpoint' => [ 'shape' => 'NonEmptyString', ], 'HttpProtocolIpv6' => [ 'shape' => 'NonEmptyString', ], 'HttpPutResponseHopLimit' => [ 'shape' => 'Integer', ], 'HttpTokens' => [ 'shape' => 'NonEmptyString', ], 'InstanceMetadataTags' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2InstanceMonitoringDetails' => [ 'type' => 'structure', 'members' => [ 'State' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2InstanceNetworkInterfacesDetails' => [ 'type' => 'structure', 'members' => [ 'NetworkInterfaceId' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2InstanceNetworkInterfacesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEc2InstanceNetworkInterfacesDetails', ], ], 'AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails' => [ 'type' => 'structure', 'members' => [ 'DeviceName' => [ 'shape' => 'NonEmptyString', ], 'Ebs' => [ 'shape' => 'AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails', ], 'NoDevice' => [ 'shape' => 'NonEmptyString', ], 'VirtualName' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails' => [ 'type' => 'structure', 'members' => [ 'DeleteOnTermination' => [ 'shape' => 'Boolean', ], 'Encrypted' => [ 'shape' => 'Boolean', ], 'Iops' => [ 'shape' => 'Integer', ], 'KmsKeyId' => [ 'shape' => 'NonEmptyString', ], 'SnapshotId' => [ 'shape' => 'NonEmptyString', ], 'Throughput' => [ 'shape' => 'Integer', ], 'VolumeSize' => [ 'shape' => 'Integer', ], 'VolumeType' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2LaunchTemplateDataBlockDeviceMappingSetList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails', ], ], 'AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails' => [ 'type' => 'structure', 'members' => [ 'CapacityReservationId' => [ 'shape' => 'NonEmptyString', ], 'CapacityReservationResourceGroupArn' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails' => [ 'type' => 'structure', 'members' => [ 'CapacityReservationPreference' => [ 'shape' => 'NonEmptyString', ], 'CapacityReservationTarget' => [ 'shape' => 'AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails', ], ], ], 'AwsEc2LaunchTemplateDataCpuOptionsDetails' => [ 'type' => 'structure', 'members' => [ 'CoreCount' => [ 'shape' => 'Integer', ], 'ThreadsPerCore' => [ 'shape' => 'Integer', ], ], ], 'AwsEc2LaunchTemplateDataCreditSpecificationDetails' => [ 'type' => 'structure', 'members' => [ 'CpuCredits' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2LaunchTemplateDataDetails' => [ 'type' => 'structure', 'members' => [ 'BlockDeviceMappingSet' => [ 'shape' => 'AwsEc2LaunchTemplateDataBlockDeviceMappingSetList', ], 'CapacityReservationSpecification' => [ 'shape' => 'AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails', ], 'CpuOptions' => [ 'shape' => 'AwsEc2LaunchTemplateDataCpuOptionsDetails', ], 'CreditSpecification' => [ 'shape' => 'AwsEc2LaunchTemplateDataCreditSpecificationDetails', ], 'DisableApiStop' => [ 'shape' => 'Boolean', ], 'DisableApiTermination' => [ 'shape' => 'Boolean', ], 'EbsOptimized' => [ 'shape' => 'Boolean', ], 'ElasticGpuSpecificationSet' => [ 'shape' => 'AwsEc2LaunchTemplateDataElasticGpuSpecificationSetList', ], 'ElasticInferenceAcceleratorSet' => [ 'shape' => 'AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetList', ], 'EnclaveOptions' => [ 'shape' => 'AwsEc2LaunchTemplateDataEnclaveOptionsDetails', ], 'HibernationOptions' => [ 'shape' => 'AwsEc2LaunchTemplateDataHibernationOptionsDetails', ], 'IamInstanceProfile' => [ 'shape' => 'AwsEc2LaunchTemplateDataIamInstanceProfileDetails', ], 'ImageId' => [ 'shape' => 'NonEmptyString', ], 'InstanceInitiatedShutdownBehavior' => [ 'shape' => 'NonEmptyString', ], 'InstanceMarketOptions' => [ 'shape' => 'AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails', ], 'InstanceRequirements' => [ 'shape' => 'AwsEc2LaunchTemplateDataInstanceRequirementsDetails', ], 'InstanceType' => [ 'shape' => 'NonEmptyString', ], 'KernelId' => [ 'shape' => 'NonEmptyString', ], 'KeyName' => [ 'shape' => 'NonEmptyString', ], 'LicenseSet' => [ 'shape' => 'AwsEc2LaunchTemplateDataLicenseSetList', ], 'MaintenanceOptions' => [ 'shape' => 'AwsEc2LaunchTemplateDataMaintenanceOptionsDetails', ], 'MetadataOptions' => [ 'shape' => 'AwsEc2LaunchTemplateDataMetadataOptionsDetails', ], 'Monitoring' => [ 'shape' => 'AwsEc2LaunchTemplateDataMonitoringDetails', ], 'NetworkInterfaceSet' => [ 'shape' => 'AwsEc2LaunchTemplateDataNetworkInterfaceSetList', ], 'Placement' => [ 'shape' => 'AwsEc2LaunchTemplateDataPlacementDetails', ], 'PrivateDnsNameOptions' => [ 'shape' => 'AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails', ], 'RamDiskId' => [ 'shape' => 'NonEmptyString', ], 'SecurityGroupIdSet' => [ 'shape' => 'NonEmptyStringList', ], 'SecurityGroupSet' => [ 'shape' => 'NonEmptyStringList', ], 'UserData' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails' => [ 'type' => 'structure', 'members' => [ 'Type' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2LaunchTemplateDataElasticGpuSpecificationSetList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails', ], ], 'AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails' => [ 'type' => 'structure', 'members' => [ 'Count' => [ 'shape' => 'Integer', ], 'Type' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails', ], ], 'AwsEc2LaunchTemplateDataEnclaveOptionsDetails' => [ 'type' => 'structure', 'members' => [ 'Enabled' => [ 'shape' => 'Boolean', ], ], ], 'AwsEc2LaunchTemplateDataHibernationOptionsDetails' => [ 'type' => 'structure', 'members' => [ 'Configured' => [ 'shape' => 'Boolean', ], ], ], 'AwsEc2LaunchTemplateDataIamInstanceProfileDetails' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'NonEmptyString', ], 'Name' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails' => [ 'type' => 'structure', 'members' => [ 'MarketType' => [ 'shape' => 'NonEmptyString', ], 'SpotOptions' => [ 'shape' => 'AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails', ], ], ], 'AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails' => [ 'type' => 'structure', 'members' => [ 'BlockDurationMinutes' => [ 'shape' => 'Integer', ], 'InstanceInterruptionBehavior' => [ 'shape' => 'NonEmptyString', ], 'MaxPrice' => [ 'shape' => 'NonEmptyString', ], 'SpotInstanceType' => [ 'shape' => 'NonEmptyString', ], 'ValidUntil' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails' => [ 'type' => 'structure', 'members' => [ 'Max' => [ 'shape' => 'Integer', ], 'Min' => [ 'shape' => 'Integer', ], ], ], 'AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails' => [ 'type' => 'structure', 'members' => [ 'Max' => [ 'shape' => 'Integer', ], 'Min' => [ 'shape' => 'Integer', ], ], ], 'AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails' => [ 'type' => 'structure', 'members' => [ 'Max' => [ 'shape' => 'Integer', ], 'Min' => [ 'shape' => 'Integer', ], ], ], 'AwsEc2LaunchTemplateDataInstanceRequirementsDetails' => [ 'type' => 'structure', 'members' => [ 'AcceleratorCount' => [ 'shape' => 'AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails', ], 'AcceleratorManufacturers' => [ 'shape' => 'NonEmptyStringList', ], 'AcceleratorNames' => [ 'shape' => 'NonEmptyStringList', ], 'AcceleratorTotalMemoryMiB' => [ 'shape' => 'AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails', ], 'AcceleratorTypes' => [ 'shape' => 'NonEmptyStringList', ], 'BareMetal' => [ 'shape' => 'NonEmptyString', ], 'BaselineEbsBandwidthMbps' => [ 'shape' => 'AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails', ], 'BurstablePerformance' => [ 'shape' => 'NonEmptyString', ], 'CpuManufacturers' => [ 'shape' => 'NonEmptyStringList', ], 'ExcludedInstanceTypes' => [ 'shape' => 'NonEmptyStringList', ], 'InstanceGenerations' => [ 'shape' => 'NonEmptyStringList', ], 'LocalStorage' => [ 'shape' => 'NonEmptyString', ], 'LocalStorageTypes' => [ 'shape' => 'NonEmptyStringList', ], 'MemoryGiBPerVCpu' => [ 'shape' => 'AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails', ], 'MemoryMiB' => [ 'shape' => 'AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails', ], 'NetworkInterfaceCount' => [ 'shape' => 'AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails', ], 'OnDemandMaxPricePercentageOverLowestPrice' => [ 'shape' => 'Integer', ], 'RequireHibernateSupport' => [ 'shape' => 'Boolean', ], 'SpotMaxPricePercentageOverLowestPrice' => [ 'shape' => 'Integer', ], 'TotalLocalStorageGB' => [ 'shape' => 'AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails', ], 'VCpuCount' => [ 'shape' => 'AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails', ], ], ], 'AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails' => [ 'type' => 'structure', 'members' => [ 'Max' => [ 'shape' => 'Double', ], 'Min' => [ 'shape' => 'Double', ], ], ], 'AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails' => [ 'type' => 'structure', 'members' => [ 'Max' => [ 'shape' => 'Integer', ], 'Min' => [ 'shape' => 'Integer', ], ], ], 'AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails' => [ 'type' => 'structure', 'members' => [ 'Max' => [ 'shape' => 'Integer', ], 'Min' => [ 'shape' => 'Integer', ], ], ], 'AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails' => [ 'type' => 'structure', 'members' => [ 'Max' => [ 'shape' => 'Double', ], 'Min' => [ 'shape' => 'Double', ], ], ], 'AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails' => [ 'type' => 'structure', 'members' => [ 'Max' => [ 'shape' => 'Integer', ], 'Min' => [ 'shape' => 'Integer', ], ], ], 'AwsEc2LaunchTemplateDataLicenseSetDetails' => [ 'type' => 'structure', 'members' => [ 'LicenseConfigurationArn' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2LaunchTemplateDataLicenseSetList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEc2LaunchTemplateDataLicenseSetDetails', ], ], 'AwsEc2LaunchTemplateDataMaintenanceOptionsDetails' => [ 'type' => 'structure', 'members' => [ 'AutoRecovery' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2LaunchTemplateDataMetadataOptionsDetails' => [ 'type' => 'structure', 'members' => [ 'HttpEndpoint' => [ 'shape' => 'NonEmptyString', ], 'HttpProtocolIpv6' => [ 'shape' => 'NonEmptyString', ], 'HttpTokens' => [ 'shape' => 'NonEmptyString', ], 'HttpPutResponseHopLimit' => [ 'shape' => 'Integer', ], 'InstanceMetadataTags' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2LaunchTemplateDataMonitoringDetails' => [ 'type' => 'structure', 'members' => [ 'Enabled' => [ 'shape' => 'Boolean', ], ], ], 'AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails' => [ 'type' => 'structure', 'members' => [ 'AssociateCarrierIpAddress' => [ 'shape' => 'Boolean', ], 'AssociatePublicIpAddress' => [ 'shape' => 'Boolean', ], 'DeleteOnTermination' => [ 'shape' => 'Boolean', ], 'Description' => [ 'shape' => 'NonEmptyString', ], 'DeviceIndex' => [ 'shape' => 'Integer', ], 'Groups' => [ 'shape' => 'NonEmptyStringList', ], 'InterfaceType' => [ 'shape' => 'NonEmptyString', ], 'Ipv4PrefixCount' => [ 'shape' => 'Integer', ], 'Ipv4Prefixes' => [ 'shape' => 'AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesList', ], 'Ipv6AddressCount' => [ 'shape' => 'Integer', ], 'Ipv6Addresses' => [ 'shape' => 'AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesList', ], 'Ipv6PrefixCount' => [ 'shape' => 'Integer', ], 'Ipv6Prefixes' => [ 'shape' => 'AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesList', ], 'NetworkCardIndex' => [ 'shape' => 'Integer', ], 'NetworkInterfaceId' => [ 'shape' => 'NonEmptyString', ], 'PrivateIpAddress' => [ 'shape' => 'NonEmptyString', ], 'PrivateIpAddresses' => [ 'shape' => 'AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesList', ], 'SecondaryPrivateIpAddressCount' => [ 'shape' => 'Integer', ], 'SubnetId' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails' => [ 'type' => 'structure', 'members' => [ 'Ipv4Prefix' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails', ], ], 'AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails' => [ 'type' => 'structure', 'members' => [ 'Ipv6Address' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails', ], ], 'AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails' => [ 'type' => 'structure', 'members' => [ 'Ipv6Prefix' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails', ], ], 'AwsEc2LaunchTemplateDataNetworkInterfaceSetList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails', ], ], 'AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails' => [ 'type' => 'structure', 'members' => [ 'Primary' => [ 'shape' => 'Boolean', ], 'PrivateIpAddress' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails', ], ], 'AwsEc2LaunchTemplateDataPlacementDetails' => [ 'type' => 'structure', 'members' => [ 'Affinity' => [ 'shape' => 'NonEmptyString', ], 'AvailabilityZone' => [ 'shape' => 'NonEmptyString', ], 'GroupName' => [ 'shape' => 'NonEmptyString', ], 'HostId' => [ 'shape' => 'NonEmptyString', ], 'HostResourceGroupArn' => [ 'shape' => 'NonEmptyString', ], 'PartitionNumber' => [ 'shape' => 'Integer', ], 'SpreadDomain' => [ 'shape' => 'NonEmptyString', ], 'Tenancy' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails' => [ 'type' => 'structure', 'members' => [ 'EnableResourceNameDnsAAAARecord' => [ 'shape' => 'Boolean', ], 'EnableResourceNameDnsARecord' => [ 'shape' => 'Boolean', ], 'HostnameType' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2LaunchTemplateDetails' => [ 'type' => 'structure', 'members' => [ 'LaunchTemplateName' => [ 'shape' => 'NonEmptyString', ], 'Id' => [ 'shape' => 'NonEmptyString', ], 'LaunchTemplateData' => [ 'shape' => 'AwsEc2LaunchTemplateDataDetails', ], 'DefaultVersionNumber' => [ 'shape' => 'Long', ], 'LatestVersionNumber' => [ 'shape' => 'Long', ], ], ], 'AwsEc2NetworkAclAssociation' => [ 'type' => 'structure', 'members' => [ 'NetworkAclAssociationId' => [ 'shape' => 'NonEmptyString', ], 'NetworkAclId' => [ 'shape' => 'NonEmptyString', ], 'SubnetId' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2NetworkAclAssociationList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEc2NetworkAclAssociation', ], ], 'AwsEc2NetworkAclDetails' => [ 'type' => 'structure', 'members' => [ 'IsDefault' => [ 'shape' => 'Boolean', ], 'NetworkAclId' => [ 'shape' => 'NonEmptyString', ], 'OwnerId' => [ 'shape' => 'NonEmptyString', ], 'VpcId' => [ 'shape' => 'NonEmptyString', ], 'Associations' => [ 'shape' => 'AwsEc2NetworkAclAssociationList', ], 'Entries' => [ 'shape' => 'AwsEc2NetworkAclEntryList', ], ], ], 'AwsEc2NetworkAclEntry' => [ 'type' => 'structure', 'members' => [ 'CidrBlock' => [ 'shape' => 'NonEmptyString', ], 'Egress' => [ 'shape' => 'Boolean', ], 'IcmpTypeCode' => [ 'shape' => 'IcmpTypeCode', ], 'Ipv6CidrBlock' => [ 'shape' => 'NonEmptyString', ], 'PortRange' => [ 'shape' => 'PortRangeFromTo', ], 'Protocol' => [ 'shape' => 'NonEmptyString', ], 'RuleAction' => [ 'shape' => 'NonEmptyString', ], 'RuleNumber' => [ 'shape' => 'Integer', ], ], ], 'AwsEc2NetworkAclEntryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEc2NetworkAclEntry', ], ], 'AwsEc2NetworkInterfaceAttachment' => [ 'type' => 'structure', 'members' => [ 'AttachTime' => [ 'shape' => 'NonEmptyString', ], 'AttachmentId' => [ 'shape' => 'NonEmptyString', ], 'DeleteOnTermination' => [ 'shape' => 'Boolean', ], 'DeviceIndex' => [ 'shape' => 'Integer', ], 'InstanceId' => [ 'shape' => 'NonEmptyString', ], 'InstanceOwnerId' => [ 'shape' => 'NonEmptyString', ], 'Status' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2NetworkInterfaceDetails' => [ 'type' => 'structure', 'members' => [ 'Attachment' => [ 'shape' => 'AwsEc2NetworkInterfaceAttachment', ], 'NetworkInterfaceId' => [ 'shape' => 'NonEmptyString', ], 'SecurityGroups' => [ 'shape' => 'AwsEc2NetworkInterfaceSecurityGroupList', ], 'SourceDestCheck' => [ 'shape' => 'Boolean', ], 'IpV6Addresses' => [ 'shape' => 'AwsEc2NetworkInterfaceIpV6AddressList', ], 'PrivateIpAddresses' => [ 'shape' => 'AwsEc2NetworkInterfacePrivateIpAddressList', ], 'PublicDnsName' => [ 'shape' => 'NonEmptyString', ], 'PublicIp' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2NetworkInterfaceIpV6AddressDetail' => [ 'type' => 'structure', 'members' => [ 'IpV6Address' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2NetworkInterfaceIpV6AddressList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEc2NetworkInterfaceIpV6AddressDetail', ], ], 'AwsEc2NetworkInterfacePrivateIpAddressDetail' => [ 'type' => 'structure', 'members' => [ 'PrivateIpAddress' => [ 'shape' => 'NonEmptyString', ], 'PrivateDnsName' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2NetworkInterfacePrivateIpAddressList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEc2NetworkInterfacePrivateIpAddressDetail', ], ], 'AwsEc2NetworkInterfaceSecurityGroup' => [ 'type' => 'structure', 'members' => [ 'GroupName' => [ 'shape' => 'NonEmptyString', ], 'GroupId' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2NetworkInterfaceSecurityGroupList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEc2NetworkInterfaceSecurityGroup', ], ], 'AwsEc2RouteTableDetails' => [ 'type' => 'structure', 'members' => [ 'AssociationSet' => [ 'shape' => 'AssociationSetList', ], 'OwnerId' => [ 'shape' => 'NonEmptyString', ], 'PropagatingVgwSet' => [ 'shape' => 'PropagatingVgwSetList', ], 'RouteTableId' => [ 'shape' => 'NonEmptyString', ], 'RouteSet' => [ 'shape' => 'RouteSetList', ], 'VpcId' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2SecurityGroupDetails' => [ 'type' => 'structure', 'members' => [ 'GroupName' => [ 'shape' => 'NonEmptyString', ], 'GroupId' => [ 'shape' => 'NonEmptyString', ], 'OwnerId' => [ 'shape' => 'NonEmptyString', ], 'VpcId' => [ 'shape' => 'NonEmptyString', ], 'IpPermissions' => [ 'shape' => 'AwsEc2SecurityGroupIpPermissionList', ], 'IpPermissionsEgress' => [ 'shape' => 'AwsEc2SecurityGroupIpPermissionList', ], ], ], 'AwsEc2SecurityGroupIpPermission' => [ 'type' => 'structure', 'members' => [ 'IpProtocol' => [ 'shape' => 'NonEmptyString', ], 'FromPort' => [ 'shape' => 'Integer', ], 'ToPort' => [ 'shape' => 'Integer', ], 'UserIdGroupPairs' => [ 'shape' => 'AwsEc2SecurityGroupUserIdGroupPairList', ], 'IpRanges' => [ 'shape' => 'AwsEc2SecurityGroupIpRangeList', ], 'Ipv6Ranges' => [ 'shape' => 'AwsEc2SecurityGroupIpv6RangeList', ], 'PrefixListIds' => [ 'shape' => 'AwsEc2SecurityGroupPrefixListIdList', ], ], ], 'AwsEc2SecurityGroupIpPermissionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEc2SecurityGroupIpPermission', ], ], 'AwsEc2SecurityGroupIpRange' => [ 'type' => 'structure', 'members' => [ 'CidrIp' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2SecurityGroupIpRangeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEc2SecurityGroupIpRange', ], ], 'AwsEc2SecurityGroupIpv6Range' => [ 'type' => 'structure', 'members' => [ 'CidrIpv6' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2SecurityGroupIpv6RangeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEc2SecurityGroupIpv6Range', ], ], 'AwsEc2SecurityGroupPrefixListId' => [ 'type' => 'structure', 'members' => [ 'PrefixListId' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2SecurityGroupPrefixListIdList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEc2SecurityGroupPrefixListId', ], ], 'AwsEc2SecurityGroupUserIdGroupPair' => [ 'type' => 'structure', 'members' => [ 'GroupId' => [ 'shape' => 'NonEmptyString', ], 'GroupName' => [ 'shape' => 'NonEmptyString', ], 'PeeringStatus' => [ 'shape' => 'NonEmptyString', ], 'UserId' => [ 'shape' => 'NonEmptyString', ], 'VpcId' => [ 'shape' => 'NonEmptyString', ], 'VpcPeeringConnectionId' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2SecurityGroupUserIdGroupPairList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEc2SecurityGroupUserIdGroupPair', ], ], 'AwsEc2SubnetDetails' => [ 'type' => 'structure', 'members' => [ 'AssignIpv6AddressOnCreation' => [ 'shape' => 'Boolean', ], 'AvailabilityZone' => [ 'shape' => 'NonEmptyString', ], 'AvailabilityZoneId' => [ 'shape' => 'NonEmptyString', ], 'AvailableIpAddressCount' => [ 'shape' => 'Integer', ], 'CidrBlock' => [ 'shape' => 'NonEmptyString', ], 'DefaultForAz' => [ 'shape' => 'Boolean', ], 'MapPublicIpOnLaunch' => [ 'shape' => 'Boolean', ], 'OwnerId' => [ 'shape' => 'NonEmptyString', ], 'State' => [ 'shape' => 'NonEmptyString', ], 'SubnetArn' => [ 'shape' => 'NonEmptyString', ], 'SubnetId' => [ 'shape' => 'NonEmptyString', ], 'VpcId' => [ 'shape' => 'NonEmptyString', ], 'Ipv6CidrBlockAssociationSet' => [ 'shape' => 'Ipv6CidrBlockAssociationList', ], ], ], 'AwsEc2TransitGatewayDetails' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'NonEmptyString', ], 'Description' => [ 'shape' => 'NonEmptyString', ], 'DefaultRouteTablePropagation' => [ 'shape' => 'NonEmptyString', ], 'AutoAcceptSharedAttachments' => [ 'shape' => 'NonEmptyString', ], 'DefaultRouteTableAssociation' => [ 'shape' => 'NonEmptyString', ], 'TransitGatewayCidrBlocks' => [ 'shape' => 'NonEmptyStringList', ], 'AssociationDefaultRouteTableId' => [ 'shape' => 'NonEmptyString', ], 'PropagationDefaultRouteTableId' => [ 'shape' => 'NonEmptyString', ], 'VpnEcmpSupport' => [ 'shape' => 'NonEmptyString', ], 'DnsSupport' => [ 'shape' => 'NonEmptyString', ], 'MulticastSupport' => [ 'shape' => 'NonEmptyString', ], 'AmazonSideAsn' => [ 'shape' => 'Integer', ], ], ], 'AwsEc2VolumeAttachment' => [ 'type' => 'structure', 'members' => [ 'AttachTime' => [ 'shape' => 'NonEmptyString', ], 'DeleteOnTermination' => [ 'shape' => 'Boolean', ], 'InstanceId' => [ 'shape' => 'NonEmptyString', ], 'Status' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2VolumeAttachmentList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEc2VolumeAttachment', ], ], 'AwsEc2VolumeDetails' => [ 'type' => 'structure', 'members' => [ 'CreateTime' => [ 'shape' => 'NonEmptyString', ], 'DeviceName' => [ 'shape' => 'NonEmptyString', ], 'Encrypted' => [ 'shape' => 'Boolean', ], 'Size' => [ 'shape' => 'Integer', ], 'SnapshotId' => [ 'shape' => 'NonEmptyString', ], 'Status' => [ 'shape' => 'NonEmptyString', ], 'KmsKeyId' => [ 'shape' => 'NonEmptyString', ], 'Attachments' => [ 'shape' => 'AwsEc2VolumeAttachmentList', ], 'VolumeId' => [ 'shape' => 'NonEmptyString', ], 'VolumeType' => [ 'shape' => 'NonEmptyString', ], 'VolumeScanStatus' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2VpcDetails' => [ 'type' => 'structure', 'members' => [ 'CidrBlockAssociationSet' => [ 'shape' => 'CidrBlockAssociationList', ], 'Ipv6CidrBlockAssociationSet' => [ 'shape' => 'Ipv6CidrBlockAssociationList', ], 'DhcpOptionsId' => [ 'shape' => 'NonEmptyString', ], 'State' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2VpcEndpointServiceDetails' => [ 'type' => 'structure', 'members' => [ 'AcceptanceRequired' => [ 'shape' => 'Boolean', ], 'AvailabilityZones' => [ 'shape' => 'NonEmptyStringList', ], 'BaseEndpointDnsNames' => [ 'shape' => 'NonEmptyStringList', ], 'ManagesVpcEndpoints' => [ 'shape' => 'Boolean', ], 'GatewayLoadBalancerArns' => [ 'shape' => 'NonEmptyStringList', ], 'NetworkLoadBalancerArns' => [ 'shape' => 'NonEmptyStringList', ], 'PrivateDnsName' => [ 'shape' => 'NonEmptyString', ], 'ServiceId' => [ 'shape' => 'NonEmptyString', ], 'ServiceName' => [ 'shape' => 'NonEmptyString', ], 'ServiceState' => [ 'shape' => 'NonEmptyString', ], 'ServiceType' => [ 'shape' => 'AwsEc2VpcEndpointServiceServiceTypeList', ], ], ], 'AwsEc2VpcEndpointServiceServiceTypeDetails' => [ 'type' => 'structure', 'members' => [ 'ServiceType' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2VpcEndpointServiceServiceTypeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEc2VpcEndpointServiceServiceTypeDetails', ], ], 'AwsEc2VpcPeeringConnectionDetails' => [ 'type' => 'structure', 'members' => [ 'AccepterVpcInfo' => [ 'shape' => 'AwsEc2VpcPeeringConnectionVpcInfoDetails', ], 'ExpirationTime' => [ 'shape' => 'NonEmptyString', ], 'RequesterVpcInfo' => [ 'shape' => 'AwsEc2VpcPeeringConnectionVpcInfoDetails', ], 'Status' => [ 'shape' => 'AwsEc2VpcPeeringConnectionStatusDetails', ], 'VpcPeeringConnectionId' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2VpcPeeringConnectionStatusDetails' => [ 'type' => 'structure', 'members' => [ 'Code' => [ 'shape' => 'NonEmptyString', ], 'Message' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2VpcPeeringConnectionVpcInfoDetails' => [ 'type' => 'structure', 'members' => [ 'CidrBlock' => [ 'shape' => 'NonEmptyString', ], 'CidrBlockSet' => [ 'shape' => 'VpcInfoCidrBlockSetList', ], 'Ipv6CidrBlockSet' => [ 'shape' => 'VpcInfoIpv6CidrBlockSetList', ], 'OwnerId' => [ 'shape' => 'NonEmptyString', ], 'PeeringOptions' => [ 'shape' => 'VpcInfoPeeringOptionsDetails', ], 'Region' => [ 'shape' => 'NonEmptyString', ], 'VpcId' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2VpnConnectionDetails' => [ 'type' => 'structure', 'members' => [ 'VpnConnectionId' => [ 'shape' => 'NonEmptyString', ], 'State' => [ 'shape' => 'NonEmptyString', ], 'CustomerGatewayId' => [ 'shape' => 'NonEmptyString', ], 'CustomerGatewayConfiguration' => [ 'shape' => 'NonEmptyString', ], 'Type' => [ 'shape' => 'NonEmptyString', ], 'VpnGatewayId' => [ 'shape' => 'NonEmptyString', ], 'Category' => [ 'shape' => 'NonEmptyString', ], 'VgwTelemetry' => [ 'shape' => 'AwsEc2VpnConnectionVgwTelemetryList', ], 'Options' => [ 'shape' => 'AwsEc2VpnConnectionOptionsDetails', ], 'Routes' => [ 'shape' => 'AwsEc2VpnConnectionRoutesList', ], 'TransitGatewayId' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2VpnConnectionOptionsDetails' => [ 'type' => 'structure', 'members' => [ 'StaticRoutesOnly' => [ 'shape' => 'Boolean', ], 'TunnelOptions' => [ 'shape' => 'AwsEc2VpnConnectionOptionsTunnelOptionsList', ], ], ], 'AwsEc2VpnConnectionOptionsTunnelOptionsDetails' => [ 'type' => 'structure', 'members' => [ 'DpdTimeoutSeconds' => [ 'shape' => 'Integer', ], 'IkeVersions' => [ 'shape' => 'NonEmptyStringList', ], 'OutsideIpAddress' => [ 'shape' => 'NonEmptyString', ], 'Phase1DhGroupNumbers' => [ 'shape' => 'IntegerList', ], 'Phase1EncryptionAlgorithms' => [ 'shape' => 'NonEmptyStringList', ], 'Phase1IntegrityAlgorithms' => [ 'shape' => 'NonEmptyStringList', ], 'Phase1LifetimeSeconds' => [ 'shape' => 'Integer', ], 'Phase2DhGroupNumbers' => [ 'shape' => 'IntegerList', ], 'Phase2EncryptionAlgorithms' => [ 'shape' => 'NonEmptyStringList', ], 'Phase2IntegrityAlgorithms' => [ 'shape' => 'NonEmptyStringList', ], 'Phase2LifetimeSeconds' => [ 'shape' => 'Integer', ], 'PreSharedKey' => [ 'shape' => 'NonEmptyString', ], 'RekeyFuzzPercentage' => [ 'shape' => 'Integer', ], 'RekeyMarginTimeSeconds' => [ 'shape' => 'Integer', ], 'ReplayWindowSize' => [ 'shape' => 'Integer', ], 'TunnelInsideCidr' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2VpnConnectionOptionsTunnelOptionsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEc2VpnConnectionOptionsTunnelOptionsDetails', ], ], 'AwsEc2VpnConnectionRoutesDetails' => [ 'type' => 'structure', 'members' => [ 'DestinationCidrBlock' => [ 'shape' => 'NonEmptyString', ], 'State' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2VpnConnectionRoutesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEc2VpnConnectionRoutesDetails', ], ], 'AwsEc2VpnConnectionVgwTelemetryDetails' => [ 'type' => 'structure', 'members' => [ 'AcceptedRouteCount' => [ 'shape' => 'Integer', ], 'CertificateArn' => [ 'shape' => 'NonEmptyString', ], 'LastStatusChange' => [ 'shape' => 'NonEmptyString', ], 'OutsideIpAddress' => [ 'shape' => 'NonEmptyString', ], 'Status' => [ 'shape' => 'NonEmptyString', ], 'StatusMessage' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEc2VpnConnectionVgwTelemetryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEc2VpnConnectionVgwTelemetryDetails', ], ], 'AwsEcrContainerImageDetails' => [ 'type' => 'structure', 'members' => [ 'RegistryId' => [ 'shape' => 'NonEmptyString', ], 'RepositoryName' => [ 'shape' => 'NonEmptyString', ], 'Architecture' => [ 'shape' => 'NonEmptyString', ], 'ImageDigest' => [ 'shape' => 'NonEmptyString', ], 'ImageTags' => [ 'shape' => 'NonEmptyStringList', ], 'ImagePublishedAt' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcrRepositoryDetails' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'NonEmptyString', ], 'ImageScanningConfiguration' => [ 'shape' => 'AwsEcrRepositoryImageScanningConfigurationDetails', ], 'ImageTagMutability' => [ 'shape' => 'NonEmptyString', ], 'LifecyclePolicy' => [ 'shape' => 'AwsEcrRepositoryLifecyclePolicyDetails', ], 'RepositoryName' => [ 'shape' => 'NonEmptyString', ], 'RepositoryPolicyText' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcrRepositoryImageScanningConfigurationDetails' => [ 'type' => 'structure', 'members' => [ 'ScanOnPush' => [ 'shape' => 'Boolean', ], ], ], 'AwsEcrRepositoryLifecyclePolicyDetails' => [ 'type' => 'structure', 'members' => [ 'LifecyclePolicyText' => [ 'shape' => 'NonEmptyString', ], 'RegistryId' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsClusterClusterSettingsDetails' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'NonEmptyString', ], 'Value' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsClusterClusterSettingsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEcsClusterClusterSettingsDetails', ], ], 'AwsEcsClusterConfigurationDetails' => [ 'type' => 'structure', 'members' => [ 'ExecuteCommandConfiguration' => [ 'shape' => 'AwsEcsClusterConfigurationExecuteCommandConfigurationDetails', ], ], ], 'AwsEcsClusterConfigurationExecuteCommandConfigurationDetails' => [ 'type' => 'structure', 'members' => [ 'KmsKeyId' => [ 'shape' => 'NonEmptyString', ], 'LogConfiguration' => [ 'shape' => 'AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails', ], 'Logging' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails' => [ 'type' => 'structure', 'members' => [ 'CloudWatchEncryptionEnabled' => [ 'shape' => 'Boolean', ], 'CloudWatchLogGroupName' => [ 'shape' => 'NonEmptyString', ], 'S3BucketName' => [ 'shape' => 'NonEmptyString', ], 'S3EncryptionEnabled' => [ 'shape' => 'Boolean', ], 'S3KeyPrefix' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsClusterDefaultCapacityProviderStrategyDetails' => [ 'type' => 'structure', 'members' => [ 'Base' => [ 'shape' => 'Integer', ], 'CapacityProvider' => [ 'shape' => 'NonEmptyString', ], 'Weight' => [ 'shape' => 'Integer', ], ], ], 'AwsEcsClusterDefaultCapacityProviderStrategyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEcsClusterDefaultCapacityProviderStrategyDetails', ], ], 'AwsEcsClusterDetails' => [ 'type' => 'structure', 'members' => [ 'ClusterArn' => [ 'shape' => 'NonEmptyString', ], 'ActiveServicesCount' => [ 'shape' => 'Integer', ], 'CapacityProviders' => [ 'shape' => 'NonEmptyStringList', ], 'ClusterSettings' => [ 'shape' => 'AwsEcsClusterClusterSettingsList', ], 'Configuration' => [ 'shape' => 'AwsEcsClusterConfigurationDetails', ], 'DefaultCapacityProviderStrategy' => [ 'shape' => 'AwsEcsClusterDefaultCapacityProviderStrategyList', ], 'ClusterName' => [ 'shape' => 'NonEmptyString', ], 'RegisteredContainerInstancesCount' => [ 'shape' => 'Integer', ], 'RunningTasksCount' => [ 'shape' => 'Integer', ], 'Status' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsContainerDetails' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'NonEmptyString', ], 'Image' => [ 'shape' => 'NonEmptyString', ], 'MountPoints' => [ 'shape' => 'AwsMountPointList', ], 'Privileged' => [ 'shape' => 'Boolean', ], ], ], 'AwsEcsContainerDetailsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEcsContainerDetails', ], ], 'AwsEcsServiceCapacityProviderStrategyDetails' => [ 'type' => 'structure', 'members' => [ 'Base' => [ 'shape' => 'Integer', ], 'CapacityProvider' => [ 'shape' => 'NonEmptyString', ], 'Weight' => [ 'shape' => 'Integer', ], ], ], 'AwsEcsServiceCapacityProviderStrategyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEcsServiceCapacityProviderStrategyDetails', ], ], 'AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails' => [ 'type' => 'structure', 'members' => [ 'Enable' => [ 'shape' => 'Boolean', ], 'Rollback' => [ 'shape' => 'Boolean', ], ], ], 'AwsEcsServiceDeploymentConfigurationDetails' => [ 'type' => 'structure', 'members' => [ 'DeploymentCircuitBreaker' => [ 'shape' => 'AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails', ], 'MaximumPercent' => [ 'shape' => 'Integer', ], 'MinimumHealthyPercent' => [ 'shape' => 'Integer', ], ], ], 'AwsEcsServiceDeploymentControllerDetails' => [ 'type' => 'structure', 'members' => [ 'Type' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsServiceDetails' => [ 'type' => 'structure', 'members' => [ 'CapacityProviderStrategy' => [ 'shape' => 'AwsEcsServiceCapacityProviderStrategyList', ], 'Cluster' => [ 'shape' => 'NonEmptyString', ], 'DeploymentConfiguration' => [ 'shape' => 'AwsEcsServiceDeploymentConfigurationDetails', ], 'DeploymentController' => [ 'shape' => 'AwsEcsServiceDeploymentControllerDetails', ], 'DesiredCount' => [ 'shape' => 'Integer', ], 'EnableEcsManagedTags' => [ 'shape' => 'Boolean', ], 'EnableExecuteCommand' => [ 'shape' => 'Boolean', ], 'HealthCheckGracePeriodSeconds' => [ 'shape' => 'Integer', ], 'LaunchType' => [ 'shape' => 'NonEmptyString', ], 'LoadBalancers' => [ 'shape' => 'AwsEcsServiceLoadBalancersList', ], 'Name' => [ 'shape' => 'NonEmptyString', ], 'NetworkConfiguration' => [ 'shape' => 'AwsEcsServiceNetworkConfigurationDetails', ], 'PlacementConstraints' => [ 'shape' => 'AwsEcsServicePlacementConstraintsList', ], 'PlacementStrategies' => [ 'shape' => 'AwsEcsServicePlacementStrategiesList', ], 'PlatformVersion' => [ 'shape' => 'NonEmptyString', ], 'PropagateTags' => [ 'shape' => 'NonEmptyString', ], 'Role' => [ 'shape' => 'NonEmptyString', ], 'SchedulingStrategy' => [ 'shape' => 'NonEmptyString', ], 'ServiceArn' => [ 'shape' => 'NonEmptyString', ], 'ServiceName' => [ 'shape' => 'NonEmptyString', ], 'ServiceRegistries' => [ 'shape' => 'AwsEcsServiceServiceRegistriesList', ], 'TaskDefinition' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsServiceLoadBalancersDetails' => [ 'type' => 'structure', 'members' => [ 'ContainerName' => [ 'shape' => 'NonEmptyString', ], 'ContainerPort' => [ 'shape' => 'Integer', ], 'LoadBalancerName' => [ 'shape' => 'NonEmptyString', ], 'TargetGroupArn' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsServiceLoadBalancersList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEcsServiceLoadBalancersDetails', ], ], 'AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails' => [ 'type' => 'structure', 'members' => [ 'AssignPublicIp' => [ 'shape' => 'NonEmptyString', ], 'SecurityGroups' => [ 'shape' => 'NonEmptyStringList', ], 'Subnets' => [ 'shape' => 'NonEmptyStringList', ], ], ], 'AwsEcsServiceNetworkConfigurationDetails' => [ 'type' => 'structure', 'members' => [ 'AwsVpcConfiguration' => [ 'shape' => 'AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails', ], ], ], 'AwsEcsServicePlacementConstraintsDetails' => [ 'type' => 'structure', 'members' => [ 'Expression' => [ 'shape' => 'NonEmptyString', ], 'Type' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsServicePlacementConstraintsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEcsServicePlacementConstraintsDetails', ], ], 'AwsEcsServicePlacementStrategiesDetails' => [ 'type' => 'structure', 'members' => [ 'Field' => [ 'shape' => 'NonEmptyString', ], 'Type' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsServicePlacementStrategiesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEcsServicePlacementStrategiesDetails', ], ], 'AwsEcsServiceServiceRegistriesDetails' => [ 'type' => 'structure', 'members' => [ 'ContainerName' => [ 'shape' => 'NonEmptyString', ], 'ContainerPort' => [ 'shape' => 'Integer', ], 'Port' => [ 'shape' => 'Integer', ], 'RegistryArn' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsServiceServiceRegistriesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEcsServiceServiceRegistriesDetails', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails' => [ 'type' => 'structure', 'members' => [ 'Condition' => [ 'shape' => 'NonEmptyString', ], 'ContainerName' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsTaskDefinitionContainerDefinitionsDependsOnList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsDetails' => [ 'type' => 'structure', 'members' => [ 'Command' => [ 'shape' => 'NonEmptyStringList', ], 'Cpu' => [ 'shape' => 'Integer', ], 'DependsOn' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsDependsOnList', ], 'DisableNetworking' => [ 'shape' => 'Boolean', ], 'DnsSearchDomains' => [ 'shape' => 'NonEmptyStringList', ], 'DnsServers' => [ 'shape' => 'NonEmptyStringList', ], 'DockerLabels' => [ 'shape' => 'FieldMap', ], 'DockerSecurityOptions' => [ 'shape' => 'NonEmptyStringList', ], 'EntryPoint' => [ 'shape' => 'NonEmptyStringList', ], 'Environment' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsEnvironmentList', ], 'EnvironmentFiles' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesList', ], 'Essential' => [ 'shape' => 'Boolean', ], 'ExtraHosts' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsExtraHostsList', ], 'FirelensConfiguration' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails', ], 'HealthCheck' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails', ], 'Hostname' => [ 'shape' => 'NonEmptyString', ], 'Image' => [ 'shape' => 'NonEmptyString', ], 'Interactive' => [ 'shape' => 'Boolean', ], 'Links' => [ 'shape' => 'NonEmptyStringList', ], 'LinuxParameters' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails', ], 'LogConfiguration' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails', ], 'Memory' => [ 'shape' => 'Integer', ], 'MemoryReservation' => [ 'shape' => 'Integer', ], 'MountPoints' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsMountPointsList', ], 'Name' => [ 'shape' => 'NonEmptyString', ], 'PortMappings' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsPortMappingsList', ], 'Privileged' => [ 'shape' => 'Boolean', ], 'PseudoTerminal' => [ 'shape' => 'Boolean', ], 'ReadonlyRootFilesystem' => [ 'shape' => 'Boolean', ], 'RepositoryCredentials' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails', ], 'ResourceRequirements' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsList', ], 'Secrets' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsSecretsList', ], 'StartTimeout' => [ 'shape' => 'Integer', ], 'StopTimeout' => [ 'shape' => 'Integer', ], 'SystemControls' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsSystemControlsList', ], 'Ulimits' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsUlimitsList', ], 'User' => [ 'shape' => 'NonEmptyString', ], 'VolumesFrom' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsVolumesFromList', ], 'WorkingDirectory' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'NonEmptyString', ], 'Value' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails' => [ 'type' => 'structure', 'members' => [ 'Type' => [ 'shape' => 'NonEmptyString', ], 'Value' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsEnvironmentList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails' => [ 'type' => 'structure', 'members' => [ 'Hostname' => [ 'shape' => 'NonEmptyString', ], 'IpAddress' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsTaskDefinitionContainerDefinitionsExtraHostsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails' => [ 'type' => 'structure', 'members' => [ 'Options' => [ 'shape' => 'FieldMap', ], 'Type' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails' => [ 'type' => 'structure', 'members' => [ 'Command' => [ 'shape' => 'NonEmptyStringList', ], 'Interval' => [ 'shape' => 'Integer', ], 'Retries' => [ 'shape' => 'Integer', ], 'StartPeriod' => [ 'shape' => 'Integer', ], 'Timeout' => [ 'shape' => 'Integer', ], ], ], 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails' => [ 'type' => 'structure', 'members' => [ 'Add' => [ 'shape' => 'NonEmptyStringList', ], 'Drop' => [ 'shape' => 'NonEmptyStringList', ], ], ], 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails' => [ 'type' => 'structure', 'members' => [ 'Capabilities' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails', ], 'Devices' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesList', ], 'InitProcessEnabled' => [ 'shape' => 'Boolean', ], 'MaxSwap' => [ 'shape' => 'Integer', ], 'SharedMemorySize' => [ 'shape' => 'Integer', ], 'Swappiness' => [ 'shape' => 'Integer', ], 'Tmpfs' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsList', ], ], ], 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails' => [ 'type' => 'structure', 'members' => [ 'ContainerPath' => [ 'shape' => 'NonEmptyString', ], 'HostPath' => [ 'shape' => 'NonEmptyString', ], 'Permissions' => [ 'shape' => 'NonEmptyStringList', ], ], ], 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails' => [ 'type' => 'structure', 'members' => [ 'ContainerPath' => [ 'shape' => 'NonEmptyString', ], 'MountOptions' => [ 'shape' => 'NonEmptyStringList', ], 'Size' => [ 'shape' => 'Integer', ], ], ], 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsDetails', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails' => [ 'type' => 'structure', 'members' => [ 'LogDriver' => [ 'shape' => 'NonEmptyString', ], 'Options' => [ 'shape' => 'FieldMap', ], 'SecretOptions' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsList', ], ], ], 'AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'NonEmptyString', ], 'ValueFrom' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails' => [ 'type' => 'structure', 'members' => [ 'ContainerPath' => [ 'shape' => 'NonEmptyString', ], 'ReadOnly' => [ 'shape' => 'Boolean', ], 'SourceVolume' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsTaskDefinitionContainerDefinitionsMountPointsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails' => [ 'type' => 'structure', 'members' => [ 'ContainerPort' => [ 'shape' => 'Integer', ], 'HostPort' => [ 'shape' => 'Integer', ], 'Protocol' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsTaskDefinitionContainerDefinitionsPortMappingsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails' => [ 'type' => 'structure', 'members' => [ 'CredentialsParameter' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails' => [ 'type' => 'structure', 'members' => [ 'Type' => [ 'shape' => 'NonEmptyString', ], 'Value' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'NonEmptyString', ], 'ValueFrom' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsTaskDefinitionContainerDefinitionsSecretsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails' => [ 'type' => 'structure', 'members' => [ 'Namespace' => [ 'shape' => 'NonEmptyString', ], 'Value' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsTaskDefinitionContainerDefinitionsSystemControlsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails' => [ 'type' => 'structure', 'members' => [ 'HardLimit' => [ 'shape' => 'Integer', ], 'Name' => [ 'shape' => 'NonEmptyString', ], 'SoftLimit' => [ 'shape' => 'Integer', ], ], ], 'AwsEcsTaskDefinitionContainerDefinitionsUlimitsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails' => [ 'type' => 'structure', 'members' => [ 'ReadOnly' => [ 'shape' => 'Boolean', ], 'SourceContainer' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsTaskDefinitionContainerDefinitionsVolumesFromList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails', ], ], 'AwsEcsTaskDefinitionDetails' => [ 'type' => 'structure', 'members' => [ 'ContainerDefinitions' => [ 'shape' => 'AwsEcsTaskDefinitionContainerDefinitionsList', ], 'Cpu' => [ 'shape' => 'NonEmptyString', ], 'ExecutionRoleArn' => [ 'shape' => 'NonEmptyString', ], 'Family' => [ 'shape' => 'NonEmptyString', ], 'InferenceAccelerators' => [ 'shape' => 'AwsEcsTaskDefinitionInferenceAcceleratorsList', ], 'IpcMode' => [ 'shape' => 'NonEmptyString', ], 'Memory' => [ 'shape' => 'NonEmptyString', ], 'NetworkMode' => [ 'shape' => 'NonEmptyString', ], 'PidMode' => [ 'shape' => 'NonEmptyString', ], 'PlacementConstraints' => [ 'shape' => 'AwsEcsTaskDefinitionPlacementConstraintsList', ], 'ProxyConfiguration' => [ 'shape' => 'AwsEcsTaskDefinitionProxyConfigurationDetails', ], 'RequiresCompatibilities' => [ 'shape' => 'NonEmptyStringList', ], 'TaskRoleArn' => [ 'shape' => 'NonEmptyString', ], 'Volumes' => [ 'shape' => 'AwsEcsTaskDefinitionVolumesList', ], 'Status' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsTaskDefinitionInferenceAcceleratorsDetails' => [ 'type' => 'structure', 'members' => [ 'DeviceName' => [ 'shape' => 'NonEmptyString', ], 'DeviceType' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsTaskDefinitionInferenceAcceleratorsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEcsTaskDefinitionInferenceAcceleratorsDetails', ], ], 'AwsEcsTaskDefinitionPlacementConstraintsDetails' => [ 'type' => 'structure', 'members' => [ 'Expression' => [ 'shape' => 'NonEmptyString', ], 'Type' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsTaskDefinitionPlacementConstraintsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEcsTaskDefinitionPlacementConstraintsDetails', ], ], 'AwsEcsTaskDefinitionProxyConfigurationDetails' => [ 'type' => 'structure', 'members' => [ 'ContainerName' => [ 'shape' => 'NonEmptyString', ], 'ProxyConfigurationProperties' => [ 'shape' => 'AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesList', ], 'Type' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'NonEmptyString', ], 'Value' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails', ], ], 'AwsEcsTaskDefinitionVolumesDetails' => [ 'type' => 'structure', 'members' => [ 'DockerVolumeConfiguration' => [ 'shape' => 'AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails', ], 'EfsVolumeConfiguration' => [ 'shape' => 'AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails', ], 'Host' => [ 'shape' => 'AwsEcsTaskDefinitionVolumesHostDetails', ], 'Name' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails' => [ 'type' => 'structure', 'members' => [ 'Autoprovision' => [ 'shape' => 'Boolean', ], 'Driver' => [ 'shape' => 'NonEmptyString', ], 'DriverOpts' => [ 'shape' => 'FieldMap', ], 'Labels' => [ 'shape' => 'FieldMap', ], 'Scope' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails' => [ 'type' => 'structure', 'members' => [ 'AccessPointId' => [ 'shape' => 'NonEmptyString', ], 'Iam' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails' => [ 'type' => 'structure', 'members' => [ 'AuthorizationConfig' => [ 'shape' => 'AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails', ], 'FilesystemId' => [ 'shape' => 'NonEmptyString', ], 'RootDirectory' => [ 'shape' => 'NonEmptyString', ], 'TransitEncryption' => [ 'shape' => 'NonEmptyString', ], 'TransitEncryptionPort' => [ 'shape' => 'Integer', ], ], ], 'AwsEcsTaskDefinitionVolumesHostDetails' => [ 'type' => 'structure', 'members' => [ 'SourcePath' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEcsTaskDefinitionVolumesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEcsTaskDefinitionVolumesDetails', ], ], 'AwsEcsTaskDetails' => [ 'type' => 'structure', 'members' => [ 'ClusterArn' => [ 'shape' => 'NonEmptyString', ], 'TaskDefinitionArn' => [ 'shape' => 'NonEmptyString', ], 'Version' => [ 'shape' => 'NonEmptyString', ], 'CreatedAt' => [ 'shape' => 'NonEmptyString', ], 'StartedAt' => [ 'shape' => 'NonEmptyString', ], 'StartedBy' => [ 'shape' => 'NonEmptyString', ], 'Group' => [ 'shape' => 'NonEmptyString', ], 'Volumes' => [ 'shape' => 'AwsEcsTaskVolumeDetailsList', ], 'Containers' => [ 'shape' => 'AwsEcsContainerDetailsList', ], ], ], 'AwsEcsTaskVolumeDetails' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'NonEmptyString', ], 'Host' => [ 'shape' => 'AwsEcsTaskVolumeHostDetails', ], ], ], 'AwsEcsTaskVolumeDetailsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEcsTaskVolumeDetails', ], ], 'AwsEcsTaskVolumeHostDetails' => [ 'type' => 'structure', 'members' => [ 'SourcePath' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEfsAccessPointDetails' => [ 'type' => 'structure', 'members' => [ 'AccessPointId' => [ 'shape' => 'NonEmptyString', ], 'Arn' => [ 'shape' => 'NonEmptyString', ], 'ClientToken' => [ 'shape' => 'NonEmptyString', ], 'FileSystemId' => [ 'shape' => 'NonEmptyString', ], 'PosixUser' => [ 'shape' => 'AwsEfsAccessPointPosixUserDetails', ], 'RootDirectory' => [ 'shape' => 'AwsEfsAccessPointRootDirectoryDetails', ], ], ], 'AwsEfsAccessPointPosixUserDetails' => [ 'type' => 'structure', 'members' => [ 'Gid' => [ 'shape' => 'NonEmptyString', ], 'SecondaryGids' => [ 'shape' => 'NonEmptyStringList', ], 'Uid' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEfsAccessPointRootDirectoryCreationInfoDetails' => [ 'type' => 'structure', 'members' => [ 'OwnerGid' => [ 'shape' => 'NonEmptyString', ], 'OwnerUid' => [ 'shape' => 'NonEmptyString', ], 'Permissions' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEfsAccessPointRootDirectoryDetails' => [ 'type' => 'structure', 'members' => [ 'CreationInfo' => [ 'shape' => 'AwsEfsAccessPointRootDirectoryCreationInfoDetails', ], 'Path' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsEksClusterDetails' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'NonEmptyString', ], 'CertificateAuthorityData' => [ 'shape' => 'NonEmptyString', ], 'ClusterStatus' => [ 'shape' => 'NonEmptyString', ], 'Endpoint' => [ 'shape' => 'NonEmptyString', ], 'Name' => [ 'shape' => 'NonEmptyString', ], 'ResourcesVpcConfig' => [ 'shape' => 'AwsEksClusterResourcesVpcConfigDetails', ], 'RoleArn' => [ 'shape' => 'NonEmptyString', ], 'Version' => [ 'shape' => 'NonEmptyString', ], 'Logging' => [ 'shape' => 'AwsEksClusterLoggingDetails', ], ], ], 'AwsEksClusterLoggingClusterLoggingDetails' => [ 'type' => 'structure', 'members' => [ 'Enabled' => [ 'shape' => 'Boolean', ], 'Types' => [ 'shape' => 'NonEmptyStringList', ], ], ], 'AwsEksClusterLoggingClusterLoggingList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsEksClusterLoggingClusterLoggingDetails', ], ], 'AwsEksClusterLoggingDetails' => [ 'type' => 'structure', 'members' => [ 'ClusterLogging' => [ 'shape' => 'AwsEksClusterLoggingClusterLoggingList', ], ], ], 'AwsEksClusterResourcesVpcConfigDetails' => [ 'type' => 'structure', 'members' => [ 'SecurityGroupIds' => [ 'shape' => 'NonEmptyStringList', ], 'SubnetIds' => [ 'shape' => 'NonEmptyStringList', ], 'EndpointPublicAccess' => [ 'shape' => 'Boolean', ], ], ], 'AwsElasticBeanstalkEnvironmentDetails' => [ 'type' => 'structure', 'members' => [ 'ApplicationName' => [ 'shape' => 'NonEmptyString', ], 'Cname' => [ 'shape' => 'NonEmptyString', ], 'DateCreated' => [ 'shape' => 'NonEmptyString', ], 'DateUpdated' => [ 'shape' => 'NonEmptyString', ], 'Description' => [ 'shape' => 'NonEmptyString', ], 'EndpointUrl' => [ 'shape' => 'NonEmptyString', ], 'EnvironmentArn' => [ 'shape' => 'NonEmptyString', ], 'EnvironmentId' => [ 'shape' => 'NonEmptyString', ], 'EnvironmentLinks' => [ 'shape' => 'AwsElasticBeanstalkEnvironmentEnvironmentLinks', ], 'EnvironmentName' => [ 'shape' => 'NonEmptyString', ], 'OptionSettings' => [ 'shape' => 'AwsElasticBeanstalkEnvironmentOptionSettings', ], 'PlatformArn' => [ 'shape' => 'NonEmptyString', ], 'SolutionStackName' => [ 'shape' => 'NonEmptyString', ], 'Status' => [ 'shape' => 'NonEmptyString', ], 'Tier' => [ 'shape' => 'AwsElasticBeanstalkEnvironmentTier', ], 'VersionLabel' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsElasticBeanstalkEnvironmentEnvironmentLink' => [ 'type' => 'structure', 'members' => [ 'EnvironmentName' => [ 'shape' => 'NonEmptyString', ], 'LinkName' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsElasticBeanstalkEnvironmentEnvironmentLinks' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsElasticBeanstalkEnvironmentEnvironmentLink', ], ], 'AwsElasticBeanstalkEnvironmentOptionSetting' => [ 'type' => 'structure', 'members' => [ 'Namespace' => [ 'shape' => 'NonEmptyString', ], 'OptionName' => [ 'shape' => 'NonEmptyString', ], 'ResourceName' => [ 'shape' => 'NonEmptyString', ], 'Value' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsElasticBeanstalkEnvironmentOptionSettings' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsElasticBeanstalkEnvironmentOptionSetting', ], ], 'AwsElasticBeanstalkEnvironmentTier' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'NonEmptyString', ], 'Type' => [ 'shape' => 'NonEmptyString', ], 'Version' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsElasticsearchDomainDetails' => [ 'type' => 'structure', 'members' => [ 'AccessPolicies' => [ 'shape' => 'NonEmptyString', ], 'DomainEndpointOptions' => [ 'shape' => 'AwsElasticsearchDomainDomainEndpointOptions', ], 'DomainId' => [ 'shape' => 'NonEmptyString', ], 'DomainName' => [ 'shape' => 'NonEmptyString', ], 'Endpoint' => [ 'shape' => 'NonEmptyString', ], 'Endpoints' => [ 'shape' => 'FieldMap', ], 'ElasticsearchVersion' => [ 'shape' => 'NonEmptyString', ], 'ElasticsearchClusterConfig' => [ 'shape' => 'AwsElasticsearchDomainElasticsearchClusterConfigDetails', ], 'EncryptionAtRestOptions' => [ 'shape' => 'AwsElasticsearchDomainEncryptionAtRestOptions', ], 'LogPublishingOptions' => [ 'shape' => 'AwsElasticsearchDomainLogPublishingOptions', ], 'NodeToNodeEncryptionOptions' => [ 'shape' => 'AwsElasticsearchDomainNodeToNodeEncryptionOptions', ], 'ServiceSoftwareOptions' => [ 'shape' => 'AwsElasticsearchDomainServiceSoftwareOptions', ], 'VPCOptions' => [ 'shape' => 'AwsElasticsearchDomainVPCOptions', ], ], ], 'AwsElasticsearchDomainDomainEndpointOptions' => [ 'type' => 'structure', 'members' => [ 'EnforceHTTPS' => [ 'shape' => 'Boolean', ], 'TLSSecurityPolicy' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsElasticsearchDomainElasticsearchClusterConfigDetails' => [ 'type' => 'structure', 'members' => [ 'DedicatedMasterCount' => [ 'shape' => 'Integer', ], 'DedicatedMasterEnabled' => [ 'shape' => 'Boolean', ], 'DedicatedMasterType' => [ 'shape' => 'NonEmptyString', ], 'InstanceCount' => [ 'shape' => 'Integer', ], 'InstanceType' => [ 'shape' => 'NonEmptyString', ], 'ZoneAwarenessConfig' => [ 'shape' => 'AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails', ], 'ZoneAwarenessEnabled' => [ 'shape' => 'Boolean', ], ], ], 'AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails' => [ 'type' => 'structure', 'members' => [ 'AvailabilityZoneCount' => [ 'shape' => 'Integer', ], ], ], 'AwsElasticsearchDomainEncryptionAtRestOptions' => [ 'type' => 'structure', 'members' => [ 'Enabled' => [ 'shape' => 'Boolean', ], 'KmsKeyId' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsElasticsearchDomainLogPublishingOptions' => [ 'type' => 'structure', 'members' => [ 'IndexSlowLogs' => [ 'shape' => 'AwsElasticsearchDomainLogPublishingOptionsLogConfig', ], 'SearchSlowLogs' => [ 'shape' => 'AwsElasticsearchDomainLogPublishingOptionsLogConfig', ], 'AuditLogs' => [ 'shape' => 'AwsElasticsearchDomainLogPublishingOptionsLogConfig', ], ], ], 'AwsElasticsearchDomainLogPublishingOptionsLogConfig' => [ 'type' => 'structure', 'members' => [ 'CloudWatchLogsLogGroupArn' => [ 'shape' => 'NonEmptyString', ], 'Enabled' => [ 'shape' => 'Boolean', ], ], ], 'AwsElasticsearchDomainNodeToNodeEncryptionOptions' => [ 'type' => 'structure', 'members' => [ 'Enabled' => [ 'shape' => 'Boolean', ], ], ], 'AwsElasticsearchDomainServiceSoftwareOptions' => [ 'type' => 'structure', 'members' => [ 'AutomatedUpdateDate' => [ 'shape' => 'NonEmptyString', ], 'Cancellable' => [ 'shape' => 'Boolean', ], 'CurrentVersion' => [ 'shape' => 'NonEmptyString', ], 'Description' => [ 'shape' => 'NonEmptyString', ], 'NewVersion' => [ 'shape' => 'NonEmptyString', ], 'UpdateAvailable' => [ 'shape' => 'Boolean', ], 'UpdateStatus' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsElasticsearchDomainVPCOptions' => [ 'type' => 'structure', 'members' => [ 'AvailabilityZones' => [ 'shape' => 'NonEmptyStringList', ], 'SecurityGroupIds' => [ 'shape' => 'NonEmptyStringList', ], 'SubnetIds' => [ 'shape' => 'NonEmptyStringList', ], 'VPCId' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsElbAppCookieStickinessPolicies' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsElbAppCookieStickinessPolicy', ], ], 'AwsElbAppCookieStickinessPolicy' => [ 'type' => 'structure', 'members' => [ 'CookieName' => [ 'shape' => 'NonEmptyString', ], 'PolicyName' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsElbLbCookieStickinessPolicies' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsElbLbCookieStickinessPolicy', ], ], 'AwsElbLbCookieStickinessPolicy' => [ 'type' => 'structure', 'members' => [ 'CookieExpirationPeriod' => [ 'shape' => 'Long', ], 'PolicyName' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsElbLoadBalancerAccessLog' => [ 'type' => 'structure', 'members' => [ 'EmitInterval' => [ 'shape' => 'Integer', ], 'Enabled' => [ 'shape' => 'Boolean', ], 'S3BucketName' => [ 'shape' => 'NonEmptyString', ], 'S3BucketPrefix' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsElbLoadBalancerAdditionalAttribute' => [ 'type' => 'structure', 'members' => [ 'Key' => [ 'shape' => 'NonEmptyString', ], 'Value' => [ 'shape' => 'NonEmptyString', ], ], ], 'AwsElbLoadBalancerAdditionalAttributeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsElbLoadBalancerAdditionalAttribute', ], ], 'AwsElbLoadBalancerAttributes' => [ 'type' => 'structure', 'members' => [ 'AccessLog' => [ 'shape' => 'AwsElbLoadBalancerAccessLog', ], 'ConnectionDraining' => [ 'shape' => 'AwsElbLoadBalancerConnectionDraining', ], 'ConnectionSettings' => [ 'shape' => 'AwsElbLoadBalancerConnectionSettings', ], 'CrossZoneLoadBalancing' => [ 'shape' => 'AwsElbLoadBalancerCrossZoneLoadBalancing', ], 'AdditionalAttributes' => [ 'shape' => 'AwsElbLoadBalancerAdditionalAttributeList', ], ], ], 'AwsElbLoadBalan