<?php
// This file was auto-generated from sdk-root/src/data/transfer/2018-11-05/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2018-11-05', 'endpointPrefix' => 'transfer', 'jsonVersion' => '1.1', 'protocol' => 'json', 'protocols' => [ 'json', ], 'serviceAbbreviation' => 'AWS Transfer', 'serviceFullName' => 'AWS Transfer Family', 'serviceId' => 'Transfer', 'signatureVersion' => 'v4', 'signingName' => 'transfer', 'targetPrefix' => 'TransferService', 'uid' => 'transfer-2018-11-05', ], 'operations' => [ 'CreateAccess' => [ 'name' => 'CreateAccess', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateAccessRequest', ], 'output' => [ 'shape' => 'CreateAccessResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceExistsException', ], ], ], 'CreateAgreement' => [ 'name' => 'CreateAgreement', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateAgreementRequest', ], 'output' => [ 'shape' => 'CreateAgreementResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceExistsException', ], ], ], 'CreateConnector' => [ 'name' => 'CreateConnector', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateConnectorRequest', ], 'output' => [ 'shape' => 'CreateConnectorResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceExistsException', ], ], ], 'CreateProfile' => [ 'name' => 'CreateProfile', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateProfileRequest', ], 'output' => [ 'shape' => 'CreateProfileResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'CreateServer' => [ 'name' => 'CreateServer', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateServerRequest', ], 'output' => [ 'shape' => 'CreateServerResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceExistsException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'CreateUser' => [ 'name' => 'CreateUser', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateUserRequest', ], 'output' => [ 'shape' => 'CreateUserResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceExistsException', ], ], 'idempotent' => true, ], 'CreateWorkflow' => [ 'name' => 'CreateWorkflow', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateWorkflowRequest', ], 'output' => [ 'shape' => 'CreateWorkflowResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceExistsException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'DeleteAccess' => [ 'name' => 'DeleteAccess', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteAccessRequest', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'DeleteAgreement' => [ 'name' => 'DeleteAgreement', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteAgreementRequest', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], 'idempotent' => true, ], 'DeleteCertificate' => [ 'name' => 'DeleteCertificate', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteCertificateRequest', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], 'idempotent' => true, ], 'DeleteConnector' => [ 'name' => 'DeleteConnector', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteConnectorRequest', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], 'idempotent' => true, ], 'DeleteHostKey' => [ 'name' => 'DeleteHostKey', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteHostKeyRequest', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'DeleteProfile' => [ 'name' => 'DeleteProfile', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteProfileRequest', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], 'idempotent' => true, ], 'DeleteServer' => [ 'name' => 'DeleteServer', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteServerRequest', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'AccessDeniedException', ], ], 'idempotent' => true, ], 'DeleteSshPublicKey' => [ 'name' => 'DeleteSshPublicKey', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteSshPublicKeyRequest', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'DeleteUser' => [ 'name' => 'DeleteUser', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteUserRequest', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], 'idempotent' => true, ], 'DeleteWorkflow' => [ 'name' => 'DeleteWorkflow', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteWorkflowRequest', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'AccessDeniedException', ], ], 'idempotent' => true, ], 'DescribeAccess' => [ 'name' => 'DescribeAccess', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeAccessRequest', ], 'output' => [ 'shape' => 'DescribeAccessResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'DescribeAgreement' => [ 'name' => 'DescribeAgreement', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeAgreementRequest', ], 'output' => [ 'shape' => 'DescribeAgreementResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'DescribeCertificate' => [ 'name' => 'DescribeCertificate', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeCertificateRequest', ], 'output' => [ 'shape' => 'DescribeCertificateResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'DescribeConnector' => [ 'name' => 'DescribeConnector', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeConnectorRequest', ], 'output' => [ 'shape' => 'DescribeConnectorResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'DescribeExecution' => [ 'name' => 'DescribeExecution', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeExecutionRequest', ], 'output' => [ 'shape' => 'DescribeExecutionResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'DescribeHostKey' => [ 'name' => 'DescribeHostKey', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeHostKeyRequest', ], 'output' => [ 'shape' => 'DescribeHostKeyResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'DescribeProfile' => [ 'name' => 'DescribeProfile', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeProfileRequest', ], 'output' => [ 'shape' => 'DescribeProfileResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'DescribeSecurityPolicy' => [ 'name' => 'DescribeSecurityPolicy', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeSecurityPolicyRequest', ], 'output' => [ 'shape' => 'DescribeSecurityPolicyResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'DescribeServer' => [ 'name' => 'DescribeServer', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeServerRequest', ], 'output' => [ 'shape' => 'DescribeServerResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'DescribeUser' => [ 'name' => 'DescribeUser', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeUserRequest', ], 'output' => [ 'shape' => 'DescribeUserResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'DescribeWorkflow' => [ 'name' => 'DescribeWorkflow', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeWorkflowRequest', ], 'output' => [ 'shape' => 'DescribeWorkflowResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'ImportCertificate' => [ 'name' => 'ImportCertificate', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ImportCertificateRequest', ], 'output' => [ 'shape' => 'ImportCertificateResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'ImportHostKey' => [ 'name' => 'ImportHostKey', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ImportHostKeyRequest', ], 'output' => [ 'shape' => 'ImportHostKeyResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceExistsException', ], ], ], 'ImportSshPublicKey' => [ 'name' => 'ImportSshPublicKey', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ImportSshPublicKeyRequest', ], 'output' => [ 'shape' => 'ImportSshPublicKeyResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceExistsException', ], ], ], 'ListAccesses' => [ 'name' => 'ListAccesses', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListAccessesRequest', ], 'output' => [ 'shape' => 'ListAccessesResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'InvalidNextTokenException', ], ], ], 'ListAgreements' => [ 'name' => 'ListAgreements', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListAgreementsRequest', ], 'output' => [ 'shape' => 'ListAgreementsResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'InvalidNextTokenException', ], ], ], 'ListCertificates' => [ 'name' => 'ListCertificates', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListCertificatesRequest', ], 'output' => [ 'shape' => 'ListCertificatesResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'InvalidNextTokenException', ], ], ], 'ListConnectors' => [ 'name' => 'ListConnectors', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListConnectorsRequest', ], 'output' => [ 'shape' => 'ListConnectorsResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'InvalidNextTokenException', ], ], ], 'ListExecutions' => [ 'name' => 'ListExecutions', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListExecutionsRequest', ], 'output' => [ 'shape' => 'ListExecutionsResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'InvalidNextTokenException', ], ], ], 'ListHostKeys' => [ 'name' => 'ListHostKeys', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListHostKeysRequest', ], 'output' => [ 'shape' => 'ListHostKeysResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'InvalidNextTokenException', ], ], ], 'ListProfiles' => [ 'name' => 'ListProfiles', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListProfilesRequest', ], 'output' => [ 'shape' => 'ListProfilesResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'InvalidNextTokenException', ], ], ], 'ListSecurityPolicies' => [ 'name' => 'ListSecurityPolicies', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListSecurityPoliciesRequest', ], 'output' => [ 'shape' => 'ListSecurityPoliciesResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'InvalidNextTokenException', ], ], ], 'ListServers' => [ 'name' => 'ListServers', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListServersRequest', ], 'output' => [ 'shape' => 'ListServersResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'InvalidNextTokenException', ], ], ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'InvalidNextTokenException', ], ], ], 'ListUsers' => [ 'name' => 'ListUsers', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListUsersRequest', ], 'output' => [ 'shape' => 'ListUsersResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'InvalidNextTokenException', ], ], ], 'ListWorkflows' => [ 'name' => 'ListWorkflows', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListWorkflowsRequest', ], 'output' => [ 'shape' => 'ListWorkflowsResponse', ], 'errors' => [ [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'InvalidNextTokenException', ], ], ], 'SendWorkflowStepState' => [ 'name' => 'SendWorkflowStepState', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'SendWorkflowStepStateRequest', ], 'output' => [ 'shape' => 'SendWorkflowStepStateResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'StartDirectoryListing' => [ 'name' => 'StartDirectoryListing', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'StartDirectoryListingRequest', ], 'output' => [ 'shape' => 'StartDirectoryListingResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'StartFileTransfer' => [ 'name' => 'StartFileTransfer', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'StartFileTransferRequest', ], 'output' => [ 'shape' => 'StartFileTransferResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'StartServer' => [ 'name' => 'StartServer', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'StartServerRequest', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'StopServer' => [ 'name' => 'StopServer', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'StopServerRequest', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'TestConnection' => [ 'name' => 'TestConnection', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'TestConnectionRequest', ], 'output' => [ 'shape' => 'TestConnectionResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'TestIdentityProvider' => [ 'name' => 'TestIdentityProvider', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'TestIdentityProviderRequest', ], 'output' => [ 'shape' => 'TestIdentityProviderResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'UpdateAccess' => [ 'name' => 'UpdateAccess', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateAccessRequest', ], 'output' => [ 'shape' => 'UpdateAccessResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceExistsException', ], ], ], 'UpdateAgreement' => [ 'name' => 'UpdateAgreement', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateAgreementRequest', ], 'output' => [ 'shape' => 'UpdateAgreementResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceExistsException', ], ], ], 'UpdateCertificate' => [ 'name' => 'UpdateCertificate', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateCertificateRequest', ], 'output' => [ 'shape' => 'UpdateCertificateResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'UpdateConnector' => [ 'name' => 'UpdateConnector', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateConnectorRequest', ], 'output' => [ 'shape' => 'UpdateConnectorResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceExistsException', ], ], ], 'UpdateHostKey' => [ 'name' => 'UpdateHostKey', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateHostKeyRequest', ], 'output' => [ 'shape' => 'UpdateHostKeyResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'UpdateProfile' => [ 'name' => 'UpdateProfile', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateProfileRequest', ], 'output' => [ 'shape' => 'UpdateProfileResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], 'UpdateServer' => [ 'name' => 'UpdateServer', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateServerRequest', ], 'output' => [ 'shape' => 'UpdateServerResponse', ], 'errors' => [ [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceExistsException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'UpdateUser' => [ 'name' => 'UpdateUser', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateUserRequest', ], 'output' => [ 'shape' => 'UpdateUserResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServiceError', ], [ 'shape' => 'ServiceUnavailableException', ], ], ], ], 'shapes' => [ 'AccessDeniedException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ServiceErrorMessage', ], ], 'exception' => true, ], 'AddressAllocationId' => [ 'type' => 'string', ], 'AddressAllocationIds' => [ 'type' => 'list', 'member' => [ 'shape' => 'AddressAllocationId', ], ], 'AgreementId' => [ 'type' => 'string', 'max' => 19, 'min' => 19, 'pattern' => 'a-([0-9a-f]{17})', ], 'AgreementStatusType' => [ 'type' => 'string', 'enum' => [ 'ACTIVE', 'INACTIVE', ], ], 'Arn' => [ 'type' => 'string', 'max' => 1600, 'min' => 20, 'pattern' => 'arn:\\S+', ], 'As2ConnectorConfig' => [ 'type' => 'structure', 'members' => [ 'LocalProfileId' => [ 'shape' => 'ProfileId', ], 'PartnerProfileId' => [ 'shape' => 'ProfileId', ], 'MessageSubject' => [ 'shape' => 'MessageSubject', ], 'Compression' => [ 'shape' => 'CompressionEnum', ], 'EncryptionAlgorithm' => [ 'shape' => 'EncryptionAlg', ], 'SigningAlgorithm' => [ 'shape' => 'SigningAlg', ], 'MdnSigningAlgorithm' => [ 'shape' => 'MdnSigningAlg', ], 'MdnResponse' => [ 'shape' => 'MdnResponse', ], 'BasicAuthSecretId' => [ 'shape' => 'As2ConnectorSecretId', ], ], ], 'As2ConnectorSecretId' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, ], 'As2Id' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[\\p{Print}\\s]*', ], 'As2Transport' => [ 'type' => 'string', 'enum' => [ 'HTTP', ], ], 'As2Transports' => [ 'type' => 'list', 'member' => [ 'shape' => 'As2Transport', ], 'max' => 1, 'min' => 1, ], 'CallbackToken' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '\\w+', ], 'CertDate' => [ 'type' => 'timestamp', ], 'CertSerial' => [ 'type' => 'string', 'max' => 48, 'min' => 0, 'pattern' => '[\\p{XDigit}{2}:?]*', ], 'Certificate' => [ 'type' => 'string', 'max' => 1600, 'min' => 0, ], 'CertificateBodyType' => [ 'type' => 'string', 'max' => 16384, 'min' => 1, 'pattern' => '[\\u0009\\u000A\\u000D\\u0020-\\u00FF]*', 'sensitive' => true, ], 'CertificateChainType' => [ 'type' => 'string', 'max' => 2097152, 'min' => 1, 'pattern' => '[\\u0009\\u000A\\u000D\\u0020-\\u00FF]*', 'sensitive' => true, ], 'CertificateId' => [ 'type' => 'string', 'max' => 22, 'min' => 22, 'pattern' => 'cert-([0-9a-f]{17})', ], 'CertificateIds' => [ 'type' => 'list', 'member' => [ 'shape' => 'CertificateId', ], ], 'CertificateStatusType' => [ 'type' => 'string', 'enum' => [ 'ACTIVE', 'PENDING_ROTATION', 'INACTIVE', ], ], 'CertificateType' => [ 'type' => 'string', 'enum' => [ 'CERTIFICATE', 'CERTIFICATE_WITH_PRIVATE_KEY', ], ], 'CertificateUsageType' => [ 'type' => 'string', 'enum' => [ 'SIGNING', 'ENCRYPTION', 'TLS', ], ], 'CompressionEnum' => [ 'type' => 'string', 'enum' => [ 'ZLIB', 'DISABLED', ], ], 'ConflictException' => [ 'type' => 'structure', 'required' => [ 'Message', ], 'members' => [ 'Message' => [ 'shape' => 'Message', ], ], 'exception' => true, ], 'ConnectorId' => [ 'type' => 'string', 'max' => 19, 'min' => 19, 'pattern' => 'c-([0-9a-f]{17})', ], 'ConnectorSecurityPolicyName' => [ 'type' => 'string', 'max' => 100, 'min' => 0, 'pattern' => 'TransferSFTPConnectorSecurityPolicy-[A-Za-z0-9-]+', ], 'CopyStepDetails' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'WorkflowStepName', ], 'DestinationFileLocation' => [ 'shape' => 'InputFileLocation', ], 'OverwriteExisting' => [ 'shape' => 'OverwriteExisting', ], 'SourceFileLocation' => [ 'shape' => 'SourceFileLocation', ], ], ], 'CreateAccessRequest' => [ 'type' => 'structure', 'required' => [ 'Role', 'ServerId', 'ExternalId', ], 'members' => [ 'HomeDirectory' => [ 'shape' => 'HomeDirectory', ], 'HomeDirectoryType' => [ 'shape' => 'HomeDirectoryType', ], 'HomeDirectoryMappings' => [ 'shape' => 'HomeDirectoryMappings', ], 'Policy' => [ 'shape' => 'Policy', ], 'PosixProfile' => [ 'shape' => 'PosixProfile', ], 'Role' => [ 'shape' => 'Role', ], 'ServerId' => [ 'shape' => 'ServerId', ], 'ExternalId' => [ 'shape' => 'ExternalId', ], ], ], 'CreateAccessResponse' => [ 'type' => 'structure', 'required' => [ 'ServerId', 'ExternalId', ], 'members' => [ 'ServerId' => [ 'shape' => 'ServerId', ], 'ExternalId' => [ 'shape' => 'ExternalId', ], ], ], 'CreateAgreementRequest' => [ 'type' => 'structure', 'required' => [ 'ServerId', 'LocalProfileId', 'PartnerProfileId', 'BaseDirectory', 'AccessRole', ], 'members' => [ 'Description' => [ 'shape' => 'Description', ], 'ServerId' => [ 'shape' => 'ServerId', ], 'LocalProfileId' => [ 'shape' => 'ProfileId', ], 'PartnerProfileId' => [ 'shape' => 'ProfileId', ], 'BaseDirectory' => [ 'shape' => 'HomeDirectory', ], 'AccessRole' => [ 'shape' => 'Role', ], 'Status' => [ 'shape' => 'AgreementStatusType', ], 'Tags' => [ 'shape' => 'Tags', ], ], ], 'CreateAgreementResponse' => [ 'type' => 'structure', 'required' => [ 'AgreementId', ], 'members' => [ 'AgreementId' => [ 'shape' => 'AgreementId', ], ], ], 'CreateConnectorRequest' => [ 'type' => 'structure', 'required' => [ 'Url', 'AccessRole', ], 'members' => [ 'Url' => [ 'shape' => 'Url', ], 'As2Config' => [ 'shape' => 'As2ConnectorConfig', ], 'AccessRole' => [ 'shape' => 'Role', ], 'LoggingRole' => [ 'shape' => 'Role', ], 'Tags' => [ 'shape' => 'Tags', ], 'SftpConfig' => [ 'shape' => 'SftpConnectorConfig', ], 'SecurityPolicyName' => [ 'shape' => 'ConnectorSecurityPolicyName', ], ], ], 'CreateConnectorResponse' => [ 'type' => 'structure', 'required' => [ 'ConnectorId', ], 'members' => [ 'ConnectorId' => [ 'shape' => 'ConnectorId', ], ], ], 'CreateProfileRequest' => [ 'type' => 'structure', 'required' => [ 'As2Id', 'ProfileType', ], 'members' => [ 'As2Id' => [ 'shape' => 'As2Id', ], 'ProfileType' => [ 'shape' => 'ProfileType', ], 'CertificateIds' => [ 'shape' => 'CertificateIds', ], 'Tags' => [ 'shape' => 'Tags', ], ], ], 'CreateProfileResponse' => [ 'type' => 'structure', 'required' => [ 'ProfileId', ], 'members' => [ 'ProfileId' => [ 'shape' => 'ProfileId', ], ], ], 'CreateServerRequest' => [ 'type' => 'structure', 'members' => [ 'Certificate' => [ 'shape' => 'Certificate', ], 'Domain' => [ 'shape' => 'Domain', ], 'EndpointDetails' => [ 'shape' => 'EndpointDetails', ], 'EndpointType' => [ 'shape' => 'EndpointType', ], 'HostKey' => [ 'shape' => 'HostKey', ], 'IdentityProviderDetails' => [ 'shape' => 'IdentityProviderDetails', ], 'IdentityProviderType' => [ 'shape' => 'IdentityProviderType', ], 'LoggingRole' => [ 'shape' => 'NullableRole', ], 'PostAuthenticationLoginBanner' => [ 'shape' => 'PostAuthenticationLoginBanner', ], 'PreAuthenticationLoginBanner' => [ 'shape' => 'PreAuthenticationLoginBanner', ], 'Protocols' => [ 'shape' => 'Protocols', ], 'ProtocolDetails' => [ 'shape' => 'ProtocolDetails', ], 'SecurityPolicyName' => [ 'shape' => 'SecurityPolicyName', ], 'Tags' => [ 'shape' => 'Tags', ], 'WorkflowDetails' => [ 'shape' => 'WorkflowDetails', ], 'StructuredLogDestinations' => [ 'shape' => 'StructuredLogDestinations', ], 'S3StorageOptions' => [ 'shape' => 'S3StorageOptions', ], ], ], 'CreateServerResponse' => [ 'type' => 'structure', 'required' => [ 'ServerId', ], 'members' => [ 'ServerId' => [ 'shape' => 'ServerId', ], ], ], 'CreateUserRequest' => [ 'type' => 'structure', 'required' => [ 'Role', 'ServerId', 'UserName', ], 'members' => [ 'HomeDirectory' => [ 'shape' => 'HomeDirectory', ], 'HomeDirectoryType' => [ 'shape' => 'HomeDirectoryType', ], 'HomeDirectoryMappings' => [ 'shape' => 'HomeDirectoryMappings', ], 'Policy' => [ 'shape' => 'Policy', ], 'PosixProfile' => [ 'shape' => 'PosixProfile', ], 'Role' => [ 'shape' => 'Role', ], 'ServerId' => [ 'shape' => 'ServerId', ], 'SshPublicKeyBody' => [ 'shape' => 'SshPublicKeyBody', ], 'Tags' => [ 'shape' => 'Tags', ], 'UserName' => [ 'shape' => 'UserName', ], ], ], 'CreateUserResponse' => [ 'type' => 'structure', 'required' => [ 'ServerId', 'UserName', ], 'members' => [ 'ServerId' => [ 'shape' => 'ServerId', ], 'UserName' => [ 'shape' => 'UserName', ], ], ], 'CreateWorkflowRequest' => [ 'type' => 'structure', 'required' => [ 'Steps', ], 'members' => [ 'Description' => [ 'shape' => 'WorkflowDescription', ], 'Steps' => [ 'shape' => 'WorkflowSteps', ], 'OnExceptionSteps' => [ 'shape' => 'WorkflowSteps', ], 'Tags' => [ 'shape' => 'Tags', ], ], ], 'CreateWorkflowResponse' => [ 'type' => 'structure', 'required' => [ 'WorkflowId', ], 'members' => [ 'WorkflowId' => [ 'shape' => 'WorkflowId', ], ], ], 'CustomStepDetails' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'WorkflowStepName', ], 'Target' => [ 'shape' => 'CustomStepTarget', ], 'TimeoutSeconds' => [ 'shape' => 'CustomStepTimeoutSeconds', ], 'SourceFileLocation' => [ 'shape' => 'SourceFileLocation', ], ], ], 'CustomStepStatus' => [ 'type' => 'string', 'enum' => [ 'SUCCESS', 'FAILURE', ], ], 'CustomStepTarget' => [ 'type' => 'string', 'max' => 170, 'min' => 0, 'pattern' => 'arn:[a-z-]+:lambda:.*', ], 'CustomStepTimeoutSeconds' => [ 'type' => 'integer', 'box' => true, 'max' => 1800, 'min' => 1, ], 'DateImported' => [ 'type' => 'timestamp', ], 'DecryptStepDetails' => [ 'type' => 'structure', 'required' => [ 'Type', 'DestinationFileLocation', ], 'members' => [ 'Name' => [ 'shape' => 'WorkflowStepName', ], 'Type' => [ 'shape' => 'EncryptionType', ], 'SourceFileLocation' => [ 'shape' => 'SourceFileLocation', ], 'OverwriteExisting' => [ 'shape' => 'OverwriteExisting', ], 'DestinationFileLocation' => [ 'shape' => 'InputFileLocation', ], ], ], 'DeleteAccessRequest' => [ 'type' => 'structure', 'required' => [ 'ServerId', 'ExternalId', ], 'members' => [ 'ServerId' => [ 'shape' => 'ServerId', ], 'ExternalId' => [ 'shape' => 'ExternalId', ], ], ], 'DeleteAgreementRequest' => [ 'type' => 'structure', 'required' => [ 'AgreementId', 'ServerId', ], 'members' => [ 'AgreementId' => [ 'shape' => 'AgreementId', ], 'ServerId' => [ 'shape' => 'ServerId', ], ], ], 'DeleteCertificateRequest' => [ 'type' => 'structure', 'required' => [ 'CertificateId', ], 'members' => [ 'CertificateId' => [ 'shape' => 'CertificateId', ], ], ], 'DeleteConnectorRequest' => [ 'type' => 'structure', 'required' => [ 'ConnectorId', ], 'members' => [ 'ConnectorId' => [ 'shape' => 'ConnectorId', ], ], ], 'DeleteHostKeyRequest' => [ 'type' => 'structure', 'required' => [ 'ServerId', 'HostKeyId', ], 'members' => [ 'ServerId' => [ 'shape' => 'ServerId', ], 'HostKeyId' => [ 'shape' => 'HostKeyId', ], ], ], 'DeleteProfileRequest' => [ 'type' => 'structure', 'required' => [ 'ProfileId', ], 'members' => [ 'ProfileId' => [ 'shape' => 'ProfileId', ], ], ], '