<?php
// This file was auto-generated from sdk-root/src/data/wellarchitected/2020-03-31/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2020-03-31', 'endpointPrefix' => 'wellarchitected', 'jsonVersion' => '1.1', 'protocol' => 'rest-json', 'serviceAbbreviation' => 'Well-Architected', 'serviceFullName' => 'AWS Well-Architected Tool', 'serviceId' => 'WellArchitected', 'signatureVersion' => 'v4', 'signingName' => 'wellarchitected', 'uid' => 'wellarchitected-2020-03-31', ], 'operations' => [ 'AssociateLenses' => [ 'name' => 'AssociateLenses', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/workloads/{WorkloadId}/associateLenses', ], 'input' => [ 'shape' => 'AssociateLensesInput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'AssociateProfiles' => [ 'name' => 'AssociateProfiles', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/workloads/{WorkloadId}/associateProfiles', ], 'input' => [ 'shape' => 'AssociateProfilesInput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'CreateLensShare' => [ 'name' => 'CreateLensShare', 'http' => [ 'method' => 'POST', 'requestUri' => '/lenses/{LensAlias}/shares', ], 'input' => [ 'shape' => 'CreateLensShareInput', ], 'output' => [ 'shape' => 'CreateLensShareOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'CreateLensVersion' => [ 'name' => 'CreateLensVersion', 'http' => [ 'method' => 'POST', 'requestUri' => '/lenses/{LensAlias}/versions', ], 'input' => [ 'shape' => 'CreateLensVersionInput', ], 'output' => [ 'shape' => 'CreateLensVersionOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'CreateMilestone' => [ 'name' => 'CreateMilestone', 'http' => [ 'method' => 'POST', 'requestUri' => '/workloads/{WorkloadId}/milestones', ], 'input' => [ 'shape' => 'CreateMilestoneInput', ], 'output' => [ 'shape' => 'CreateMilestoneOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'CreateProfile' => [ 'name' => 'CreateProfile', 'http' => [ 'method' => 'POST', 'requestUri' => '/profiles', ], 'input' => [ 'shape' => 'CreateProfileInput', ], 'output' => [ 'shape' => 'CreateProfileOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'CreateProfileShare' => [ 'name' => 'CreateProfileShare', 'http' => [ 'method' => 'POST', 'requestUri' => '/profiles/{ProfileArn}/shares', ], 'input' => [ 'shape' => 'CreateProfileShareInput', ], 'output' => [ 'shape' => 'CreateProfileShareOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'CreateReviewTemplate' => [ 'name' => 'CreateReviewTemplate', 'http' => [ 'method' => 'POST', 'requestUri' => '/reviewTemplates', ], 'input' => [ 'shape' => 'CreateReviewTemplateInput', ], 'output' => [ 'shape' => 'CreateReviewTemplateOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'CreateTemplateShare' => [ 'name' => 'CreateTemplateShare', 'http' => [ 'method' => 'POST', 'requestUri' => '/templates/shares/{TemplateArn}', ], 'input' => [ 'shape' => 'CreateTemplateShareInput', ], 'output' => [ 'shape' => 'CreateTemplateShareOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'CreateWorkload' => [ 'name' => 'CreateWorkload', 'http' => [ 'method' => 'POST', 'requestUri' => '/workloads', ], 'input' => [ 'shape' => 'CreateWorkloadInput', ], 'output' => [ 'shape' => 'CreateWorkloadOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'CreateWorkloadShare' => [ 'name' => 'CreateWorkloadShare', 'http' => [ 'method' => 'POST', 'requestUri' => '/workloads/{WorkloadId}/shares', ], 'input' => [ 'shape' => 'CreateWorkloadShareInput', ], 'output' => [ 'shape' => 'CreateWorkloadShareOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'DeleteLens' => [ 'name' => 'DeleteLens', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/lenses/{LensAlias}', ], 'input' => [ 'shape' => 'DeleteLensInput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'DeleteLensShare' => [ 'name' => 'DeleteLensShare', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/lenses/{LensAlias}/shares/{ShareId}', ], 'input' => [ 'shape' => 'DeleteLensShareInput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'DeleteProfile' => [ 'name' => 'DeleteProfile', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/profiles/{ProfileArn}', ], 'input' => [ 'shape' => 'DeleteProfileInput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'DeleteProfileShare' => [ 'name' => 'DeleteProfileShare', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/profiles/{ProfileArn}/shares/{ShareId}', ], 'input' => [ 'shape' => 'DeleteProfileShareInput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'DeleteReviewTemplate' => [ 'name' => 'DeleteReviewTemplate', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/reviewTemplates/{TemplateArn}', ], 'input' => [ 'shape' => 'DeleteReviewTemplateInput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'DeleteTemplateShare' => [ 'name' => 'DeleteTemplateShare', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/templates/shares/{TemplateArn}/{ShareId}', ], 'input' => [ 'shape' => 'DeleteTemplateShareInput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'DeleteWorkload' => [ 'name' => 'DeleteWorkload', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/workloads/{WorkloadId}', ], 'input' => [ 'shape' => 'DeleteWorkloadInput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'DeleteWorkloadShare' => [ 'name' => 'DeleteWorkloadShare', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/workloads/{WorkloadId}/shares/{ShareId}', ], 'input' => [ 'shape' => 'DeleteWorkloadShareInput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'DisassociateLenses' => [ 'name' => 'DisassociateLenses', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/workloads/{WorkloadId}/disassociateLenses', ], 'input' => [ 'shape' => 'DisassociateLensesInput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'DisassociateProfiles' => [ 'name' => 'DisassociateProfiles', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/workloads/{WorkloadId}/disassociateProfiles', ], 'input' => [ 'shape' => 'DisassociateProfilesInput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ExportLens' => [ 'name' => 'ExportLens', 'http' => [ 'method' => 'GET', 'requestUri' => '/lenses/{LensAlias}/export', ], 'input' => [ 'shape' => 'ExportLensInput', ], 'output' => [ 'shape' => 'ExportLensOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetAnswer' => [ 'name' => 'GetAnswer', 'http' => [ 'method' => 'GET', 'requestUri' => '/workloads/{WorkloadId}/lensReviews/{LensAlias}/answers/{QuestionId}', ], 'input' => [ 'shape' => 'GetAnswerInput', ], 'output' => [ 'shape' => 'GetAnswerOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetConsolidatedReport' => [ 'name' => 'GetConsolidatedReport', 'http' => [ 'method' => 'GET', 'requestUri' => '/consolidatedReport', ], 'input' => [ 'shape' => 'GetConsolidatedReportInput', ], 'output' => [ 'shape' => 'GetConsolidatedReportOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], ], ], 'GetGlobalSettings' => [ 'name' => 'GetGlobalSettings', 'http' => [ 'method' => 'GET', 'requestUri' => '/global-settings', ], 'output' => [ 'shape' => 'GetGlobalSettingsOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetLens' => [ 'name' => 'GetLens', 'http' => [ 'method' => 'GET', 'requestUri' => '/lenses/{LensAlias}', ], 'input' => [ 'shape' => 'GetLensInput', ], 'output' => [ 'shape' => 'GetLensOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetLensReview' => [ 'name' => 'GetLensReview', 'http' => [ 'method' => 'GET', 'requestUri' => '/workloads/{WorkloadId}/lensReviews/{LensAlias}', ], 'input' => [ 'shape' => 'GetLensReviewInput', ], 'output' => [ 'shape' => 'GetLensReviewOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetLensReviewReport' => [ 'name' => 'GetLensReviewReport', 'http' => [ 'method' => 'GET', 'requestUri' => '/workloads/{WorkloadId}/lensReviews/{LensAlias}/report', ], 'input' => [ 'shape' => 'GetLensReviewReportInput', ], 'output' => [ 'shape' => 'GetLensReviewReportOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetLensVersionDifference' => [ 'name' => 'GetLensVersionDifference', 'http' => [ 'method' => 'GET', 'requestUri' => '/lenses/{LensAlias}/versionDifference', ], 'input' => [ 'shape' => 'GetLensVersionDifferenceInput', ], 'output' => [ 'shape' => 'GetLensVersionDifferenceOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetMilestone' => [ 'name' => 'GetMilestone', 'http' => [ 'method' => 'GET', 'requestUri' => '/workloads/{WorkloadId}/milestones/{MilestoneNumber}', ], 'input' => [ 'shape' => 'GetMilestoneInput', ], 'output' => [ 'shape' => 'GetMilestoneOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetProfile' => [ 'name' => 'GetProfile', 'http' => [ 'method' => 'GET', 'requestUri' => '/profiles/{ProfileArn}', ], 'input' => [ 'shape' => 'GetProfileInput', ], 'output' => [ 'shape' => 'GetProfileOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetProfileTemplate' => [ 'name' => 'GetProfileTemplate', 'http' => [ 'method' => 'GET', 'requestUri' => '/profileTemplate', ], 'input' => [ 'shape' => 'GetProfileTemplateInput', ], 'output' => [ 'shape' => 'GetProfileTemplateOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetReviewTemplate' => [ 'name' => 'GetReviewTemplate', 'http' => [ 'method' => 'GET', 'requestUri' => '/reviewTemplates/{TemplateArn}', ], 'input' => [ 'shape' => 'GetReviewTemplateInput', ], 'output' => [ 'shape' => 'GetReviewTemplateOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetReviewTemplateAnswer' => [ 'name' => 'GetReviewTemplateAnswer', 'http' => [ 'method' => 'GET', 'requestUri' => '/reviewTemplates/{TemplateArn}/lensReviews/{LensAlias}/answers/{QuestionId}', ], 'input' => [ 'shape' => 'GetReviewTemplateAnswerInput', ], 'output' => [ 'shape' => 'GetReviewTemplateAnswerOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetReviewTemplateLensReview' => [ 'name' => 'GetReviewTemplateLensReview', 'http' => [ 'method' => 'GET', 'requestUri' => '/reviewTemplates/{TemplateArn}/lensReviews/{LensAlias}', ], 'input' => [ 'shape' => 'GetReviewTemplateLensReviewInput', ], 'output' => [ 'shape' => 'GetReviewTemplateLensReviewOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetWorkload' => [ 'name' => 'GetWorkload', 'http' => [ 'method' => 'GET', 'requestUri' => '/workloads/{WorkloadId}', ], 'input' => [ 'shape' => 'GetWorkloadInput', ], 'output' => [ 'shape' => 'GetWorkloadOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ImportLens' => [ 'name' => 'ImportLens', 'http' => [ 'method' => 'PUT', 'requestUri' => '/importLens', ], 'input' => [ 'shape' => 'ImportLensInput', ], 'output' => [ 'shape' => 'ImportLensOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListAnswers' => [ 'name' => 'ListAnswers', 'http' => [ 'method' => 'GET', 'requestUri' => '/workloads/{WorkloadId}/lensReviews/{LensAlias}/answers', ], 'input' => [ 'shape' => 'ListAnswersInput', ], 'output' => [ 'shape' => 'ListAnswersOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListCheckDetails' => [ 'name' => 'ListCheckDetails', 'http' => [ 'method' => 'POST', 'requestUri' => '/workloads/{WorkloadId}/checks', ], 'input' => [ 'shape' => 'ListCheckDetailsInput', ], 'output' => [ 'shape' => 'ListCheckDetailsOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListCheckSummaries' => [ 'name' => 'ListCheckSummaries', 'http' => [ 'method' => 'POST', 'requestUri' => '/workloads/{WorkloadId}/checkSummaries', ], 'input' => [ 'shape' => 'ListCheckSummariesInput', ], 'output' => [ 'shape' => 'ListCheckSummariesOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListLensReviewImprovements' => [ 'name' => 'ListLensReviewImprovements', 'http' => [ 'method' => 'GET', 'requestUri' => '/workloads/{WorkloadId}/lensReviews/{LensAlias}/improvements', ], 'input' => [ 'shape' => 'ListLensReviewImprovementsInput', ], 'output' => [ 'shape' => 'ListLensReviewImprovementsOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListLensReviews' => [ 'name' => 'ListLensReviews', 'http' => [ 'method' => 'GET', 'requestUri' => '/workloads/{WorkloadId}/lensReviews', ], 'input' => [ 'shape' => 'ListLensReviewsInput', ], 'output' => [ 'shape' => 'ListLensReviewsOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListLensShares' => [ 'name' => 'ListLensShares', 'http' => [ 'method' => 'GET', 'requestUri' => '/lenses/{LensAlias}/shares', ], 'input' => [ 'shape' => 'ListLensSharesInput', ], 'output' => [ 'shape' => 'ListLensSharesOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListLenses' => [ 'name' => 'ListLenses', 'http' => [ 'method' => 'GET', 'requestUri' => '/lenses', ], 'input' => [ 'shape' => 'ListLensesInput', ], 'output' => [ 'shape' => 'ListLensesOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListMilestones' => [ 'name' => 'ListMilestones', 'http' => [ 'method' => 'POST', 'requestUri' => '/workloads/{WorkloadId}/milestonesSummaries', ], 'input' => [ 'shape' => 'ListMilestonesInput', ], 'output' => [ 'shape' => 'ListMilestonesOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListNotifications' => [ 'name' => 'ListNotifications', 'http' => [ 'method' => 'POST', 'requestUri' => '/notifications', ], 'input' => [ 'shape' => 'ListNotificationsInput', ], 'output' => [ 'shape' => 'ListNotificationsOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListProfileNotifications' => [ 'name' => 'ListProfileNotifications', 'http' => [ 'method' => 'GET', 'requestUri' => '/profileNotifications/', ], 'input' => [ 'shape' => 'ListProfileNotificationsInput', ], 'output' => [ 'shape' => 'ListProfileNotificationsOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListProfileShares' => [ 'name' => 'ListProfileShares', 'http' => [ 'method' => 'GET', 'requestUri' => '/profiles/{ProfileArn}/shares', ], 'input' => [ 'shape' => 'ListProfileSharesInput', ], 'output' => [ 'shape' => 'ListProfileSharesOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListProfiles' => [ 'name' => 'ListProfiles', 'http' => [ 'method' => 'GET', 'requestUri' => '/profileSummaries', ], 'input' => [ 'shape' => 'ListProfilesInput', ], 'output' => [ 'shape' => 'ListProfilesOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListReviewTemplateAnswers' => [ 'name' => 'ListReviewTemplateAnswers', 'http' => [ 'method' => 'GET', 'requestUri' => '/reviewTemplates/{TemplateArn}/lensReviews/{LensAlias}/answers', ], 'input' => [ 'shape' => 'ListReviewTemplateAnswersInput', ], 'output' => [ 'shape' => 'ListReviewTemplateAnswersOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListReviewTemplates' => [ 'name' => 'ListReviewTemplates', 'http' => [ 'method' => 'GET', 'requestUri' => '/reviewTemplates', ], 'input' => [ 'shape' => 'ListReviewTemplatesInput', ], 'output' => [ 'shape' => 'ListReviewTemplatesOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListShareInvitations' => [ 'name' => 'ListShareInvitations', 'http' => [ 'method' => 'GET', 'requestUri' => '/shareInvitations', ], 'input' => [ 'shape' => 'ListShareInvitationsInput', ], 'output' => [ 'shape' => 'ListShareInvitationsOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/tags/{WorkloadArn}', ], 'input' => [ 'shape' => 'ListTagsForResourceInput', ], 'output' => [ 'shape' => 'ListTagsForResourceOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListTemplateShares' => [ 'name' => 'ListTemplateShares', 'http' => [ 'method' => 'GET', 'requestUri' => '/templates/shares/{TemplateArn}', ], 'input' => [ 'shape' => 'ListTemplateSharesInput', ], 'output' => [ 'shape' => 'ListTemplateSharesOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListWorkloadShares' => [ 'name' => 'ListWorkloadShares', 'http' => [ 'method' => 'GET', 'requestUri' => '/workloads/{WorkloadId}/shares', ], 'input' => [ 'shape' => 'ListWorkloadSharesInput', ], 'output' => [ 'shape' => 'ListWorkloadSharesOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListWorkloads' => [ 'name' => 'ListWorkloads', 'http' => [ 'method' => 'POST', 'requestUri' => '/workloadsSummaries', ], 'input' => [ 'shape' => 'ListWorkloadsInput', ], 'output' => [ 'shape' => 'ListWorkloadsOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tags/{WorkloadArn}', ], 'input' => [ 'shape' => 'TagResourceInput', ], 'output' => [ 'shape' => 'TagResourceOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tags/{WorkloadArn}', ], 'input' => [ 'shape' => 'UntagResourceInput', ], 'output' => [ 'shape' => 'UntagResourceOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'UpdateAnswer' => [ 'name' => 'UpdateAnswer', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/workloads/{WorkloadId}/lensReviews/{LensAlias}/answers/{QuestionId}', ], 'input' => [ 'shape' => 'UpdateAnswerInput', ], 'output' => [ 'shape' => 'UpdateAnswerOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'UpdateGlobalSettings' => [ 'name' => 'UpdateGlobalSettings', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/global-settings', ], 'input' => [ 'shape' => 'UpdateGlobalSettingsInput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'UpdateIntegration' => [ 'name' => 'UpdateIntegration', 'http' => [ 'method' => 'POST', 'requestUri' => '/workloads/{WorkloadId}/updateIntegration', ], 'input' => [ 'shape' => 'UpdateIntegrationInput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'UpdateLensReview' => [ 'name' => 'UpdateLensReview', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/workloads/{WorkloadId}/lensReviews/{LensAlias}', ], 'input' => [ 'shape' => 'UpdateLensReviewInput', ], 'output' => [ 'shape' => 'UpdateLensReviewOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'UpdateProfile' => [ 'name' => 'UpdateProfile', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/profiles/{ProfileArn}', ], 'input' => [ 'shape' => 'UpdateProfileInput', ], 'output' => [ 'shape' => 'UpdateProfileOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'UpdateReviewTemplate' => [ 'name' => 'UpdateReviewTemplate', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/reviewTemplates/{TemplateArn}', ], 'input' => [ 'shape' => 'UpdateReviewTemplateInput', ], 'output' => [ 'shape' => 'UpdateReviewTemplateOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'UpdateReviewTemplateAnswer' => [ 'name' => 'UpdateReviewTemplateAnswer', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/reviewTemplates/{TemplateArn}/lensReviews/{LensAlias}/answers/{QuestionId}', ], 'input' => [ 'shape' => 'UpdateReviewTemplateAnswerInput', ], 'output' => [ 'shape' => 'UpdateReviewTemplateAnswerOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'UpdateReviewTemplateLensReview' => [ 'name' => 'UpdateReviewTemplateLensReview', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/reviewTemplates/{TemplateArn}/lensReviews/{LensAlias}', ], 'input' => [ 'shape' => 'UpdateReviewTemplateLensReviewInput', ], 'output' => [ 'shape' => 'UpdateReviewTemplateLensReviewOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'UpdateShareInvitation' => [ 'name' => 'UpdateShareInvitation', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/shareInvitations/{ShareInvitationId}', ], 'input' => [ 'shape' => 'UpdateShareInvitationInput', ], 'output' => [ 'shape' => 'UpdateShareInvitationOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'UpdateWorkload' => [ 'name' => 'UpdateWorkload', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/workloads/{WorkloadId}', ], 'input' => [ 'shape' => 'UpdateWorkloadInput', ], 'output' => [ 'shape' => 'UpdateWorkloadOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'UpdateWorkloadShare' => [ 'name' => 'UpdateWorkloadShare', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/workloads/{WorkloadId}/shares/{ShareId}', ], 'input' => [ 'shape' => 'UpdateWorkloadShareInput', ], 'output' => [ 'shape' => 'UpdateWorkloadShareOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'UpgradeLensReview' => [ 'name' => 'UpgradeLensReview', 'http' => [ 'method' => 'PUT', 'requestUri' => '/workloads/{WorkloadId}/lensReviews/{LensAlias}/upgrade', ], 'input' => [ 'shape' => 'UpgradeLensReviewInput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], ], 'UpgradeProfileVersion' => [ 'name' => 'UpgradeProfileVersion', 'http' => [ 'method' => 'PUT', 'requestUri' => '/workloads/{WorkloadId}/profiles/{ProfileArn}/upgrade', ], 'input' => [ 'shape' => 'UpgradeProfileVersionInput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], ], 'UpgradeReviewTemplateLensReview' => [ 'name' => 'UpgradeReviewTemplateLensReview', 'http' => [ 'method' => 'PUT', 'requestUri' => '/reviewTemplates/{TemplateArn}/lensReviews/{LensAlias}/upgrade', ], 'input' => [ 'shape' => 'UpgradeReviewTemplateLensReviewInput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], ], ], ], 'shapes' => [ 'AccessDeniedException' => [ 'type' => 'structure', 'required' => [ 'Message', ], 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'error' => [ 'httpStatusCode' => 403, ], 'exception' => true, ], 'AccountJiraConfigurationInput' => [ 'type' => 'structure', 'members' => [ 'IssueManagementStatus' => [ 'shape' => 'AccountJiraIssueManagementStatus', ], 'IssueManagementType' => [ 'shape' => 'IssueManagementType', ], 'JiraProjectKey' => [ 'shape' => 'JiraProjectKey', ], 'IntegrationStatus' => [ 'shape' => 'IntegrationStatusInput', ], ], ], 'AccountJiraConfigurationOutput' => [ 'type' => 'structure', 'members' => [ 'IntegrationStatus' => [ 'shape' => 'IntegrationStatus', ], 'IssueManagementStatus' => [ 'shape' => 'AccountJiraIssueManagementStatus', ], 'IssueManagementType' => [ 'shape' => 'IssueManagementType', ], 'Subdomain' => [ 'shape' => 'Subdomain', ], 'JiraProjectKey' => [ 'shape' => 'JiraProjectKey', ], 'StatusMessage' => [ 'shape' => 'StatusMessage', ], ], ], 'AccountJiraIssueManagementStatus' => [ 'type' => 'string', 'enum' => [ 'ENABLED', 'DISABLED', ], ], 'AccountSummary' => [ 'type' => 'map', 'key' => [ 'shape' => 'CheckStatus', ], 'value' => [ 'shape' => 'CheckStatusCount', ], ], 'AdditionalResourceType' => [ 'type' => 'string', 'enum' => [ 'HELPFUL_RESOURCE', 'IMPROVEMENT_PLAN', ], ], 'AdditionalResources' => [ 'type' => 'structure', 'members' => [ 'Type' => [ 'shape' => 'AdditionalResourceType', ], 'Content' => [ 'shape' => 'Urls', ], ], ], 'AdditionalResourcesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AdditionalResources', ], ], 'Answer' => [ 'type' => 'structure', 'members' => [ 'QuestionId' => [ 'shape' => 'QuestionId', ], 'PillarId' => [ 'shape' => 'PillarId', ], 'QuestionTitle' => [ 'shape' => 'QuestionTitle', ], 'QuestionDescription' => [ 'shape' => 'QuestionDescription', ], 'ImprovementPlanUrl' => [ 'shape' => 'ImprovementPlanUrl', ], 'HelpfulResourceUrl' => [ 'shape' => 'HelpfulResourceUrl', ], 'HelpfulResourceDisplayText' => [ 'shape' => 'DisplayText', ], 'Choices' => [ 'shape' => 'Choices', ], 'SelectedChoices' => [ 'shape' => 'SelectedChoices', ], 'ChoiceAnswers' => [ 'shape' => 'ChoiceAnswers', ], 'IsApplicable' => [ 'shape' => 'IsApplicable', ], 'Risk' => [ 'shape' => 'Risk', ], 'Notes' => [ 'shape' => 'Notes', ], 'Reason' => [ 'shape' => 'AnswerReason', ], 'JiraConfiguration' => [ 'shape' => 'JiraConfiguration', ], ], ], 'AnswerReason' => [ 'type' => 'string', 'enum' => [ 'OUT_OF_SCOPE', 'BUSINESS_PRIORITIES', 'ARCHITECTURE_CONSTRAINTS', 'OTHER', 'NONE', ], ], 'AnswerSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'AnswerSummary', ], ], 'AnswerSummary' => [ 'type' => 'structure', 'members' => [ 'QuestionId' => [ 'shape' => 'QuestionId', ], 'PillarId' => [ 'shape' => 'PillarId', ], 'QuestionTitle' => [ 'shape' => 'QuestionTitle', ], 'Choices' => [ 'shape' => 'Choices', ], 'SelectedChoices' => [ 'shape' => 'SelectedChoices', ], 'ChoiceAnswerSummaries' => [ 'shape' => 'ChoiceAnswerSummaries', ], 'IsApplicable' => [ 'shape' => 'IsApplicable', ], 'Risk' => [ 'shape' => 'Risk', ], 'Reason' => [ 'shape' => 'AnswerReason', ], 'QuestionType' => [ 'shape' => 'QuestionType', ], 'JiraConfiguration' => [ 'shape' => 'JiraConfiguration', ], ], ], 'ApplicationArn' => [ 'type' => 'string', 'max' => 2084, 'pattern' => 'arn:aws[-a-z]*:servicecatalog:[a-z]{2}(-gov)?-[a-z]+-\\d:\\d{12}:/applications/[a-z0-9]+', ], 'AssociateLensesInput' => [ 'type' => 'structure', 'required' => [ 'WorkloadId', 'LensAliases', ], 'members' => [ 'WorkloadId' => [ 'shape' => 'WorkloadId', 'location' => 'uri', 'locationName' => 'WorkloadId', ], 'LensAliases' => [ 'shape' => 'LensAliases', ], ], ], 'AssociateProfilesInput' => [ 'type' => 'structure', 'required' => [ 'WorkloadId', 'ProfileArns', ], 'members' => [ 'WorkloadId' => [ 'shape' => 'WorkloadId', 'location' => 'uri', 'locationName' => 'WorkloadId', ], 'ProfileArns' => [ 'shape' => 'ProfileArns', ], ], ], 'AwsAccountId' => [ 'type' => 'string', 'max' => 12, 'min' => 12, 'pattern' => '[0-9]{12}', ], 'AwsRegion' => [ 'type' => 'string', 'max' => 100, ], 'Base64String' => [ 'type' => 'string', ], 'BestPractice' => [ 'type' => 'structure', 'members' => [ 'ChoiceId' => [ 'shape' => 'ChoiceId', ], 'ChoiceTitle' => [ 'shape' => 'ChoiceTitle', ], ], ], 'BestPractices' => [ 'type' => 'list', 'member' => [ 'shape' => 'BestPractice', ], ], 'CheckDescription' => [ 'type' => 'string', ], 'CheckDetail' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'CheckId', ], 'Name' => [ 'shape' => 'CheckName', ], 'Description' => [ 'shape' => 'CheckDescription', ], 'Provider' => [ 'shape' => 'CheckProvider', ], 'LensArn' => [ 'shape' => 'LensArn', ], 'PillarId' => [ 'shape' => 'PillarId', ], 'QuestionId' => [ 'shape' => 'QuestionId', ], 'ChoiceId' => [ 'shape' => 'ChoiceId', ], 'Status' => [ 'shape' => 'CheckStatus', ], 'AccountId' => [ 'shape' => 'AwsAccountId', ], 'FlaggedResources' => [ 'shape' => 'FlaggedResources', ], 'Reason' => [ 'shape' => 'CheckFailureReason', ], 'UpdatedAt' => [ 'shape' => 'Timestamp', ], ], ], 'CheckDetails' => [ 'type' => 'list', 'member' => [ 'shape' => 'CheckDetail', ], ], 'CheckFailureReason' => [ 'type' => 'string', 'enum' => [ 'ASSUME_ROLE_ERROR', 'ACCESS_DENIED', 'UNKNOWN_ERROR', 'PREMIUM_SUPPORT_REQUIRED', ], ], 'CheckId' => [ 'type' => 'string', ], 'CheckName' => [ 'type' => 'string', ], 'CheckProvider' => [ 'type' => 'string', 'enum' => [ 'TRUSTED_ADVISOR', ], ], 'CheckStatus' => [ 'type' => 'string', 'enum' => [ 'OKAY', 'WARNING', 'ERROR', 'NOT_AVAILABLE', 'FETCH_FAILED', ], ], 'CheckStatusCount' => [ 'type' => 'integer', 'max' => 101, 'min' => 1, ], 'CheckSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'CheckSummary', ], ], 'CheckSummary' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'CheckId', ], 'Name' => [ 'shape' => 'CheckName', ], 'Provider' => [ 'shape' => 'CheckProvider', ], 'Description' => [ 'shape' => 'CheckDescription', ], 'UpdatedAt' => [ 'shape' => 'Timestamp', ], 'LensArn' => [ 'shape' => 'LensArn', ], 'PillarId' => [ 'shape' => 'PillarId', ], 'QuestionId' => [ 'shape' => 'QuestionId', ], 'ChoiceId' => [ 'shape' => 'ChoiceId', ], 'Status' => [ 'shape' => 'CheckStatus', ], 'AccountSummary' => [ 'shape' => 'AccountSummary', ], ], ], 'Choice' => [ 'type' => 'structure', 'members' => [ 'ChoiceId' => [ 'shape' => 'ChoiceId', ], 'Title' => [ 'shape' => 'ChoiceTitle', ], 'Description' => [ 'shape' => 'ChoiceDescription', ], 'HelpfulResource' => [ 'shape' => 'ChoiceContent', ], 'ImprovementPlan' => [ 'shape' => 'ChoiceContent', ], 'AdditionalResources' => [ 'shape' => 'AdditionalResourcesList', ], ], ], 'ChoiceAnswer' => [ 'type' => 'structure', 'members' => [ 'ChoiceId' => [ 'shape' => 'ChoiceId', ], 'Status' => [ 'shape' => 'ChoiceStatus', ], 'Reason' => [ 'shape' => 'ChoiceReason', ], 'Notes' => [ 'shape' => 'ChoiceNotes', ], ], ], 'ChoiceAnswerSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'ChoiceAnswerSummary', ], ], 'ChoiceAnswerSummary' => [ 'type' => 'structure', 'members' => [ 'ChoiceId' => [ 'shape' => 'ChoiceId', ], 'Status' => [ 'shape' => 'ChoiceStatus', ], 'Reason' => [ 'shape' => 'ChoiceReason', ], ], ], 'ChoiceAnswers' => [ 'type' => 'list', 'member' => [ 'shape' => 'ChoiceAnswer', ], ], 'ChoiceContent' => [ 'type' => 'structure', 'members' => [ 'DisplayText' => [ 'shape' => 'ChoiceContentDisplayText', ], 'Url' => [ 'shape' => 'ChoiceContentUrl', ], ], ], 'ChoiceContentDisplayText' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, ], 'ChoiceContentUrl' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, ], 'ChoiceDescription' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, ], 'ChoiceId' => [ 'type' => 'string', 'max' => 64, 'min' => 1, ], 'ChoiceImprovementPlan' => [ 'type' => 'structure', 'members' => [ 'ChoiceId' => [ 'shape' => 'ChoiceId', ], 'DisplayText' => [ 'shape' => 'DisplayText', ], 'ImprovementPlanUrl' => [ 'shape' => 'ImprovementPlanUrl', ], ], ], 'ChoiceImprovementPlans' => [ 'type' => 'list', 'member' => [ 'shape' => 'ChoiceImprovementPlan', ], ], 'ChoiceNotes' => [ 'type' => 'string', 'max' => 250, ], 'ChoiceReason' => [ 'type' => 'string', 'enum' => [ 'OUT_OF_SCOPE', 'BUSINESS_PRIORITIES', 'ARCHITECTURE_CONSTRAINTS', 'OTHER', 'NONE', ], ], 'ChoiceStatus' => [ 'type' => 'string', 'enum' => [ 'SELECTED', 'NOT_APPLICABLE', 'UNSELECTED', ], ], 'ChoiceTitle' => [ 'type' => 'string', 'max' => 512, 'min' => 1, ], 'ChoiceUpdate' => [ 'type' => 'structure', 'required' => [ 'Status', ], 'members' => [ 'Status' => [ 'shape' => 'ChoiceStatus', ], 'Reason' => [ 'shape' => 'ChoiceReason', ], 'Notes' => [ 'shape' => 'ChoiceNotes', ], ], ], 'ChoiceUpdates' => [ 'type' => 'map', 'key' => [ 'shape' => 'ChoiceId', ], 'value' => [ 'shape' => 'ChoiceUpdate', ], ], 'Choices' => [ 'type' => 'list', 'member' => [ 'shape' => 'Choice', ], ], 'ClientRequestToken' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, ], 'ConflictException' => [ 'type' => 'structure', 'required' => [ 'Message', 'ResourceId', 'ResourceType', ], 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], 'ResourceId' => [ 'shape' => 'ExceptionResourceId', ], 'ResourceType' => [ 'shape' => 'ExceptionResourceType', ], ], 'error' => [ 'httpStatusCode' => 409, ], 'exception' => true, ], 'ConsolidatedReportMetric' => [ 'type' => 'structure', 'members' => [ 'MetricType' => [ 'shape' => 'MetricType', ], 'RiskCounts' => [ 'shape' => 'RiskCounts', ], 'WorkloadId' => [ 'shape' => 'WorkloadId', ], 'WorkloadName' => [ 'shape' => 'WorkloadName', ], 'WorkloadArn' => [ 'shape' => 'WorkloadArn', ], 'UpdatedAt' => [ 'shape' => 'Timestamp', ], 'Lenses' => [ 'shape' => 'LensMetrics', ], 'LensesAppliedCount' => [ 'shape' => 'LensesAppliedCount', ], ], ], 'ConsolidatedReportMetrics' => [ 'type' => 'list', 'member' => [ 'shape' => 'ConsolidatedReportMetric', ], ], 'Count' => [ 'type' => 'integer', 'min' => 0, ], 'CreateLensShareInput' => [ 'type' => 'structure', 'required' => [ 'LensAlias', 'SharedWith', 'ClientRequestToken', ], 'members' => [ 'LensAlias' => [ 'shape' => 'LensAlias', 'location' => 'uri', 'locationName' => 'LensAlias', ], 'SharedWith' => [ 'shape' => 'SharedWith', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', 'idempotencyToken' => true, ], ], ], 'CreateLensShareOutput' => [ 'type' => 'structure', 'members' => [ 'ShareId' => [ 'shape' => 'ShareId', ], ], ], 'CreateLensVersionInput' => [ 'type' => 'structure', 'required' => [ 'LensAlias', 'LensVersion', 'ClientRequestToken', ], 'members' => [ 'LensAlias' => [ 'shape' => 'LensAlias', 'location' => 'uri', 'locationName' => 'LensAlias', ], 'LensVersion' => [ 'shape' => 'LensVersion', ], 'IsMajorVersion' => [ 'shape' => 'IsMajorVersion', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', 'idempotencyToken' => true, ], ], ], 'CreateLensVersionOutput' => [ 'type' => 'structure', 'members' => [ 'LensArn' => [ 'shape' => 'LensArn', ], 'LensVersion' => [ 'shape' => 'LensVersion', ], ], ], 'CreateMilestoneInput' => [ 'type' => 'structure', 'required' => [ 'WorkloadId', 'MilestoneName', 'ClientRequestToken', ], 'members' => [ 'WorkloadId' => [ 'shape' => 'WorkloadId', 'location' => 'uri', 'locationName' => 'WorkloadId', ], 'MilestoneName' => [ 'shape' => 'MilestoneName', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', 'idempotencyToken' => true, ], ], ], 'CreateMilestoneOutput' => [ 'type' => 'structure', 'members' => [ 'WorkloadId' => [ 'shape' => 'WorkloadId', ], 'MilestoneNumber' => [ 'shape' => 'MilestoneNumber', ], ], ], 'CreateProfileInput' => [ 'type' => 'structure', 'required' => [ 'ProfileName', 'ProfileDescription', 'ProfileQuestions', 'ClientRequestToken', ], 'members' => [ 'ProfileName' => [ 'shape' => 'ProfileName', ], 'ProfileDescription' => [ 'shape' => 'ProfileDescription', ], 'ProfileQuestions' => [ 'shape' => 'ProfileQuestionUpdates', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', 'idempotencyToken' => true, ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateProfileOutput' => [ 'type' => 'structure', 'members' => [ 'ProfileArn' => [ 'shape' => 'ProfileArn', ], 'ProfileVersion' => [ 'shape' => 'ProfileVersion', ], ], ], 'CreateProfileShareInput' => [ 'type' => 'structure', 'required' => [ 'ProfileArn', 'SharedWith', 'ClientRequestToken', ], 'members' => [ 'ProfileArn' => [ 'shape' => 'ProfileArn', 'location' => 'uri', 'locationName' => 'ProfileArn', ], 'SharedWith' => [ 'shape' => 'SharedWith', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', 'idempotencyToken' => true, ], ], ], 'CreateProfileShareOutput' => [ 'type' => 'structure', 'members' => [ 'ShareId' => [ 'shape' => 'ShareId', ], 'ProfileArn' => [ 'shape' => 'ProfileArn', ], ], ], 'CreateReviewTemplateInput' => [ 'type' => 'structure', 'required' => [ 'TemplateName', 'Description', 'Lenses', 'ClientRequestToken', ], 'members' => [ 'TemplateName' => [ 'shape' => 'TemplateName', ], 'Description' => [ 'shape' => 'TemplateDescription', ], 'Lenses' => [ 'shape' => 'ReviewTemplateLenses', ], 'Notes' => [ 'shape' => 'Notes', ], 'Tags' => [ 'shape' => 'TagMap', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', 'idempotencyToken' => true, ], ], ], 'CreateReviewTemplateOutput' => [ 'type' => 'structure', 'members' => [ 'TemplateArn' => [ 'shape' => 'TemplateArn', ], ], ], 'CreateTemplateShareInput' => [ 'type' => 'structure', 'required' => [ 'TemplateArn', 'SharedWith', 'ClientRequestToken', ], 'members' => [ 'TemplateArn' => [ 'shape' => 'TemplateArn', 'location' => 'uri', 'locationName' => 'TemplateArn', ], 'SharedWith' => [ 'shape' => 'SharedWith', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', 'idempotencyToken' => true, ], ], ], 'CreateTemplateShareOutput' => [ 'type' => 'structure', 'members' => [ 'TemplateArn' => [ 'shape' => 'TemplateArn', ], 'ShareId' => [ 'shape' => 'ShareId', ], ], ], 'CreateWorkloadInput' => [ 'type' => 'structure', 'required' => [ 'WorkloadName', 'Description', 'Environment', 'Lenses', 'ClientRequestToken', ], 'members' => [ 'WorkloadName' => [ 'shape' => 'WorkloadName', ], 'Description' => [ 'shape' => 'WorkloadDescription', ], 'Environment' => [ 'shape' => 'WorkloadEnvironment', ], 'AccountIds' => [ 'shape' => 'WorkloadAccountIds', ], 'AwsRegions' => [ 'shape' => 'WorkloadAwsRegions', ], 'NonAwsRegions' => [ 'shape' => 'WorkloadNonAwsRegions', ], 'PillarPriorities' => [ 'shape' => 'WorkloadPillarPriorities', ], 'ArchitecturalDesign' => [ 'shape' => 'WorkloadArchitecturalDesign', ], 'ReviewOwner' => [ 'shape' => 'WorkloadReviewOwner', ], 'IndustryType' => [ 'shape' => 'WorkloadIndustryType', ], 'Industry' => [ 'shape' => 'WorkloadIndustry', ], 'Lenses' => [ 'shape' => 'WorkloadLenses', ], 'Notes' => [ 'shape' => 'Notes', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', 'idempotencyToken' => true, ], 'Tags' => [ 'shape' => 'TagMap', ], 'DiscoveryConfig' => [ 'shape' => 'WorkloadDiscoveryConfig', ], 'Applications' => [ 'shape' => 'WorkloadApplications', ], 'ProfileArns' => [ 'shape' => 'WorkloadProfileArns', ], 'ReviewTemplateArns' => [ 'shape' => 'ReviewTemplateArns', ], 'JiraConfiguration' => [ 'shape' => 'WorkloadJiraConfigurationInput', ], ], ], 'CreateWorkloadOutput' => [ 'type' => 'structure', 'members' => [ 'WorkloadId' => [ 'shape' => 'WorkloadId', ], 'WorkloadArn' => [ 'shape' => 'WorkloadArn', ], ], ], 'CreateWorkloadShareInput' => [ 'type' => 'structure', 'required' => [ 'WorkloadId', 'SharedWith', 'PermissionType', 'ClientRequestToken', ], 'members' => [ 'WorkloadId' => [ 'shape' => 'WorkloadId', 'location' => 'uri', 'locationName' => 'WorkloadId', ], 'SharedWith' => [ 'shape' => 'SharedWith', ], 'PermissionType' => [ 'shape' => 'PermissionType', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', 'idempotencyToken' => true, ], ], ], 'CreateWorkloadShareOutput' => [ 'type' => 'structure', 'members' => [ 'WorkloadId' => [ 'shape' => 'WorkloadId', ], 'ShareId' => [ 'shape' => 'ShareId', ], ], ], 'DefinitionType' => [ 'type' => 'string', 'enum' => [ 'WORKLOAD_METADATA', 'APP_REGISTRY', ], ], 'DeleteLensInput' => [ 'type' => 'structure', 'required' => [ 'LensAlias', 'ClientRequestToken', 'LensStatus', ], 'members' => [ 'LensAlias' => [ 'shape' => 'LensAlias', 'location' => 'uri', 'locationName' => 'LensAlias', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', 'idempotencyToken' => true, 'location' => 'querystring', 'locationName' => 'ClientRequestToken', ], 'LensStatus' => [ 'shape' => 'LensStatusType', 'location' => 'querystring', 'locationName' => 'LensStatus', ], ], ], 'DeleteLensShareInput' => [ 'type' => 'structure', 'required' => [ 'ShareId', 'LensAlias', 'ClientRequestToken', ], 'members' => [ 'ShareId' => [ 'shape' => 'ShareId', 'location' => 'uri', 'locationName' => 'ShareId', ], 'LensAlias' => [ 'shape' => 'LensAlias', 'location' => 'uri', 'locationName' => 'LensAlias', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', 'idempotencyToken' => true, 'location' => 'querystring', 'locationName' => 'ClientRequestToken', ], ], ], 'DeleteProfileInput' => [ 'type' => 'structure', 'required' => [ 'ProfileArn', 'ClientRequestToken', ], 'members' => [ 'ProfileArn' => [ 'shape' => 'ProfileArn', 'location' => 'uri', 'locationName' => 'ProfileArn', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', 'idempotencyToken' => true, 'location' => 'querystring', 'locationName' => 'ClientRequestToken', ], ], ], 'DeleteProfileShareInput' => [ 'type' => 'structure', 'required' => [ 'ShareId', 'ProfileArn', 'ClientRequestToken', ], 'members' => [ 'ShareId' => [ 'shape' => 'ShareId', 'location' => 'uri', 'locationName' => 'ShareId', ], 'ProfileArn' => [ 'shape' => 'ProfileArn', 'location' => 'uri', 'locationName' => 'ProfileArn', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', 'idempotencyToken' => true, 'location' => 'querystring', 'locationName' => 'ClientRequestToken', ], ], ], 'DeleteReviewTemplateInput' => [ 'type' => 'structure', 'required' => [ 'TemplateArn', 'ClientRequestToken', ], 'members' => [