<?php
/**
 * Demo Import Data
 */

function themesflat_import_files() {
    return array(
        array(
            'import_file_name'           => 'Import Demo Data',
            'import_file_url'            => THEMESFLAT_LINK.'sample_data/content.xml',
            'import_widget_file_url'     => THEMESFLAT_LINK.'sample_data/widgets.wie',
            'import_customizer_file_url' => THEMESFLAT_LINK.'sample_data/options.dat',
            'import_preview_image_url'   => THEMESFLAT_LINK.'screenshot.png',
            'import_notice'              => esc_html__( 'After you import this demo, you will have to setup the MailChimp form.', 'consuloan' ),
            'preview_url'                => esc_url('https://surielementor.com/consuloan/'),
        ),
    );
}
add_filter( 'pt-ocdi/import_files', 'themesflat_import_files' );

function themesflat_before_content_import() { 
    $pages = get_posts(array( 'post_type' => 'page','numberposts' => -1));    
    foreach ( $pages as $page ) {
        wp_delete_post( $page->ID, true);
    }
    $posts = get_posts(array( 'post_type' => 'post','numberposts' => -1));
    foreach ( $posts as $posts ) {
        wp_delete_post( $posts->ID, true);
    }   

    global $wp_registered_sidebars;
    $widgets = get_option('sidebars_widgets');
    foreach ($wp_registered_sidebars as $sidebar => $value) {
        unset($widgets[$sidebar]);
    }
    update_option('sidebars_widgets',$widgets);
}
add_action( 'pt-ocdi/before_content_import', 'themesflat_before_content_import' );

function themesflat_after_import_setup() {
    $main_menu = get_term_by( 'name', 'Main', 'nav_menu' );
    $footer_menu = get_term_by( 'name', 'Footer', 'nav_menu' );

    set_theme_mod( 'nav_menu_locations', array(
            'primary' => $main_menu->term_id,
            'footer' => $footer_menu->term_id,
        )
    );

    $front_page_id = get_page_by_title( 'HOME' );
    $blog_page_id  = get_page_by_title( 'Blog' );

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'page_for_posts', $blog_page_id->ID ); 

    global $wp_rewrite;
    $wp_rewrite->set_permalink_structure('/%postname%/');
    $wp_rewrite->flush_rules();   
}
add_action( 'pt-ocdi/after_import', 'themesflat_after_import_setup' );

function themesflat_import_revsliders() {
    if (class_exists('RevSlider')) {
        $slider_array = array(
            THEMESFLAT_DIR . '/sample_data/home1.zip',
            THEMESFLAT_DIR . '/sample_data/home3.zip',
            THEMESFLAT_DIR . '/sample_data/home6.zip',
            THEMESFLAT_DIR . '/sample_data/home7.zip',
            THEMESFLAT_DIR . '/sample_data/home8.zip',
            THEMESFLAT_DIR . '/sample_data/careers.zip'
        );
        $slider = new RevSlider();       
        foreach($slider_array as $filepath){
            $slider->importSliderFromPost(true,true,$filepath);  
        }       
        return 'Revolution Slider imported';
    }
}
add_action( 'pt-ocdi/after_import', 'themesflat_import_revsliders' );

